/*
 * Copyright (C) 2016 - Niklas Baudy, Ruben Gees, Mario Đanić and contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.vanniktech.emoji.twitter.category

import com.vanniktech.emoji.twitter.TwitterEmoji

internal object TravelAndPlacesCategoryChunk1 {
  internal val EMOJIS: List<TwitterEmoji> = listOf(
    TwitterEmoji(String(intArrayOf(0x1F6A4), 0, 1), listOf("speedboat"), 36, 25, false),
    TwitterEmoji(String(intArrayOf(0x1F6F3, 0xFE0F), 0, 2), listOf("passenger_ship"), 38, 23, false),
    TwitterEmoji(String(intArrayOf(0x26F4, 0xFE0F), 0, 2), listOf("ferry"), 58, 30, false),
    TwitterEmoji(String(intArrayOf(0x1F6E5, 0xFE0F), 0, 2), listOf("motor_boat"), 38, 18, false),
    TwitterEmoji(String(intArrayOf(0x1F6A2), 0, 1), listOf("ship"), 36, 6, false),
    TwitterEmoji(String(intArrayOf(0x2708, 0xFE0F), 0, 2), listOf("airplane"), 58, 56, false),
    TwitterEmoji(String(intArrayOf(0x1F6E9, 0xFE0F), 0, 2), listOf("small_airplane"), 38, 19, false),
    TwitterEmoji(String(intArrayOf(0x1F6EB), 0, 1), listOf("airplane_departure"), 38, 20, false),
    TwitterEmoji(String(intArrayOf(0x1F6EC), 0, 1), listOf("airplane_arriving"), 38, 21, false),
    TwitterEmoji(String(intArrayOf(0x1FA82), 0, 1), listOf("parachute"), 54, 2, false),
    TwitterEmoji(String(intArrayOf(0x1F4BA), 0, 1), listOf("seat"), 28, 18, false),
    TwitterEmoji(String(intArrayOf(0x1F681), 0, 1), listOf("helicopter"), 35, 34, false),
    TwitterEmoji(String(intArrayOf(0x1F69F), 0, 1), listOf("suspension_railway"), 36, 3, false),
    TwitterEmoji(String(intArrayOf(0x1F6A0), 0, 1), listOf("mountain_cableway"), 36, 4, false),
    TwitterEmoji(String(intArrayOf(0x1F6A1), 0, 1), listOf("aerial_tramway"), 36, 5, false),
    TwitterEmoji(String(intArrayOf(0x1F6F0, 0xFE0F), 0, 2), listOf("satellite"), 38, 22, false),
    TwitterEmoji(String(intArrayOf(0x1F680), 0, 1), listOf("rocket"), 35, 33, false),
    TwitterEmoji(String(intArrayOf(0x1F6F8), 0, 1), listOf("flying_saucer"), 38, 28, false),
    TwitterEmoji(String(intArrayOf(0x1F6CE, 0xFE0F), 0, 2), listOf("bellhop_bell"), 38, 1, false),
    TwitterEmoji(String(intArrayOf(0x1F9F3), 0, 1), listOf("luggage"), 53, 35, false),
    TwitterEmoji(String(intArrayOf(0x231B), 0, 1), listOf("hourglass"), 56, 45, false),
    TwitterEmoji(String(intArrayOf(0x23F3), 0, 1), listOf("hourglass_flowing_sand"), 56, 58, false),
    TwitterEmoji(String(intArrayOf(0x231A), 0, 1), listOf("watch"), 56, 44, false),
    TwitterEmoji(String(intArrayOf(0x23F0), 0, 1), listOf("alarm_clock"), 56, 55, false),
    TwitterEmoji(String(intArrayOf(0x23F1, 0xFE0F), 0, 2), listOf("stopwatch"), 56, 56, false),
    TwitterEmoji(String(intArrayOf(0x23F2, 0xFE0F), 0, 2), listOf("timer_clock"), 56, 57, false),
    TwitterEmoji(String(intArrayOf(0x1F570, 0xFE0F), 0, 2), listOf("mantelpiece_clock"), 30, 58, false),
    TwitterEmoji(String(intArrayOf(0x1F55B), 0, 1), listOf("clock12"), 30, 44, false),
    TwitterEmoji(String(intArrayOf(0x1F567), 0, 1), listOf("clock1230"), 30, 56, false),
    TwitterEmoji(String(intArrayOf(0x1F550), 0, 1), listOf("clock1"), 30, 33, false),
    TwitterEmoji(String(intArrayOf(0x1F55C), 0, 1), listOf("clock130"), 30, 45, false),
    TwitterEmoji(String(intArrayOf(0x1F551), 0, 1), listOf("clock2"), 30, 34, false),
    TwitterEmoji(String(intArrayOf(0x1F55D), 0, 1), listOf("clock230"), 30, 46, false),
    TwitterEmoji(String(intArrayOf(0x1F552), 0, 1), listOf("clock3"), 30, 35, false),
    TwitterEmoji(String(intArrayOf(0x1F55E), 0, 1), listOf("clock330"), 30, 47, false),
    TwitterEmoji(String(intArrayOf(0x1F553), 0, 1), listOf("clock4"), 30, 36, false),
    TwitterEmoji(String(intArrayOf(0x1F55F), 0, 1), listOf("clock430"), 30, 48, false),
    TwitterEmoji(String(intArrayOf(0x1F554), 0, 1), listOf("clock5"), 30, 37, false),
    TwitterEmoji(String(intArrayOf(0x1F560), 0, 1), listOf("clock530"), 30, 49, false),
    TwitterEmoji(String(intArrayOf(0x1F555), 0, 1), listOf("clock6"), 30, 38, false),
    TwitterEmoji(String(intArrayOf(0x1F561), 0, 1), listOf("clock630"), 30, 50, false),
    TwitterEmoji(String(intArrayOf(0x1F556), 0, 1), listOf("clock7"), 30, 39, false),
    TwitterEmoji(String(intArrayOf(0x1F562), 0, 1), listOf("clock730"), 30, 51, false),
    TwitterEmoji(String(intArrayOf(0x1F557), 0, 1), listOf("clock8"), 30, 40, false),
    TwitterEmoji(String(intArrayOf(0x1F563), 0, 1), listOf("clock830"), 30, 52, false),
    TwitterEmoji(String(intArrayOf(0x1F558), 0, 1), listOf("clock9"), 30, 41, false),
    TwitterEmoji(String(intArrayOf(0x1F564), 0, 1), listOf("clock930"), 30, 53, false),
    TwitterEmoji(String(intArrayOf(0x1F559), 0, 1), listOf("clock10"), 30, 42, false),
    TwitterEmoji(String(intArrayOf(0x1F565), 0, 1), listOf("clock1030"), 30, 54, false),
    TwitterEmoji(String(intArrayOf(0x1F55A), 0, 1), listOf("clock11"), 30, 43, false),
    TwitterEmoji(String(intArrayOf(0x1F566), 0, 1), listOf("clock1130"), 30, 55, false),
    TwitterEmoji(String(intArrayOf(0x1F311), 0, 1), listOf("new_moon"), 5, 16, false),
    TwitterEmoji(String(intArrayOf(0x1F312), 0, 1), listOf("waxing_crescent_moon"), 5, 17, false),
    TwitterEmoji(String(intArrayOf(0x1F313), 0, 1), listOf("first_quarter_moon"), 5, 18, false),
    TwitterEmoji(String(intArrayOf(0x1F314), 0, 1), listOf("moon", "waxing_gibbous_moon"), 5, 19, false),
    TwitterEmoji(String(intArrayOf(0x1F315), 0, 1), listOf("full_moon"), 5, 20, false),
    TwitterEmoji(String(intArrayOf(0x1F316), 0, 1), listOf("waning_gibbous_moon"), 5, 21, false),
    TwitterEmoji(String(intArrayOf(0x1F317), 0, 1), listOf("last_quarter_moon"), 5, 22, false),
    TwitterEmoji(String(intArrayOf(0x1F318), 0, 1), listOf("waning_crescent_moon"), 5, 23, false),
    TwitterEmoji(String(intArrayOf(0x1F319), 0, 1), listOf("crescent_moon"), 5, 24, false),
    TwitterEmoji(String(intArrayOf(0x1F31A), 0, 1), listOf("new_moon_with_face"), 5, 25, false),
    TwitterEmoji(String(intArrayOf(0x1F31B), 0, 1), listOf("first_quarter_moon_with_face"), 5, 26, false),
    TwitterEmoji(String(intArrayOf(0x1F31C), 0, 1), listOf("last_quarter_moon_with_face"), 5, 27, false),
    TwitterEmoji(String(intArrayOf(0x1F321, 0xFE0F), 0, 2), listOf("thermometer"), 5, 32, false),
    TwitterEmoji(String(intArrayOf(0x2600, 0xFE0F), 0, 2), listOf("sunny"), 57, 10, false),
    TwitterEmoji(String(intArrayOf(0x1F31D), 0, 1), listOf("full_moon_with_face"), 5, 28, false),
    TwitterEmoji(String(intArrayOf(0x1F31E), 0, 1), listOf("sun_with_face"), 5, 29, false),
    TwitterEmoji(String(intArrayOf(0x1FA90), 0, 1), listOf("ringed_planet"), 54, 9, false),
    TwitterEmoji(
      String(intArrayOf(0x2B50), 0, 1), listOf("star"), 59, 55, false,
      variants = listOf(
        TwitterEmoji(String(intArrayOf(0x2B50, 0xFE0F), 0, 2), emptyList<String>(), 59, 55, false),
      ),
    ),
    TwitterEmoji(String(intArrayOf(0x1F31F), 0, 1), listOf("star2"), 5, 30, false),
    TwitterEmoji(String(intArrayOf(0x1F320), 0, 1), listOf("stars"), 5, 31, false),
    TwitterEmoji(String(intArrayOf(0x1F30C), 0, 1), listOf("milky_way"), 5, 11, false),
    TwitterEmoji(String(intArrayOf(0x2601, 0xFE0F), 0, 2), listOf("cloud"), 57, 11, false),
    TwitterEmoji(String(intArrayOf(0x26C5), 0, 1), listOf("partly_sunny"), 58, 17, false),
    TwitterEmoji(String(intArrayOf(0x26C8, 0xFE0F), 0, 2), listOf("thunder_cloud_and_rain"), 58, 18, false),
    TwitterEmoji(String(intArrayOf(0x1F324, 0xFE0F), 0, 2), listOf("mostly_sunny", "sun_small_cloud"), 5, 33, false),
    TwitterEmoji(String(intArrayOf(0x1F325, 0xFE0F), 0, 2), listOf("barely_sunny", "sun_behind_cloud"), 5, 34, false),
    TwitterEmoji(String(intArrayOf(0x1F326, 0xFE0F), 0, 2), listOf("partly_sunny_rain", "sun_behind_rain_cloud"), 5, 35, false),
    TwitterEmoji(String(intArrayOf(0x1F327, 0xFE0F), 0, 2), listOf("rain_cloud"), 5, 36, false),
    TwitterEmoji(String(intArrayOf(0x1F328, 0xFE0F), 0, 2), listOf("snow_cloud"), 5, 37, false),
    TwitterEmoji(String(intArrayOf(0x1F329, 0xFE0F), 0, 2), listOf("lightning", "lightning_cloud"), 5, 38, false),
    TwitterEmoji(String(intArrayOf(0x1F32A, 0xFE0F), 0, 2), listOf("tornado", "tornado_cloud"), 5, 39, false),
    TwitterEmoji(String(intArrayOf(0x1F32B, 0xFE0F), 0, 2), listOf("fog"), 5, 40, false),
    TwitterEmoji(String(intArrayOf(0x1F32C, 0xFE0F), 0, 2), listOf("wind_blowing_face"), 5, 41, false),
    TwitterEmoji(String(intArrayOf(0x1F300), 0, 1), listOf("cyclone"), 4, 60, false),
    TwitterEmoji(String(intArrayOf(0x1F308), 0, 1), listOf("rainbow"), 5, 7, false),
    TwitterEmoji(String(intArrayOf(0x1F302), 0, 1), listOf("closed_umbrella"), 5, 1, false),
    TwitterEmoji(String(intArrayOf(0x2602, 0xFE0F), 0, 2), listOf("umbrella"), 57, 12, false),
    TwitterEmoji(String(intArrayOf(0x2614), 0, 1), listOf("umbrella_with_rain_drops"), 57, 17, false),
    TwitterEmoji(String(intArrayOf(0x26F1, 0xFE0F), 0, 2), listOf("umbrella_on_ground"), 58, 27, false),
    TwitterEmoji(String(intArrayOf(0x26A1), 0, 1), listOf("zap"), 58, 8, false),
    TwitterEmoji(String(intArrayOf(0x2744, 0xFE0F), 0, 2), listOf("snowflake"), 59, 30, false),
    TwitterEmoji(String(intArrayOf(0x2603, 0xFE0F), 0, 2), listOf("snowman"), 57, 13, false),
    TwitterEmoji(String(intArrayOf(0x26C4), 0, 1), listOf("snowman_without_snow"), 58, 16, false),
    TwitterEmoji(String(intArrayOf(0x2604, 0xFE0F), 0, 2), listOf("comet"), 57, 14, false),
    TwitterEmoji(String(intArrayOf(0x1F525), 0, 1), listOf("fire"), 30, 2, false),
    TwitterEmoji(String(intArrayOf(0x1F4A7), 0, 1), listOf("droplet"), 27, 55, false),
    TwitterEmoji(String(intArrayOf(0x1F30A), 0, 1), listOf("ocean"), 5, 9, false),
  )
}
