/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.widget.GridView;
import android.widget.ListAdapter;
import com.vanniktech.emoji.EmojiArrayAdapter;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.VariantEmoji;
import com.vanniktech.emoji.emoji.EmojiCategory;
import com.vanniktech.emoji.listeners.OnEmojiClickListener;
import com.vanniktech.emoji.listeners.OnEmojiLongClickListener;

class EmojiGridView
extends GridView {
    protected EmojiArrayAdapter emojiArrayAdapter;

    EmojiGridView(Context context) {
        super(context);
        Resources resources = this.getResources();
        int width = resources.getDimensionPixelSize(R.dimen.emoji_grid_view_column_width);
        int spacing = resources.getDimensionPixelSize(R.dimen.emoji_grid_view_spacing);
        this.setColumnWidth(width);
        this.setHorizontalSpacing(spacing);
        this.setVerticalSpacing(spacing);
        this.setPadding(spacing, spacing, spacing, spacing);
        this.setNumColumns(-1);
        this.setClipToPadding(false);
        this.setVerticalScrollBarEnabled(false);
    }

    public EmojiGridView init(@Nullable OnEmojiClickListener onEmojiClickListener, @Nullable OnEmojiLongClickListener onEmojiLongClickListener, @NonNull EmojiCategory category, @NonNull VariantEmoji variantManager) {
        this.emojiArrayAdapter = new EmojiArrayAdapter(this.getContext(), category.getEmojis(), variantManager, onEmojiClickListener, onEmojiLongClickListener);
        this.setAdapter((ListAdapter)this.emojiArrayAdapter);
        return this;
    }
}

