/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.Spannable;
import android.text.TextUtils;
import com.vanniktech.emoji.EmojiProvider;
import com.vanniktech.emoji.EmojiRange;
import com.vanniktech.emoji.EmojiReplacer;
import com.vanniktech.emoji.EmojiSpan;
import com.vanniktech.emoji.Utils;
import com.vanniktech.emoji.emoji.Emoji;
import com.vanniktech.emoji.emoji.EmojiCategory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EmojiManager {
    private static final EmojiManager INSTANCE = new EmojiManager();
    private static final int GUESSED_UNICODE_AMOUNT = 3000;
    private static final int GUESSED_TOTAL_PATTERN_LENGTH = 12000;
    private static final Comparator<String> STRING_LENGTH_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String first, String second) {
            int secondLength;
            int firstLength = first.length();
            return firstLength < (secondLength = second.length()) ? 1 : (firstLength == secondLength ? 0 : -1);
        }
    };
    private static final EmojiReplacer DEFAULT_EMOJI_REPLACER = new EmojiReplacer(){

        @Override
        public void replaceWithImages(Context context, Spannable text, float emojiSize, float defaultEmojiSize, EmojiReplacer fallback) {
            EmojiManager emojiManager = EmojiManager.getInstance();
            EmojiSpan[] existingSpans = (EmojiSpan[])text.getSpans(0, text.length(), EmojiSpan.class);
            ArrayList<Integer> existingSpanPositions = new ArrayList<Integer>(existingSpans.length);
            int size = existingSpans.length;
            for (int i = 0; i < size; ++i) {
                existingSpanPositions.add(text.getSpanStart((Object)existingSpans[i]));
            }
            List<EmojiRange> findAllEmojis = emojiManager.findAllEmojis((CharSequence)text);
            for (int i = 0; i < findAllEmojis.size(); ++i) {
                EmojiRange location = findAllEmojis.get(i);
                if (existingSpanPositions.contains(location.start)) continue;
                text.setSpan((Object)new EmojiSpan(context, location.emoji, emojiSize), location.start, location.end, 33);
            }
        }
    };
    private final Map<String, Emoji> emojiMap = new LinkedHashMap<String, Emoji>(3000);
    private EmojiCategory[] categories;
    private Pattern emojiPattern;
    private Pattern emojiRepetitivePattern;
    private EmojiReplacer emojiReplacer;

    private EmojiManager() {
    }

    public static EmojiManager getInstance() {
        return INSTANCE;
    }

    public static void install(@NonNull EmojiProvider provider) {
        EmojiManager.INSTANCE.categories = Utils.checkNotNull(provider.getCategories(), "categories == null");
        EmojiManager.INSTANCE.emojiMap.clear();
        EmojiManager.INSTANCE.emojiReplacer = provider instanceof EmojiReplacer ? (EmojiReplacer)((Object)provider) : DEFAULT_EMOJI_REPLACER;
        ArrayList<String> unicodesForPattern = new ArrayList<String>(3000);
        int categoriesSize = EmojiManager.INSTANCE.categories.length;
        for (int i = 0; i < categoriesSize; ++i) {
            for (Emoji emoji : Utils.checkNotNull(EmojiManager.INSTANCE.categories[i].getEmojis(), "emojies == null")) {
                String unicode = emoji.getUnicode();
                List<Emoji> variants = emoji.getVariants();
                EmojiManager.INSTANCE.emojiMap.put(unicode, emoji);
                unicodesForPattern.add(unicode);
                for (int k = 0; k < variants.size(); ++k) {
                    Emoji variant = variants.get(k);
                    String variantUnicode = variant.getUnicode();
                    EmojiManager.INSTANCE.emojiMap.put(variantUnicode, variant);
                    unicodesForPattern.add(variantUnicode);
                }
            }
        }
        if (unicodesForPattern.isEmpty()) {
            throw new IllegalArgumentException("Your EmojiProvider must at least have one category with at least one emoji.");
        }
        Collections.sort(unicodesForPattern, STRING_LENGTH_COMPARATOR);
        StringBuilder patternBuilder = new StringBuilder(12000);
        int unicodesForPatternSize = unicodesForPattern.size();
        for (int i = 0; i < unicodesForPatternSize; ++i) {
            patternBuilder.append(Pattern.quote((String)unicodesForPattern.get(i))).append('|');
        }
        String regex = patternBuilder.deleteCharAt(patternBuilder.length() - 1).toString();
        EmojiManager.INSTANCE.emojiPattern = Pattern.compile(regex);
        EmojiManager.INSTANCE.emojiRepetitivePattern = Pattern.compile('(' + regex + ")+");
    }

    public static void destroy() {
        EmojiManager.release();
        EmojiManager.INSTANCE.emojiMap.clear();
        EmojiManager.INSTANCE.categories = null;
        EmojiManager.INSTANCE.emojiPattern = null;
        EmojiManager.INSTANCE.emojiRepetitivePattern = null;
        EmojiManager.INSTANCE.emojiReplacer = null;
    }

    public static void release() {
        for (Emoji emoji : EmojiManager.INSTANCE.emojiMap.values()) {
            emoji.destroy();
        }
    }

    public void replaceWithImages(Context context, Spannable text, float emojiSize, float defaultEmojiSize) {
        this.verifyInstalled();
        this.emojiReplacer.replaceWithImages(context, text, emojiSize, defaultEmojiSize, DEFAULT_EMOJI_REPLACER);
    }

    EmojiCategory[] getCategories() {
        this.verifyInstalled();
        return this.categories;
    }

    Pattern getEmojiRepetitivePattern() {
        return this.emojiRepetitivePattern;
    }

    @NonNull
    List<EmojiRange> findAllEmojis(@Nullable CharSequence text) {
        this.verifyInstalled();
        ArrayList<EmojiRange> result = new ArrayList<EmojiRange>();
        if (!TextUtils.isEmpty((CharSequence)text)) {
            Matcher matcher = this.emojiPattern.matcher(text);
            while (matcher.find()) {
                Emoji found = this.findEmoji(text.subSequence(matcher.start(), matcher.end()));
                if (found == null) continue;
                result.add(new EmojiRange(matcher.start(), matcher.end(), found));
            }
        }
        return result;
    }

    @Nullable
    Emoji findEmoji(@NonNull CharSequence candidate) {
        this.verifyInstalled();
        return this.emojiMap.get(candidate.toString());
    }

    void verifyInstalled() {
        if (this.categories == null) {
            throw new IllegalStateException("Please install an EmojiProvider through the EmojiManager.install() method first.");
        }
    }
}

