/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.support.annotation.CallSuper;
import android.support.annotation.DimenRes;
import android.support.annotation.Px;
import android.support.v7.widget.AppCompatMultiAutoCompleteTextView;
import android.text.Spannable;
import android.util.AttributeSet;
import android.widget.EditText;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.Utils;
import com.vanniktech.emoji.emoji.Emoji;

public class EmojiMultiAutoCompleteTextView
extends AppCompatMultiAutoCompleteTextView {
    private float emojiSize;

    public EmojiMultiAutoCompleteTextView(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmojiMultiAutoCompleteTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            EmojiManager.getInstance().verifyInstalled();
        }
        Paint.FontMetrics fontMetrics = this.getPaint().getFontMetrics();
        float defaultEmojiSize = fontMetrics.descent - fontMetrics.ascent;
        if (attrs == null) {
            this.emojiSize = defaultEmojiSize;
        } else {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.EmojiMultiAutoCompleteTextView);
            try {
                this.emojiSize = a.getDimension(R.styleable.EmojiMultiAutoCompleteTextView_emojiSize, defaultEmojiSize);
            }
            finally {
                a.recycle();
            }
        }
        this.setText((CharSequence)this.getText());
    }

    @CallSuper
    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        Paint.FontMetrics fontMetrics = this.getPaint().getFontMetrics();
        float defaultEmojiSize = fontMetrics.descent - fontMetrics.ascent;
        EmojiManager.getInstance().replaceWithImages(this.getContext(), (Spannable)this.getText(), this.emojiSize, defaultEmojiSize);
    }

    @CallSuper
    public void backspace() {
        Utils.backspace((EditText)this);
    }

    @CallSuper
    public void input(Emoji emoji) {
        Utils.input((EditText)this, emoji);
    }

    public final float getEmojiSize() {
        return this.emojiSize;
    }

    public final void setEmojiSize(@Px int pixels) {
        this.setEmojiSize(pixels, true);
    }

    public final void setEmojiSize(@Px int pixels, boolean shouldInvalidate) {
        this.emojiSize = pixels;
        if (shouldInvalidate) {
            this.setText((CharSequence)this.getText());
        }
    }

    public final void setEmojiSizeRes(@DimenRes int res) {
        this.setEmojiSizeRes(res, true);
    }

    public final void setEmojiSizeRes(@DimenRes int res, boolean shouldInvalidate) {
        this.setEmojiSize(this.getResources().getDimensionPixelSize(res), shouldInvalidate);
    }
}

