/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ResultReceiver;
import android.support.annotation.CheckResult;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.autofill.AutofillManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.PopupWindow;
import com.vanniktech.emoji.EmojiImageView;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.EmojiResultReceiver;
import com.vanniktech.emoji.EmojiVariantPopup;
import com.vanniktech.emoji.EmojiView;
import com.vanniktech.emoji.RecentEmoji;
import com.vanniktech.emoji.RecentEmojiManager;
import com.vanniktech.emoji.Utils;
import com.vanniktech.emoji.VariantEmoji;
import com.vanniktech.emoji.VariantEmojiManager;
import com.vanniktech.emoji.emoji.Emoji;
import com.vanniktech.emoji.listeners.OnEmojiBackspaceClickListener;
import com.vanniktech.emoji.listeners.OnEmojiClickListener;
import com.vanniktech.emoji.listeners.OnEmojiLongClickListener;
import com.vanniktech.emoji.listeners.OnEmojiPopupDismissListener;
import com.vanniktech.emoji.listeners.OnEmojiPopupShownListener;
import com.vanniktech.emoji.listeners.OnSoftKeyboardCloseListener;
import com.vanniktech.emoji.listeners.OnSoftKeyboardOpenListener;

public final class EmojiPopup
implements EmojiResultReceiver.Receiver {
    static final String TAG = "EmojiPopup";
    static final int MIN_KEYBOARD_HEIGHT = 50;
    final View rootView;
    final Activity context;
    @NonNull
    final RecentEmoji recentEmoji;
    @NonNull
    final VariantEmoji variantEmoji;
    @NonNull
    final EmojiVariantPopup variantPopup;
    final PopupWindow popupWindow;
    final EditText editText;
    boolean isPendingOpen;
    boolean isKeyboardOpen;
    @Nullable
    OnEmojiPopupShownListener onEmojiPopupShownListener;
    @Nullable
    OnSoftKeyboardCloseListener onSoftKeyboardCloseListener;
    @Nullable
    OnSoftKeyboardOpenListener onSoftKeyboardOpenListener;
    @Nullable
    OnEmojiBackspaceClickListener onEmojiBackspaceClickListener;
    @Nullable
    OnEmojiClickListener onEmojiClickListener;
    @Nullable
    OnEmojiPopupDismissListener onEmojiPopupDismissListener;
    int originalImeOptions = -1;
    final EmojiResultReceiver emojiResultReceiver = new EmojiResultReceiver(new Handler(Looper.getMainLooper()));
    final ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            EmojiPopup.this.updateKeyboardState();
        }
    };

    EmojiPopup(@NonNull View rootView, final @NonNull EditText editText, @Nullable RecentEmoji recent, @Nullable VariantEmoji variant, @ColorInt int backgroundColor, @ColorInt int iconColor, @ColorInt int dividerColor, @StyleRes int animationStyle, @Nullable ViewPager.PageTransformer pageTransformer) {
        this.context = Utils.asActivity(rootView.getContext());
        this.rootView = rootView.getRootView();
        this.editText = editText;
        this.recentEmoji = recent != null ? recent : new RecentEmojiManager((Context)this.context);
        this.variantEmoji = variant != null ? variant : new VariantEmojiManager((Context)this.context);
        this.popupWindow = new PopupWindow((Context)this.context);
        OnEmojiLongClickListener longClickListener = new OnEmojiLongClickListener(){

            @Override
            public void onEmojiLongClick(@NonNull EmojiImageView view, @NonNull Emoji emoji) {
                EmojiPopup.this.variantPopup.show(view, emoji);
            }
        };
        OnEmojiClickListener clickListener = new OnEmojiClickListener(){

            @Override
            public void onEmojiClick(@NonNull EmojiImageView imageView, @NonNull Emoji emoji) {
                Utils.input(editText, emoji);
                EmojiPopup.this.recentEmoji.addEmoji(emoji);
                EmojiPopup.this.variantEmoji.addVariant(emoji);
                imageView.updateEmoji(emoji);
                if (EmojiPopup.this.onEmojiClickListener != null) {
                    EmojiPopup.this.onEmojiClickListener.onEmojiClick(imageView, emoji);
                }
                EmojiPopup.this.variantPopup.dismiss();
            }
        };
        this.variantPopup = new EmojiVariantPopup(this.rootView, clickListener);
        EmojiView emojiView = new EmojiView((Context)this.context, clickListener, longClickListener, this.recentEmoji, this.variantEmoji, backgroundColor, iconColor, dividerColor, pageTransformer);
        emojiView.setOnEmojiBackspaceClickListener(new OnEmojiBackspaceClickListener(){

            @Override
            public void onEmojiBackspaceClick(View v) {
                Utils.backspace(editText);
                if (EmojiPopup.this.onEmojiBackspaceClickListener != null) {
                    EmojiPopup.this.onEmojiBackspaceClickListener.onEmojiBackspaceClick(v);
                }
            }
        });
        this.popupWindow.setContentView((View)emojiView);
        this.popupWindow.setInputMethodMode(2);
        this.popupWindow.setBackgroundDrawable((Drawable)new BitmapDrawable(this.context.getResources(), (Bitmap)null));
        this.popupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                if (EmojiPopup.this.onEmojiPopupDismissListener != null) {
                    EmojiPopup.this.onEmojiPopupDismissListener.onEmojiPopupDismiss();
                }
            }
        });
        if (animationStyle != 0) {
            this.popupWindow.setAnimationStyle(animationStyle);
        }
        rootView.getViewTreeObserver().addOnGlobalLayoutListener(this.onGlobalLayoutListener);
    }

    void updateKeyboardState() {
        int keyboardHeight = Utils.getInputMethodHeight((Context)this.context, this.rootView);
        if (keyboardHeight > Utils.dpToPx((Context)this.context, 50.0f)) {
            this.updateKeyboardStateOpened(keyboardHeight);
        } else {
            this.updateKeyboardStateClosed();
        }
    }

    private void updateKeyboardStateOpened(int keyboardHeight) {
        int properWidth;
        if (this.popupWindow.getHeight() != keyboardHeight) {
            this.popupWindow.setHeight(keyboardHeight);
        }
        Rect rect = Utils.windowVisibleDisplayFrame(this.context);
        int n = properWidth = Utils.getOrientation((Context)this.context) == 1 ? rect.right : Utils.getScreenWidth(this.context);
        if (this.popupWindow.getWidth() != properWidth) {
            this.popupWindow.setWidth(properWidth);
        }
        if (!this.isKeyboardOpen) {
            this.isKeyboardOpen = true;
            if (this.onSoftKeyboardOpenListener != null) {
                this.onSoftKeyboardOpenListener.onKeyboardOpen(keyboardHeight);
            }
        }
        if (this.isPendingOpen) {
            this.showAtBottom();
        }
    }

    private void updateKeyboardStateClosed() {
        this.isKeyboardOpen = false;
        if (this.onSoftKeyboardCloseListener != null) {
            this.onSoftKeyboardCloseListener.onKeyboardClose();
        }
        if (this.isShowing()) {
            this.dismiss();
        }
    }

    public void toggle() {
        if (!this.popupWindow.isShowing()) {
            if (Utils.shouldOverrideRegularCondition((Context)this.context, this.editText) && this.originalImeOptions == -1) {
                this.originalImeOptions = this.editText.getImeOptions();
            }
            this.editText.setFocusableInTouchMode(true);
            this.editText.requestFocus();
            this.showAtBottomPending();
        } else {
            this.dismiss();
        }
    }

    private void showAtBottomPending() {
        this.isPendingOpen = true;
        InputMethodManager inputMethodManager = (InputMethodManager)this.context.getSystemService("input_method");
        if (Utils.shouldOverrideRegularCondition((Context)this.context, this.editText)) {
            this.editText.setImeOptions(this.editText.getImeOptions() | 0x10000000);
            if (inputMethodManager != null) {
                inputMethodManager.restartInput((View)this.editText);
            }
        }
        if (inputMethodManager != null) {
            this.emojiResultReceiver.setReceiver(this);
            inputMethodManager.showSoftInput((View)this.editText, 0, (ResultReceiver)this.emojiResultReceiver);
        }
    }

    public boolean isShowing() {
        return this.popupWindow.isShowing();
    }

    public void dismiss() {
        this.popupWindow.dismiss();
        this.variantPopup.dismiss();
        this.recentEmoji.persist();
        this.variantEmoji.persist();
        this.emojiResultReceiver.setReceiver(null);
        if (this.originalImeOptions != -1) {
            AutofillManager autofillManager;
            this.editText.setImeOptions(this.originalImeOptions);
            InputMethodManager inputMethodManager = (InputMethodManager)this.context.getSystemService("input_method");
            if (inputMethodManager != null) {
                inputMethodManager.restartInput((View)this.editText);
            }
            if (Build.VERSION.SDK_INT >= 26 && (autofillManager = (AutofillManager)this.context.getSystemService(AutofillManager.class)) != null) {
                autofillManager.cancel();
            }
        }
    }

    void showAtBottom() {
        this.isPendingOpen = false;
        this.popupWindow.showAtLocation(this.rootView, 80, 0, 0);
        if (this.onEmojiPopupShownListener != null) {
            this.onEmojiPopupShownListener.onEmojiPopupShown();
        }
    }

    @Override
    public void onReceiveResult(int resultCode, Bundle data) {
        if (resultCode == 0 || resultCode == 1) {
            this.showAtBottom();
        }
    }

    public static final class Builder {
        @NonNull
        private final View rootView;
        @StyleRes
        private int keyboardAnimationStyle;
        @ColorInt
        private int backgroundColor;
        @ColorInt
        private int iconColor;
        @ColorInt
        private int dividerColor;
        @Nullable
        private ViewPager.PageTransformer pageTransformer;
        @Nullable
        private OnEmojiPopupShownListener onEmojiPopupShownListener;
        @Nullable
        private OnSoftKeyboardCloseListener onSoftKeyboardCloseListener;
        @Nullable
        private OnSoftKeyboardOpenListener onSoftKeyboardOpenListener;
        @Nullable
        private OnEmojiBackspaceClickListener onEmojiBackspaceClickListener;
        @Nullable
        private OnEmojiClickListener onEmojiClickListener;
        @Nullable
        private OnEmojiPopupDismissListener onEmojiPopupDismissListener;
        @Nullable
        private RecentEmoji recentEmoji;
        @Nullable
        private VariantEmoji variantEmoji;

        private Builder(View rootView) {
            this.rootView = Utils.checkNotNull(rootView, "The root View can't be null");
        }

        @CheckResult
        public static Builder fromRootView(View rootView) {
            return new Builder(rootView);
        }

        @CheckResult
        public Builder setOnSoftKeyboardCloseListener(@Nullable OnSoftKeyboardCloseListener listener) {
            this.onSoftKeyboardCloseListener = listener;
            return this;
        }

        @CheckResult
        public Builder setOnEmojiClickListener(@Nullable OnEmojiClickListener listener) {
            this.onEmojiClickListener = listener;
            return this;
        }

        @CheckResult
        public Builder setOnSoftKeyboardOpenListener(@Nullable OnSoftKeyboardOpenListener listener) {
            this.onSoftKeyboardOpenListener = listener;
            return this;
        }

        @CheckResult
        public Builder setOnEmojiPopupShownListener(@Nullable OnEmojiPopupShownListener listener) {
            this.onEmojiPopupShownListener = listener;
            return this;
        }

        @CheckResult
        public Builder setOnEmojiPopupDismissListener(@Nullable OnEmojiPopupDismissListener listener) {
            this.onEmojiPopupDismissListener = listener;
            return this;
        }

        @CheckResult
        public Builder setOnEmojiBackspaceClickListener(@Nullable OnEmojiBackspaceClickListener listener) {
            this.onEmojiBackspaceClickListener = listener;
            return this;
        }

        @CheckResult
        public Builder setRecentEmoji(@Nullable RecentEmoji recent) {
            this.recentEmoji = recent;
            return this;
        }

        @CheckResult
        public Builder setVariantEmoji(@Nullable VariantEmoji variant) {
            this.variantEmoji = variant;
            return this;
        }

        @CheckResult
        public Builder setBackgroundColor(@ColorInt int color2) {
            this.backgroundColor = color2;
            return this;
        }

        @CheckResult
        public Builder setIconColor(@ColorInt int color2) {
            this.iconColor = color2;
            return this;
        }

        @CheckResult
        public Builder setDividerColor(@ColorInt int color2) {
            this.dividerColor = color2;
            return this;
        }

        @CheckResult
        public Builder setKeyboardAnimationStyle(@StyleRes int animation) {
            this.keyboardAnimationStyle = animation;
            return this;
        }

        @CheckResult
        public Builder setPageTransformer(@Nullable ViewPager.PageTransformer transformer) {
            this.pageTransformer = transformer;
            return this;
        }

        @CheckResult
        public EmojiPopup build(@NonNull EditText editText) {
            EmojiManager.getInstance().verifyInstalled();
            Utils.checkNotNull(editText, "EditText can't be null");
            EmojiPopup emojiPopup = new EmojiPopup(this.rootView, editText, this.recentEmoji, this.variantEmoji, this.backgroundColor, this.iconColor, this.dividerColor, this.keyboardAnimationStyle, this.pageTransformer);
            emojiPopup.onSoftKeyboardCloseListener = this.onSoftKeyboardCloseListener;
            emojiPopup.onEmojiClickListener = this.onEmojiClickListener;
            emojiPopup.onSoftKeyboardOpenListener = this.onSoftKeyboardOpenListener;
            emojiPopup.onEmojiPopupShownListener = this.onEmojiPopupShownListener;
            emojiPopup.onEmojiPopupDismissListener = this.onEmojiPopupDismissListener;
            emojiPopup.onEmojiBackspaceClickListener = this.onEmojiBackspaceClickListener;
            return emojiPopup;
        }
    }
}

