/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.emoji;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.content.res.AppCompatResources;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Emoji
implements Serializable {
    private static final long serialVersionUID = 3L;
    private static final List<Emoji> EMPTY_EMOJI_LIST = Collections.emptyList();
    @NonNull
    private final String unicode;
    @DrawableRes
    private final int resource;
    private final boolean isDuplicate;
    @NonNull
    private final List<Emoji> variants;
    @Nullable
    private Emoji base;

    public Emoji(@NonNull int[] codePoints, @DrawableRes int resource, boolean isDuplicate) {
        this(codePoints, resource, isDuplicate, new Emoji[0]);
    }

    public Emoji(int codePoint, @DrawableRes int resource, boolean isDuplicate) {
        this(codePoint, resource, isDuplicate, new Emoji[0]);
    }

    public Emoji(int codePoint, @DrawableRes int resource, boolean isDuplicate, Emoji ... variants) {
        this(new int[]{codePoint}, resource, isDuplicate, variants);
    }

    public Emoji(@NonNull int[] codePoints, @DrawableRes int resource, boolean isDuplicate, Emoji ... variants) {
        this.unicode = new String(codePoints, 0, codePoints.length);
        this.resource = resource;
        this.isDuplicate = isDuplicate;
        this.variants = variants.length == 0 ? EMPTY_EMOJI_LIST : Arrays.asList(variants);
        for (Emoji variant : variants) {
            variant.base = this;
        }
    }

    @NonNull
    public String getUnicode() {
        return this.unicode;
    }

    @Deprecated
    @DrawableRes
    public int getResource() {
        return this.resource;
    }

    @NonNull
    public Drawable getDrawable(Context context) {
        return AppCompatResources.getDrawable((Context)context, (int)this.resource);
    }

    public boolean isDuplicate() {
        return this.isDuplicate;
    }

    @NonNull
    public List<Emoji> getVariants() {
        return new ArrayList<Emoji>(this.variants);
    }

    @NonNull
    public Emoji getBase() {
        Emoji result = this;
        while (result.base != null) {
            result = result.base;
        }
        return result;
    }

    public int getLength() {
        return this.unicode.length();
    }

    public boolean hasVariants() {
        return !this.variants.isEmpty();
    }

    public void destroy() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Emoji emoji = (Emoji)o;
        return this.resource == emoji.resource && this.unicode.equals(emoji.unicode) && this.variants.equals(emoji.variants);
    }

    public int hashCode() {
        int result = this.unicode.hashCode();
        result = 31 * result + this.resource;
        result = 31 * result + this.variants.hashCode();
        return result;
    }
}

