/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.code.quality.tools;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LintPlugin;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.repository.Revision;
import com.vanniktech.code.quality.tools.CodeQualityToolsPluginExtension;
import com.vanniktech.code.quality.tools.CodeQualityToolsPluginKt;
import com.vanniktech.code.quality.tools.DetektCheckTask;
import com.vanniktech.code.quality.tools.KtLintFormatTask;
import com.vanniktech.code.quality.tools.KtLintTask;
import de.aaschmid.gradle.plugins.cpd.Cpd;
import de.aaschmid.gradle.plugins.cpd.CpdExtension;
import de.aaschmid.gradle.plugins.cpd.CpdPlugin;
import de.aaschmid.gradle.plugins.cpd.CpdReports;
import de.aaschmid.gradle.plugins.cpd.CpdTextFileReport;
import de.aaschmid.gradle.plugins.cpd.CpdXmlFileReport;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CheckstylePlugin;
import org.gradle.api.plugins.quality.CheckstyleReports;
import org.gradle.api.plugins.quality.FindBugs;
import org.gradle.api.plugins.quality.FindBugsExtension;
import org.gradle.api.plugins.quality.FindBugsPlugin;
import org.gradle.api.plugins.quality.FindBugsReports;
import org.gradle.api.plugins.quality.FindBugsXmlReport;
import org.gradle.api.plugins.quality.Pmd;
import org.gradle.api.plugins.quality.PmdExtension;
import org.gradle.api.plugins.quality.PmdPlugin;
import org.gradle.api.plugins.quality.PmdReports;
import org.gradle.api.reporting.CustomizableHtmlReport;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u0006\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000b\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010\f\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\r\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010\u000e\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u000f\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010\u0010\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u0011\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010\u0012\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\u0012\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014*\u00020\u0007\u001a\f\u0010\u0016\u001a\u00020\u0005*\u00020\u0007H\u0002\u001a\f\u0010\u0017\u001a\u00020\u0005*\u00020\u0007H\u0002\u001a\f\u0010\u0018\u001a\u00020\u0005*\u00020\u0007H\u0002\u001a\u0012\u0010\u0019\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014*\u00020\u0007\u001a\u0014\u0010\u001a\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"GROUP_VERIFICATION", "", "androidGradlePluginVersion", "Lcom/android/repository/Revision;", "hasLintPlugin", "", "addCheckstyle", "Lorg/gradle/api/Project;", "rootProject", "extension", "Lcom/vanniktech/code/quality/tools/CodeQualityToolsPluginExtension;", "addCpd", "addDetekt", "addErrorProne", "addFindbugs", "addKotlin", "addKtlint", "addLint", "addPmd", "editorconfigFiles", "Lorg/gradle/api/file/ConfigurableFileTree;", "kotlin.jvm.PlatformType", "isAndroidProject", "isJavaProject", "isKotlinProject", "kotlinFiles", "shouldIgnore", "gradle-code-quality-tools-plugin"})
public final class CodeQualityToolsPluginKt {
    @NotNull
    public static final String GROUP_VERIFICATION = "verification";

    @NotNull
    public static final Revision androidGradlePluginVersion() {
        Object o = new Object();
        try {
            Revision revision = Revision.parseRevision((String)Class.forName("com.android.builder.Version").getDeclaredField("ANDROID_GRADLE_PLUGIN_VERSION").get(o).toString(), (Revision.Precision)Revision.Precision.PREVIEW);
            Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"Revision.parseRevision(C\u2026vision.Precision.PREVIEW)");
            return revision;
        }
        catch (Exception exception) {
            try {
                Revision revision = Revision.parseRevision((String)Class.forName("com.android.builder.model.Version").getDeclaredField("ANDROID_GRADLE_PLUGIN_VERSION").get(o).toString(), (Revision.Precision)Revision.Precision.PREVIEW);
                Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"Revision.parseRevision(C\u2026vision.Precision.PREVIEW)");
                return revision;
            }
            catch (Exception exception2) {
                throw (Throwable)new IllegalArgumentException("Can't get Android Gradle Plugin version");
            }
        }
    }

    public static final boolean hasLintPlugin() {
        boolean bl;
        try {
            Class.forName("com.android.build.gradle.LintPlugin");
            bl = true;
        }
        catch (ClassNotFoundException ignored) {
            bl = false;
        }
        return bl;
    }

    public static final ConfigurableFileTree kotlinFiles(@NotNull Project $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.fileTree(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"dir", (Object)"."), TuplesKt.to((Object)"exclude", (Object)"**/build/**"), TuplesKt.to((Object)"includes", (Object)CollectionsKt.listOf((Object[])new String[]{"**/*.kt", "**/*.kts"}))}));
    }

    public static final ConfigurableFileTree editorconfigFiles(@NotNull Project $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.fileTree(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"dir", (Object)"."), TuplesKt.to((Object)"include", (Object)"**/.editorconfig")}));
    }

    public static final boolean addPmd(@NotNull Project $receiver, @NotNull Project rootProject, @NotNull CodeQualityToolsPluginExtension extension) {
        boolean isPmdSupported;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)rootProject, (String)"rootProject");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        boolean isNotIgnored = !CodeQualityToolsPluginKt.shouldIgnore($receiver, extension);
        boolean isEnabled = extension.getPmd().getEnabled();
        boolean bl = isPmdSupported = CodeQualityToolsPluginKt.isJavaProject($receiver) || CodeQualityToolsPluginKt.isAndroidProject($receiver);
        if (isNotIgnored && isEnabled && isPmdSupported) {
            $receiver.getPlugins().apply(PmdPlugin.class);
            $receiver.getExtensions().configure(PmdExtension.class, (Action)new Action<PmdExtension>($receiver, extension, rootProject){
                final /* synthetic */ Project $this_addPmd;
                final /* synthetic */ CodeQualityToolsPluginExtension $extension;
                final /* synthetic */ Project $rootProject;

                public final void execute(PmdExtension it) {
                    PmdExtension pmdExtension = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pmdExtension, (String)"it");
                    pmdExtension.setToolVersion(this.$extension.getPmd().getToolVersion());
                    Boolean bl = this.$extension.getPmd().getIgnoreFailures();
                    it.setIgnoreFailures(bl != null ? bl : !this.$extension.getFailEarly());
                    it.setRuleSetFiles((FileCollection)this.$this_addPmd.files(new Object[]{this.$rootProject.file((Object)this.$extension.getPmd().getRuleSetFile())}));
                }
                {
                    this.$this_addPmd = project;
                    this.$extension = codeQualityToolsPluginExtension;
                    this.$rootProject = project2;
                }
            });
            $receiver.getTasks().register("pmd", Pmd.class, (Action)new Action<Pmd>($receiver, extension){
                final /* synthetic */ Project $this_addPmd;
                final /* synthetic */ CodeQualityToolsPluginExtension $extension;

                public final void execute(Pmd it) {
                    Pmd pmd = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)pmd, (String)"it");
                    pmd.setDescription("Runs pmd.");
                    it.setGroup("verification");
                    it.setRuleSets(CollectionsKt.emptyList());
                    it.setSource((FileTree)this.$this_addPmd.fileTree((Object)this.$extension.getPmd().getSource()));
                    it.include((Iterable)this.$extension.getPmd().getInclude());
                    it.exclude((Iterable)this.$extension.getPmd().getExclude());
                    PmdReports pmdReports = it.getReports();
                    Intrinsics.checkExpressionValueIsNotNull((Object)pmdReports, (String)"it.reports");
                    SingleFileReport singleFileReport = pmdReports.getHtml();
                    Intrinsics.checkExpressionValueIsNotNull((Object)singleFileReport, (String)"it.reports.html");
                    singleFileReport.setEnabled(this.$extension.getHtmlReports());
                    PmdReports pmdReports2 = it.getReports();
                    Intrinsics.checkExpressionValueIsNotNull((Object)pmdReports2, (String)"it.reports");
                    SingleFileReport singleFileReport2 = pmdReports2.getXml();
                    Intrinsics.checkExpressionValueIsNotNull((Object)singleFileReport2, (String)"it.reports.xml");
                    singleFileReport2.setEnabled(this.$extension.getXmlReports());
                }
                {
                    this.$this_addPmd = project;
                    this.$extension = codeQualityToolsPluginExtension;
                }
            });
            $receiver.getTasks().named("check").configure((Action)addPmd.3.INSTANCE);
            return true;
        }
        return false;
    }

    public static final boolean addCheckstyle(@NotNull Project $receiver, @NotNull Project rootProject, @NotNull CodeQualityToolsPluginExtension extension) {
        boolean isCheckstyleSupported;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)rootProject, (String)"rootProject");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        boolean isNotIgnored = !CodeQualityToolsPluginKt.shouldIgnore($receiver, extension);
        boolean isEnabled = extension.getCheckstyle().getEnabled();
        boolean bl = isCheckstyleSupported = CodeQualityToolsPluginKt.isJavaProject($receiver) || CodeQualityToolsPluginKt.isAndroidProject($receiver);
        if (isNotIgnored && isEnabled && isCheckstyleSupported) {
            $receiver.getPlugins().apply(CheckstylePlugin.class);
            $receiver.getExtensions().configure(CheckstyleExtension.class, (Action)new Action<CheckstyleExtension>(extension, rootProject){
                final /* synthetic */ CodeQualityToolsPluginExtension $extension;
                final /* synthetic */ Project $rootProject;

                public final void execute(CheckstyleExtension it) {
                    CheckstyleExtension checkstyleExtension = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)checkstyleExtension, (String)"it");
                    checkstyleExtension.setToolVersion(this.$extension.getCheckstyle().getToolVersion());
                    it.setConfigFile(this.$rootProject.file((Object)this.$extension.getCheckstyle().getConfigFile()));
                    Boolean bl = this.$extension.getCheckstyle().getIgnoreFailures();
                    it.setIgnoreFailures(bl != null ? bl : !this.$extension.getFailEarly());
                    Boolean bl2 = this.$extension.getCheckstyle().getShowViolations();
                    it.setShowViolations(bl2 != null ? bl2.booleanValue() : this.$extension.getFailEarly());
                }
                {
                    this.$extension = codeQualityToolsPluginExtension;
                    this.$rootProject = project;
                }
            });
            $receiver.getTasks().register("checkstyle", Checkstyle.class, (Action)new Action<Checkstyle>($receiver, extension){
                final /* synthetic */ Project $this_addCheckstyle;
                final /* synthetic */ CodeQualityToolsPluginExtension $extension;

                public final void execute(Checkstyle it) {
                    Checkstyle checkstyle = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)checkstyle, (String)"it");
                    checkstyle.setDescription("Runs checkstyle.");
                    it.setGroup("verification");
                    it.setSource((FileTree)this.$this_addCheckstyle.fileTree((Object)this.$extension.getCheckstyle().getSource()));
                    it.include((Iterable)this.$extension.getCheckstyle().getInclude());
                    it.exclude((Iterable)this.$extension.getCheckstyle().getExclude());
                    it.setClasspath((FileCollection)this.$this_addCheckstyle.files(new Object[0]));
                    CheckstyleReports checkstyleReports = it.getReports();
                    Intrinsics.checkExpressionValueIsNotNull((Object)checkstyleReports, (String)"it.reports");
                    CustomizableHtmlReport customizableHtmlReport = checkstyleReports.getHtml();
                    Intrinsics.checkExpressionValueIsNotNull((Object)customizableHtmlReport, (String)"it.reports.html");
                    customizableHtmlReport.setEnabled(this.$extension.getHtmlReports());
                    CheckstyleReports checkstyleReports2 = it.getReports();
                    Intrinsics.checkExpressionValueIsNotNull((Object)checkstyleReports2, (String)"it.reports");
                    SingleFileReport singleFileReport = checkstyleReports2.getXml();
                    Intrinsics.checkExpressionValueIsNotNull((Object)singleFileReport, (String)"it.reports.xml");
                    singleFileReport.setEnabled(this.$extension.getXmlReports());
                }
                {
                    this.$this_addCheckstyle = project;
                    this.$extension = codeQualityToolsPluginExtension;
                }
            });
            $receiver.getTasks().named("check").configure((Action)addCheckstyle.3.INSTANCE);
            return true;
        }
        return false;
    }

    public static final boolean addFindbugs(@NotNull Project $receiver, @NotNull Project rootProject, @NotNull CodeQualityToolsPluginExtension extension) {
        boolean isFindbugsSupported;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)rootProject, (String)"rootProject");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        boolean isNotIgnored = !CodeQualityToolsPluginKt.shouldIgnore($receiver, extension);
        boolean isEnabled = extension.getFindbugs().getEnabled();
        boolean bl = isFindbugsSupported = CodeQualityToolsPluginKt.isJavaProject($receiver) || CodeQualityToolsPluginKt.isAndroidProject($receiver) || CodeQualityToolsPluginKt.isKotlinProject($receiver);
        if (isNotIgnored && isEnabled && isFindbugsSupported) {
            List buildDirIncludes = new ArrayList();
            if (CodeQualityToolsPluginKt.isAndroidProject($receiver)) {
                Revision androidGradlePluginVersion = CodeQualityToolsPluginKt.androidGradlePluginVersion();
                if (androidGradlePluginVersion.compareTo(Revision.parseRevision((String)"3.2.0", (Revision.Precision)Revision.Precision.PREVIEW)) >= 0) {
                    buildDirIncludes.add("intermediates/javac/debug/**");
                } else {
                    buildDirIncludes.add("intermediates/classes/debug/**");
                }
            } else {
                if (CodeQualityToolsPluginKt.isKotlinProject($receiver)) {
                    buildDirIncludes.add("classes/kotlin/main/**");
                }
                if (CodeQualityToolsPluginKt.isJavaProject($receiver)) {
                    buildDirIncludes.add("classes/java/main/**");
                }
            }
            $receiver.getPlugins().apply(FindBugsPlugin.class);
            $receiver.getExtensions().configure(FindBugsExtension.class, (Action)new Action<FindBugsExtension>(extension, rootProject){
                final /* synthetic */ CodeQualityToolsPluginExtension $extension;
                final /* synthetic */ Project $rootProject;

                public final void execute(FindBugsExtension it) {
                    FindBugsExtension findBugsExtension = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)findBugsExtension, (String)"it");
                    findBugsExtension.setSourceSets((Collection)CollectionsKt.emptyList());
                    Boolean bl = this.$extension.getFindbugs().getIgnoreFailures();
                    it.setIgnoreFailures(bl != null ? bl : !this.$extension.getFailEarly());
                    it.setToolVersion(this.$extension.getFindbugs().getToolVersion());
                    it.setEffort(this.$extension.getFindbugs().getEffort());
                    it.setReportLevel(this.$extension.getFindbugs().getReportLevel());
                    it.setExcludeFilter(this.$rootProject.file((Object)this.$extension.getFindbugs().getExcludeFilter()));
                }
                {
                    this.$extension = codeQualityToolsPluginExtension;
                    this.$rootProject = project;
                }
            });
            $receiver.getTasks().register("findbugs", FindBugs.class, (Action)new Action<FindBugs>($receiver, buildDirIncludes, extension){
                final /* synthetic */ Project $this_addFindbugs;
                final /* synthetic */ List $buildDirIncludes;
                final /* synthetic */ CodeQualityToolsPluginExtension $extension;

                public final void execute(FindBugs it) {
                    FindBugs findBugs = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)findBugs, (String)"it");
                    findBugs.setDescription("Runs findbugs.");
                    it.setGroup("verification");
                    PatternFilterable patternFilterable = this.$this_addFindbugs.fileTree((Object)this.$this_addFindbugs.getBuildDir()).include((Iterable)this.$buildDirIncludes);
                    if (patternFilterable == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.file.FileTree");
                    }
                    it.setClasses((FileCollection)((FileTree)patternFilterable));
                    it.setSource((FileTree)this.$this_addFindbugs.fileTree((Object)this.$extension.getFindbugs().getSource()));
                    it.setClasspath((FileCollection)this.$this_addFindbugs.files(new Object[0]));
                    FindBugsReports findBugsReports = it.getReports();
                    Intrinsics.checkExpressionValueIsNotNull((Object)findBugsReports, (String)"it.reports");
                    CustomizableHtmlReport customizableHtmlReport = findBugsReports.getHtml();
                    Intrinsics.checkExpressionValueIsNotNull((Object)customizableHtmlReport, (String)"it.reports.html");
                    customizableHtmlReport.setEnabled(this.$extension.getHtmlReports());
                    FindBugsReports findBugsReports2 = it.getReports();
                    Intrinsics.checkExpressionValueIsNotNull((Object)findBugsReports2, (String)"it.reports");
                    FindBugsXmlReport findBugsXmlReport = findBugsReports2.getXml();
                    Intrinsics.checkExpressionValueIsNotNull((Object)findBugsXmlReport, (String)"it.reports.xml");
                    findBugsXmlReport.setEnabled(this.$extension.getXmlReports());
                    it.dependsOn(new Object[]{"assemble"});
                }
                {
                    this.$this_addFindbugs = project;
                    this.$buildDirIncludes = list;
                    this.$extension = codeQualityToolsPluginExtension;
                }
            });
            $receiver.getTasks().named("check").configure((Action)addFindbugs.3.INSTANCE);
            return true;
        }
        return false;
    }

    public static final boolean addLint(@NotNull Project $receiver, @NotNull CodeQualityToolsPluginExtension extension) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        boolean isNotIgnored = !CodeQualityToolsPluginKt.shouldIgnore($receiver, extension);
        boolean isEnabled = extension.getLint().getEnabled();
        boolean isAndroidProject = CodeQualityToolsPluginKt.isAndroidProject($receiver);
        boolean isJavaProject = CodeQualityToolsPluginKt.isJavaProject($receiver);
        if (isNotIgnored && isEnabled) {
            LintOptions lintOptions;
            LintOptions lintOptions2;
            if (isAndroidProject) {
                Object object = $receiver.getExtensions().getByType(BaseExtension.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"extensions.getByType(BaseExtension::class.java)");
                lintOptions2 = ((BaseExtension)object).getLintOptions();
            } else if (isJavaProject && CodeQualityToolsPluginKt.hasLintPlugin()) {
                $receiver.getPlugins().apply(LintPlugin.class);
                lintOptions2 = (LintOptions)$receiver.getExtensions().getByType(LintOptions.class);
            } else {
                lintOptions2 = lintOptions = null;
            }
            if (lintOptions != null) {
                boolean it;
                Object object;
                Boolean bl = extension.getLint().getWarningsAsErrors();
                lintOptions.setWarningsAsErrors(bl != null ? bl.booleanValue() : extension.getFailEarly());
                Boolean bl2 = extension.getLint().getAbortOnError();
                lintOptions.setAbortOnError(bl2 != null ? bl2.booleanValue() : extension.getFailEarly());
                Boolean bl3 = extension.getLint().getCheckAllWarnings();
                if (bl3 != null) {
                    object = bl3;
                    it = (Boolean)object;
                    boolean bl4 = false;
                    lintOptions.setCheckAllWarnings(it);
                }
                Boolean bl5 = extension.getLint().getAbsolutePaths();
                if (bl5 != null) {
                    object = bl5;
                    it = (Boolean)object;
                    boolean bl6 = false;
                    lintOptions.setAbsolutePaths(it);
                }
                String string = extension.getLint().getBaselineFileName();
                if (string != null) {
                    Object it2 = object = string;
                    boolean bl7 = false;
                    lintOptions.setBaselineFile($receiver.file(it2));
                }
                File file = extension.getLint().getLintConfig();
                if (file != null) {
                    Object it3 = object = file;
                    boolean bl8 = false;
                    lintOptions.setLintConfig((File)it3);
                }
                Boolean bl9 = extension.getLint().getCheckReleaseBuilds();
                if (bl9 != null) {
                    object = bl9;
                    boolean it4 = (Boolean)object;
                    boolean bl10 = false;
                    lintOptions.setCheckReleaseBuilds(it4);
                }
                Boolean bl11 = extension.getLint().getCheckTestSources();
                if (bl11 != null) {
                    object = bl11;
                    boolean it5 = (Boolean)object;
                    boolean bl12 = false;
                    lintOptions.setCheckTestSources(it5);
                }
                Boolean bl13 = extension.getLint().getCheckDependencies();
                if (bl13 != null) {
                    object = bl13;
                    boolean it6 = (Boolean)object;
                    boolean bl14 = false;
                    lintOptions.setCheckDependencies(it6);
                }
                Boolean bl15 = extension.getLint().getTextReport();
                if (bl15 != null) {
                    object = bl15;
                    boolean it7 = (Boolean)object;
                    boolean bl16 = false;
                    lintOptions.setTextReport(it7);
                    lintOptions.textOutput(extension.getLint().getTextOutput());
                }
                $receiver.getTasks().named("check").configure((Action)addLint.9.INSTANCE);
                return true;
            }
        }
        return false;
    }

    public static final boolean addKotlin(@NotNull Project $receiver, @NotNull CodeQualityToolsPluginExtension extension) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        boolean isNotIgnored = !CodeQualityToolsPluginKt.shouldIgnore($receiver, extension);
        boolean isKotlinProject = CodeQualityToolsPluginKt.isKotlinProject($receiver);
        if (isNotIgnored && isKotlinProject) {
            Project project = $receiver.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
            project.getTasks().withType(KotlinCompile.class, (Action)new Action<KotlinCompile>(extension){
                final /* synthetic */ CodeQualityToolsPluginExtension $extension;

                public final void execute(KotlinCompile it) {
                    it.getKotlinOptions().setAllWarningsAsErrors(this.$extension.getKotlin().getAllWarningsAsErrors());
                }
                {
                    this.$extension = codeQualityToolsPluginExtension;
                }
            });
            return true;
        }
        return false;
    }

    public static final boolean addKtlint(@NotNull Project $receiver, @NotNull Project rootProject, @NotNull CodeQualityToolsPluginExtension extension) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)rootProject, (String)"rootProject");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        boolean isNotIgnored = !CodeQualityToolsPluginKt.shouldIgnore($receiver, extension);
        boolean isEnabled = extension.getKtlint().getEnabled();
        boolean isKtlintSupported = CodeQualityToolsPluginKt.isKotlinProject($receiver);
        if (isNotIgnored && isEnabled && isKtlintSupported) {
            String ktlint = "ktlint";
            ((Configuration)$receiver.getConfigurations().create(ktlint)).defaultDependencies((Action)new Action<DependencySet>($receiver, extension){
                final /* synthetic */ Project $this_addKtlint;
                final /* synthetic */ CodeQualityToolsPluginExtension $extension;

                public final void execute(DependencySet it) {
                    it.add((Object)this.$this_addKtlint.getDependencies().create((Object)("com.github.shyiko:ktlint:" + this.$extension.getKtlint().getToolVersion())));
                }
                {
                    this.$this_addKtlint = project;
                    this.$extension = codeQualityToolsPluginExtension;
                }
            });
            $receiver.getTasks().register(ktlint, KtLintTask.class, (Action)new Action<KtLintTask>($receiver, extension, rootProject){
                final /* synthetic */ Project $this_addKtlint;
                final /* synthetic */ CodeQualityToolsPluginExtension $extension;
                final /* synthetic */ Project $rootProject;

                public final void execute(KtLintTask task) {
                    task.setVersion(this.$extension.getKtlint().getToolVersion());
                    task.setOutputDirectory(new File(this.$this_addKtlint.getBuildDir(), "reports/ktlint/"));
                    KtLintTask ktLintTask = task;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktLintTask), (String)"task");
                    ktLintTask.getInputs().files(new Object[]{CodeQualityToolsPluginKt.kotlinFiles(this.$this_addKtlint), CodeQualityToolsPluginKt.editorconfigFiles(this.$rootProject)});
                }
                {
                    this.$this_addKtlint = project;
                    this.$extension = codeQualityToolsPluginExtension;
                    this.$rootProject = project2;
                }
            });
            $receiver.getTasks().register("ktlintFormat", KtLintFormatTask.class, (Action)new Action<KtLintFormatTask>($receiver, extension, rootProject){
                final /* synthetic */ Project $this_addKtlint;
                final /* synthetic */ CodeQualityToolsPluginExtension $extension;
                final /* synthetic */ Project $rootProject;

                public final void execute(KtLintFormatTask task) {
                    task.setVersion(this.$extension.getKtlint().getToolVersion());
                    task.setOutputDirectory(new File(this.$this_addKtlint.getBuildDir(), "reports/ktlint/"));
                    KtLintFormatTask ktLintFormatTask = task;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktLintFormatTask), (String)"task");
                    ktLintFormatTask.getInputs().files(new Object[]{CodeQualityToolsPluginKt.kotlinFiles(this.$this_addKtlint), CodeQualityToolsPluginKt.editorconfigFiles(this.$rootProject)});
                }
                {
                    this.$this_addKtlint = project;
                    this.$extension = codeQualityToolsPluginExtension;
                    this.$rootProject = project2;
                }
            });
            $receiver.getTasks().named("check").configure((Action)new Action<Task>(ktlint){
                final /* synthetic */ String $ktlint;

                public final void execute(Task it) {
                    it.dependsOn(new Object[]{this.$ktlint});
                }
                {
                    this.$ktlint = string;
                }
            });
            return true;
        }
        return false;
    }

    public static final boolean addCpd(@NotNull Project $receiver, @NotNull CodeQualityToolsPluginExtension extension) {
        boolean isCpdSupported;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        boolean isNotIgnored = !CodeQualityToolsPluginKt.shouldIgnore($receiver, extension);
        boolean isEnabled = extension.getCpd().getEnabled();
        boolean bl = isCpdSupported = CodeQualityToolsPluginKt.isJavaProject($receiver) || CodeQualityToolsPluginKt.isAndroidProject($receiver);
        if (isNotIgnored && isEnabled && isCpdSupported) {
            $receiver.getPlugins().apply(CpdPlugin.class);
            $receiver.getExtensions().configure(CpdExtension.class, (Action)new Action<CpdExtension>(extension){
                final /* synthetic */ CodeQualityToolsPluginExtension $extension;

                public final void execute(CpdExtension it) {
                    CpdExtension cpdExtension = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)cpdExtension, (String)"it");
                    cpdExtension.setLanguage(this.$extension.getCpd().getLanguage());
                    it.setToolVersion(this.$extension.getPmd().getToolVersion());
                    Boolean bl = this.$extension.getCpd().getIgnoreFailures();
                    it.setIgnoreFailures(bl != null ? bl : !this.$extension.getFailEarly());
                    it.setMinimumTokenCount(this.$extension.getCpd().getMinimumTokenCount());
                }
                {
                    this.$extension = codeQualityToolsPluginExtension;
                }
            });
            $receiver.getTasks().named("cpdCheck", Cpd.class, (Action)new Action<Cpd>($receiver, extension){
                final /* synthetic */ Project $this_addCpd;
                final /* synthetic */ CodeQualityToolsPluginExtension $extension;

                public final void execute(Cpd it) {
                    Cpd cpd = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)cpd, (String)"it");
                    cpd.setDescription("Runs cpd.");
                    it.setGroup("verification");
                    CpdReports cpdReports = it.getReports();
                    Intrinsics.checkExpressionValueIsNotNull((Object)cpdReports, (String)"it.reports");
                    CpdTextFileReport cpdTextFileReport = cpdReports.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)cpdTextFileReport, (String)"it.reports.text");
                    cpdTextFileReport.setEnabled(this.$extension.getTextReports());
                    CpdReports cpdReports2 = it.getReports();
                    Intrinsics.checkExpressionValueIsNotNull((Object)cpdReports2, (String)"it.reports");
                    CpdXmlFileReport cpdXmlFileReport = cpdReports2.getXml();
                    Intrinsics.checkExpressionValueIsNotNull((Object)cpdXmlFileReport, (String)"it.reports.xml");
                    cpdXmlFileReport.setEnabled(this.$extension.getXmlReports());
                    it.setEncoding("UTF-8");
                    FileCollection fileCollection = this.$this_addCpd.fileTree((Object)this.$extension.getCpd().getSource()).filter((Spec)new Spec<File>(this){
                        final /* synthetic */ addCpd.2 this$0;

                        public final boolean isSatisfiedBy(File it) {
                            File file = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                            String string = file.getName();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.name");
                            return StringsKt.endsWith$default((String)string, (String)('.' + this.this$0.$extension.getCpd().getLanguage()), (boolean)false, (int)2, null);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                    Intrinsics.checkExpressionValueIsNotNull((Object)fileCollection, (String)"fileTree(extension.cpd.s\u2026tension.cpd.language}\") }");
                    it.setSource(fileCollection.getAsFileTree());
                }
                {
                    this.$this_addCpd = project;
                    this.$extension = codeQualityToolsPluginExtension;
                }
            });
            $receiver.getTasks().named("check").configure((Action)addCpd.3.INSTANCE);
            return true;
        }
        return false;
    }

    public static final boolean addDetekt(@NotNull Project $receiver, @NotNull Project rootProject, @NotNull CodeQualityToolsPluginExtension extension) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)rootProject, (String)"rootProject");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        boolean isNotIgnored = !CodeQualityToolsPluginKt.shouldIgnore($receiver, extension);
        boolean isEnabled = extension.getDetekt().getEnabled();
        boolean isDetektSupported = CodeQualityToolsPluginKt.isKotlinProject($receiver);
        if (isNotIgnored && isEnabled && isDetektSupported) {
            ((Configuration)$receiver.getConfigurations().create("detekt")).defaultDependencies((Action)new Action<DependencySet>($receiver, extension){
                final /* synthetic */ Project $this_addDetekt;
                final /* synthetic */ CodeQualityToolsPluginExtension $extension;

                public final void execute(DependencySet it) {
                    it.add((Object)this.$this_addDetekt.getDependencies().create((Object)("io.gitlab.arturbosch.detekt:detekt-cli:" + this.$extension.getDetekt().getToolVersion())));
                }
                {
                    this.$this_addDetekt = project;
                    this.$extension = codeQualityToolsPluginExtension;
                }
            });
            $receiver.getTasks().register("detektCheck", DetektCheckTask.class, (Action)new Action<DetektCheckTask>($receiver, extension, rootProject){
                final /* synthetic */ Project $this_addDetekt;
                final /* synthetic */ CodeQualityToolsPluginExtension $extension;
                final /* synthetic */ Project $rootProject;

                public final void execute(DetektCheckTask task) {
                    block0: {
                        String string;
                        task.setVersion(this.$extension.getDetekt().getToolVersion());
                        task.setOutputDirectory(new File(this.$this_addDetekt.getBuildDir(), "reports/detekt/"));
                        File file = this.$rootProject.file((Object)this.$extension.getDetekt().getConfig());
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"rootProject.file(extension.detekt.config)");
                        task.setConfigFile(file);
                        DetektCheckTask detektCheckTask = task;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)detektCheckTask), (String)"task");
                        detektCheckTask.getInputs().files(new Object[]{CodeQualityToolsPluginKt.kotlinFiles(this.$this_addDetekt)});
                        task.getInputs().property("baseline-file-exists", (Object)false);
                        String string2 = this.$extension.getDetekt().getBaselineFileName();
                        if (string2 == null) break block0;
                        String it = string = string2;
                        boolean bl = false;
                        File file2 = this.$this_addDetekt.file((Object)it);
                        task.setBaselineFilePath(file2.toString());
                        task.getInputs().property("baseline-file-exists", (Object)file2.exists());
                    }
                }
                {
                    this.$this_addDetekt = project;
                    this.$extension = codeQualityToolsPluginExtension;
                    this.$rootProject = project2;
                }
            });
            $receiver.getTasks().named("check").configure((Action)addDetekt.3.INSTANCE);
            return true;
        }
        return false;
    }

    private static final boolean shouldIgnore(@NotNull Project $receiver, CodeQualityToolsPluginExtension extension) {
        return extension.getIgnoreProjects().contains($receiver.getName());
    }

    public static final boolean addErrorProne(@NotNull Project $receiver, @NotNull CodeQualityToolsPluginExtension extension) {
        boolean isErrorProneSupported;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        boolean isNotIgnored = !CodeQualityToolsPluginKt.shouldIgnore($receiver, extension);
        boolean isEnabled = extension.getErrorProne().getEnabled();
        boolean bl = isErrorProneSupported = CodeQualityToolsPluginKt.isJavaProject($receiver) || CodeQualityToolsPluginKt.isAndroidProject($receiver);
        if (isNotIgnored && isEnabled && isErrorProneSupported) {
            $receiver.getPlugins().apply("net.ltgt.errorprone");
            Configuration configuration = $receiver.getConfigurations().getByName("errorprone");
            Intrinsics.checkExpressionValueIsNotNull((Object)configuration, (String)"configurations.getByName(\"errorprone\")");
            configuration.getResolutionStrategy().force(new Object[]{"com.google.errorprone:error_prone_core:" + extension.getErrorProne().getToolVersion()});
            return true;
        }
        return false;
    }

    private static final boolean isJavaProject(@NotNull Project $receiver) {
        boolean isJava = $receiver.getPlugins().hasPlugin("java");
        boolean isJavaLibrary = $receiver.getPlugins().hasPlugin("java-library");
        boolean isJavaGradlePlugin = $receiver.getPlugins().hasPlugin("java-gradle-plugin");
        return isJava || isJavaLibrary || isJavaGradlePlugin;
    }

    private static final boolean isAndroidProject(@NotNull Project $receiver) {
        boolean isAndroidLibrary = $receiver.getPlugins().hasPlugin("com.android.library");
        boolean isAndroidApp = $receiver.getPlugins().hasPlugin("com.android.application");
        boolean isAndroidTest = $receiver.getPlugins().hasPlugin("com.android.test");
        boolean isAndroidFeature = $receiver.getPlugins().hasPlugin("com.android.feature");
        boolean isAndroidInstantApp = $receiver.getPlugins().hasPlugin("com.android.instantapp");
        return isAndroidLibrary || isAndroidApp || isAndroidTest || isAndroidFeature || isAndroidInstantApp;
    }

    private static final boolean isKotlinProject(@NotNull Project $receiver) {
        boolean isKotlin = $receiver.getPlugins().hasPlugin("kotlin");
        boolean isKotlinAndroid = $receiver.getPlugins().hasPlugin("kotlin-android");
        boolean isKotlinPlatformCommon = $receiver.getPlugins().hasPlugin("kotlin-platform-common");
        boolean isKotlinPlatformJvm = $receiver.getPlugins().hasPlugin("kotlin-platform-jvm");
        boolean isKotlinPlatformJs = $receiver.getPlugins().hasPlugin("kotlin-platform-js");
        return isKotlin || isKotlinAndroid || isKotlinPlatformCommon || isKotlinPlatformJvm || isKotlinPlatformJs;
    }
}

