/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.code.quality.tools;

import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskExecutionException;
import org.gradle.process.JavaExecSpec;
import org.gradle.util.VersionNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTask
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0016H\u0007R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001e\u0010\u0012\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\b\u00a8\u0006\u001e"}, d2={"Lcom/vanniktech/code/quality/tools/DetektCheckTask;", "Lorg/gradle/api/DefaultTask;", "()V", "baselineFilePath", "", "getBaselineFilePath", "()Ljava/lang/String;", "setBaselineFilePath", "(Ljava/lang/String;)V", "configFile", "Ljava/io/File;", "getConfigFile", "()Ljava/io/File;", "setConfigFile", "(Ljava/io/File;)V", "outputDirectory", "getOutputDirectory", "setOutputDirectory", "version", "getVersion", "setVersion", "executeDetekt", "", "configuration", "Lorg/gradle/api/file/FileCollection;", "shouldCreateBaseLine", "", "run", "Companion", "ReportingMetaInformation", "gradle-code-quality-tools-plugin"})
public class DetektCheckTask
extends DefaultTask {
    @Input
    @NotNull
    public String version;
    @Input
    @Optional
    @Nullable
    private String baselineFilePath;
    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public File configFile;
    @OutputDirectory
    @PathSensitive(value=PathSensitivity.NONE)
    @NotNull
    public File outputDirectory;
    public static final int RC_BREAKING_POINT = 10;
    private static final VersionNumber VERSION_REPORT_CHANGE;
    private static final VersionNumber VERSION_REPORT_EXTENSION_CHANGE;
    public static final Companion Companion;

    @NotNull
    public final String getVersion() {
        String string = this.version;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"version");
        }
        return string;
    }

    public final void setVersion(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.version = string;
    }

    @Nullable
    public final String getBaselineFilePath() {
        return this.baselineFilePath;
    }

    public final void setBaselineFilePath(@Nullable String string) {
        this.baselineFilePath = string;
    }

    @NotNull
    public final File getConfigFile() {
        File file = this.configFile;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configFile");
        }
        return file;
    }

    public final void setConfigFile(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.configFile = file;
    }

    @NotNull
    public final File getOutputDirectory() {
        File file = this.outputDirectory;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"outputDirectory");
        }
        return file;
    }

    public final void setOutputDirectory(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
        this.outputDirectory = file;
    }

    @TaskAction
    public final void run() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Configuration configuration = project.getConfigurations().getByName("detekt");
        String string = this.baselineFilePath;
        if (string != null) {
            String string2;
            String file = string2 = string;
            boolean bl = false;
            if (!new File(file).exists()) {
                Configuration configuration2 = configuration;
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"configuration");
                this.executeDetekt((FileCollection)configuration2, true);
                throw (Throwable)new TaskExecutionException((Task)this, (Throwable)new GradleException("Aborting build since new baseline file was created"));
            }
        }
        Configuration configuration3 = configuration;
        Intrinsics.checkExpressionValueIsNotNull((Object)configuration3, (String)"configuration");
        DetektCheckTask.executeDetekt$default(this, (FileCollection)configuration3, false, 2, null);
    }

    private final void executeDetekt(FileCollection configuration, boolean shouldCreateBaseLine) {
        String string;
        String reportKey;
        Object object;
        String string2 = this.version;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"version");
        }
        VersionNumber fixedVersion = VersionNumber.parse((String)StringsKt.replace$default((String)string2, (String)".RC", (String)"-RC", (boolean)false, (int)4, null));
        Regex regex = new Regex("RC[\\d]+");
        String string3 = this.version;
        if (string3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"version");
        }
        Integer possibleRcVersion = (object = Regex.find$default((Regex)regex, (CharSequence)string3, (int)0, (int)2, null)) != null && (object = object.getValue()) != null && (object = StringsKt.replace$default((String)object, (String)"RC", (String)"", (boolean)false, (int)4, null)) != null ? StringsKt.toIntOrNull((String)object) : null;
        boolean isAtLeastRc10 = possibleRcVersion != null && possibleRcVersion >= 10;
        boolean shouldUseReport = fixedVersion.compareTo(VERSION_REPORT_CHANGE) >= 0 || isAtLeastRc10;
        boolean canUseFileEnding = fixedVersion.compareTo(VERSION_REPORT_EXTENSION_CHANGE) >= 0 && isAtLeastRc10;
        String string4 = reportKey = shouldUseReport ? "--report" : "--output";
        if (shouldUseReport) {
            string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])new ReportingMetaInformation[]{new ReportingMetaInformation("plain", "txt", "plain"), new ReportingMetaInformation("xml", "xml", "checkstyle"), new ReportingMetaInformation("html", "html", "report")}), (CharSequence)",", null, null, (int)0, null, (Function1)((Function1)new Function1<ReportingMetaInformation, String>(this, canUseFileEnding){
                final /* synthetic */ DetektCheckTask this$0;
                final /* synthetic */ boolean $canUseFileEnding;

                @NotNull
                public final String invoke(@NotNull ReportingMetaInformation it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    String reportId = this.$canUseFileEnding ? it.getFileEnding() : it.getReportId();
                    return reportId + ":" + new File(this.this$0.getOutputDirectory(), "detekt-" + it.getFileNameSuffix() + '.' + it.getFileEnding()).getAbsolutePath();
                }
                {
                    this.this$0 = detektCheckTask;
                    this.$canUseFileEnding = bl;
                    super(1);
                }
            }), (int)30, null);
        } else {
            File file = this.outputDirectory;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"outputDirectory");
            }
            string = file.getAbsolutePath();
        }
        String reportValue2 = string;
        this.getProject().javaexec((Action)new Action<JavaExecSpec>(this, configuration, reportKey, reportValue2, shouldCreateBaseLine){
            final /* synthetic */ DetektCheckTask this$0;
            final /* synthetic */ FileCollection $configuration;
            final /* synthetic */ String $reportKey;
            final /* synthetic */ String $reportValue;
            final /* synthetic */ boolean $shouldCreateBaseLine;

            public final void execute(JavaExecSpec task) {
                block1: {
                    String string;
                    JavaExecSpec javaExecSpec = task;
                    Intrinsics.checkExpressionValueIsNotNull((Object)javaExecSpec, (String)"task");
                    javaExecSpec.setMain("io.gitlab.arturbosch.detekt.cli.Main");
                    task.setClasspath(this.$configuration);
                    task.args(new Object[]{"--config", this.this$0.getConfigFile(), "--input", this.this$0.getProject().file((Object)"."), "--filters", ".*build/.*", this.$reportKey, this.$reportValue});
                    if (this.$shouldCreateBaseLine) {
                        task.args(new Object[]{"--create-baseline"});
                    }
                    String string2 = this.this$0.getBaselineFilePath();
                    if (string2 == null) break block1;
                    String it = string = string2;
                    boolean bl = false;
                    task.args(new Object[]{"--baseline", it});
                }
            }
            {
                this.this$0 = detektCheckTask;
                this.$configuration = fileCollection;
                this.$reportKey = string;
                this.$reportValue = string2;
                this.$shouldCreateBaseLine = bl;
            }
        });
    }

    static /* synthetic */ void executeDetekt$default(DetektCheckTask detektCheckTask, FileCollection fileCollection, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: executeDetekt");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        detektCheckTask.executeDetekt(fileCollection, bl);
    }

    public DetektCheckTask() {
        this.setGroup("verification");
        this.setDescription("Runs detekt.");
    }

    static {
        Companion = new Companion(null);
        VERSION_REPORT_CHANGE = VersionNumber.parse((String)"1.0.0-RC9");
        VERSION_REPORT_EXTENSION_CHANGE = VersionNumber.parse((String)"1.0.0-RC10");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/vanniktech/code/quality/tools/DetektCheckTask$ReportingMetaInformation;", "", "reportId", "", "fileEnding", "fileNameSuffix", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFileEnding", "()Ljava/lang/String;", "getFileNameSuffix", "getReportId", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "gradle-code-quality-tools-plugin"})
    public static final class ReportingMetaInformation {
        @NotNull
        private final String reportId;
        @NotNull
        private final String fileEnding;
        @NotNull
        private final String fileNameSuffix;

        @NotNull
        public final String getReportId() {
            return this.reportId;
        }

        @NotNull
        public final String getFileEnding() {
            return this.fileEnding;
        }

        @NotNull
        public final String getFileNameSuffix() {
            return this.fileNameSuffix;
        }

        public ReportingMetaInformation(@NotNull String reportId, @NotNull String fileEnding, @NotNull String fileNameSuffix) {
            Intrinsics.checkParameterIsNotNull((Object)reportId, (String)"reportId");
            Intrinsics.checkParameterIsNotNull((Object)fileEnding, (String)"fileEnding");
            Intrinsics.checkParameterIsNotNull((Object)fileNameSuffix, (String)"fileNameSuffix");
            this.reportId = reportId;
            this.fileEnding = fileEnding;
            this.fileNameSuffix = fileNameSuffix;
        }

        @NotNull
        public final String component1() {
            return this.reportId;
        }

        @NotNull
        public final String component2() {
            return this.fileEnding;
        }

        @NotNull
        public final String component3() {
            return this.fileNameSuffix;
        }

        @NotNull
        public final ReportingMetaInformation copy(@NotNull String reportId, @NotNull String fileEnding, @NotNull String fileNameSuffix) {
            Intrinsics.checkParameterIsNotNull((Object)reportId, (String)"reportId");
            Intrinsics.checkParameterIsNotNull((Object)fileEnding, (String)"fileEnding");
            Intrinsics.checkParameterIsNotNull((Object)fileNameSuffix, (String)"fileNameSuffix");
            return new ReportingMetaInformation(reportId, fileEnding, fileNameSuffix);
        }

        @NotNull
        public static /* synthetic */ ReportingMetaInformation copy$default(ReportingMetaInformation reportingMetaInformation, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = reportingMetaInformation.reportId;
            }
            if ((n & 2) != 0) {
                string2 = reportingMetaInformation.fileEnding;
            }
            if ((n & 4) != 0) {
                string3 = reportingMetaInformation.fileNameSuffix;
            }
            return reportingMetaInformation.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ReportingMetaInformation(reportId=" + this.reportId + ", fileEnding=" + this.fileEnding + ", fileNameSuffix=" + this.fileNameSuffix + ")";
        }

        public int hashCode() {
            String string = this.reportId;
            String string2 = this.fileEnding;
            String string3 = this.fileNameSuffix;
            return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ReportingMetaInformation)) break block3;
                    ReportingMetaInformation reportingMetaInformation = (ReportingMetaInformation)object;
                    if (!Intrinsics.areEqual((Object)this.reportId, (Object)reportingMetaInformation.reportId) || !Intrinsics.areEqual((Object)this.fileEnding, (Object)reportingMetaInformation.fileEnding) || !Intrinsics.areEqual((Object)this.fileNameSuffix, (Object)reportingMetaInformation.fileNameSuffix)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/vanniktech/code/quality/tools/DetektCheckTask$Companion;", "", "()V", "RC_BREAKING_POINT", "", "VERSION_REPORT_CHANGE", "Lorg/gradle/util/VersionNumber;", "kotlin.jvm.PlatformType", "getVERSION_REPORT_CHANGE$gradle_code_quality_tools_plugin", "()Lorg/gradle/util/VersionNumber;", "VERSION_REPORT_EXTENSION_CHANGE", "getVERSION_REPORT_EXTENSION_CHANGE$gradle_code_quality_tools_plugin", "gradle-code-quality-tools-plugin"})
    public static final class Companion {
        public final VersionNumber getVERSION_REPORT_CHANGE$gradle_code_quality_tools_plugin() {
            return VERSION_REPORT_CHANGE;
        }

        public final VersionNumber getVERSION_REPORT_EXTENSION_CHANGE$gradle_code_quality_tools_plugin() {
            return VERSION_REPORT_EXTENSION_CHANGE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

