/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.code.quality.tools;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LintPlugin;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.vanniktech.code.quality.tools.CodeQualityToolsPluginExtension;
import com.vanniktech.code.quality.tools.DetektCheckTask;
import com.vanniktech.code.quality.tools.KtLintFormatTask;
import com.vanniktech.code.quality.tools.KtLintTask;
import de.aaschmid.gradle.plugins.cpd.Cpd;
import de.aaschmid.gradle.plugins.cpd.CpdExtension;
import de.aaschmid.gradle.plugins.cpd.CpdPlugin;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CheckstylePlugin;
import org.gradle.api.plugins.quality.Pmd;
import org.gradle.api.plugins.quality.PmdExtension;
import org.gradle.api.plugins.quality.PmdPlugin;
import org.gradle.api.tasks.util.PatternFilterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\u0004\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\t\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u001a\u0010\n\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\u000b\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u001a\u0010\f\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\r\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u001a\u0010\u000e\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0012\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010*\u00020\u0005\u001a\f\u0010\u0012\u001a\u00020\u0003*\u00020\u0005H\u0002\u001a\f\u0010\u0013\u001a\u00020\u0003*\u00020\u0005H\u0002\u001a\f\u0010\u0014\u001a\u00020\u0003*\u00020\u0005H\u0002\u001a\u001e\u0010\u0015\u001a\n \u0011*\u0004\u0018\u00010\u00160\u0016*\u00020\u00052\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0001\u001a\u0014\u0010\u0018\u001a\u00020\u0003*\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"GROUP_VERIFICATION", "", "hasLintPlugin", "", "addCheckstyle", "Lorg/gradle/api/Project;", "rootProject", "extension", "Lcom/vanniktech/code/quality/tools/CodeQualityToolsPluginExtension;", "addCpd", "addDetekt", "addKotlin", "addKtlint", "addLint", "addPmd", "editorconfigFile", "Lorg/gradle/api/file/ConfigurableFileTree;", "kotlin.jvm.PlatformType", "isAndroidProject", "isJavaProject", "isKotlinProject", "kotlinFiles", "Lorg/gradle/api/tasks/util/PatternFilterable;", "baseDir", "shouldIgnore", "gradle-code-quality-tools-plugin"})
public final class CodeQualityToolsPluginKt {
    @NotNull
    public static final String GROUP_VERIFICATION = "verification";

    public static final boolean hasLintPlugin() {
        boolean bl;
        try {
            Class.forName("com.android.build.gradle.LintPlugin");
            bl = true;
        }
        catch (ClassNotFoundException ignored) {
            bl = false;
        }
        return bl;
    }

    public static final PatternFilterable kotlinFiles(@NotNull Project $this$kotlinFiles, @Nullable String baseDir) {
        Intrinsics.checkNotNullParameter((Object)$this$kotlinFiles, (String)"<this>");
        Object object = baseDir;
        if (object == null) {
            object = $this$kotlinFiles.getProjectDir();
        }
        Object[] objectArray = new String[]{"**/*.kt", "**/*.kts"};
        PatternFilterable patternFilterable = $this$kotlinFiles.fileTree(object).setIncludes((Iterable)CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"build/", "generated/"};
        return patternFilterable.setExcludes((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    public static /* synthetic */ PatternFilterable kotlinFiles$default(Project project, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return CodeQualityToolsPluginKt.kotlinFiles(project, string);
    }

    public static final ConfigurableFileTree editorconfigFile(@NotNull Project $this$editorconfigFile) {
        Intrinsics.checkNotNullParameter((Object)$this$editorconfigFile, (String)"<this>");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"dir", (Object)"."), TuplesKt.to((Object)"include", (Object)".editorconfig")};
        return $this$editorconfigFile.fileTree(MapsKt.mapOf((Pair[])pairArray));
    }

    public static final boolean addPmd(@NotNull Project $this$addPmd, @NotNull Project rootProject, @NotNull CodeQualityToolsPluginExtension extension) {
        boolean isPmdSupported;
        Intrinsics.checkNotNullParameter((Object)$this$addPmd, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rootProject, (String)"rootProject");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        boolean isNotIgnored = !CodeQualityToolsPluginKt.shouldIgnore($this$addPmd, extension);
        boolean isEnabled = extension.getPmd().getEnabled();
        boolean bl = isPmdSupported = CodeQualityToolsPluginKt.isJavaProject($this$addPmd) || CodeQualityToolsPluginKt.isAndroidProject($this$addPmd);
        if (isNotIgnored && isEnabled && isPmdSupported) {
            $this$addPmd.getPlugins().apply(PmdPlugin.class);
            $this$addPmd.getExtensions().configure(PmdExtension.class, arg_0 -> CodeQualityToolsPluginKt.addPmd$lambda-0(extension, $this$addPmd, rootProject, arg_0));
            $this$addPmd.getTasks().register("pmd", Pmd.class, arg_0 -> CodeQualityToolsPluginKt.addPmd$lambda-1($this$addPmd, extension, arg_0));
            $this$addPmd.getTasks().named("check").configure(CodeQualityToolsPluginKt::addPmd$lambda-2);
            return true;
        }
        return false;
    }

    public static final boolean addCheckstyle(@NotNull Project $this$addCheckstyle, @NotNull Project rootProject, @NotNull CodeQualityToolsPluginExtension extension) {
        boolean isCheckstyleSupported;
        Intrinsics.checkNotNullParameter((Object)$this$addCheckstyle, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rootProject, (String)"rootProject");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        boolean isNotIgnored = !CodeQualityToolsPluginKt.shouldIgnore($this$addCheckstyle, extension);
        boolean isEnabled = extension.getCheckstyle().getEnabled();
        boolean bl = isCheckstyleSupported = CodeQualityToolsPluginKt.isJavaProject($this$addCheckstyle) || CodeQualityToolsPluginKt.isAndroidProject($this$addCheckstyle);
        if (isNotIgnored && isEnabled && isCheckstyleSupported) {
            $this$addCheckstyle.getPlugins().apply(CheckstylePlugin.class);
            $this$addCheckstyle.getExtensions().configure(CheckstyleExtension.class, arg_0 -> CodeQualityToolsPluginKt.addCheckstyle$lambda-3(extension, rootProject, arg_0));
            $this$addCheckstyle.getTasks().register("checkstyle", Checkstyle.class, arg_0 -> CodeQualityToolsPluginKt.addCheckstyle$lambda-4($this$addCheckstyle, extension, arg_0));
            $this$addCheckstyle.getTasks().named("check").configure(CodeQualityToolsPluginKt::addCheckstyle$lambda-5);
            return true;
        }
        return false;
    }

    public static final boolean addLint(@NotNull Project $this$addLint, @NotNull CodeQualityToolsPluginExtension extension) {
        Intrinsics.checkNotNullParameter((Object)$this$addLint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        boolean isNotIgnored = !CodeQualityToolsPluginKt.shouldIgnore($this$addLint, extension);
        boolean isEnabled = extension.getLint().getEnabled();
        boolean isAndroidProject = CodeQualityToolsPluginKt.isAndroidProject($this$addLint);
        boolean isJavaProject = CodeQualityToolsPluginKt.isJavaProject($this$addLint);
        if (isNotIgnored && isEnabled) {
            LintOptions lintOptions;
            LintOptions lintOptions2;
            if (isAndroidProject) {
                lintOptions2 = ((BaseExtension)$this$addLint.getExtensions().getByType(BaseExtension.class)).getLintOptions();
            } else if (isJavaProject && CodeQualityToolsPluginKt.hasLintPlugin()) {
                $this$addLint.getPlugins().apply(LintPlugin.class);
                lintOptions2 = (LintOptions)$this$addLint.getExtensions().getByType(LintOptions.class);
            } else {
                lintOptions2 = lintOptions = (LintOptions)null;
            }
            if (lintOptions != null) {
                boolean it;
                Object object;
                Boolean bl = extension.getLint().getWarningsAsErrors();
                lintOptions.setWarningsAsErrors(bl != null ? bl.booleanValue() : extension.getFailEarly());
                Boolean bl2 = extension.getLint().getAbortOnError();
                lintOptions.setAbortOnError(bl2 != null ? bl2.booleanValue() : extension.getFailEarly());
                Boolean bl3 = extension.getLint().getCheckAllWarnings();
                if (bl3 != null) {
                    object = bl3;
                    it = (Boolean)object;
                    boolean bl4 = false;
                    lintOptions.setCheckAllWarnings(it);
                }
                Boolean bl5 = extension.getLint().getAbsolutePaths();
                if (bl5 != null) {
                    object = bl5;
                    it = (Boolean)object;
                    boolean bl6 = false;
                    lintOptions.setAbsolutePaths(it);
                }
                String string = extension.getLint().getBaselineFileName();
                if (string != null) {
                    Object it2 = object = string;
                    boolean bl7 = false;
                    lintOptions.setBaselineFile($this$addLint.file(it2));
                }
                File file = extension.getLint().getLintConfig();
                if (file != null) {
                    Object it3 = object = file;
                    boolean bl8 = false;
                    lintOptions.setLintConfig((File)it3);
                }
                Boolean bl9 = extension.getLint().getCheckReleaseBuilds();
                if (bl9 != null) {
                    object = bl9;
                    boolean it4 = (Boolean)object;
                    boolean bl10 = false;
                    lintOptions.setCheckReleaseBuilds(it4);
                }
                Boolean bl11 = extension.getLint().getCheckTestSources();
                if (bl11 != null) {
                    object = bl11;
                    boolean it5 = (Boolean)object;
                    boolean bl12 = false;
                    lintOptions.setCheckTestSources(it5);
                }
                Boolean bl13 = extension.getLint().getCheckDependencies();
                if (bl13 != null) {
                    object = bl13;
                    boolean it6 = (Boolean)object;
                    boolean bl14 = false;
                    lintOptions.setCheckDependencies(it6);
                }
                Boolean bl15 = extension.getLint().getTextReport();
                if (bl15 != null) {
                    object = bl15;
                    boolean it7 = (Boolean)object;
                    boolean bl16 = false;
                    lintOptions.setTextReport(it7);
                    lintOptions.textOutput(extension.getLint().getTextOutput());
                }
                $this$addLint.getTasks().named("check").configure(CodeQualityToolsPluginKt::addLint$lambda-14);
                return true;
            }
        }
        return false;
    }

    public static final boolean addKotlin(@NotNull Project $this$addKotlin, @NotNull CodeQualityToolsPluginExtension extension) {
        Intrinsics.checkNotNullParameter((Object)$this$addKotlin, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        boolean isNotIgnored = !CodeQualityToolsPluginKt.shouldIgnore($this$addKotlin, extension);
        boolean isKotlinProject = CodeQualityToolsPluginKt.isKotlinProject($this$addKotlin);
        if (isNotIgnored && isKotlinProject) {
            $this$addKotlin.getProject().getTasks().withType(KotlinCompile.class, arg_0 -> CodeQualityToolsPluginKt.addKotlin$lambda-15(extension, arg_0));
            return true;
        }
        return false;
    }

    public static final boolean addKtlint(@NotNull Project $this$addKtlint, @NotNull Project rootProject, @NotNull CodeQualityToolsPluginExtension extension) {
        Intrinsics.checkNotNullParameter((Object)$this$addKtlint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rootProject, (String)"rootProject");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        boolean isNotIgnored = !CodeQualityToolsPluginKt.shouldIgnore($this$addKtlint, extension);
        boolean isEnabled = extension.getKtlint().getEnabled();
        boolean isKtlintSupported = CodeQualityToolsPluginKt.isKotlinProject($this$addKtlint);
        if (isNotIgnored && isEnabled && isKtlintSupported) {
            String ktlint = "ktlint";
            Configuration ktlintConfiguration = (Configuration)$this$addKtlint.getConfigurations().create(ktlint, arg_0 -> CodeQualityToolsPluginKt.addKtlint$lambda-18($this$addKtlint, extension, arg_0));
            $this$addKtlint.getTasks().register(ktlint, KtLintTask.class, arg_0 -> CodeQualityToolsPluginKt.addKtlint$lambda-19(extension, ktlintConfiguration, $this$addKtlint, rootProject, arg_0));
            $this$addKtlint.getTasks().register("ktlintFormat", KtLintFormatTask.class, arg_0 -> CodeQualityToolsPluginKt.addKtlint$lambda-20(extension, ktlintConfiguration, $this$addKtlint, rootProject, arg_0));
            $this$addKtlint.getTasks().named("check").configure(arg_0 -> CodeQualityToolsPluginKt.addKtlint$lambda-21(ktlint, arg_0));
            return true;
        }
        return false;
    }

    public static final boolean addCpd(@NotNull Project $this$addCpd, @NotNull CodeQualityToolsPluginExtension extension) {
        boolean isCpdSupported;
        Intrinsics.checkNotNullParameter((Object)$this$addCpd, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        boolean isNotIgnored = !CodeQualityToolsPluginKt.shouldIgnore($this$addCpd, extension);
        boolean isEnabled = extension.getCpd().getEnabled();
        boolean bl = isCpdSupported = CodeQualityToolsPluginKt.isJavaProject($this$addCpd) || CodeQualityToolsPluginKt.isAndroidProject($this$addCpd);
        if (isNotIgnored && isEnabled && isCpdSupported) {
            $this$addCpd.getPlugins().apply(CpdPlugin.class);
            $this$addCpd.getExtensions().configure(CpdExtension.class, arg_0 -> CodeQualityToolsPluginKt.addCpd$lambda-22(extension, arg_0));
            $this$addCpd.getTasks().named("cpdCheck", Cpd.class, arg_0 -> CodeQualityToolsPluginKt.addCpd$lambda-24(extension, $this$addCpd, arg_0));
            $this$addCpd.getTasks().named("check").configure(CodeQualityToolsPluginKt::addCpd$lambda-25);
            return true;
        }
        return false;
    }

    public static final boolean addDetekt(@NotNull Project $this$addDetekt, @NotNull Project rootProject, @NotNull CodeQualityToolsPluginExtension extension) {
        Intrinsics.checkNotNullParameter((Object)$this$addDetekt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)rootProject, (String)"rootProject");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        boolean isNotIgnored = !CodeQualityToolsPluginKt.shouldIgnore($this$addDetekt, extension);
        boolean isEnabled = extension.getDetekt().getEnabled();
        boolean isDetektSupported = CodeQualityToolsPluginKt.isKotlinProject($this$addDetekt);
        if (isNotIgnored && isEnabled && isDetektSupported) {
            Configuration detektConfiguration = (Configuration)$this$addDetekt.getConfigurations().create("detekt", arg_0 -> CodeQualityToolsPluginKt.addDetekt$lambda-28($this$addDetekt, extension, arg_0));
            $this$addDetekt.getTasks().register("detektCheck", DetektCheckTask.class, arg_0 -> CodeQualityToolsPluginKt.addDetekt$lambda-30(extension, $this$addDetekt, rootProject, detektConfiguration, arg_0));
            $this$addDetekt.getTasks().named("check").configure(CodeQualityToolsPluginKt::addDetekt$lambda-31);
            return true;
        }
        return false;
    }

    private static final boolean shouldIgnore(Project $this$shouldIgnore, CodeQualityToolsPluginExtension extension) {
        return extension.getIgnoreProjects().contains($this$shouldIgnore.getName());
    }

    private static final boolean isJavaProject(Project $this$isJavaProject) {
        boolean isJava = $this$isJavaProject.getPlugins().hasPlugin("java");
        boolean isJavaLibrary = $this$isJavaProject.getPlugins().hasPlugin("java-library");
        boolean isJavaGradlePlugin = $this$isJavaProject.getPlugins().hasPlugin("java-gradle-plugin");
        return isJava || isJavaLibrary || isJavaGradlePlugin;
    }

    private static final boolean isAndroidProject(Project $this$isAndroidProject) {
        boolean isAndroidLibrary = $this$isAndroidProject.getPlugins().hasPlugin("com.android.library");
        boolean isAndroidApp = $this$isAndroidProject.getPlugins().hasPlugin("com.android.application");
        boolean isAndroidTest = $this$isAndroidProject.getPlugins().hasPlugin("com.android.test");
        boolean isAndroidInstantApp = $this$isAndroidProject.getPlugins().hasPlugin("com.android.instantapp");
        return isAndroidLibrary || isAndroidApp || isAndroidTest || isAndroidInstantApp;
    }

    private static final boolean isKotlinProject(Project $this$isKotlinProject) {
        boolean isKotlin = $this$isKotlinProject.getPlugins().hasPlugin("kotlin");
        boolean isKotlinAndroid = $this$isKotlinProject.getPlugins().hasPlugin("kotlin-android");
        boolean isKotlinMultiPlatform = $this$isKotlinProject.getPlugins().hasPlugin("org.jetbrains.kotlin.multiplatform");
        boolean isKotlinPlatformCommon = $this$isKotlinProject.getPlugins().hasPlugin("kotlin-platform-common");
        boolean isKotlinPlatformJvm = $this$isKotlinProject.getPlugins().hasPlugin("kotlin-platform-jvm");
        boolean isKotlinPlatformJs = $this$isKotlinProject.getPlugins().hasPlugin("kotlin-platform-js");
        return isKotlin || isKotlinAndroid || isKotlinMultiPlatform || isKotlinPlatformCommon || isKotlinPlatformJvm || isKotlinPlatformJs;
    }

    private static final void addPmd$lambda-0(CodeQualityToolsPluginExtension $extension, Project $this_addPmd, Project $rootProject, PmdExtension it) {
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        Intrinsics.checkNotNullParameter((Object)$this_addPmd, (String)"$this_addPmd");
        Intrinsics.checkNotNullParameter((Object)$rootProject, (String)"$rootProject");
        it.setToolVersion($extension.getPmd().getToolVersion());
        Boolean bl = $extension.getPmd().getIgnoreFailures();
        it.setIgnoreFailures(bl != null ? bl : !$extension.getFailEarly());
        Object[] objectArray = new Object[]{$rootProject.file((Object)$extension.getPmd().getRuleSetFile())};
        it.setRuleSetFiles((FileCollection)$this_addPmd.files(objectArray));
    }

    private static final void addPmd$lambda-1(Project $this_addPmd, CodeQualityToolsPluginExtension $extension, Pmd it) {
        Intrinsics.checkNotNullParameter((Object)$this_addPmd, (String)"$this_addPmd");
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        it.setDescription("Runs pmd.");
        it.setGroup(GROUP_VERIFICATION);
        it.setRuleSets(CollectionsKt.emptyList());
        it.setSource((FileTree)$this_addPmd.fileTree((Object)$extension.getPmd().getSource()));
        it.include((Iterable)$extension.getPmd().getInclude());
        it.exclude((Iterable)$extension.getPmd().getExclude());
        it.getReports().getHtml().getRequired().set((Object)$extension.getHtmlReports());
        it.getReports().getXml().getRequired().set((Object)$extension.getXmlReports());
    }

    private static final void addPmd$lambda-2(Task it) {
        Object[] objectArray = new Object[]{"pmd"};
        it.dependsOn(objectArray);
    }

    private static final void addCheckstyle$lambda-3(CodeQualityToolsPluginExtension $extension, Project $rootProject, CheckstyleExtension it) {
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        Intrinsics.checkNotNullParameter((Object)$rootProject, (String)"$rootProject");
        it.setToolVersion($extension.getCheckstyle().getToolVersion());
        it.setConfigFile($rootProject.file((Object)$extension.getCheckstyle().getConfigFile()));
        Boolean bl = $extension.getCheckstyle().getIgnoreFailures();
        it.setIgnoreFailures(bl != null ? bl : !$extension.getFailEarly());
        Boolean bl2 = $extension.getCheckstyle().getShowViolations();
        it.setShowViolations(bl2 != null ? bl2.booleanValue() : $extension.getFailEarly());
    }

    private static final void addCheckstyle$lambda-4(Project $this_addCheckstyle, CodeQualityToolsPluginExtension $extension, Checkstyle it) {
        Intrinsics.checkNotNullParameter((Object)$this_addCheckstyle, (String)"$this_addCheckstyle");
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        it.setDescription("Runs checkstyle.");
        it.setGroup(GROUP_VERIFICATION);
        it.setSource((FileTree)$this_addCheckstyle.fileTree((Object)$extension.getCheckstyle().getSource()));
        it.include((Iterable)$extension.getCheckstyle().getInclude());
        it.exclude((Iterable)$extension.getCheckstyle().getExclude());
        it.setClasspath((FileCollection)$this_addCheckstyle.files(new Object[0]));
        it.getReports().getHtml().getRequired().set((Object)$extension.getHtmlReports());
        it.getReports().getXml().getRequired().set((Object)$extension.getXmlReports());
    }

    private static final void addCheckstyle$lambda-5(Task it) {
        Object[] objectArray = new Object[]{"checkstyle"};
        it.dependsOn(objectArray);
    }

    private static final void addLint$lambda-14(Task it) {
        Object[] objectArray = new Object[]{"lint"};
        it.dependsOn(objectArray);
    }

    private static final void addKotlin$lambda-15(CodeQualityToolsPluginExtension $extension, KotlinCompile it) {
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        it.getKotlinOptions().setAllWarningsAsErrors($extension.getKotlin().getAllWarningsAsErrors());
    }

    private static final void addKtlint$lambda-18$lambda-16(Project $this_addKtlint, AttributeContainer it) {
        Intrinsics.checkNotNullParameter((Object)$this_addKtlint, (String)"$this_addKtlint");
        it.attribute(Usage.USAGE_ATTRIBUTE, (Object)$this_addKtlint.getObjects().named(Usage.class, "java-runtime"));
    }

    private static final void addKtlint$lambda-18$lambda-17(Project $this_addKtlint, CodeQualityToolsPluginExtension $extension, DependencySet it) {
        Intrinsics.checkNotNullParameter((Object)$this_addKtlint, (String)"$this_addKtlint");
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        it.add((Object)$this_addKtlint.getDependencies().create((Object)("com.pinterest:ktlint:" + $extension.getKtlint().getToolVersion())));
    }

    private static final void addKtlint$lambda-18(Project $this_addKtlint, CodeQualityToolsPluginExtension $extension, Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)$this_addKtlint, (String)"$this_addKtlint");
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        configuration.attributes(arg_0 -> CodeQualityToolsPluginKt.addKtlint$lambda-18$lambda-16($this_addKtlint, arg_0));
        configuration.setCanBeConsumed(false);
        configuration.defaultDependencies(arg_0 -> CodeQualityToolsPluginKt.addKtlint$lambda-18$lambda-17($this_addKtlint, $extension, arg_0));
    }

    private static final void addKtlint$lambda-19(CodeQualityToolsPluginExtension $extension, Configuration $ktlintConfiguration, Project $this_addKtlint, Project $rootProject, KtLintTask task) {
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        Intrinsics.checkNotNullParameter((Object)$this_addKtlint, (String)"$this_addKtlint");
        Intrinsics.checkNotNullParameter((Object)$rootProject, (String)"$rootProject");
        task.setExperimental($extension.getKtlint().getExperimental());
        task.setVersion($extension.getKtlint().getToolVersion());
        Object[] objectArray = new Object[]{$ktlintConfiguration};
        task.getClasspath().from(objectArray);
        task.setOutputDirectory(new File($this_addKtlint.getBuildDir(), "reports/ktlint/"));
        objectArray = new Object[]{CodeQualityToolsPluginKt.kotlinFiles$default($this_addKtlint, null, 1, null), CodeQualityToolsPluginKt.editorconfigFile($rootProject)};
        task.getInputs().files(objectArray);
    }

    private static final void addKtlint$lambda-20(CodeQualityToolsPluginExtension $extension, Configuration $ktlintConfiguration, Project $this_addKtlint, Project $rootProject, KtLintFormatTask task) {
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        Intrinsics.checkNotNullParameter((Object)$this_addKtlint, (String)"$this_addKtlint");
        Intrinsics.checkNotNullParameter((Object)$rootProject, (String)"$rootProject");
        task.setExperimental($extension.getKtlint().getExperimental());
        task.setVersion($extension.getKtlint().getToolVersion());
        Object[] objectArray = new Object[]{$ktlintConfiguration};
        task.getClasspath().from(objectArray);
        task.setOutputDirectory(new File($this_addKtlint.getBuildDir(), "reports/ktlint/"));
        objectArray = new Object[]{CodeQualityToolsPluginKt.kotlinFiles$default($this_addKtlint, null, 1, null), CodeQualityToolsPluginKt.editorconfigFile($rootProject)};
        task.getInputs().files(objectArray);
    }

    private static final void addKtlint$lambda-21(String $ktlint, Task it) {
        Intrinsics.checkNotNullParameter((Object)$ktlint, (String)"$ktlint");
        Object[] objectArray = new Object[]{$ktlint};
        it.dependsOn(objectArray);
    }

    private static final void addCpd$lambda-22(CodeQualityToolsPluginExtension $extension, CpdExtension it) {
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        it.setLanguage($extension.getCpd().getLanguage());
        it.setToolVersion($extension.getPmd().getToolVersion());
        Boolean bl = $extension.getCpd().getIgnoreFailures();
        it.setIgnoreFailures(bl != null ? bl : !$extension.getFailEarly());
        it.setMinimumTokenCount($extension.getCpd().getMinimumTokenCount());
    }

    private static final boolean addCpd$lambda-24$lambda-23(CodeQualityToolsPluginExtension $extension, File source) {
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        String string = source.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.name");
        return StringsKt.endsWith$default((String)string, (String)('.' + $extension.getCpd().getLanguage()), (boolean)false, (int)2, null);
    }

    private static final void addCpd$lambda-24(CodeQualityToolsPluginExtension $extension, Project $this_addCpd, Cpd it) {
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        Intrinsics.checkNotNullParameter((Object)$this_addCpd, (String)"$this_addCpd");
        it.setDescription("Runs cpd.");
        it.setGroup(GROUP_VERIFICATION);
        it.getReports().getText().getRequired().set((Object)$extension.getTextReports());
        it.getReports().getXml().getRequired().set((Object)$extension.getXmlReports());
        it.setEncoding("UTF-8");
        it.setSource($this_addCpd.fileTree((Object)$extension.getCpd().getSource()).filter(arg_0 -> CodeQualityToolsPluginKt.addCpd$lambda-24$lambda-23($extension, arg_0)).getAsFileTree());
    }

    private static final void addCpd$lambda-25(Task it) {
        Object[] objectArray = new Object[]{"cpdCheck"};
        it.dependsOn(objectArray);
    }

    private static final void addDetekt$lambda-28$lambda-26(Project $this_addDetekt, AttributeContainer it) {
        Intrinsics.checkNotNullParameter((Object)$this_addDetekt, (String)"$this_addDetekt");
        it.attribute(Usage.USAGE_ATTRIBUTE, (Object)$this_addDetekt.getObjects().named(Usage.class, "java-runtime"));
    }

    private static final void addDetekt$lambda-28$lambda-27(Project $this_addDetekt, CodeQualityToolsPluginExtension $extension, DependencySet it) {
        Intrinsics.checkNotNullParameter((Object)$this_addDetekt, (String)"$this_addDetekt");
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        it.add((Object)$this_addDetekt.getDependencies().create((Object)("io.gitlab.arturbosch.detekt:detekt-cli:" + $extension.getDetekt().getToolVersion())));
    }

    private static final void addDetekt$lambda-28(Project $this_addDetekt, CodeQualityToolsPluginExtension $extension, Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)$this_addDetekt, (String)"$this_addDetekt");
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        configuration.attributes(arg_0 -> CodeQualityToolsPluginKt.addDetekt$lambda-28$lambda-26($this_addDetekt, arg_0));
        configuration.setCanBeConsumed(false);
        configuration.defaultDependencies(arg_0 -> CodeQualityToolsPluginKt.addDetekt$lambda-28$lambda-27($this_addDetekt, $extension, arg_0));
    }

    private static final void addDetekt$lambda-30(CodeQualityToolsPluginExtension $extension, Project $this_addDetekt, Project $rootProject, Configuration $detektConfiguration, DetektCheckTask task) {
        block0: {
            String string;
            Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
            Intrinsics.checkNotNullParameter((Object)$this_addDetekt, (String)"$this_addDetekt");
            Intrinsics.checkNotNullParameter((Object)$rootProject, (String)"$rootProject");
            task.setFailFast($extension.getDetekt().getFailFast());
            task.setBuildUponDefaultConfig($extension.getDetekt().getBuildUponDefaultConfig());
            task.setParallel($extension.getDetekt().getParallel());
            task.setVersion($extension.getDetekt().getToolVersion());
            task.setOutputDirectory(new File($this_addDetekt.getBuildDir(), "reports/detekt/"));
            File file = $rootProject.file((Object)$extension.getDetekt().getConfig());
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"rootProject.file(extension.detekt.config)");
            task.setConfigFile(file);
            File file2 = $this_addDetekt.file((Object)$extension.getDetekt().getInput());
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file(extension.detekt.input)");
            task.setInputFile(file2);
            Object[] objectArray = new Object[]{$detektConfiguration};
            task.getClasspath().from(objectArray);
            objectArray = new Object[]{CodeQualityToolsPluginKt.kotlinFiles($this_addDetekt, $extension.getDetekt().getInput())};
            task.getInputs().files(objectArray);
            task.getInputs().property("baseline-file-exists", (Object)false);
            String string2 = $extension.getDetekt().getBaselineFileName();
            if (string2 == null) break block0;
            String it = string = string2;
            boolean bl = false;
            File file3 = $this_addDetekt.file((Object)it);
            task.setBaselineFilePath(file3.toString());
            task.getInputs().property("baseline-file-exists", (Object)file3.exists());
        }
    }

    private static final void addDetekt$lambda-31(Task it) {
        Object[] objectArray = new Object[]{"detektCheck"};
        it.dependsOn(objectArray);
    }
}

