/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish;

import com.vanniktech.maven.publish.Configurer;
import com.vanniktech.maven.publish.MavenPublishConfigurer;
import com.vanniktech.maven.publish.MavenPublishPlugin;
import com.vanniktech.maven.publish.MavenPublishPluginExtension;
import com.vanniktech.maven.publish.MavenPublishPom;
import com.vanniktech.maven.publish.MavenPublishTarget;
import com.vanniktech.maven.publish.nexus.NexusConfigurer;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.SigningPlugin;
import org.gradle.util.VersionNumber;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/vanniktech/maven/publish/MavenPublishPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "p", "configureDokka", "project", "configureJavadoc", "configurePublishing", "configurer", "Lcom/vanniktech/maven/publish/Configurer;", "configureSigning", "Companion", "gradle-maven-publish-plugin"})
public class MavenPublishPlugin
implements Plugin<Project> {
    public static final int MINIMUM_GRADLE_MAJOR = 4;
    public static final int MINIMUM_GRADLE_MINOR = 10;
    public static final int MINIMUM_GRADLE_MICRO = 1;
    @NotNull
    public static final String PLUGIN_DOKKA = "org.jetbrains.dokka";
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull Project p) {
        Intrinsics.checkParameterIsNotNull((Object)p, (String)"p");
        MavenPublishPluginExtension extension = (MavenPublishPluginExtension)p.getExtensions().create("mavenPublish", MavenPublishPluginExtension.class, new Object[]{p});
        Gradle gradle = p.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"p.gradle");
        VersionNumber gradleVersion = VersionNumber.parse((String)gradle.getGradleVersion());
        if (gradleVersion.compareTo(new VersionNumber(4, 10, 1, null)) < 0) {
            throw (Throwable)new IllegalArgumentException("You need gradle version 4.10.1 or higher");
        }
        p.getPlugins().apply(org.gradle.api.publish.maven.plugins.MavenPublishPlugin.class);
        MavenPublishPom pom = MavenPublishPom.Companion.fromProject(p);
        p.setGroup((Object)pom.getGroupId());
        p.setVersion((Object)pom.getVersion());
        this.configureSigning(p);
        this.configureJavadoc(p);
        this.configureDokka(p);
        p.afterEvaluate((Action)new Action<Project>(this, p, pom, extension){
            final /* synthetic */ MavenPublishPlugin this$0;
            final /* synthetic */ Project $p;
            final /* synthetic */ MavenPublishPom $pom;
            final /* synthetic */ MavenPublishPluginExtension $extension;

            public final void execute(Project project) {
                MavenPublishConfigurer configurer = new MavenPublishConfigurer(this.$p, this.$pom, (Iterable)this.$extension.getTargets());
                this.$extension.getTargets().all((Action)new Action<MavenPublishTarget>(configurer){
                    final /* synthetic */ MavenPublishConfigurer $configurer;

                    public final void execute(MavenPublishTarget it) {
                        String string = it.getReleaseRepositoryUrl();
                        boolean bl = false;
                        boolean bl2 = false;
                        if (string == null) {
                            boolean bl3 = false;
                            String string2 = "releaseRepositoryUrl of " + it.getName$gradle_maven_publish_plugin() + " is required to be set";
                            throw (Throwable)new IllegalStateException(string2.toString());
                        }
                        MavenPublishTarget mavenPublishTarget = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)mavenPublishTarget, (String)"it");
                        this.$configurer.configureTarget(mavenPublishTarget);
                    }
                    {
                        this.$configurer = mavenPublishConfigurer;
                    }
                });
                Project project2 = project;
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                MavenPublishPlugin.access$configurePublishing(this.this$0, project2, configurer);
            }
            {
                this.this$0 = mavenPublishPlugin;
                this.$p = project;
                this.$pom = mavenPublishPom;
                this.$extension = mavenPublishPluginExtension;
            }
        });
        new NexusConfigurer(p);
    }

    /*
     * WARNING - void declaration
     */
    private final void configureSigning(Project project) {
        void $this$isSigningRequired$iv;
        project.getPlugins().apply(SigningPlugin.class);
        Project $this$signing$iv = project;
        boolean $i$f$getSigning = false;
        Object object = $this$signing$iv.getExtensions().getByType(SigningExtension.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"extensions.getByType(SigningExtension::class.java)");
        $this$signing$iv = project;
        SigningExtension signingExtension = (SigningExtension)object;
        boolean $i$f$isSigningRequired = false;
        Callable callable = new Callable<Boolean>((Project)$this$isSigningRequired$iv){
            final /* synthetic */ Project $this_isSigningRequired;

            public final boolean call() {
                Project project = this.$this_isSigningRequired.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                return !StringsKt.contains$default((CharSequence)project.getVersion().toString(), (CharSequence)"SNAPSHOT", (boolean)false, (int)2, null);
            }
            {
                this.$this_isSigningRequired = project;
            }
        };
        signingExtension.setRequired((Object)callable);
        project.afterEvaluate((Action)new Action<Project>(project){
            final /* synthetic */ Project $project;

            /*
             * WARNING - void declaration
             */
            public final void execute(Project it) {
                Project $this$isSigningRequired$iv = this.$project;
                boolean $i$f$isSigningRequired = false;
                V v = ((Callable)new /* invalid duplicate definition of identical inner class */).call();
                Intrinsics.checkExpressionValueIsNotNull(v, (String)"project.isSigningRequired.call()");
                if (((Boolean)v).booleanValue()) {
                    Project project = this.$project.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project.project");
                    Project $this$publishExtension$iv = project;
                    boolean $i$f$getPublishExtension = false;
                    Project project2 = $this$publishExtension$iv.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
                    Object object = project2.getExtensions().getByType(MavenPublishPluginExtension.class);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.extensions.getBy\u2026ginExtension::class.java)");
                    if (((MavenPublishPluginExtension)object).getReleaseSigningEnabled()) {
                        void $this$publishing$iv;
                        Project $this$signing$iv = this.$project;
                        boolean $i$f$getSigning = false;
                        Object object2 = $this$signing$iv.getExtensions().getByType(SigningExtension.class);
                        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"extensions.getByType(SigningExtension::class.java)");
                        $this$signing$iv = this.$project;
                        SigningExtension signingExtension = (SigningExtension)object2;
                        boolean $i$f$getPublishing = false;
                        Object object3 = $this$publishing$iv.getExtensions().getByType(PublishingExtension.class);
                        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"extensions.getByType(Pub\u2026ingExtension::class.java)");
                        PublishingExtension publishingExtension = (PublishingExtension)object3;
                        signingExtension.sign((DomainObjectCollection)publishingExtension.getPublications());
                    }
                }
            }
            {
                this.$project = project;
            }
        });
    }

    private final void configureJavadoc(Project project) {
        project.getTasks().withType(Javadoc.class).configureEach((Action)configureJavadoc.1.INSTANCE);
    }

    private final void configureDokka(Project project) {
        project.getPlugins().withId("org.jetbrains.kotlin.jvm", (Action)new Action<Plugin<Object>>(project){
            final /* synthetic */ Project $project;

            public final void execute(Plugin<Object> it) {
                this.$project.getPlugins().apply("org.jetbrains.dokka");
            }
            {
                this.$project = project;
            }
        });
        project.getPlugins().withId("org.jetbrains.kotlin.android", (Action)new Action<Plugin<Object>>(project){
            final /* synthetic */ Project $project;

            public final void execute(Plugin<Object> it) {
                this.$project.getPlugins().apply("org.jetbrains.dokka");
            }
            {
                this.$project = project;
            }
        });
    }

    private final void configurePublishing(Project project, Configurer configurer) {
        if (project.getPlugins().hasPlugin("org.jetbrains.kotlin.multiplatform")) {
            configurer.configureKotlinMppProject();
        } else if (project.getPlugins().hasPlugin("java-gradle-plugin")) {
            configurer.configureGradlePluginProject();
        } else if (project.getPlugins().hasPlugin("com.android.library")) {
            configurer.configureAndroidArtifacts();
        } else if (project.getPlugins().hasPlugin("java") || project.getPlugins().hasPlugin("java-library")) {
            configurer.configureJavaArtifacts();
        } else {
            project.getLogger().warn("No compatible plugin found in project " + project.getName() + " for publishing");
        }
    }

    public static final /* synthetic */ void access$configurePublishing(MavenPublishPlugin $this, Project project, Configurer configurer) {
        $this.configurePublishing(project, configurer);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/vanniktech/maven/publish/MavenPublishPlugin$Companion;", "", "()V", "MINIMUM_GRADLE_MAJOR", "", "MINIMUM_GRADLE_MICRO", "MINIMUM_GRADLE_MINOR", "PLUGIN_DOKKA", "", "gradle-maven-publish-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

