/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish;

import com.vanniktech.maven.publish.MavenPublishConfigurer;
import com.vanniktech.maven.publish.MavenPublishPlugin;
import com.vanniktech.maven.publish.MavenPublishPluginExtension;
import com.vanniktech.maven.publish.MavenPublishPom;
import com.vanniktech.maven.publish.legacy.CoordinatesKt;
import com.vanniktech.maven.publish.legacy.TargetsKt;
import com.vanniktech.maven.publish.nexus.NexusConfigurer;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.SigningPlugin;
import org.gradle.util.VersionNumber;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0002H\u0002\u00a8\u0006\u000f"}, d2={"Lcom/vanniktech/maven/publish/MavenPublishPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "p", "configureDokka", "project", "configureJavadoc", "configurePublishing", "pom", "Lcom/vanniktech/maven/publish/MavenPublishPom;", "configureSigning", "Companion", "gradle-maven-publish-plugin"})
public class MavenPublishPlugin
implements Plugin<Project> {
    public static final int MINIMUM_GRADLE_MAJOR = 6;
    public static final int MINIMUM_GRADLE_MINOR = 6;
    public static final int MINIMUM_GRADLE_MICRO = 0;
    @NotNull
    public static final String PLUGIN_DOKKA = "org.jetbrains.dokka";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull Project p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        MavenPublishPluginExtension extension = (MavenPublishPluginExtension)p.getExtensions().create("mavenPublish", MavenPublishPluginExtension.class, new Object[]{p});
        Gradle gradle = p.getGradle();
        Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"p.gradle");
        VersionNumber gradleVersion = VersionNumber.parse((String)gradle.getGradleVersion());
        if (gradleVersion.compareTo(new VersionNumber(6, 6, 0, null)) < 0) {
            throw (Throwable)new IllegalArgumentException("You need gradle version 6.6.0 or higher");
        }
        p.getPlugins().apply(org.gradle.api.publish.maven.plugins.MavenPublishPlugin.class);
        MavenPublishPom pom = MavenPublishPom.Companion.fromProject(p);
        CoordinatesKt.setCoordinates(p, pom);
        MavenPublishPluginExtension mavenPublishPluginExtension = extension;
        Intrinsics.checkNotNullExpressionValue((Object)mavenPublishPluginExtension, (String)"extension");
        TargetsKt.configureTargets(p, mavenPublishPluginExtension);
        this.configureSigning(p);
        this.configureJavadoc(p);
        this.configureDokka(p);
        p.afterEvaluate((Action)new Action<Project>(this, pom){
            final /* synthetic */ MavenPublishPlugin this$0;
            final /* synthetic */ MavenPublishPom $pom;

            public final void execute(Project project) {
                Project project2 = project;
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                MavenPublishPlugin.access$configurePublishing(this.this$0, project2, this.$pom);
            }
            {
                this.this$0 = mavenPublishPlugin;
                this.$pom = mavenPublishPom;
            }
        });
        new NexusConfigurer(p);
    }

    private final void configureSigning(Project project) {
        project.getPlugins().apply(SigningPlugin.class);
        Project $this$signing$iv = project;
        boolean $i$f$getSigning = false;
        Object object = $this$signing$iv.getExtensions().getByType(SigningExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(SigningExtension::class.java)");
        Project $this$isSigningRequired$iv = project;
        boolean $i$f$isSigningRequired = false;
        ((SigningExtension)object).setRequired((Object)new Callable<Boolean>($this$isSigningRequired$iv){
            final /* synthetic */ Project $this_isSigningRequired;

            public final Boolean call() {
                Project project = this.$this_isSigningRequired.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return !StringsKt.contains$default((CharSequence)project.getVersion().toString(), (CharSequence)"SNAPSHOT", (boolean)false, (int)2, null);
            }
            {
                this.$this_isSigningRequired = project;
            }
        });
        project.afterEvaluate((Action)new Action<Project>(project){
            final /* synthetic */ Project $project;

            public final void execute(Project it) {
                Project $this$isSigningRequired$iv = this.$project;
                boolean $i$f$isSigningRequired = false;
                V v = ((Callable)new /* invalid duplicate definition of identical inner class */).call();
                Intrinsics.checkNotNullExpressionValue(v, (String)"project.isSigningRequired.call()");
                if (((Boolean)v).booleanValue()) {
                    Project project = this.$project.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project.project");
                    Project $this$publishExtension$iv = project;
                    boolean $i$f$getPublishExtension = false;
                    Project project2 = $this$publishExtension$iv.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                    Object object = project2.getExtensions().getByType(MavenPublishPluginExtension.class);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.getBy\u2026ginExtension::class.java)");
                    if (((MavenPublishPluginExtension)object).getReleaseSigningEnabled()) {
                        Project $this$signing$iv = this.$project;
                        boolean $i$f$getSigning = false;
                        Object object2 = $this$signing$iv.getExtensions().getByType(SigningExtension.class);
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"extensions.getByType(SigningExtension::class.java)");
                        SigningExtension signingExtension = (SigningExtension)object2;
                        Project $this$publishing$iv = this.$project;
                        boolean $i$f$getPublishing = false;
                        Object object3 = $this$publishing$iv.getExtensions().getByType(PublishingExtension.class);
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"extensions.getByType(Pub\u2026ingExtension::class.java)");
                        signingExtension.sign((DomainObjectCollection)((PublishingExtension)object3).getPublications());
                    }
                }
            }
            {
                this.$project = project;
            }
        });
    }

    private final void configureJavadoc(Project project) {
        project.getTasks().withType(Javadoc.class).configureEach((Action)configureJavadoc.1.INSTANCE);
    }

    private final void configureDokka(Project project) {
        project.getPlugins().withId("org.jetbrains.kotlin.jvm", (Action)new Action<Plugin<Object>>(project){
            final /* synthetic */ Project $project;

            public final void execute(Plugin<Object> it) {
                this.$project.getPlugins().apply("org.jetbrains.dokka");
            }
            {
                this.$project = project;
            }
        });
        project.getPlugins().withId("org.jetbrains.kotlin.android", (Action)new Action<Plugin<Object>>(project){
            final /* synthetic */ Project $project;

            public final void execute(Plugin<Object> it) {
                this.$project.getPlugins().apply("org.jetbrains.dokka");
            }
            {
                this.$project = project;
            }
        });
    }

    private final void configurePublishing(Project project, MavenPublishPom pom) {
        MavenPublishConfigurer configurer = new MavenPublishConfigurer(project, pom);
        if (project.getPlugins().hasPlugin("org.jetbrains.kotlin.multiplatform")) {
            configurer.configureKotlinMppProject();
        } else if (project.getPlugins().hasPlugin("java-gradle-plugin")) {
            configurer.configureGradlePluginProject();
        } else if (project.getPlugins().hasPlugin("com.android.library")) {
            configurer.configureAndroidArtifacts();
        } else if (project.getPlugins().hasPlugin("java") || project.getPlugins().hasPlugin("java-library")) {
            configurer.configureJavaArtifacts();
        } else if (project.getPlugins().hasPlugin("org.jetbrains.kotlin.js")) {
            configurer.configureKotlinJsProject();
        } else {
            project.getLogger().warn("No compatible plugin found in project " + project.getName() + " for publishing");
        }
    }

    public static final /* synthetic */ void access$configurePublishing(MavenPublishPlugin $this, Project project, MavenPublishPom pom) {
        $this.configurePublishing(project, pom);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/vanniktech/maven/publish/MavenPublishPlugin$Companion;", "", "()V", "MINIMUM_GRADLE_MAJOR", "", "MINIMUM_GRADLE_MICRO", "MINIMUM_GRADLE_MINOR", "PLUGIN_DOKKA", "", "gradle-maven-publish-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

