/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish;

import com.vanniktech.maven.publish.AndroidLibrary;
import com.vanniktech.maven.publish.GradlePlugin;
import com.vanniktech.maven.publish.JavaLibrary;
import com.vanniktech.maven.publish.KotlinJs;
import com.vanniktech.maven.publish.KotlinJvm;
import com.vanniktech.maven.publish.KotlinMultiplatform;
import com.vanniktech.maven.publish.MavenPublishBaseExtension;
import com.vanniktech.maven.publish.MavenPublishConfigurer;
import com.vanniktech.maven.publish.Platform;
import com.vanniktech.maven.publish.ProjectExtensionsKt;
import com.vanniktech.maven.publish.SonatypeHost;
import com.vanniktech.maven.publish.nexus.CloseAndReleaseRepositoryTask;
import com.vanniktech.maven.publish.nexus.NexusOptions;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.SigningPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Incubating
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b'\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001b\u0010\t\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u0018\u0010\u0015\u001a\u00020\u00112\u000e\u0010\u0010\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00160\u0013H\u0007J\u001c\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00072\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0007J\b\u0010\u001a\u001a\u00020\u0011H\u0007R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/vanniktech/maven/publish/MavenPublishBaseExtension;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "mavenCentral", "Lkotlin/Pair;", "Lcom/vanniktech/maven/publish/SonatypeHost;", "", "nexusOptions", "Lcom/vanniktech/maven/publish/nexus/NexusOptions;", "platform", "Lcom/vanniktech/maven/publish/Platform;", "signing", "", "Ljava/lang/Boolean;", "configure", "", "action", "Lorg/gradle/api/Action;", "nexusOptions$gradle_maven_publish_plugin", "pom", "Lorg/gradle/api/publish/maven/MavenPom;", "publishToMavenCentral", "host", "stagingRepositoryId", "signAllPublications", "gradle-maven-publish-plugin"})
public abstract class MavenPublishBaseExtension {
    private NexusOptions nexusOptions;
    private Pair<? extends SonatypeHost, String> mavenCentral;
    private Boolean signing;
    private Platform platform;
    private final Project project;

    @Incubating
    @JvmOverloads
    public final void publishToMavenCentral(@NotNull SonatypeHost host, @Nullable String stagingRepositoryId) {
        Intrinsics.checkNotNullParameter((Object)((Object)host), (String)"host");
        Pair<? extends SonatypeHost, String> mavenCentral = this.mavenCentral;
        if (mavenCentral != null) {
            if ((SonatypeHost)((Object)mavenCentral.getFirst()) == host || Intrinsics.areEqual((Object)((String)mavenCentral.getSecond()), (Object)stagingRepositoryId)) {
                return;
            }
            throw (Throwable)new IllegalArgumentException("Called publishToMavenCentral more than once with different arguments");
        }
        this.mavenCentral = TuplesKt.to((Object)((Object)host), (Object)stagingRepositoryId);
        Project $this$gradlePublishing$iv = this.project;
        boolean $i$f$getGradlePublishing = false;
        Object object = $this$gradlePublishing$iv.getExtensions().getByType(PublishingExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(Pub\u2026ingExtension::class.java)");
        ((PublishingExtension)object).getRepositories().maven((Action)new Action<MavenArtifactRepository>(this, stagingRepositoryId, host){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            final /* synthetic */ String $stagingRepositoryId;
            final /* synthetic */ SonatypeHost $host;

            public final void execute(MavenArtifactRepository repo) {
                MavenArtifactRepository mavenArtifactRepository = repo;
                Intrinsics.checkNotNullExpressionValue((Object)mavenArtifactRepository, (String)"repo");
                mavenArtifactRepository.setName("mavenCentral");
                if (this.$stagingRepositoryId != null) {
                    repo.setUrl((Object)(this.$host.getRootUrl$gradle_maven_publish_plugin() + "/service/local/staging/deployByRepositoryId/" + this.$stagingRepositoryId + '/'));
                } else {
                    repo.setUrl((Object)(this.$host.getRootUrl$gradle_maven_publish_plugin() + "/service/local/staging/deploy/maven2/"));
                }
                repo.credentials(PasswordCredentials.class);
                MavenPublishBaseExtension.access$getProject$p(this.this$0).afterEvaluate((Action)new Action<Project>(this, repo){
                    final /* synthetic */ publishToMavenCentral.1 this$0;
                    final /* synthetic */ MavenArtifactRepository $repo;

                    public final void execute(Project it) {
                        Project project = it;
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"it");
                        if (StringsKt.endsWith$default((String)project.getVersion().toString(), (String)"SNAPSHOT", (boolean)false, (int)2, null)) {
                            if (this.this$0.$stagingRepositoryId != null) {
                                throw (Throwable)new IllegalArgumentException("Staging repositories are not supported for SNAPSHOT versions.");
                            }
                            this.$repo.setUrl((Object)(this.this$0.$host.getRootUrl$gradle_maven_publish_plugin() + "/content/repositories/snapshots/"));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$repo = mavenArtifactRepository;
                    }
                });
            }
            {
                this.this$0 = mavenPublishBaseExtension;
                this.$stagingRepositoryId = string;
                this.$host = sonatypeHost;
            }
        });
        this.nexusOptions$gradle_maven_publish_plugin((Action<NexusOptions>)((Action)new Action<NexusOptions>(this, host){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            final /* synthetic */ SonatypeHost $host;

            public final void execute(NexusOptions it) {
                it.setBaseUrl(this.$host.getRootUrl$gradle_maven_publish_plugin() + "/service/local/");
                it.setRepositoryUsername(ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "mavenCentralUsername"));
                it.setRepositoryPassword(ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "mavenCentralPassword"));
            }
            {
                this.this$0 = mavenPublishBaseExtension;
                this.$host = sonatypeHost;
            }
        }));
    }

    public static /* synthetic */ void publishToMavenCentral$default(MavenPublishBaseExtension mavenPublishBaseExtension, SonatypeHost sonatypeHost, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishToMavenCentral");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        mavenPublishBaseExtension.publishToMavenCentral(sonatypeHost, string);
    }

    @Incubating
    @JvmOverloads
    public final void publishToMavenCentral(@NotNull SonatypeHost host) {
        MavenPublishBaseExtension.publishToMavenCentral$default(this, host, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void nexusOptions$gradle_maven_publish_plugin(@NotNull Action<NexusOptions> action) {
        void nexusOptions2;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = this.nexusOptions;
        if ((NexusOptions)nexusOptions2.element == null) {
            Object object = this.project.getObjects().newInstance(NexusOptions.class, new Object[0]);
            boolean bl = false;
            boolean bl2 = false;
            bl2 = false;
            boolean bl3 = false;
            if (object == null) {
                boolean bl4 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            nexusOptions2.element = (NexusOptions)object;
            this.nexusOptions = (NexusOptions)nexusOptions2.element;
            try {
                Project project = this.project.getRootProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project.rootProject");
                object = project.getTasks().named("closeAndReleaseRepository");
            }
            catch (UnknownTaskException e) {
                Project project = this.project.getRootProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project.rootProject");
                object = project.getTasks().register("closeAndReleaseRepository", CloseAndReleaseRepositoryTask.class, (Action)new Action<CloseAndReleaseRepositoryTask>((Ref.ObjectRef)nexusOptions2){
                    final /* synthetic */ Ref.ObjectRef $nexusOptions;

                    public final void execute(CloseAndReleaseRepositoryTask it) {
                        CloseAndReleaseRepositoryTask closeAndReleaseRepositoryTask = it;
                        Intrinsics.checkNotNullExpressionValue((Object)((Object)closeAndReleaseRepositoryTask), (String)"it");
                        closeAndReleaseRepositoryTask.setDescription("Closes and releases an artifacts repository in Nexus");
                        it.setGroup("release");
                        it.setNexusOptions((NexusOptions)this.$nexusOptions.element);
                    }
                    {
                        this.$nexusOptions = objectRef;
                    }
                });
            }
        }
        action.execute((Object)((NexusOptions)nexusOptions2.element));
    }

    @Incubating
    public final void signAllPublications() {
        Boolean signing = this.signing;
        if (Intrinsics.areEqual((Object)signing, (Object)true)) {
            return;
        }
        this.signing = true;
        this.project.getPlugins().apply(SigningPlugin.class);
        Project $this$gradleSigning$iv = this.project;
        boolean $i$f$getGradleSigning = false;
        Object object = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(SigningExtension::class.java)");
        Project $this$isSigningRequired$iv = this.project;
        boolean $i$f$isSigningRequired = false;
        ((SigningExtension)object).setRequired((Object)new Callable<Boolean>($this$isSigningRequired$iv){
            final /* synthetic */ Project $this_isSigningRequired;

            public final Boolean call() {
                Project project = this.$this_isSigningRequired.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                return !StringsKt.contains$default((CharSequence)project.getVersion().toString(), (CharSequence)"SNAPSHOT", (boolean)false, (int)2, null);
            }
            {
                this.$this_isSigningRequired = project;
            }
        });
        $this$gradleSigning$iv = this.project;
        $i$f$getGradleSigning = false;
        Object object2 = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"extensions.getByType(SigningExtension::class.java)");
        SigningExtension signingExtension = (SigningExtension)object2;
        Project $this$gradlePublishing$iv = this.project;
        boolean $i$f$getGradlePublishing = false;
        Object object3 = $this$gradlePublishing$iv.getExtensions().getByType(PublishingExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"extensions.getByType(Pub\u2026ingExtension::class.java)");
        signingExtension.sign((DomainObjectCollection)((PublishingExtension)object3).getPublications());
        String inMemoryKey = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKey");
        if (inMemoryKey != null) {
            String inMemoryKeyId = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKeyId");
            String string = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKeyPassword");
            if (string == null) {
                string = "";
            }
            String inMemoryKeyPassword = string;
            Project $this$gradleSigning$iv2 = this.project;
            boolean $i$f$getGradleSigning2 = false;
            Object object4 = $this$gradleSigning$iv2.getExtensions().getByType(SigningExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"extensions.getByType(SigningExtension::class.java)");
            ((SigningExtension)object4).useInMemoryPgpKeys(inMemoryKeyId, inMemoryKey, inMemoryKeyPassword);
        }
    }

    @Incubating
    public final void pom(@NotNull Action<? super MavenPom> configure) {
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        Project $this$gradlePublishing$iv = this.project;
        boolean $i$f$getGradlePublishing = false;
        Object object = $this$gradlePublishing$iv.getExtensions().getByType(PublishingExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(Pub\u2026ingExtension::class.java)");
        ((PublishingExtension)object).getPublications().withType(MavenPublication.class).configureEach((Action)new Action<MavenPublication>(configure){
            final /* synthetic */ Action $configure;

            public final void execute(MavenPublication it) {
                it.pom(this.$configure);
            }
            {
                this.$configure = action;
            }
        });
    }

    @Incubating
    public final void configure(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        if (this.platform != null) {
            if (Intrinsics.areEqual((Object)this.platform, (Object)platform)) {
                return;
            }
            throw (Throwable)new IllegalArgumentException("Called configure(Platform) more than once with different arguments");
        }
        this.platform = platform;
        MavenPublishConfigurer configurer = new MavenPublishConfigurer(this.project);
        Platform platform2 = platform;
        if (platform2 instanceof JavaLibrary) {
            configurer.configureJavaArtifacts(platform.getSourcesJar(), platform.getJavadocJar());
        } else if (platform2 instanceof GradlePlugin) {
            configurer.configureGradlePluginProject(platform.getSourcesJar(), platform.getJavadocJar());
        } else if (platform2 instanceof AndroidLibrary) {
            configurer.configureAndroidArtifacts(((AndroidLibrary)platform).getVariant(), platform.getSourcesJar(), platform.getJavadocJar());
        } else if (platform2 instanceof KotlinMultiplatform) {
            configurer.configureKotlinMppProject(platform.getJavadocJar());
        } else if (platform2 instanceof KotlinJs) {
            configurer.configureKotlinJsProject(platform.getSourcesJar(), platform.getJavadocJar());
        } else if (platform2 instanceof KotlinJvm) {
            configurer.configureJavaArtifacts(platform.getSourcesJar(), platform.getJavadocJar());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public MavenPublishBaseExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public static final /* synthetic */ Project access$getProject$p(MavenPublishBaseExtension $this) {
        return $this.project;
    }
}

