/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish;

import com.vanniktech.maven.publish.AndroidLibrary;
import com.vanniktech.maven.publish.GradlePlugin;
import com.vanniktech.maven.publish.JavaLibrary;
import com.vanniktech.maven.publish.KotlinJs;
import com.vanniktech.maven.publish.KotlinJvm;
import com.vanniktech.maven.publish.KotlinMultiplatform;
import com.vanniktech.maven.publish.MavenPublishBaseExtension;
import com.vanniktech.maven.publish.MavenPublishConfigurer;
import com.vanniktech.maven.publish.MavenPublishRootExtension;
import com.vanniktech.maven.publish.Platform;
import com.vanniktech.maven.publish.ProjectExtensionsKt;
import com.vanniktech.maven.publish.SonatypeHost;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.MavenPomDeveloper;
import org.gradle.api.publish.maven.MavenPomDeveloperSpec;
import org.gradle.api.publish.maven.MavenPomLicense;
import org.gradle.api.publish.maven.MavenPomLicenseSpec;
import org.gradle.api.publish.maven.MavenPomScm;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.SigningPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Incubating
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u0011\u001a\u00020\u00102\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u0012H\u0007J\b\u0010\u0014\u001a\u00020\u0010H\u0007J\u001c\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00072\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\bH\u0007J\b\u0010\u0018\u001a\u00020\u0010H\u0007R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/vanniktech/maven/publish/MavenPublishBaseExtension;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "mavenCentral", "Lkotlin/Pair;", "Lcom/vanniktech/maven/publish/SonatypeHost;", "", "platform", "Lcom/vanniktech/maven/publish/Platform;", "pomFromProperties", "", "Ljava/lang/Boolean;", "signing", "configure", "", "pom", "Lorg/gradle/api/Action;", "Lorg/gradle/api/publish/maven/MavenPom;", "pomFromGradleProperties", "publishToMavenCentral", "host", "stagingRepositoryId", "signAllPublications", "gradle-maven-publish-plugin"})
public abstract class MavenPublishBaseExtension {
    private Pair<? extends SonatypeHost, String> mavenCentral;
    private Boolean signing;
    private Boolean pomFromProperties;
    private Platform platform;
    private final Project project;

    @Incubating
    @JvmOverloads
    public final void publishToMavenCentral(@NotNull SonatypeHost host, @Nullable String stagingRepositoryId) {
        Intrinsics.checkNotNullParameter((Object)((Object)host), (String)"host");
        Pair<? extends SonatypeHost, String> mavenCentral = this.mavenCentral;
        if (mavenCentral != null) {
            if ((SonatypeHost)((Object)mavenCentral.getFirst()) == host || Intrinsics.areEqual((Object)((String)mavenCentral.getSecond()), (Object)stagingRepositoryId)) {
                return;
            }
            throw (Throwable)new IllegalArgumentException("Called publishToMavenCentral more than once with different arguments");
        }
        this.mavenCentral = TuplesKt.to((Object)((Object)host), (Object)stagingRepositoryId);
        Project $this$gradlePublishing$iv = this.project;
        boolean $i$f$getGradlePublishing = false;
        Object object = $this$gradlePublishing$iv.getExtensions().getByType(PublishingExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(Pub\u2026ingExtension::class.java)");
        ((PublishingExtension)object).getRepositories().maven((Action)new Action<MavenArtifactRepository>(this, stagingRepositoryId, host){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            final /* synthetic */ String $stagingRepositoryId;
            final /* synthetic */ SonatypeHost $host;

            public final void execute(MavenArtifactRepository repo) {
                MavenArtifactRepository mavenArtifactRepository = repo;
                Intrinsics.checkNotNullExpressionValue((Object)mavenArtifactRepository, (String)"repo");
                mavenArtifactRepository.setName("mavenCentral");
                if (this.$stagingRepositoryId != null) {
                    repo.setUrl((Object)(this.$host.getRootUrl$gradle_maven_publish_plugin() + "/service/local/staging/deployByRepositoryId/" + this.$stagingRepositoryId + '/'));
                } else {
                    repo.setUrl((Object)(this.$host.getRootUrl$gradle_maven_publish_plugin() + "/service/local/staging/deploy/maven2/"));
                }
                repo.credentials(PasswordCredentials.class);
                MavenPublishBaseExtension.access$getProject$p(this.this$0).afterEvaluate((Action)new Action<Project>(this, repo){
                    final /* synthetic */ publishToMavenCentral.1 this$0;
                    final /* synthetic */ MavenArtifactRepository $repo;

                    public final void execute(Project it) {
                        Project project = it;
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"it");
                        if (StringsKt.endsWith$default((String)project.getVersion().toString(), (String)"SNAPSHOT", (boolean)false, (int)2, null)) {
                            if (this.this$0.$stagingRepositoryId != null) {
                                throw (Throwable)new IllegalArgumentException("Staging repositories are not supported for SNAPSHOT versions.");
                            }
                            this.$repo.setUrl((Object)(this.this$0.$host.getRootUrl$gradle_maven_publish_plugin() + "/content/repositories/snapshots/"));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$repo = mavenArtifactRepository;
                    }
                });
            }
            {
                this.this$0 = mavenPublishBaseExtension;
                this.$stagingRepositoryId = string;
                this.$host = sonatypeHost;
            }
        });
        Project $this$rootExtension$iv = this.project;
        boolean $i$f$getRootExtension = false;
        Project project = $this$rootExtension$iv.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"rootProject");
        Object object2 = project.getExtensions().getByType(MavenPublishRootExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"rootProject.extensions.g\u2026ootExtension::class.java)");
        ((MavenPublishRootExtension)object2).configureCloseAndReleaseTask$gradle_maven_publish_plugin(host.getRootUrl$gradle_maven_publish_plugin() + "/service/local/", ProjectExtensionsKt.findOptionalProperty(this.project, "mavenCentralUsername"), ProjectExtensionsKt.findOptionalProperty(this.project, "mavenCentralPassword"));
    }

    public static /* synthetic */ void publishToMavenCentral$default(MavenPublishBaseExtension mavenPublishBaseExtension, SonatypeHost sonatypeHost, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishToMavenCentral");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        mavenPublishBaseExtension.publishToMavenCentral(sonatypeHost, string);
    }

    @Incubating
    @JvmOverloads
    public final void publishToMavenCentral(@NotNull SonatypeHost host) {
        MavenPublishBaseExtension.publishToMavenCentral$default(this, host, null, 2, null);
    }

    @Incubating
    public final void signAllPublications() {
        if (Intrinsics.areEqual((Object)this.signing, (Object)true)) {
            return;
        }
        this.signing = true;
        this.project.getPlugins().apply(SigningPlugin.class);
        Project $this$gradleSigning$iv = this.project;
        boolean $i$f$getGradleSigning = false;
        Object object = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(SigningExtension::class.java)");
        ((SigningExtension)object).setRequired(new Callable<Boolean>(this){
            final /* synthetic */ MavenPublishBaseExtension this$0;

            public final Boolean call() {
                return !StringsKt.contains$default((CharSequence)MavenPublishBaseExtension.access$getProject$p(this.this$0).getVersion().toString(), (CharSequence)"SNAPSHOT", (boolean)false, (int)2, null);
            }
            {
                this.this$0 = mavenPublishBaseExtension;
            }
        });
        $this$gradleSigning$iv = this.project;
        $i$f$getGradleSigning = false;
        Object object2 = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"extensions.getByType(SigningExtension::class.java)");
        SigningExtension signingExtension = (SigningExtension)object2;
        Project $this$gradlePublishing$iv = this.project;
        boolean $i$f$getGradlePublishing = false;
        Object object3 = $this$gradlePublishing$iv.getExtensions().getByType(PublishingExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"extensions.getByType(Pub\u2026ingExtension::class.java)");
        signingExtension.sign((DomainObjectCollection)((PublishingExtension)object3).getPublications());
        String inMemoryKey = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKey");
        if (inMemoryKey != null) {
            String inMemoryKeyId = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKeyId");
            String string = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKeyPassword");
            if (string == null) {
                string = "";
            }
            String inMemoryKeyPassword = string;
            Project $this$gradleSigning$iv2 = this.project;
            boolean $i$f$getGradleSigning2 = false;
            Object object4 = $this$gradleSigning$iv2.getExtensions().getByType(SigningExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"extensions.getByType(SigningExtension::class.java)");
            ((SigningExtension)object4).useInMemoryPgpKeys(inMemoryKeyId, inMemoryKey, inMemoryKeyPassword);
        }
    }

    @Incubating
    public final void pom(@NotNull Action<? super MavenPom> configure) {
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        Project $this$gradlePublishing$iv = this.project;
        boolean $i$f$getGradlePublishing = false;
        Object object = $this$gradlePublishing$iv.getExtensions().getByType(PublishingExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(Pub\u2026ingExtension::class.java)");
        ((PublishingExtension)object).getPublications().withType(MavenPublication.class).configureEach((Action)new Action<MavenPublication>(configure){
            final /* synthetic */ Action $configure;

            public final void execute(MavenPublication it) {
                it.pom(this.$configure);
            }
            {
                this.$configure = action;
            }
        });
    }

    @Incubating
    public final void pomFromGradleProperties() {
        if (Intrinsics.areEqual((Object)this.pomFromProperties, (Object)true)) {
            return;
        }
        this.pomFromProperties = true;
        this.project.afterEvaluate((Action)new Action<Project>(this){
            final /* synthetic */ MavenPublishBaseExtension this$0;

            public final void execute(Project it) {
                this.this$0.pom((Action<? super MavenPom>)((Action)new Action<MavenPom>(this){
                    final /* synthetic */ pomFromGradleProperties.1 this$0;

                    public final void execute(MavenPom pom2) {
                        String inceptionYear;
                        String url;
                        String description;
                        String name = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0.this$0), "POM_NAME");
                        if (name != null) {
                            MavenPom mavenPom = pom2;
                            Intrinsics.checkNotNullExpressionValue((Object)mavenPom, (String)"pom");
                            mavenPom.getName().set((Object)name);
                        }
                        if ((description = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0.this$0), "POM_DESCRIPTION")) != null) {
                            MavenPom mavenPom = pom2;
                            Intrinsics.checkNotNullExpressionValue((Object)mavenPom, (String)"pom");
                            mavenPom.getDescription().set((Object)description);
                        }
                        if ((url = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0.this$0), "POM_URL")) != null) {
                            MavenPom mavenPom = pom2;
                            Intrinsics.checkNotNullExpressionValue((Object)mavenPom, (String)"pom");
                            mavenPom.getUrl().set((Object)url);
                        }
                        if ((inceptionYear = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0.this$0), "POM_INCEPTION_YEAR")) != null) {
                            MavenPom mavenPom = pom2;
                            Intrinsics.checkNotNullExpressionValue((Object)mavenPom, (String)"pom");
                            mavenPom.getInceptionYear().set((Object)inceptionYear);
                        }
                        String scmUrl = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0.this$0), "POM_SCM_URL");
                        String scmConnection = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0.this$0), "POM_SCM_CONNECTION");
                        String scmDeveloperConnection = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0.this$0), "POM_SCM_DEV_CONNECTION");
                        if (scmUrl != null || scmConnection != null || scmDeveloperConnection != null) {
                            pom2.scm((Action)new Action<MavenPomScm>(scmUrl, scmConnection, scmDeveloperConnection){
                                final /* synthetic */ String $scmUrl;
                                final /* synthetic */ String $scmConnection;
                                final /* synthetic */ String $scmDeveloperConnection;

                                public final void execute(MavenPomScm it) {
                                    MavenPomScm mavenPomScm = it;
                                    Intrinsics.checkNotNullExpressionValue((Object)mavenPomScm, (String)"it");
                                    mavenPomScm.getUrl().set((Object)this.$scmUrl);
                                    it.getConnection().set((Object)this.$scmConnection);
                                    it.getDeveloperConnection().set((Object)this.$scmDeveloperConnection);
                                }
                                {
                                    this.$scmUrl = string;
                                    this.$scmConnection = string2;
                                    this.$scmDeveloperConnection = string3;
                                }
                            });
                        }
                        String licenceName = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0.this$0), "POM_LICENCE_NAME");
                        String licenceUrl = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0.this$0), "POM_LICENCE_URL");
                        String licenceDistribution = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0.this$0), "POM_LICENCE_DIST");
                        if (licenceName != null || licenceUrl != null || licenceDistribution != null) {
                            pom2.licenses((Action)new Action<MavenPomLicenseSpec>(licenceName, licenceUrl, licenceDistribution){
                                final /* synthetic */ String $licenceName;
                                final /* synthetic */ String $licenceUrl;
                                final /* synthetic */ String $licenceDistribution;

                                public final void execute(MavenPomLicenseSpec licences) {
                                    licences.license((Action)new Action<MavenPomLicense>(this){
                                        final /* synthetic */ pomFromGradleProperties.2 this$0;

                                        public final void execute(MavenPomLicense it) {
                                            MavenPomLicense mavenPomLicense = it;
                                            Intrinsics.checkNotNullExpressionValue((Object)mavenPomLicense, (String)"it");
                                            mavenPomLicense.getName().set((Object)this.this$0.$licenceName);
                                            it.getUrl().set((Object)this.this$0.$licenceUrl);
                                            it.getDistribution().set((Object)this.this$0.$licenceDistribution);
                                        }
                                        {
                                            this.this$0 = var1_1;
                                        }
                                    });
                                }
                                {
                                    this.$licenceName = string;
                                    this.$licenceUrl = string2;
                                    this.$licenceDistribution = string3;
                                }
                            });
                        }
                        String licenseName = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0.this$0), "POM_LICENSE_NAME");
                        String licenseUrl = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0.this$0), "POM_LICENSE_URL");
                        String licenseDistribution = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0.this$0), "POM_LICENSE_DIST");
                        if (licenseName != null || licenseUrl != null || licenseDistribution != null) {
                            pom2.licenses((Action)new Action<MavenPomLicenseSpec>(licenseName, licenseUrl, licenseDistribution){
                                final /* synthetic */ String $licenseName;
                                final /* synthetic */ String $licenseUrl;
                                final /* synthetic */ String $licenseDistribution;

                                public final void execute(MavenPomLicenseSpec licenses) {
                                    licenses.license((Action)new Action<MavenPomLicense>(this){
                                        final /* synthetic */ pomFromGradleProperties.3 this$0;

                                        public final void execute(MavenPomLicense it) {
                                            MavenPomLicense mavenPomLicense = it;
                                            Intrinsics.checkNotNullExpressionValue((Object)mavenPomLicense, (String)"it");
                                            mavenPomLicense.getName().set((Object)this.this$0.$licenseName);
                                            it.getUrl().set((Object)this.this$0.$licenseUrl);
                                            it.getDistribution().set((Object)this.this$0.$licenseDistribution);
                                        }
                                        {
                                            this.this$0 = var1_1;
                                        }
                                    });
                                }
                                {
                                    this.$licenseName = string;
                                    this.$licenseUrl = string2;
                                    this.$licenseDistribution = string3;
                                }
                            });
                        }
                        String developerId = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0.this$0), "POM_DEVELOPER_ID");
                        String developerName = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0.this$0), "POM_DEVELOPER_NAME");
                        String developerUrl = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0.this$0), "POM_DEVELOPER_URL");
                        if (developerId != null || developerName != null || developerUrl != null) {
                            pom2.developers((Action)new Action<MavenPomDeveloperSpec>(developerId, developerName, developerUrl){
                                final /* synthetic */ String $developerId;
                                final /* synthetic */ String $developerName;
                                final /* synthetic */ String $developerUrl;

                                public final void execute(MavenPomDeveloperSpec developers) {
                                    developers.developer((Action)new Action<MavenPomDeveloper>(this){
                                        final /* synthetic */ pomFromGradleProperties.4 this$0;

                                        public final void execute(MavenPomDeveloper it) {
                                            MavenPomDeveloper mavenPomDeveloper = it;
                                            Intrinsics.checkNotNullExpressionValue((Object)mavenPomDeveloper, (String)"it");
                                            mavenPomDeveloper.getId().set((Object)this.this$0.$developerId);
                                            it.getName().set((Object)this.this$0.$developerName);
                                            it.getUrl().set((Object)this.this$0.$developerUrl);
                                        }
                                        {
                                            this.this$0 = var1_1;
                                        }
                                    });
                                }
                                {
                                    this.$developerId = string;
                                    this.$developerName = string2;
                                    this.$developerUrl = string3;
                                }
                            });
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
            }
            {
                this.this$0 = mavenPublishBaseExtension;
            }
        });
    }

    @Incubating
    public final void configure(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        if (this.platform != null) {
            if (Intrinsics.areEqual((Object)this.platform, (Object)platform)) {
                return;
            }
            throw (Throwable)new IllegalArgumentException("Called configure(Platform) more than once with different arguments");
        }
        this.platform = platform;
        MavenPublishConfigurer configurer = new MavenPublishConfigurer(this.project);
        Platform platform2 = platform;
        if (platform2 instanceof JavaLibrary) {
            configurer.configureJavaArtifacts(platform.getSourcesJar(), platform.getJavadocJar());
        } else if (platform2 instanceof GradlePlugin) {
            configurer.configureGradlePluginProject(platform.getSourcesJar(), platform.getJavadocJar());
        } else if (platform2 instanceof AndroidLibrary) {
            configurer.configureAndroidArtifacts(((AndroidLibrary)platform).getVariant(), platform.getSourcesJar(), platform.getJavadocJar());
        } else if (platform2 instanceof KotlinMultiplatform) {
            configurer.configureKotlinMppProject(platform.getJavadocJar());
        } else if (platform2 instanceof KotlinJs) {
            configurer.configureKotlinJsProject(platform.getSourcesJar(), platform.getJavadocJar());
        } else if (platform2 instanceof KotlinJvm) {
            configurer.configureJavaArtifacts(platform.getSourcesJar(), platform.getJavadocJar());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public MavenPublishBaseExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public static final /* synthetic */ Project access$getProject$p(MavenPublishBaseExtension $this) {
        return $this.project;
    }
}

