/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish;

import com.vanniktech.maven.publish.MavenPublishRootExtension;
import com.vanniktech.maven.publish.Platform;
import com.vanniktech.maven.publish.ProjectExtensionsKt;
import com.vanniktech.maven.publish.SonatypeHost;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.MavenPomDeveloper;
import org.gradle.api.publish.maven.MavenPomDeveloperSpec;
import org.gradle.api.publish.maven.MavenPomLicense;
import org.gradle.api.publish.maven.MavenPomLicenseSpec;
import org.gradle.api.publish.maven.MavenPomScm;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.SigningPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Incubating
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0007J\u0018\u0010\u0011\u001a\u00020\u00102\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00130\u0012H\u0007J\b\u0010\u0014\u001a\u00020\u0010H\u0007J\u001c\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00072\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\bH\u0007J\b\u0010\u0018\u001a\u00020\u0010H\u0007R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/vanniktech/maven/publish/MavenPublishBaseExtension;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "mavenCentral", "Lkotlin/Pair;", "Lcom/vanniktech/maven/publish/SonatypeHost;", "", "platform", "Lcom/vanniktech/maven/publish/Platform;", "pomFromProperties", "", "Ljava/lang/Boolean;", "signing", "configure", "", "pom", "Lorg/gradle/api/Action;", "Lorg/gradle/api/publish/maven/MavenPom;", "pomFromGradleProperties", "publishToMavenCentral", "host", "stagingRepositoryId", "signAllPublications", "plugin"})
public abstract class MavenPublishBaseExtension {
    @NotNull
    private final Project project;
    @Nullable
    private Pair<? extends SonatypeHost, String> mavenCentral;
    @Nullable
    private Boolean signing;
    @Nullable
    private Boolean pomFromProperties;
    @Nullable
    private Platform platform;

    public MavenPublishBaseExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Incubating
    @JvmOverloads
    public final void publishToMavenCentral(@NotNull SonatypeHost host, @Nullable String stagingRepositoryId) {
        Intrinsics.checkNotNullParameter((Object)((Object)host), (String)"host");
        Pair<? extends SonatypeHost, String> mavenCentral = this.mavenCentral;
        if (mavenCentral != null) {
            if (mavenCentral.getFirst() == host || Intrinsics.areEqual((Object)mavenCentral.getSecond(), (Object)stagingRepositoryId)) {
                return;
            }
            throw new IllegalArgumentException("Called publishToMavenCentral more than once with different arguments");
        }
        this.mavenCentral = TuplesKt.to((Object)((Object)host), (Object)stagingRepositoryId);
        Project $this$gradlePublishing$iv = this.project;
        boolean $i$f$getGradlePublishing = false;
        Object object = $this$gradlePublishing$iv.getExtensions().getByType(PublishingExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(PublishingExtension::class.java)");
        ((PublishingExtension)object).getRepositories().maven(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda-1(stagingRepositoryId, host, this, arg_0));
        Project $this$rootExtension$iv = this.project;
        boolean $i$f$getRootExtension = false;
        object = $this$rootExtension$iv.getRootProject().getExtensions().getByType(MavenPublishRootExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"rootProject.extensions.getByType(MavenPublishRootExtension::class.java)");
        ((MavenPublishRootExtension)object).configureCloseAndReleaseTask$plugin(Intrinsics.stringPlus((String)host.getRootUrl$plugin(), (Object)"/service/local/"), ProjectExtensionsKt.findOptionalProperty(this.project, "mavenCentralUsername"), ProjectExtensionsKt.findOptionalProperty(this.project, "mavenCentralPassword"));
    }

    public static /* synthetic */ void publishToMavenCentral$default(MavenPublishBaseExtension mavenPublishBaseExtension, SonatypeHost sonatypeHost, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishToMavenCentral");
        }
        if ((n & 2) != 0) {
            string = null;
        }
        mavenPublishBaseExtension.publishToMavenCentral(sonatypeHost, string);
    }

    @Incubating
    public final void signAllPublications() {
        if (Intrinsics.areEqual((Object)this.signing, (Object)true)) {
            return;
        }
        this.signing = true;
        this.project.getPlugins().apply(SigningPlugin.class);
        Project $this$gradleSigning$iv = this.project;
        boolean $i$f$getGradleSigning = false;
        Object object = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(SigningExtension::class.java)");
        ((SigningExtension)object).setRequired(() -> MavenPublishBaseExtension.signAllPublications$lambda-2(this));
        $this$gradleSigning$iv = this.project;
        $i$f$getGradleSigning = false;
        object = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(SigningExtension::class.java)");
        SigningExtension signingExtension = (SigningExtension)object;
        Project $this$gradlePublishing$iv = this.project;
        boolean $i$f$getGradlePublishing = false;
        object = $this$gradlePublishing$iv.getExtensions().getByType(PublishingExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(PublishingExtension::class.java)");
        signingExtension.sign((DomainObjectCollection)((PublishingExtension)object).getPublications());
        String inMemoryKey = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKey");
        if (inMemoryKey != null) {
            String inMemoryKeyId = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKeyId");
            String string = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKeyPassword");
            String inMemoryKeyPassword = string == null ? "" : string;
            Project $this$gradleSigning$iv2 = this.project;
            boolean $i$f$getGradleSigning2 = false;
            Object object2 = $this$gradleSigning$iv2.getExtensions().getByType(SigningExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"extensions.getByType(SigningExtension::class.java)");
            ((SigningExtension)object2).useInMemoryPgpKeys(inMemoryKeyId, inMemoryKey, inMemoryKeyPassword);
        }
    }

    @Incubating
    public final void pom(@NotNull Action<? super MavenPom> configure2) {
        Intrinsics.checkNotNullParameter(configure2, (String)"configure");
        Project $this$gradlePublishing$iv = this.project;
        boolean $i$f$getGradlePublishing = false;
        Object object = $this$gradlePublishing$iv.getExtensions().getByType(PublishingExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(PublishingExtension::class.java)");
        ((PublishingExtension)object).getPublications().withType(MavenPublication.class).configureEach(arg_0 -> MavenPublishBaseExtension.pom$lambda-3(configure2, arg_0));
    }

    @Incubating
    public final void pomFromGradleProperties() {
        if (Intrinsics.areEqual((Object)this.pomFromProperties, (Object)true)) {
            return;
        }
        this.pomFromProperties = true;
        this.project.afterEvaluate(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda-12(this, arg_0));
    }

    @Incubating
    public final void configure(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        if (this.platform != null) {
            if (Intrinsics.areEqual((Object)this.platform, (Object)platform)) {
                return;
            }
            throw new IllegalArgumentException("Called configure(Platform) more than once with different arguments");
        }
        this.platform = platform;
        platform.configure$plugin(this.project);
    }

    @Incubating
    @JvmOverloads
    public final void publishToMavenCentral(@NotNull SonatypeHost host) {
        Intrinsics.checkNotNullParameter((Object)((Object)host), (String)"host");
        MavenPublishBaseExtension.publishToMavenCentral$default(this, host, null, 2, null);
    }

    private static final void publishToMavenCentral$lambda-1$lambda-0(String $stagingRepositoryId, MavenArtifactRepository $repo, SonatypeHost $host, Project it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$host), (String)"$host");
        if (StringsKt.endsWith$default((String)it.getVersion().toString(), (String)"SNAPSHOT", (boolean)false, (int)2, null)) {
            if ($stagingRepositoryId != null) {
                throw new IllegalArgumentException("Staging repositories are not supported for SNAPSHOT versions.");
            }
            $repo.setUrl((Object)Intrinsics.stringPlus((String)$host.getRootUrl$plugin(), (Object)"/content/repositories/snapshots/"));
        }
    }

    private static final void publishToMavenCentral$lambda-1(String $stagingRepositoryId, SonatypeHost $host, MavenPublishBaseExtension this$0, MavenArtifactRepository repo) {
        Intrinsics.checkNotNullParameter((Object)((Object)$host), (String)"$host");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        repo.setName("mavenCentral");
        if ($stagingRepositoryId != null) {
            repo.setUrl((Object)($host.getRootUrl$plugin() + "/service/local/staging/deployByRepositoryId/" + $stagingRepositoryId + '/'));
        } else {
            repo.setUrl((Object)Intrinsics.stringPlus((String)$host.getRootUrl$plugin(), (Object)"/service/local/staging/deploy/maven2/"));
        }
        repo.credentials(PasswordCredentials.class);
        this$0.project.afterEvaluate(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda-1$lambda-0($stagingRepositoryId, repo, $host, arg_0));
    }

    private static final Boolean signAllPublications$lambda-2(MavenPublishBaseExtension this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return !StringsKt.contains$default((CharSequence)this$0.project.getVersion().toString(), (CharSequence)"SNAPSHOT", (boolean)false, (int)2, null);
    }

    private static final void pom$lambda-3(Action $configure, MavenPublication it) {
        Intrinsics.checkNotNullParameter((Object)$configure, (String)"$configure");
        it.pom($configure);
    }

    private static final void pomFromGradleProperties$lambda-12$lambda-11$lambda-4(String $scmUrl, String $scmConnection, String $scmDeveloperConnection, MavenPomScm it) {
        it.getUrl().set((Object)$scmUrl);
        it.getConnection().set((Object)$scmConnection);
        it.getDeveloperConnection().set((Object)$scmDeveloperConnection);
    }

    private static final void pomFromGradleProperties$lambda-12$lambda-11$lambda-6$lambda-5(String $licenceName, String $licenceUrl, String $licenceDistribution, MavenPomLicense it) {
        it.getName().set((Object)$licenceName);
        it.getUrl().set((Object)$licenceUrl);
        it.getDistribution().set((Object)$licenceDistribution);
    }

    private static final void pomFromGradleProperties$lambda-12$lambda-11$lambda-6(String $licenceName, String $licenceUrl, String $licenceDistribution, MavenPomLicenseSpec licences) {
        licences.license(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda-12$lambda-11$lambda-6$lambda-5($licenceName, $licenceUrl, $licenceDistribution, arg_0));
    }

    private static final void pomFromGradleProperties$lambda-12$lambda-11$lambda-8$lambda-7(String $licenseName, String $licenseUrl, String $licenseDistribution, MavenPomLicense it) {
        it.getName().set((Object)$licenseName);
        it.getUrl().set((Object)$licenseUrl);
        it.getDistribution().set((Object)$licenseDistribution);
    }

    private static final void pomFromGradleProperties$lambda-12$lambda-11$lambda-8(String $licenseName, String $licenseUrl, String $licenseDistribution, MavenPomLicenseSpec licenses) {
        licenses.license(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda-12$lambda-11$lambda-8$lambda-7($licenseName, $licenseUrl, $licenseDistribution, arg_0));
    }

    private static final void pomFromGradleProperties$lambda-12$lambda-11$lambda-10$lambda-9(String $developerId, String $developerName, String $developerUrl, MavenPomDeveloper it) {
        it.getId().set((Object)$developerId);
        it.getName().set((Object)$developerName);
        it.getUrl().set((Object)$developerUrl);
    }

    private static final void pomFromGradleProperties$lambda-12$lambda-11$lambda-10(String $developerId, String $developerName, String $developerUrl, MavenPomDeveloperSpec developers) {
        developers.developer(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda-12$lambda-11$lambda-10$lambda-9($developerId, $developerName, $developerUrl, arg_0));
    }

    private static final void pomFromGradleProperties$lambda-12$lambda-11(MavenPublishBaseExtension this$0, MavenPom pom) {
        String inceptionYear;
        String url;
        String description;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String name = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_NAME");
        if (name != null) {
            pom.getName().set((Object)name);
        }
        if ((description = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_DESCRIPTION")) != null) {
            pom.getDescription().set((Object)description);
        }
        if ((url = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_URL")) != null) {
            pom.getUrl().set((Object)url);
        }
        if ((inceptionYear = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_INCEPTION_YEAR")) != null) {
            pom.getInceptionYear().set((Object)inceptionYear);
        }
        String scmUrl = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_SCM_URL");
        String scmConnection = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_SCM_CONNECTION");
        String scmDeveloperConnection = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_SCM_DEV_CONNECTION");
        if (scmUrl != null || scmConnection != null || scmDeveloperConnection != null) {
            pom.scm(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda-12$lambda-11$lambda-4(scmUrl, scmConnection, scmDeveloperConnection, arg_0));
        }
        String licenceName = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENCE_NAME");
        String licenceUrl = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENCE_URL");
        String licenceDistribution = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENCE_DIST");
        if (licenceName != null || licenceUrl != null || licenceDistribution != null) {
            pom.licenses(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda-12$lambda-11$lambda-6(licenceName, licenceUrl, licenceDistribution, arg_0));
        }
        String licenseName = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENSE_NAME");
        String licenseUrl = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENSE_URL");
        String licenseDistribution = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENSE_DIST");
        if (licenseName != null || licenseUrl != null || licenseDistribution != null) {
            pom.licenses(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda-12$lambda-11$lambda-8(licenseName, licenseUrl, licenseDistribution, arg_0));
        }
        String developerId = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_DEVELOPER_ID");
        String developerName = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_DEVELOPER_NAME");
        String developerUrl = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_DEVELOPER_URL");
        if (developerId != null || developerName != null || developerUrl != null) {
            pom.developers(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda-12$lambda-11$lambda-10(developerId, developerName, developerUrl, arg_0));
        }
    }

    private static final void pomFromGradleProperties$lambda-12(MavenPublishBaseExtension this$0, Project it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.pom((Action<? super MavenPom>)((Action)arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda-12$lambda-11(this$0, arg_0)));
    }
}

