/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish;

import com.vanniktech.maven.publish.ProjectExtensionsKt;
import com.vanniktech.maven.publish.SonatypeHost;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lcom/vanniktech/maven/publish/MavenPublishPluginExtension;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "androidVariantToPublish", "", "getAndroidVariantToPublish", "()Ljava/lang/String;", "setAndroidVariantToPublish", "(Ljava/lang/String;)V", "releaseSigningEnabled", "", "getReleaseSigningEnabled", "()Z", "setReleaseSigningEnabled", "(Z)V", "sonatypeHost", "Lcom/vanniktech/maven/publish/SonatypeHost;", "getSonatypeHost", "()Lcom/vanniktech/maven/publish/SonatypeHost;", "setSonatypeHost", "(Lcom/vanniktech/maven/publish/SonatypeHost;)V", "defaultSonatypeHost", "plugin"})
public abstract class MavenPublishPluginExtension {
    @NotNull
    private final Project project;
    @Nullable
    private SonatypeHost sonatypeHost;
    @NotNull
    private String androidVariantToPublish;
    private boolean releaseSigningEnabled;

    public MavenPublishPluginExtension(@NotNull Project project) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.sonatypeHost = this.defaultSonatypeHost();
        this.androidVariantToPublish = "release";
        String string = ProjectExtensionsKt.findOptionalProperty(this.project, "RELEASE_SIGNING_ENABLED");
        if (string == null) {
            bl = true;
        } else {
            boolean bl2;
            String string2 = string;
            boolean bl3 = false;
            bl = bl2 = Boolean.parseBoolean(string2);
        }
        this.releaseSigningEnabled = bl;
    }

    @Nullable
    public final SonatypeHost getSonatypeHost() {
        return this.sonatypeHost;
    }

    public final void setSonatypeHost(@Nullable SonatypeHost sonatypeHost) {
        this.sonatypeHost = sonatypeHost;
    }

    @NotNull
    public final String getAndroidVariantToPublish() {
        return this.androidVariantToPublish;
    }

    public final void setAndroidVariantToPublish(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.androidVariantToPublish = string;
    }

    public final boolean getReleaseSigningEnabled() {
        return this.releaseSigningEnabled;
    }

    public final void setReleaseSigningEnabled(boolean bl) {
        this.releaseSigningEnabled = bl;
    }

    private final SonatypeHost defaultSonatypeHost() {
        String property = ProjectExtensionsKt.findOptionalProperty(this.project, "SONATYPE_HOST");
        if (property != null) {
            return StringsKt.isBlank((CharSequence)property) ? (SonatypeHost)null : SonatypeHost.valueOf(property);
        }
        return SonatypeHost.DEFAULT;
    }
}

