/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish.nexus;

import com.vanniktech.maven.publish.nexus.Nexus;
import com.vanniktech.maven.publish.nexus.NexusOkHttpInterceptor;
import com.vanniktech.maven.publish.nexus.NexusService;
import com.vanniktech.maven.publish.nexus.ProfileRepositoriesResponse;
import com.vanniktech.maven.publish.nexus.Repository;
import com.vanniktech.maven.publish.nexus.TransitionRepositoryInput;
import com.vanniktech.maven.publish.nexus.TransitionRepositoryInputData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0015H\u0002J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0003J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0003H\u0002R#\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/vanniktech/maven/publish/nexus/Nexus;", "", "baseUrl", "", "username", "password", "stagingRepository", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "service", "Lcom/vanniktech/maven/publish/nexus/NexusService;", "kotlin.jvm.PlatformType", "getService", "()Lcom/vanniktech/maven/publish/nexus/NexusService;", "service$delegate", "Lkotlin/Lazy;", "closeAndReleaseRepository", "", "findAndCloseStagingRepository", "findStagingRepository", "Lcom/vanniktech/maven/publish/nexus/Repository;", "getProfileRepositories", "", "releaseStagingRepository", "repositoryId", "waitForClose", "Companion", "plugin"})
public final class Nexus {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String stagingRepository;
    @NotNull
    private final Lazy service$delegate;
    @NotNull
    private static final String PROGRESS_1 = "\u2839";
    @NotNull
    private static final String PROGRESS_2 = "\u2838";
    @NotNull
    private static final String PROGRESS_3 = "\u2834";
    @NotNull
    private static final String PROGRESS_4 = "\u2826";
    @NotNull
    private static final String PROGRESS_5 = "\u2807";
    @NotNull
    private static final String PROGRESS_6 = "\u280f";
    @NotNull
    private static final String PROGRESS_7 = "\u2819";
    private static final long CLOSE_TIMEOUT_MILLIS = 900000L;
    private static final long CLOSE_WAIT_INTERVAL_MILLIS = 10000L;

    public Nexus(@NotNull String baseUrl, @NotNull String username, @NotNull String password, @Nullable String stagingRepository) {
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        this.stagingRepository = stagingRepository;
        this.service$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NexusService>(username, password, baseUrl){
            final /* synthetic */ String $username;
            final /* synthetic */ String $password;
            final /* synthetic */ String $baseUrl;
            {
                this.$username = $username;
                this.$password = $password;
                this.$baseUrl = $baseUrl;
                super(0);
            }

            public final NexusService invoke() {
                OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new NexusOkHttpInterceptor(this.$username, this.$password)).build();
                Retrofit retrofit = new Retrofit.Builder().addConverterFactory((Converter.Factory)MoshiConverterFactory.create()).client(okHttpClient).baseUrl(this.$baseUrl).build();
                return (NexusService)retrofit.create(NexusService.class);
            }
        }));
    }

    private final NexusService getService() {
        Lazy lazy = this.service$delegate;
        boolean bl = false;
        return (NexusService)lazy.getValue();
    }

    private final List<Repository> getProfileRepositories() {
        Response profileRepositoriesResponse = this.getService().getProfileRepositories().execute();
        if (!profileRepositoriesResponse.isSuccessful()) {
            ResponseBody responseBody = profileRepositoriesResponse.errorBody();
            throw new IOException(Intrinsics.stringPlus((String)"Cannot get profileRepositories: ", (Object)(responseBody == null ? null : responseBody.string())));
        }
        ProfileRepositoriesResponse profileRepositoriesResponse2 = (ProfileRepositoriesResponse)profileRepositoriesResponse.body();
        return profileRepositoriesResponse2 == null ? null : profileRepositoriesResponse2.getData();
    }

    /*
     * WARNING - void declaration
     */
    private final Repository findStagingRepository() {
        List candidateRepositories;
        List list;
        List allRepositories;
        List list2 = this.getProfileRepositories();
        List list3 = allRepositories = list2 == null ? CollectionsKt.emptyList() : list2;
        if (allRepositories.isEmpty()) {
            throw new IllegalArgumentException("No staging repository prefixed with. Make sure you called \"./gradlew publish\".");
        }
        if (this.stagingRepository != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = allRepositories;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Repository it = (Repository)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getRepositoryId(), (Object)this.stagingRepository)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = candidateRepositories = allRepositories;
        }
        if (candidateRepositories.isEmpty()) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"No matching staging repository found. You can can explicitly choose one by passing it as an option like this \"./gradlew closeAndReleaseRepository --repository=comexample-123\". Available repositories are: ", (Object)CollectionsKt.joinToString$default((Iterable)allRepositories, (CharSequence)", ", null, null, (int)0, null, (Function1)findStagingRepository.1.INSTANCE, (int)30, null)));
        }
        if (candidateRepositories.size() > 1) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"More than 1 matching staging repository found. You can can explicitly choose one by passing it as an option like this \"./gradlew closeAndReleaseRepository --repository comexample-123\". Available repositories are: ", (Object)CollectionsKt.joinToString$default((Iterable)allRepositories, (CharSequence)", ", null, null, (int)0, null, (Function1)findStagingRepository.2.INSTANCE, (int)30, null)));
        }
        return candidateRepositories.get(0);
    }

    @NotNull
    public final String findAndCloseStagingRepository() {
        Repository stagingRepository = this.findStagingRepository();
        String repositoryId = stagingRepository.getRepositoryId();
        if (!Intrinsics.areEqual((Object)stagingRepository.getType(), (Object)"open")) {
            throw new IllegalArgumentException("Repository " + repositoryId + " is of type '" + stagingRepository.getType() + "' and not 'open'");
        }
        String string = Intrinsics.stringPlus((String)"Closing repository: ", (Object)repositoryId);
        boolean bl = false;
        System.out.println((Object)string);
        Response response = this.getService().closeRepository(new TransitionRepositoryInput(new TransitionRepositoryInputData(CollectionsKt.listOf((Object)repositoryId), null, 2, null))).execute();
        if (!response.isSuccessful()) {
            ResponseBody responseBody = response.errorBody();
            throw new IOException(Intrinsics.stringPlus((String)"Cannot close repository: ", (Object)(responseBody == null ? null : responseBody.string())));
        }
        this.waitForClose(repositoryId);
        return repositoryId;
    }

    private final void waitForClose(String repositoryId) {
        long startMillis = System.currentTimeMillis();
        Object[] objectArray = new String[]{PROGRESS_1, PROGRESS_2, PROGRESS_3, PROGRESS_4, PROGRESS_5, PROGRESS_6, PROGRESS_7};
        List waitingChars = CollectionsKt.listOf((Object[])objectArray);
        int i = 0;
        while (true) {
            if (System.currentTimeMillis() - startMillis > 900000L) {
                throw new IOException("Timeout waiting for repository close");
            }
            int n = i;
            i = n + 1;
            String string = '\r' + (String)waitingChars.get(n % waitingChars.size()) + " waiting for close...";
            boolean bl = false;
            System.out.print((Object)string);
            System.out.flush();
            Thread.sleep(10000L);
            try {
                Repository repository = (Repository)this.getService().getRepository(repositoryId).execute().body();
                Repository repository2 = repository;
                if (!Intrinsics.areEqual((Object)(repository2 == null ? null : repository2.getType()), (Object)"closed") || repository.getTransitioning()) continue;
            }
            catch (IOException e) {
                System.err.println(Intrinsics.stringPlus((String)"Exception trying to get repository status: ", (Object)e.getMessage()));
                continue;
            }
            break;
        }
    }

    public final void releaseStagingRepository(@NotNull String repositoryId) {
        Intrinsics.checkNotNullParameter((Object)repositoryId, (String)"repositoryId");
        String string = Intrinsics.stringPlus((String)"Releasing repository: ", (Object)repositoryId);
        boolean bl = false;
        System.out.println((Object)string);
        Response response = this.getService().releaseRepository(new TransitionRepositoryInput(new TransitionRepositoryInputData(CollectionsKt.listOf((Object)repositoryId), true))).execute();
        if (!response.isSuccessful()) {
            ResponseBody responseBody = response.errorBody();
            throw new IOException(Intrinsics.stringPlus((String)"Cannot release repository: ", (Object)(responseBody == null ? null : responseBody.string())));
        }
        String string2 = "Repository " + repositoryId + " released";
        boolean bl2 = false;
        System.out.println((Object)string2);
    }

    public final void closeAndReleaseRepository() {
        String repositoryId = this.findAndCloseStagingRepository();
        this.releaseStagingRepository(repositoryId);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/vanniktech/maven/publish/nexus/Nexus$Companion;", "", "()V", "CLOSE_TIMEOUT_MILLIS", "", "CLOSE_WAIT_INTERVAL_MILLIS", "PROGRESS_1", "", "PROGRESS_2", "PROGRESS_3", "PROGRESS_4", "PROGRESS_5", "PROGRESS_6", "PROGRESS_7", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

