/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish;

import com.vanniktech.maven.publish.MavenPublishBaseExtension;
import com.vanniktech.maven.publish.Platform;
import com.vanniktech.maven.publish.ProjectExtensionsKt;
import com.vanniktech.maven.publish.SonatypeHost;
import com.vanniktech.maven.publish.sonatype.CloseAndReleaseSonatypeRepositoryTask;
import com.vanniktech.maven.publish.sonatype.CreateSonatypeRepositoryTask;
import com.vanniktech.maven.publish.sonatype.DropSonatypeRepositoryTask;
import com.vanniktech.maven.publish.sonatype.SonatypeRepositoryBuildService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.MavenPomDeveloper;
import org.gradle.api.publish.maven.MavenPomDeveloperSpec;
import org.gradle.api.publish.maven.MavenPomIssueManagement;
import org.gradle.api.publish.maven.MavenPomLicense;
import org.gradle.api.publish.maven.MavenPomLicenseSpec;
import org.gradle.api.publish.maven.MavenPomScm;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.tasks.AbstractPublishToMaven;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.plugins.signing.Sign;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.SigningPlugin;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007H\u0007J\u0010\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0007H\u0002J\u0018\u0010\u0017\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00190\u0018H\u0007J\b\u0010\u001a\u001a\u00020\u0014H\u0007J\u001c\u0010\u001b\u001a\u00020\u00142\b\b\u0002\u0010\u001c\u001a\u00020\u00102\b\b\u0002\u0010\u001d\u001a\u00020\rH\u0007J\u001a\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u00072\b\b\u0002\u0010\u001d\u001a\u00020\rH\u0007J\u0006\u0010\u001e\u001a\u00020\u0014J\u0010\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u001c\u0010\u001f\u001a\u00020\u0007*\u00020\u00072\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\t\u00a8\u0006\""}, d2={"Lcom/vanniktech/maven/publish/MavenPublishBaseExtension;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "groupId", "Lorg/gradle/api/provider/Property;", "", "getGroupId$plugin", "()Lorg/gradle/api/provider/Property;", "platform", "Lcom/vanniktech/maven/publish/Platform;", "pomFromProperties", "", "signing", "sonatypeHost", "Lcom/vanniktech/maven/publish/SonatypeHost;", "version", "getVersion$plugin", "artifactId", "", "configure", "coordinates", "pom", "Lorg/gradle/api/Action;", "Lorg/gradle/api/publish/maven/MavenPom;", "pomFromGradleProperties", "publishToMavenCentral", "host", "automaticRelease", "signAllPublications", "forMultiplatform", "publication", "Lorg/gradle/api/publish/maven/MavenPublication;", "plugin"})
@SourceDebugExtension(value={"SMAP\nMavenPublishBaseExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenPublishBaseExtension.kt\ncom/vanniktech/maven/publish/MavenPublishBaseExtension\n+ 2 ProjectExtensions.kt\ncom/vanniktech/maven/publish/ProjectExtensionsKt\n*L\n1#1,351:1\n21#2:352\n18#2:353\n18#2:354\n18#2:355\n18#2:356\n*S KotlinDebug\n*F\n+ 1 MavenPublishBaseExtension.kt\ncom/vanniktech/maven/publish/MavenPublishBaseExtension\n*L\n77#1:352\n132#1:353\n138#1:354\n146#1:355\n149#1:356\n*E\n"})
public abstract class MavenPublishBaseExtension {
    @NotNull
    private final Project project;
    @NotNull
    private final Property<SonatypeHost> sonatypeHost;
    @NotNull
    private final Property<Boolean> signing;
    @NotNull
    private final Property<String> groupId;
    @NotNull
    private final Property<String> version;
    @NotNull
    private final Property<Boolean> pomFromProperties;
    @NotNull
    private final Property<Platform> platform;

    public MavenPublishBaseExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Property property = this.project.getObjects().property(SonatypeHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"project.objects.property(SonatypeHost::class.java)");
        this.sonatypeHost = property;
        Property property2 = this.project.getObjects().property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"project.objects.property(Boolean::class.java)");
        this.signing = property2;
        Property property3 = this.project.getObjects().property(String.class).convention(this.project.provider(() -> MavenPublishBaseExtension.groupId$lambda$0(this)));
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"project.objects.property\u2026oject.group.toString() })");
        this.groupId = property3;
        Property property4 = this.project.getObjects().property(String.class).convention(this.project.provider(() -> MavenPublishBaseExtension.version$lambda$1(this)));
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"project.objects.property\u2026ect.version.toString() })");
        this.version = property4;
        Property property5 = this.project.getObjects().property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"project.objects.property(Boolean::class.java)");
        this.pomFromProperties = property5;
        Property property6 = this.project.getObjects().property(Platform.class);
        Intrinsics.checkNotNullExpressionValue((Object)property6, (String)"project.objects.property(Platform::class.java)");
        this.platform = property6;
    }

    @NotNull
    public final Property<String> getGroupId$plugin() {
        return this.groupId;
    }

    @NotNull
    public final Property<String> getVersion$plugin() {
        return this.version;
    }

    @JvmOverloads
    public final void publishToMavenCentral(@NotNull SonatypeHost host, boolean automaticRelease) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.sonatypeHost.set((Object)host);
        this.sonatypeHost.finalizeValue();
        Provider provider = (Provider)this.sonatypeHost;
        Provider provider2 = this.project.getProviders().gradleProperty("mavenCentralUsername");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"project.providers.gradle\u2026y(\"mavenCentralUsername\")");
        Provider provider3 = this.project.getProviders().gradleProperty("mavenCentralPassword");
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"project.providers.gradle\u2026y(\"mavenCentralPassword\")");
        Provider<SonatypeRepositoryBuildService> buildService = SonatypeRepositoryBuildService.Companion.registerSonatypeRepositoryBuildService(this.project, (Provider<SonatypeHost>)provider, (Provider<String>)provider2, (Provider<String>)provider3, automaticRelease);
        Provider versionIsSnapshot2 = this.version.map(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$2(publishToMavenCentral.versionIsSnapshot.1.INSTANCE, arg_0));
        TaskContainer taskContainer = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        Provider provider4 = (Provider)this.groupId;
        Intrinsics.checkNotNullExpressionValue((Object)versionIsSnapshot2, (String)"versionIsSnapshot");
        TaskProvider<CreateSonatypeRepositoryTask> createRepository = CreateSonatypeRepositoryTask.Companion.registerCreateRepository(taskContainer, (Provider<String>)provider4, (Provider<Boolean>)versionIsSnapshot2, buildService);
        Provider stagingRepositoryId2 = buildService.map(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$3((Function1)new Function1<SonatypeRepositoryBuildService, String>(this){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final String invoke(SonatypeRepositoryBuildService it) {
                String string = it.getStagingRepositoryId();
                MavenPublishBaseExtension mavenPublishBaseExtension = this.this$0;
                String string2 = string;
                if (string2 == null) {
                    boolean bl = false;
                    String string3 = MavenPublishBaseExtension.access$getProject$p(mavenPublishBaseExtension).getGradle().getStartParameter().isConfigurationCacheRequested() ? "Publishing releases to Maven Central is not supported yet with configuration caching enabled, because of this missing Gradle feature: https://github.com/gradle/gradle/issues/22779" : "The staging repository was not created yet. Please open a bug with a build scan or build logs and stacktrace";
                    throw new IllegalArgumentException(string3.toString());
                }
                return string2;
            }
        }, arg_0));
        Project $this$gradlePublishing$iv = this.project;
        boolean $i$f$getGradlePublishing = false;
        Object object = $this$gradlePublishing$iv.getExtensions().getByType(PublishingExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(Pub\u2026ingExtension::class.java)");
        ((PublishingExtension)object).getRepositories().maven(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$4((Function1)new Function1<MavenArtifactRepository, Unit>(this, (Provider<Boolean>)versionIsSnapshot2, (Provider<String>)stagingRepositoryId2){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            final /* synthetic */ Provider<Boolean> $versionIsSnapshot;
            final /* synthetic */ Provider<String> $stagingRepositoryId;
            {
                this.this$0 = $receiver;
                this.$versionIsSnapshot = $versionIsSnapshot;
                this.$stagingRepositoryId = $stagingRepositoryId;
                super(1);
            }

            public final void invoke(MavenArtifactRepository repo) {
                repo.setName("mavenCentral");
                repo.setUrl((Object)MavenPublishBaseExtension.access$getSonatypeHost$p(this.this$0).map(arg_0 -> publishToMavenCentral.1.invoke$lambda$0((Function1)new Function1<SonatypeHost, String>(this.$versionIsSnapshot, this.$stagingRepositoryId){
                    final /* synthetic */ Provider<Boolean> $versionIsSnapshot;
                    final /* synthetic */ Provider<String> $stagingRepositoryId;
                    {
                        this.$versionIsSnapshot = $versionIsSnapshot;
                        this.$stagingRepositoryId = $stagingRepositoryId;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(SonatypeHost it) {
                        Object object = this.$versionIsSnapshot.get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"versionIsSnapshot.get()");
                        boolean bl = (Boolean)object;
                        Provider<String> provider = this.$stagingRepositoryId;
                        Intrinsics.checkNotNullExpressionValue(provider, (String)"stagingRepositoryId");
                        return it.publishingUrl$plugin(bl, provider);
                    }
                }, arg_0)));
                repo.credentials(PasswordCredentials.class);
            }

            private static final String invoke$lambda$0(Function1 $tmp0, Object in) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (String)$tmp0.invoke(in);
            }
        }, arg_0));
        this.project.getTasks().withType(PublishToMavenRepository.class).configureEach(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$5((Function1)new Function1<PublishToMavenRepository, Unit>(createRepository){
            final /* synthetic */ TaskProvider<CreateSonatypeRepositoryTask> $createRepository;
            {
                this.$createRepository = $createRepository;
                super(1);
            }

            public final void invoke(PublishToMavenRepository publishTask) {
                String string = publishTask.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"publishTask.name");
                if (StringsKt.endsWith$default((String)string, (String)"ToMavenCentralRepository", (boolean)false, (int)2, null)) {
                    Object[] objectArray = new Object[]{this.$createRepository};
                    publishTask.dependsOn(objectArray);
                }
            }
        }, arg_0));
        TaskContainer taskContainer2 = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer2, (String)"project.tasks");
        CloseAndReleaseSonatypeRepositoryTask.Companion.registerCloseAndReleaseRepository(taskContainer2, buildService);
        TaskContainer taskContainer3 = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer3, (String)"project.tasks");
        DropSonatypeRepositoryTask.Companion.registerDropRepository(taskContainer3, buildService);
    }

    public static /* synthetic */ void publishToMavenCentral$default(MavenPublishBaseExtension mavenPublishBaseExtension, SonatypeHost sonatypeHost, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishToMavenCentral");
        }
        if ((n & 1) != 0) {
            sonatypeHost = SonatypeHost.DEFAULT;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        mavenPublishBaseExtension.publishToMavenCentral(sonatypeHost, bl);
    }

    @JvmOverloads
    public final /* synthetic */ void publishToMavenCentral(String host, boolean automaticRelease) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.publishToMavenCentral(SonatypeHost.Companion.valueOf(host), automaticRelease);
    }

    public static /* synthetic */ void publishToMavenCentral$default(MavenPublishBaseExtension mavenPublishBaseExtension, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishToMavenCentral");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        mavenPublishBaseExtension.publishToMavenCentral(string, bl);
    }

    public final void signAllPublications() {
        this.signing.set((Object)true);
        this.signing.finalizeValue();
        this.project.getPlugins().apply(SigningPlugin.class);
        Project $this$gradleSigning$iv = this.project;
        boolean $i$f$getGradleSigning = false;
        Object object = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(SigningExtension::class.java)");
        ((SigningExtension)object).setRequired((Object)this.version.map(arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$6(signAllPublications.1.INSTANCE, arg_0)));
        String inMemoryKey = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKey");
        if (inMemoryKey != null) {
            String inMemoryKeyId = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKeyId");
            String string = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKeyPassword");
            if (string == null) {
                string = "";
            }
            String inMemoryKeyPassword = string;
            Project $this$gradleSigning$iv2 = this.project;
            boolean $i$f$getGradleSigning2 = false;
            Object object2 = $this$gradleSigning$iv2.getExtensions().getByType(SigningExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"extensions.getByType(SigningExtension::class.java)");
            ((SigningExtension)object2).useInMemoryPgpKeys(inMemoryKeyId, inMemoryKey, inMemoryKeyPassword);
        }
        ProjectExtensionsKt.mavenPublications(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$7(this, arg_0)));
        this.project.getTasks().withType(AbstractPublishToMaven.class).configureEach(arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$8((Function1)new Function1<AbstractPublishToMaven, Unit>(this){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(AbstractPublishToMaven publishTask) {
                Object[] objectArray = new Object[]{MavenPublishBaseExtension.access$getProject$p(this.this$0).getTasks().withType(Sign.class)};
                publishTask.dependsOn(objectArray);
            }
        }, arg_0));
    }

    @Incubating
    public final void coordinates(@NotNull String groupId, @NotNull String artifactId2, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId2, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.groupId(groupId);
        this.artifactId(artifactId2);
        this.version(version);
    }

    private final void groupId(String groupId) {
        this.groupId.set((Object)groupId);
        this.groupId.finalizeValueOnRead();
        ProjectExtensionsKt.mavenPublicationsWithoutPluginMarker(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.groupId$lambda$9(this, arg_0)));
    }

    private final void artifactId(String artifactId2) {
        ProjectExtensionsKt.mavenPublicationsWithoutPluginMarker(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.artifactId$lambda$11(this, artifactId2, arg_0)));
    }

    private final String forMultiplatform(String $this$forMultiplatform, MavenPublication publication, Project project) {
        String string;
        String projectName = project.getName();
        if (Intrinsics.areEqual((Object)publication.getArtifactId(), (Object)projectName)) {
            string = $this$forMultiplatform;
        } else {
            String string2 = publication.getArtifactId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"publication.artifactId");
            if (StringsKt.startsWith$default((String)string2, (String)(projectName + "-"), (boolean)false, (int)2, null)) {
                String string3 = publication.getArtifactId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"publication.artifactId");
                string = StringsKt.replace$default((String)string3, (String)(projectName + "-"), (String)($this$forMultiplatform + "-"), (boolean)false, (int)4, null);
            } else {
                throw new IllegalStateException("The plugin can't handle the publication " + publication.getName() + " artifactId " + publication.getArtifactId() + " in project " + projectName);
            }
        }
        return string;
    }

    private final void version(String version) {
        this.version.set((Object)version);
        this.version.finalizeValueOnRead();
        ProjectExtensionsKt.mavenPublications(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.version$lambda$12(this, arg_0)));
    }

    @Incubating
    public final void pom(@NotNull Action<? super MavenPom> configure2) {
        Intrinsics.checkNotNullParameter(configure2, (String)"configure");
        ProjectExtensionsKt.mavenPublications(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.pom$lambda$14(this, configure2, arg_0)));
    }

    @Incubating
    public final void pomFromGradleProperties() {
        String version;
        String artifactId2;
        this.pomFromProperties.set((Object)true);
        this.pomFromProperties.finalizeValue();
        String groupId = ProjectExtensionsKt.findOptionalProperty(this.project, "GROUP");
        if (groupId != null) {
            this.groupId(groupId);
        }
        if ((artifactId2 = ProjectExtensionsKt.findOptionalProperty(this.project, "POM_ARTIFACT_ID")) != null) {
            this.artifactId(artifactId2);
        }
        if ((version = ProjectExtensionsKt.findOptionalProperty(this.project, "VERSION_NAME")) != null) {
            this.version(version);
        }
        this.pom((Action<? super MavenPom>)((Action)arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$15((Function1)new Function1<MavenPom, Unit>(this){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(MavenPom pom2) {
                String inceptionYear;
                String url;
                String description;
                String name = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_NAME");
                if (name != null) {
                    pom2.getName().set((Object)name);
                }
                if ((description = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_DESCRIPTION")) != null) {
                    pom2.getDescription().set((Object)description);
                }
                if ((url = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_URL")) != null) {
                    pom2.getUrl().set((Object)url);
                }
                if ((inceptionYear = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_INCEPTION_YEAR")) != null) {
                    pom2.getInceptionYear().set((Object)inceptionYear);
                }
                String issueManagementSystem = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_ISSUE_SYSTEM");
                String issueManagementUrl = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_ISSUE_URL");
                if (issueManagementSystem != null || issueManagementUrl != null) {
                    pom2.issueManagement(arg_0 -> pomFromGradleProperties.1.invoke$lambda$0((Function1)new Function1<MavenPomIssueManagement, Unit>(issueManagementSystem, issueManagementUrl){
                        final /* synthetic */ String $issueManagementSystem;
                        final /* synthetic */ String $issueManagementUrl;
                        {
                            this.$issueManagementSystem = $issueManagementSystem;
                            this.$issueManagementUrl = $issueManagementUrl;
                            super(1);
                        }

                        public final void invoke(MavenPomIssueManagement it) {
                            it.getSystem().set((Object)this.$issueManagementSystem);
                            it.getUrl().set((Object)this.$issueManagementUrl);
                        }
                    }, arg_0));
                }
                String scmUrl = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_SCM_URL");
                String scmConnection = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_SCM_CONNECTION");
                String scmDeveloperConnection = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_SCM_DEV_CONNECTION");
                if (scmUrl != null || scmConnection != null || scmDeveloperConnection != null) {
                    pom2.scm(arg_0 -> pomFromGradleProperties.1.invoke$lambda$1((Function1)new Function1<MavenPomScm, Unit>(scmUrl, scmConnection, scmDeveloperConnection){
                        final /* synthetic */ String $scmUrl;
                        final /* synthetic */ String $scmConnection;
                        final /* synthetic */ String $scmDeveloperConnection;
                        {
                            this.$scmUrl = $scmUrl;
                            this.$scmConnection = $scmConnection;
                            this.$scmDeveloperConnection = $scmDeveloperConnection;
                            super(1);
                        }

                        public final void invoke(MavenPomScm it) {
                            it.getUrl().set((Object)this.$scmUrl);
                            it.getConnection().set((Object)this.$scmConnection);
                            it.getDeveloperConnection().set((Object)this.$scmDeveloperConnection);
                        }
                    }, arg_0));
                }
                String licenceName = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_LICENCE_NAME");
                String licenceUrl = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_LICENCE_URL");
                String licenceDistribution = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_LICENCE_DIST");
                if (licenceName != null || licenceUrl != null || licenceDistribution != null) {
                    pom2.licenses(arg_0 -> pomFromGradleProperties.1.invoke$lambda$2((Function1)new Function1<MavenPomLicenseSpec, Unit>(licenceName, licenceUrl, licenceDistribution){
                        final /* synthetic */ String $licenceName;
                        final /* synthetic */ String $licenceUrl;
                        final /* synthetic */ String $licenceDistribution;
                        {
                            this.$licenceName = $licenceName;
                            this.$licenceUrl = $licenceUrl;
                            this.$licenceDistribution = $licenceDistribution;
                            super(1);
                        }

                        public final void invoke(MavenPomLicenseSpec licences) {
                            licences.license(arg_0 -> pomFromGradleProperties.3.invoke$lambda$0((Function1)new Function1<MavenPomLicense, Unit>(this.$licenceName, this.$licenceUrl, this.$licenceDistribution){
                                final /* synthetic */ String $licenceName;
                                final /* synthetic */ String $licenceUrl;
                                final /* synthetic */ String $licenceDistribution;
                                {
                                    this.$licenceName = $licenceName;
                                    this.$licenceUrl = $licenceUrl;
                                    this.$licenceDistribution = $licenceDistribution;
                                    super(1);
                                }

                                public final void invoke(MavenPomLicense it) {
                                    it.getName().set((Object)this.$licenceName);
                                    it.getUrl().set((Object)this.$licenceUrl);
                                    it.getDistribution().set((Object)this.$licenceDistribution);
                                }
                            }, arg_0));
                        }

                        private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            $tmp0.invoke(p0);
                        }
                    }, arg_0));
                }
                String licenseName = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_LICENSE_NAME");
                String licenseUrl = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_LICENSE_URL");
                String licenseDistribution = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_LICENSE_DIST");
                if (licenseName != null || licenseUrl != null || licenseDistribution != null) {
                    pom2.licenses(arg_0 -> pomFromGradleProperties.1.invoke$lambda$3((Function1)new Function1<MavenPomLicenseSpec, Unit>(licenseName, licenseUrl, licenseDistribution){
                        final /* synthetic */ String $licenseName;
                        final /* synthetic */ String $licenseUrl;
                        final /* synthetic */ String $licenseDistribution;
                        {
                            this.$licenseName = $licenseName;
                            this.$licenseUrl = $licenseUrl;
                            this.$licenseDistribution = $licenseDistribution;
                            super(1);
                        }

                        public final void invoke(MavenPomLicenseSpec licenses) {
                            licenses.license(arg_0 -> pomFromGradleProperties.4.invoke$lambda$0((Function1)new Function1<MavenPomLicense, Unit>(this.$licenseName, this.$licenseUrl, this.$licenseDistribution){
                                final /* synthetic */ String $licenseName;
                                final /* synthetic */ String $licenseUrl;
                                final /* synthetic */ String $licenseDistribution;
                                {
                                    this.$licenseName = $licenseName;
                                    this.$licenseUrl = $licenseUrl;
                                    this.$licenseDistribution = $licenseDistribution;
                                    super(1);
                                }

                                public final void invoke(MavenPomLicense it) {
                                    it.getName().set((Object)this.$licenseName);
                                    it.getUrl().set((Object)this.$licenseUrl);
                                    it.getDistribution().set((Object)this.$licenseDistribution);
                                }
                            }, arg_0));
                        }

                        private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            $tmp0.invoke(p0);
                        }
                    }, arg_0));
                }
                String developerId = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_DEVELOPER_ID");
                String developerName = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_DEVELOPER_NAME");
                String developerUrl = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_DEVELOPER_URL");
                String developerEmail = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_DEVELOPER_EMAIL");
                if (developerId != null || developerName != null || developerUrl != null) {
                    pom2.developers(arg_0 -> pomFromGradleProperties.1.invoke$lambda$4((Function1)new Function1<MavenPomDeveloperSpec, Unit>(developerId, developerName, developerUrl, developerEmail){
                        final /* synthetic */ String $developerId;
                        final /* synthetic */ String $developerName;
                        final /* synthetic */ String $developerUrl;
                        final /* synthetic */ String $developerEmail;
                        {
                            this.$developerId = $developerId;
                            this.$developerName = $developerName;
                            this.$developerUrl = $developerUrl;
                            this.$developerEmail = $developerEmail;
                            super(1);
                        }

                        public final void invoke(MavenPomDeveloperSpec developers) {
                            developers.developer(arg_0 -> pomFromGradleProperties.5.invoke$lambda$0((Function1)new Function1<MavenPomDeveloper, Unit>(this.$developerId, this.$developerName, this.$developerUrl, this.$developerEmail){
                                final /* synthetic */ String $developerId;
                                final /* synthetic */ String $developerName;
                                final /* synthetic */ String $developerUrl;
                                final /* synthetic */ String $developerEmail;
                                {
                                    this.$developerId = $developerId;
                                    this.$developerName = $developerName;
                                    this.$developerUrl = $developerUrl;
                                    this.$developerEmail = $developerEmail;
                                    super(1);
                                }

                                public final void invoke(MavenPomDeveloper it) {
                                    it.getId().set((Object)this.$developerId);
                                    it.getName().set((Object)this.$developerName);
                                    it.getUrl().set((Object)this.$developerUrl);
                                    it.getEmail().set((Object)this.$developerEmail);
                                }
                            }, arg_0));
                        }

                        private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            $tmp0.invoke(p0);
                        }
                    }, arg_0));
                }
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$2(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$3(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$4(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0)));
    }

    @Incubating
    public final void configure(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform.set((Object)platform);
        this.platform.finalizeValue();
        platform.configure$plugin(this.project);
    }

    @JvmOverloads
    public final void publishToMavenCentral(@NotNull SonatypeHost host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        MavenPublishBaseExtension.publishToMavenCentral$default(this, host, false, 2, null);
    }

    @JvmOverloads
    public final void publishToMavenCentral() {
        MavenPublishBaseExtension.publishToMavenCentral$default(this, null, false, 3, null);
    }

    @JvmOverloads
    public final /* synthetic */ void publishToMavenCentral(String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        MavenPublishBaseExtension.publishToMavenCentral$default(this, host, false, 2, null);
    }

    private static final String groupId$lambda$0(MavenPublishBaseExtension this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.project.getGroup().toString();
    }

    private static final String version$lambda$1(MavenPublishBaseExtension this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.project.getVersion().toString();
    }

    private static final Boolean publishToMavenCentral$lambda$2(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(in);
    }

    private static final String publishToMavenCentral$lambda$3(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(in);
    }

    private static final void publishToMavenCentral$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void publishToMavenCentral$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Boolean signAllPublications$lambda$6(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(in);
    }

    private static final void signAllPublications$lambda$7(MavenPublishBaseExtension this$0, MavenPublication publication) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"8.0-rc-1")) < 0) {
            TaskContainer taskContainer = this$0.project.getTasks();
            String string = publication.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"publication.name");
            Task task = (Task)taskContainer.findByName("sign" + StringsKt.capitalize((String)string) + "Publication");
            if (task == null) {
                Publication[] $this$gradleSigning$iv = this$0.project;
                boolean $i$f$getGradleSigning = false;
                Object object = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(SigningExtension::class.java)");
                $this$gradleSigning$iv = new Publication[]{(Publication)publication};
                ((SigningExtension)object).sign($this$gradleSigning$iv);
            }
        } else {
            Project $this$gradleSigning$iv = this$0.project;
            boolean $i$f$getGradleSigning = false;
            Object object = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(SigningExtension::class.java)");
            Publication[] publicationArray = new Publication[]{(Publication)publication};
            ((SigningExtension)object).sign(publicationArray);
        }
    }

    private static final void signAllPublications$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void groupId$lambda$9(MavenPublishBaseExtension this$0, MavenPublication it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.setGroupId((String)this$0.groupId.get());
    }

    private static final void artifactId$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void artifactId$lambda$11(MavenPublishBaseExtension this$0, String $artifactId, MavenPublication it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$artifactId, (String)"$artifactId");
        if (this$0.project.getPlugins().hasPlugin("org.jetbrains.kotlin.multiplatform")) {
            this$0.project.afterEvaluate(arg_0 -> MavenPublishBaseExtension.artifactId$lambda$11$lambda$10((Function1)new Function1<Project, Unit>(it, this$0, $artifactId){
                final /* synthetic */ MavenPublication $it;
                final /* synthetic */ MavenPublishBaseExtension this$0;
                final /* synthetic */ String $artifactId;
                {
                    this.$it = $it;
                    this.this$0 = $receiver;
                    this.$artifactId = $artifactId;
                    super(1);
                }

                public final void invoke(Project project) {
                    MavenPublication mavenPublication = this.$it;
                    Intrinsics.checkNotNullExpressionValue((Object)mavenPublication, (String)"it");
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                    this.$it.setArtifactId(MavenPublishBaseExtension.access$forMultiplatform(this.this$0, this.$artifactId, mavenPublication, project));
                }
            }, arg_0));
        } else {
            it.setArtifactId($artifactId);
        }
    }

    private static final void version$lambda$12(MavenPublishBaseExtension this$0, MavenPublication it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.setVersion((String)this$0.version.get());
    }

    private static final void pom$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void pom$lambda$14(MavenPublishBaseExtension this$0, Action $configure, MavenPublication publication) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$configure, (String)"$configure");
        this$0.project.afterEvaluate(arg_0 -> MavenPublishBaseExtension.pom$lambda$14$lambda$13((Function1)new Function1<Project, Unit>(publication, (Action<? super MavenPom>)$configure){
            final /* synthetic */ MavenPublication $publication;
            final /* synthetic */ Action<? super MavenPom> $configure;
            {
                this.$publication = $publication;
                this.$configure = $configure;
                super(1);
            }

            public final void invoke(Project it) {
                this.$publication.pom(this.$configure);
            }
        }, arg_0));
    }

    private static final void pomFromGradleProperties$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(MavenPublishBaseExtension $this) {
        return $this.project;
    }

    public static final /* synthetic */ Property access$getSonatypeHost$p(MavenPublishBaseExtension $this) {
        return $this.sonatypeHost;
    }

    public static final /* synthetic */ String access$forMultiplatform(MavenPublishBaseExtension $this, String $receiver, MavenPublication publication, Project project) {
        return $this.forMultiplatform($receiver, publication, project);
    }
}

