/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish.sonatype;

import com.vanniktech.maven.publish.SonatypeHost;
import com.vanniktech.maven.publish.nexus.Nexus;
import com.vanniktech.maven.publish.sonatype.SonatypeRepositoryBuildService;
import java.io.IOException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0002$%B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0010\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R(\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006&"}, d2={"Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService;", "Lorg/gradle/api/services/BuildService;", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$Params;", "Ljava/lang/AutoCloseable;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "()V", "buildIsSuccess", "", "logger", "Lorg/gradle/api/logging/Logger;", "nexus", "Lcom/vanniktech/maven/publish/nexus/Nexus;", "getNexus", "()Lcom/vanniktech/maven/publish/nexus/Nexus;", "nexus$delegate", "Lkotlin/Lazy;", "repositoryClosed", "getRepositoryClosed", "()Z", "setRepositoryClosed", "(Z)V", "repositoryDropped", "getRepositoryDropped", "setRepositoryDropped", "value", "", "stagingRepositoryId", "getStagingRepositoryId", "()Ljava/lang/String;", "setStagingRepositoryId", "(Ljava/lang/String;)V", "close", "", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "Companion", "Params", "plugin"})
public abstract class SonatypeRepositoryBuildService
implements BuildService<Params>,
AutoCloseable,
OperationCompletionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy nexus$delegate;
    @Nullable
    private String stagingRepositoryId;
    private boolean repositoryClosed;
    private boolean repositoryDropped;
    private boolean buildIsSuccess;
    @NotNull
    private static final String NAME = "sonatype-repository-build-service";

    public SonatypeRepositoryBuildService() {
        Logger logger = Logging.getLogger(SonatypeRepositoryBuildService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(SonatypeReposi\u2026BuildService::class.java)");
        this.logger = logger;
        this.nexus$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Nexus>(this){
            final /* synthetic */ SonatypeRepositoryBuildService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Nexus invoke() {
                String string = ((SonatypeHost)((Params)this.this$0.getParameters()).getSonatypeHost().get()).apiBaseUrl$plugin();
                Object object = ((Params)this.this$0.getParameters()).getRepositoryUsername().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.repositoryUsername.get()");
                String string2 = (String)object;
                Object object2 = ((Params)this.this$0.getParameters()).getRepositoryPassword().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.repositoryPassword.get()");
                String string3 = (String)object2;
                Object object3 = ((Params)this.this$0.getParameters()).getOkhttpTimeoutSeconds().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.okhttpTimeoutSeconds.get()");
                long l = ((Number)object3).longValue();
                Object object4 = ((Params)this.this$0.getParameters()).getCloseTimeoutSeconds().get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parameters.closeTimeoutSeconds.get()");
                return new Nexus(string, string2, string3, "com.vanniktech.maven.publish", "0.25.3", l, ((Number)object4).longValue());
            }
        }));
        this.buildIsSuccess = true;
    }

    @NotNull
    public final Nexus getNexus() {
        Lazy lazy = this.nexus$delegate;
        return (Nexus)lazy.getValue();
    }

    @Nullable
    public final String getStagingRepositoryId() {
        return this.stagingRepositoryId;
    }

    public final void setStagingRepositoryId(@Nullable String value) {
        if (this.stagingRepositoryId != null) {
            throw new IllegalStateException("stagingRepositoryId was already set");
        }
        this.stagingRepositoryId = value;
    }

    public final boolean getRepositoryClosed() {
        return this.repositoryClosed;
    }

    public final void setRepositoryClosed(boolean bl) {
        this.repositoryClosed = bl;
    }

    public final boolean getRepositoryDropped() {
        return this.repositoryDropped;
    }

    public final void setRepositoryDropped(boolean bl) {
        this.repositoryDropped = bl;
    }

    public void onFinish(@NotNull FinishEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getResult() instanceof FailureResult) {
            this.buildIsSuccess = false;
        }
    }

    @Override
    public void close() {
        String stagingRepositoryId = this.stagingRepositoryId;
        if (stagingRepositoryId != null) {
            if (this.buildIsSuccess) {
                this.getNexus().closeStagingRepository(stagingRepositoryId);
                Object object = ((Params)this.getParameters()).getAutomaticRelease().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.automaticRelease.get()");
                if (((Boolean)object).booleanValue()) {
                    this.getNexus().releaseStagingRepository(stagingRepositoryId);
                }
            } else {
                try {
                    this.getNexus().dropStagingRepository(stagingRepositoryId);
                }
                catch (IOException e) {
                    this.logger.info("Failed to drop staging repository " + stagingRepositoryId, (Throwable)e);
                }
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$Companion;", "", "()V", "NAME", "", "registerSonatypeRepositoryBuildService", "Lorg/gradle/api/provider/Provider;", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService;", "Lorg/gradle/api/Project;", "sonatypeHost", "Lcom/vanniktech/maven/publish/SonatypeHost;", "repositoryUsername", "repositoryPassword", "automaticRelease", "", "plugin"})
    @SourceDebugExtension(value={"SMAP\nSonatypeRepositoryBuildService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SonatypeRepositoryBuildService.kt\ncom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$Companion\n+ 2 TaskInternalExtensions.kt\norg/gradle/configurationcache/extensions/TaskInternalExtensionsKt\n*L\n1#1,120:1\n32#2,9:121\n*S KotlinDebug\n*F\n+ 1 SonatypeRepositoryBuildService.kt\ncom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$Companion\n*L\n115#1:121,9\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Provider<SonatypeRepositoryBuildService> registerSonatypeRepositoryBuildService(@NotNull Project $this$registerSonatypeRepositoryBuildService, @NotNull Provider<SonatypeHost> sonatypeHost, @NotNull Provider<String> repositoryUsername, @NotNull Provider<String> repositoryPassword, boolean automaticRelease) {
            Intrinsics.checkNotNullParameter((Object)$this$registerSonatypeRepositoryBuildService, (String)"<this>");
            Intrinsics.checkNotNullParameter(sonatypeHost, (String)"sonatypeHost");
            Intrinsics.checkNotNullParameter(repositoryUsername, (String)"repositoryUsername");
            Intrinsics.checkNotNullParameter(repositoryPassword, (String)"repositoryPassword");
            Provider okhttpTimeout2 = $this$registerSonatypeRepositoryBuildService.getProject().getProviders().gradleProperty("SONATYPE_CONNECT_TIMEOUT_SECONDS").map(arg_0 -> Companion.registerSonatypeRepositoryBuildService$lambda$0(registerSonatypeRepositoryBuildService.okhttpTimeout.1.INSTANCE, arg_0)).orElse((Object)60L);
            Provider closeTimeout2 = $this$registerSonatypeRepositoryBuildService.getProject().getProviders().gradleProperty("SONATYPE_CLOSE_TIMEOUT_SECONDS").map(arg_0 -> Companion.registerSonatypeRepositoryBuildService$lambda$1(registerSonatypeRepositoryBuildService.closeTimeout.1.INSTANCE, arg_0)).orElse((Object)900L);
            Provider service2 = $this$registerSonatypeRepositoryBuildService.getGradle().getSharedServices().registerIfAbsent(SonatypeRepositoryBuildService.NAME, SonatypeRepositoryBuildService.class, arg_0 -> Companion.registerSonatypeRepositoryBuildService$lambda$2((Function1)new Function1<BuildServiceSpec<Params>, Unit>(sonatypeHost, repositoryUsername, repositoryPassword, automaticRelease, (Provider<Long>)okhttpTimeout2, (Provider<Long>)closeTimeout2){
                final /* synthetic */ Provider<SonatypeHost> $sonatypeHost;
                final /* synthetic */ Provider<String> $repositoryUsername;
                final /* synthetic */ Provider<String> $repositoryPassword;
                final /* synthetic */ boolean $automaticRelease;
                final /* synthetic */ Provider<Long> $okhttpTimeout;
                final /* synthetic */ Provider<Long> $closeTimeout;
                {
                    this.$sonatypeHost = $sonatypeHost;
                    this.$repositoryUsername = $repositoryUsername;
                    this.$repositoryPassword = $repositoryPassword;
                    this.$automaticRelease = $automaticRelease;
                    this.$okhttpTimeout = $okhttpTimeout;
                    this.$closeTimeout = $closeTimeout;
                    super(1);
                }

                public final void invoke(BuildServiceSpec<Params> it) {
                    it.getMaxParallelUsages().set((Object)1);
                    ((Params)it.getParameters()).getSonatypeHost().set(this.$sonatypeHost);
                    ((Params)it.getParameters()).getRepositoryUsername().set(this.$repositoryUsername);
                    ((Params)it.getParameters()).getRepositoryPassword().set(this.$repositoryPassword);
                    ((Params)it.getParameters()).getAutomaticRelease().set((Object)this.$automaticRelease);
                    ((Params)it.getParameters()).getOkhttpTimeoutSeconds().set(this.$okhttpTimeout);
                    ((Params)it.getParameters()).getCloseTimeoutSeconds().set(this.$closeTimeout);
                }
            }, arg_0));
            Project project = $this$registerSonatypeRepositoryBuildService.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            Project $this$serviceOf$iv = project;
            boolean $i$f$serviceOf = false;
            ServiceRegistry serviceRegistry = ((ProjectInternal)$this$serviceOf$iv).getServices();
            Intrinsics.checkNotNullExpressionValue((Object)serviceRegistry, (String)"this as ProjectInternal).services");
            ServiceRegistry $this$get$iv$iv = serviceRegistry;
            boolean $i$f$get = false;
            Object object = $this$get$iv$iv.get(BuildEventsListenerRegistry.class);
            Intrinsics.checkNotNull((Object)object);
            ((BuildEventsListenerRegistry)object).onTaskCompletion(service2);
            Intrinsics.checkNotNullExpressionValue((Object)service2, (String)"service");
            return service2;
        }

        private static final Long registerSonatypeRepositoryBuildService$lambda$0(Function1 $tmp0, Object in) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Long)$tmp0.invoke(in);
        }

        private static final Long registerSonatypeRepositoryBuildService$lambda$1(Function1 $tmp0, Object in) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Long)$tmp0.invoke(in);
        }

        private static final void registerSonatypeRepositoryBuildService$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0006R\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0006\u00a8\u0006\u0014"}, d2={"Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$Params;", "Lorg/gradle/api/services/BuildServiceParameters;", "automaticRelease", "Lorg/gradle/api/provider/Property;", "", "getAutomaticRelease", "()Lorg/gradle/api/provider/Property;", "closeTimeoutSeconds", "", "getCloseTimeoutSeconds", "okhttpTimeoutSeconds", "getOkhttpTimeoutSeconds", "repositoryPassword", "", "getRepositoryPassword", "repositoryUsername", "getRepositoryUsername", "sonatypeHost", "Lcom/vanniktech/maven/publish/SonatypeHost;", "getSonatypeHost", "plugin"})
    public static interface Params
    extends BuildServiceParameters {
        @NotNull
        public Property<SonatypeHost> getSonatypeHost();

        @NotNull
        public Property<String> getRepositoryUsername();

        @NotNull
        public Property<String> getRepositoryPassword();

        @NotNull
        public Property<Boolean> getAutomaticRelease();

        @NotNull
        public Property<Long> getOkhttpTimeoutSeconds();

        @NotNull
        public Property<Long> getCloseTimeoutSeconds();
    }
}

