/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish;

import com.vanniktech.maven.publish.AndroidSingleVariantLibrary;
import com.vanniktech.maven.publish.GradlePlugin;
import com.vanniktech.maven.publish.GradlePublishPlugin;
import com.vanniktech.maven.publish.JavaLibrary;
import com.vanniktech.maven.publish.JavaPlatform;
import com.vanniktech.maven.publish.JavadocJar;
import com.vanniktech.maven.publish.KotlinJs;
import com.vanniktech.maven.publish.KotlinJvm;
import com.vanniktech.maven.publish.KotlinMultiplatform;
import com.vanniktech.maven.publish.MavenPublishBaseExtension;
import com.vanniktech.maven.publish.Platform;
import com.vanniktech.maven.publish.ProjectExtensionsKt;
import com.vanniktech.maven.publish.SonatypeHost;
import com.vanniktech.maven.publish.VersionCatalog;
import com.vanniktech.maven.publish.sonatype.CloseAndReleaseSonatypeRepositoryTask;
import com.vanniktech.maven.publish.sonatype.CreateSonatypeRepositoryTask;
import com.vanniktech.maven.publish.sonatype.DropSonatypeRepositoryTask;
import com.vanniktech.maven.publish.sonatype.SonatypeRepositoryBuildService;
import com.vanniktech.maven.publish.tasks.WorkaroundSignatureType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.MavenPomDeveloper;
import org.gradle.api.publish.maven.MavenPomDeveloperSpec;
import org.gradle.api.publish.maven.MavenPomIssueManagement;
import org.gradle.api.publish.maven.MavenPomLicense;
import org.gradle.api.publish.maven.MavenPomLicenseSpec;
import org.gradle.api.publish.maven.MavenPomScm;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.tasks.AbstractPublishToMaven;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.MinimalJavadocOptions;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.plugins.signing.Sign;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.SigningPlugin;
import org.gradle.plugins.signing.type.SignatureType;
import org.gradle.plugins.signing.type.pgp.ArmoredSignatureType;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.gradle.DokkaTask;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\u0017\u001a\u00020\u0015H\u0007J,\u0010\u0018\u001a\u00020\u00152\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000eH\u0002J\u0010\u0010\u0005\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0007H\u0002J\u0018\u0010\u001c\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u001e0\u001dH\u0007J\b\u0010\u001f\u001a\u00020\u0015H\u0007J\u001c\u0010 \u001a\u00020\u00152\b\b\u0002\u0010!\u001a\u00020\u00112\b\b\u0002\u0010\"\u001a\u00020\u000eH\u0007J\u001a\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u00072\b\b\u0002\u0010\"\u001a\u00020\u000eH\u0007J\u0006\u0010#\u001a\u00020\u0015J\u0010\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u001c\u0010$\u001a\u00020\u0007*\u00020\u00072\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\t\u00a8\u0006'"}, d2={"Lcom/vanniktech/maven/publish/MavenPublishBaseExtension;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "groupId", "Lorg/gradle/api/provider/Property;", "", "getGroupId$plugin", "()Lorg/gradle/api/provider/Property;", "platform", "Lcom/vanniktech/maven/publish/Platform;", "getPlatform$plugin", "pomFromProperties", "", "signing", "sonatypeHost", "Lcom/vanniktech/maven/publish/SonatypeHost;", "version", "getVersion$plugin", "artifactId", "", "configure", "configureBasedOnAppliedPlugins", "coordinates", "defaultJavaDocOption", "Lcom/vanniktech/maven/publish/JavadocJar;", "plainJavadocSupported", "pom", "Lorg/gradle/api/Action;", "Lorg/gradle/api/publish/maven/MavenPom;", "pomFromGradleProperties", "publishToMavenCentral", "host", "automaticRelease", "signAllPublications", "forMultiplatform", "publication", "Lorg/gradle/api/publish/maven/MavenPublication;", "plugin"})
@SourceDebugExtension(value={"SMAP\nMavenPublishBaseExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenPublishBaseExtension.kt\ncom/vanniktech/maven/publish/MavenPublishBaseExtension\n+ 2 ProjectExtensions.kt\ncom/vanniktech/maven/publish/ProjectExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,432:1\n23#2:433\n20#2:434\n20#2:435\n20#2:437\n20#2:438\n1#3:436\n*S KotlinDebug\n*F\n+ 1 MavenPublishBaseExtension.kt\ncom/vanniktech/maven/publish/MavenPublishBaseExtension\n*L\n71#1:433\n140#1:434\n147#1:435\n155#1:437\n158#1:438\n*E\n"})
public abstract class MavenPublishBaseExtension {
    @NotNull
    private final Project project;
    @NotNull
    private final Property<SonatypeHost> sonatypeHost;
    @NotNull
    private final Property<Boolean> signing;
    @NotNull
    private final Property<String> groupId;
    @NotNull
    private final Property<String> version;
    @NotNull
    private final Property<Boolean> pomFromProperties;
    @NotNull
    private final Property<Platform> platform;

    public MavenPublishBaseExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Property property = this.project.getObjects().property(SonatypeHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(...)");
        this.sonatypeHost = property;
        Property property2 = this.project.getObjects().property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(...)");
        this.signing = property2;
        Property property3 = this.project.getObjects().property(String.class).convention(this.project.provider(() -> MavenPublishBaseExtension.groupId$lambda$0(this)));
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"convention(...)");
        this.groupId = property3;
        Property property4 = this.project.getObjects().property(String.class).convention(this.project.provider(() -> MavenPublishBaseExtension.version$lambda$1(this)));
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"convention(...)");
        this.version = property4;
        Property property5 = this.project.getObjects().property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"property(...)");
        this.pomFromProperties = property5;
        Property property6 = this.project.getObjects().property(Platform.class);
        Intrinsics.checkNotNullExpressionValue((Object)property6, (String)"property(...)");
        this.platform = property6;
    }

    @NotNull
    public final Property<String> getGroupId$plugin() {
        return this.groupId;
    }

    @NotNull
    public final Property<String> getVersion$plugin() {
        return this.version;
    }

    @NotNull
    public final Property<Platform> getPlatform$plugin() {
        return this.platform;
    }

    @JvmOverloads
    public final void publishToMavenCentral(@NotNull SonatypeHost host, boolean automaticRelease) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.sonatypeHost.set((Object)host);
        this.sonatypeHost.finalizeValue();
        Provider provider = (Provider)this.sonatypeHost;
        Provider provider2 = (Provider)this.groupId;
        Provider provider3 = this.version.map(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$2(publishToMavenCentral.buildService.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"map(...)");
        Provider provider4 = this.project.getProviders().gradleProperty("mavenCentralUsername");
        Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"gradleProperty(...)");
        Provider provider5 = this.project.getProviders().gradleProperty("mavenCentralPassword");
        Intrinsics.checkNotNullExpressionValue((Object)provider5, (String)"gradleProperty(...)");
        Provider<SonatypeRepositoryBuildService> buildService2 = SonatypeRepositoryBuildService.Companion.registerSonatypeRepositoryBuildService(this.project, (Provider<SonatypeHost>)provider, (Provider<String>)provider2, (Provider<Boolean>)provider3, (Provider<String>)provider4, (Provider<String>)provider5, automaticRelease);
        boolean configCacheEnabled = ProjectExtensionsKt.configurationCache(this.project);
        Project $this$gradlePublishing$iv = this.project;
        boolean $i$f$getGradlePublishing = false;
        Object object = $this$gradlePublishing$iv.getExtensions().getByType(PublishingExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(...)");
        ((PublishingExtension)object).getRepositories().maven(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$3((Function1)new Function1<MavenArtifactRepository, Unit>(buildService2, configCacheEnabled){
            final /* synthetic */ Provider<SonatypeRepositoryBuildService> $buildService;
            final /* synthetic */ boolean $configCacheEnabled;
            {
                this.$buildService = $buildService;
                this.$configCacheEnabled = $configCacheEnabled;
                super(1);
            }

            public final void invoke(MavenArtifactRepository repo) {
                repo.setName("mavenCentral");
                repo.setUrl((Object)this.$buildService.map(arg_0 -> publishToMavenCentral.1.invoke$lambda$0((Function1)new Function1<SonatypeRepositoryBuildService, String>(this.$configCacheEnabled){
                    final /* synthetic */ boolean $configCacheEnabled;
                    {
                        this.$configCacheEnabled = $configCacheEnabled;
                        super(1);
                    }

                    @NotNull
                    public final String invoke(SonatypeRepositoryBuildService it) {
                        return it.publishingUrl$plugin(this.$configCacheEnabled);
                    }
                }, arg_0)));
                repo.credentials(PasswordCredentials.class);
            }

            private static final String invoke$lambda$0(Function1 $tmp0, Object in) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (String)$tmp0.invoke(in);
            }
        }, arg_0));
        TaskContainer taskContainer = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskProvider<CreateSonatypeRepositoryTask> createRepository = CreateSonatypeRepositoryTask.Companion.registerCreateRepository(taskContainer, buildService2);
        this.project.getTasks().withType(PublishToMavenRepository.class).configureEach(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$4((Function1)new Function1<PublishToMavenRepository, Unit>(createRepository){
            final /* synthetic */ TaskProvider<CreateSonatypeRepositoryTask> $createRepository;
            {
                this.$createRepository = $createRepository;
                super(1);
            }

            public final void invoke(PublishToMavenRepository publishTask) {
                String string = publishTask.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (StringsKt.endsWith$default((String)string, (String)"ToMavenCentralRepository", (boolean)false, (int)2, null)) {
                    Object[] objectArray = new Object[]{this.$createRepository};
                    publishTask.dependsOn(objectArray);
                }
            }
        }, arg_0));
        TaskContainer taskContainer2 = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer2, (String)"getTasks(...)");
        TaskProvider<CloseAndReleaseSonatypeRepositoryTask> releaseRepository = CloseAndReleaseSonatypeRepositoryTask.Companion.registerReleaseRepository(taskContainer2, buildService2, createRepository);
        TaskContainer taskContainer3 = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer3, (String)"getTasks(...)");
        CloseAndReleaseSonatypeRepositoryTask.Companion.registerCloseAndReleaseRepository(taskContainer3, buildService2, createRepository);
        TaskContainer taskContainer4 = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer4, (String)"getTasks(...)");
        DropSonatypeRepositoryTask.Companion.registerDropRepository(taskContainer4, buildService2, createRepository);
        this.project.getTasks().register("publishToMavenCentral", arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$5((Function1)new Function1<Task, Unit>(this){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Task it) {
                it.setDescription("Publishes to a staging repository on Sonatype OSS");
                it.setGroup("release");
                Object[] objectArray = new Object[]{MavenPublishBaseExtension.access$getProject$p(this.this$0).getTasks().named("publishAllPublicationsToMavenCentralRepository")};
                it.dependsOn(objectArray);
            }
        }, arg_0));
        this.project.getTasks().register("publishAndReleaseToMavenCentral", arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$6((Function1)new Function1<Task, Unit>(this, releaseRepository){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            final /* synthetic */ TaskProvider<CloseAndReleaseSonatypeRepositoryTask> $releaseRepository;
            {
                this.this$0 = $receiver;
                this.$releaseRepository = $releaseRepository;
                super(1);
            }

            public final void invoke(Task it) {
                it.setDescription("Publishes to a staging repository on Sonatype OSS and releases it to MavenCentral");
                it.setGroup("release");
                Object[] objectArray = new Object[]{MavenPublishBaseExtension.access$getProject$p(this.this$0).getTasks().named("publishAllPublicationsToMavenCentralRepository")};
                it.dependsOn(objectArray);
                objectArray = new Object[]{this.$releaseRepository};
                it.dependsOn(objectArray);
            }
        }, arg_0));
    }

    public static /* synthetic */ void publishToMavenCentral$default(MavenPublishBaseExtension mavenPublishBaseExtension, SonatypeHost sonatypeHost, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishToMavenCentral");
        }
        if ((n & 1) != 0) {
            sonatypeHost = SonatypeHost.DEFAULT;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        mavenPublishBaseExtension.publishToMavenCentral(sonatypeHost, bl);
    }

    @JvmOverloads
    public final /* synthetic */ void publishToMavenCentral(String host, boolean automaticRelease) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.publishToMavenCentral(SonatypeHost.Companion.valueOf(host), automaticRelease);
    }

    public static /* synthetic */ void publishToMavenCentral$default(MavenPublishBaseExtension mavenPublishBaseExtension, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishToMavenCentral");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        mavenPublishBaseExtension.publishToMavenCentral(string, bl);
    }

    public final void signAllPublications() {
        this.signing.set((Object)true);
        this.signing.finalizeValue();
        this.project.getPlugins().apply(SigningPlugin.class);
        Project $this$gradleSigning$iv = this.project;
        boolean $i$f$getGradleSigning = false;
        Object object = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(...)");
        ((SigningExtension)object).setRequired((Object)this.version.map(arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$7(signAllPublications.1.INSTANCE, arg_0)));
        String inMemoryKey = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKey");
        if (inMemoryKey != null) {
            String inMemoryKeyId = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKeyId");
            String string = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKeyPassword");
            if (string == null) {
                string = "";
            }
            String inMemoryKeyPassword = string;
            Project $this$gradleSigning$iv2 = this.project;
            boolean $i$f$getGradleSigning2 = false;
            Object object2 = $this$gradleSigning$iv2.getExtensions().getByType(SigningExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getByType(...)");
            ((SigningExtension)object2).useInMemoryPgpKeys(inMemoryKeyId, inMemoryKey, inMemoryKeyPassword);
        }
        ProjectExtensionsKt.mavenPublications(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$8(this, arg_0)));
        this.project.getTasks().withType(AbstractPublishToMaven.class).configureEach(arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$9((Function1)new Function1<AbstractPublishToMaven, Unit>(this){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(AbstractPublishToMaven publishTask) {
                Object[] objectArray = new Object[]{MavenPublishBaseExtension.access$getProject$p(this.this$0).getTasks().withType(Sign.class)};
                publishTask.dependsOn(objectArray);
            }
        }, arg_0));
        this.project.getPlugins().withId("org.jetbrains.kotlin.multiplatform", arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$10((Function1)new Function1<Plugin<?>, Unit>(this){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                MavenPublishBaseExtension.access$getProject$p(this.this$0).getTasks().withType(Sign.class).configureEach(arg_0 -> signAllPublications.4.invoke$lambda$0((Function1)new Function1<Sign, Unit>(this.this$0){
                    final /* synthetic */ MavenPublishBaseExtension this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(Sign it) {
                        SignatureType signatureType = it.getSignatureType();
                        if (signatureType == null) {
                            signatureType = (SignatureType)new ArmoredSignatureType();
                        }
                        Provider provider = MavenPublishBaseExtension.access$getProject$p(this.this$0).getLayout().getBuildDirectory().dir("signatures/" + it.getName());
                        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"dir(...)");
                        it.setSignatureType((SignatureType)new WorkaroundSignatureType(signatureType, (Provider<Directory>)provider));
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0));
    }

    @Incubating
    public final void coordinates(@Nullable String groupId, @Nullable String artifactId2, @Nullable String version) {
        block2: {
            String it;
            String string;
            String string2 = groupId;
            if (string2 != null) {
                it = string = string2;
                boolean bl = false;
                this.groupId(it);
            }
            String string3 = artifactId2;
            if (string3 != null) {
                it = string = string3;
                boolean bl = false;
                this.artifactId(it);
            }
            String string4 = version;
            if (string4 == null) break block2;
            it = string = string4;
            boolean bl = false;
            this.version(it);
        }
    }

    public static /* synthetic */ void coordinates$default(MavenPublishBaseExtension mavenPublishBaseExtension, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: coordinates");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        mavenPublishBaseExtension.coordinates(string, string2, string3);
    }

    private final void groupId(String groupId) {
        this.groupId.set((Object)groupId);
        this.groupId.finalizeValueOnRead();
        ProjectExtensionsKt.mavenPublicationsWithoutPluginMarker(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.groupId$lambda$14(this, arg_0)));
    }

    private final void artifactId(String artifactId2) {
        ProjectExtensionsKt.mavenPublicationsWithoutPluginMarker(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.artifactId$lambda$16(this, artifactId2, arg_0)));
    }

    private final String forMultiplatform(String $this$forMultiplatform, MavenPublication publication, Project project) {
        String string;
        String projectName = project.getName();
        if (Intrinsics.areEqual((Object)publication.getArtifactId(), (Object)projectName)) {
            string = $this$forMultiplatform;
        } else {
            String string2 = publication.getArtifactId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getArtifactId(...)");
            if (StringsKt.startsWith$default((String)string2, (String)(projectName + "-"), (boolean)false, (int)2, null)) {
                String string3 = publication.getArtifactId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getArtifactId(...)");
                string = StringsKt.replace$default((String)string3, (String)(projectName + "-"), (String)($this$forMultiplatform + "-"), (boolean)false, (int)4, null);
            } else {
                throw new IllegalStateException("The plugin can't handle the publication " + publication.getName() + " artifactId " + publication.getArtifactId() + " in project " + projectName);
            }
        }
        return string;
    }

    private final void version(String version) {
        this.version.set((Object)version);
        this.version.finalizeValueOnRead();
        ProjectExtensionsKt.mavenPublications(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.version$lambda$17(this, arg_0)));
    }

    @Incubating
    public final void pom(@NotNull Action<? super MavenPom> configure2) {
        Intrinsics.checkNotNullParameter(configure2, (String)"configure");
        ProjectExtensionsKt.mavenPublications(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.pom$lambda$19(this, configure2, arg_0)));
    }

    @Incubating
    public final void pomFromGradleProperties() {
        String version;
        String artifactId2;
        this.pomFromProperties.set((Object)true);
        this.pomFromProperties.finalizeValue();
        String groupId = ProjectExtensionsKt.findOptionalProperty(this.project, "GROUP");
        if (groupId != null) {
            this.groupId(groupId);
        }
        if ((artifactId2 = ProjectExtensionsKt.findOptionalProperty(this.project, "POM_ARTIFACT_ID")) != null) {
            this.artifactId(artifactId2);
        }
        if ((version = ProjectExtensionsKt.findOptionalProperty(this.project, "VERSION_NAME")) != null) {
            this.version(version);
        }
        this.pom((Action<? super MavenPom>)((Action)arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$20((Function1)new Function1<MavenPom, Unit>(this){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(MavenPom pom2) {
                String inceptionYear;
                String url;
                String description;
                String name = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_NAME");
                if (name != null) {
                    pom2.getName().set((Object)name);
                }
                if ((description = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_DESCRIPTION")) != null) {
                    pom2.getDescription().set((Object)description);
                }
                if ((url = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_URL")) != null) {
                    pom2.getUrl().set((Object)url);
                }
                if ((inceptionYear = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_INCEPTION_YEAR")) != null) {
                    pom2.getInceptionYear().set((Object)inceptionYear);
                }
                String issueManagementSystem = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_ISSUE_SYSTEM");
                String issueManagementUrl = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_ISSUE_URL");
                if (issueManagementSystem != null || issueManagementUrl != null) {
                    pom2.issueManagement(arg_0 -> pomFromGradleProperties.1.invoke$lambda$0((Function1)new Function1<MavenPomIssueManagement, Unit>(issueManagementSystem, issueManagementUrl){
                        final /* synthetic */ String $issueManagementSystem;
                        final /* synthetic */ String $issueManagementUrl;
                        {
                            this.$issueManagementSystem = $issueManagementSystem;
                            this.$issueManagementUrl = $issueManagementUrl;
                            super(1);
                        }

                        public final void invoke(MavenPomIssueManagement it) {
                            it.getSystem().set((Object)this.$issueManagementSystem);
                            it.getUrl().set((Object)this.$issueManagementUrl);
                        }
                    }, arg_0));
                }
                String scmUrl = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_SCM_URL");
                String scmConnection = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_SCM_CONNECTION");
                String scmDeveloperConnection = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_SCM_DEV_CONNECTION");
                if (scmUrl != null || scmConnection != null || scmDeveloperConnection != null) {
                    pom2.scm(arg_0 -> pomFromGradleProperties.1.invoke$lambda$1((Function1)new Function1<MavenPomScm, Unit>(scmUrl, scmConnection, scmDeveloperConnection){
                        final /* synthetic */ String $scmUrl;
                        final /* synthetic */ String $scmConnection;
                        final /* synthetic */ String $scmDeveloperConnection;
                        {
                            this.$scmUrl = $scmUrl;
                            this.$scmConnection = $scmConnection;
                            this.$scmDeveloperConnection = $scmDeveloperConnection;
                            super(1);
                        }

                        public final void invoke(MavenPomScm it) {
                            it.getUrl().set((Object)this.$scmUrl);
                            it.getConnection().set((Object)this.$scmConnection);
                            it.getDeveloperConnection().set((Object)this.$scmDeveloperConnection);
                        }
                    }, arg_0));
                }
                String licenceName = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_LICENCE_NAME");
                String licenceUrl = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_LICENCE_URL");
                String licenceDistribution = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_LICENCE_DIST");
                if (licenceName != null || licenceUrl != null || licenceDistribution != null) {
                    pom2.licenses(arg_0 -> pomFromGradleProperties.1.invoke$lambda$2((Function1)new Function1<MavenPomLicenseSpec, Unit>(licenceName, licenceUrl, licenceDistribution){
                        final /* synthetic */ String $licenceName;
                        final /* synthetic */ String $licenceUrl;
                        final /* synthetic */ String $licenceDistribution;
                        {
                            this.$licenceName = $licenceName;
                            this.$licenceUrl = $licenceUrl;
                            this.$licenceDistribution = $licenceDistribution;
                            super(1);
                        }

                        public final void invoke(MavenPomLicenseSpec licences) {
                            licences.license(arg_0 -> pomFromGradleProperties.3.invoke$lambda$0((Function1)new Function1<MavenPomLicense, Unit>(this.$licenceName, this.$licenceUrl, this.$licenceDistribution){
                                final /* synthetic */ String $licenceName;
                                final /* synthetic */ String $licenceUrl;
                                final /* synthetic */ String $licenceDistribution;
                                {
                                    this.$licenceName = $licenceName;
                                    this.$licenceUrl = $licenceUrl;
                                    this.$licenceDistribution = $licenceDistribution;
                                    super(1);
                                }

                                public final void invoke(MavenPomLicense it) {
                                    it.getName().set((Object)this.$licenceName);
                                    it.getUrl().set((Object)this.$licenceUrl);
                                    it.getDistribution().set((Object)this.$licenceDistribution);
                                }
                            }, arg_0));
                        }

                        private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            $tmp0.invoke(p0);
                        }
                    }, arg_0));
                }
                String licenseName = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_LICENSE_NAME");
                String licenseUrl = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_LICENSE_URL");
                String licenseDistribution = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_LICENSE_DIST");
                if (licenseName != null || licenseUrl != null || licenseDistribution != null) {
                    pom2.licenses(arg_0 -> pomFromGradleProperties.1.invoke$lambda$3((Function1)new Function1<MavenPomLicenseSpec, Unit>(licenseName, licenseUrl, licenseDistribution){
                        final /* synthetic */ String $licenseName;
                        final /* synthetic */ String $licenseUrl;
                        final /* synthetic */ String $licenseDistribution;
                        {
                            this.$licenseName = $licenseName;
                            this.$licenseUrl = $licenseUrl;
                            this.$licenseDistribution = $licenseDistribution;
                            super(1);
                        }

                        public final void invoke(MavenPomLicenseSpec licenses) {
                            licenses.license(arg_0 -> pomFromGradleProperties.4.invoke$lambda$0((Function1)new Function1<MavenPomLicense, Unit>(this.$licenseName, this.$licenseUrl, this.$licenseDistribution){
                                final /* synthetic */ String $licenseName;
                                final /* synthetic */ String $licenseUrl;
                                final /* synthetic */ String $licenseDistribution;
                                {
                                    this.$licenseName = $licenseName;
                                    this.$licenseUrl = $licenseUrl;
                                    this.$licenseDistribution = $licenseDistribution;
                                    super(1);
                                }

                                public final void invoke(MavenPomLicense it) {
                                    it.getName().set((Object)this.$licenseName);
                                    it.getUrl().set((Object)this.$licenseUrl);
                                    it.getDistribution().set((Object)this.$licenseDistribution);
                                }
                            }, arg_0));
                        }

                        private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            $tmp0.invoke(p0);
                        }
                    }, arg_0));
                }
                String developerId = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_DEVELOPER_ID");
                String developerName = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_DEVELOPER_NAME");
                String developerUrl = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_DEVELOPER_URL");
                String developerEmail = ProjectExtensionsKt.findOptionalProperty(MavenPublishBaseExtension.access$getProject$p(this.this$0), "POM_DEVELOPER_EMAIL");
                if (developerId != null || developerName != null || developerUrl != null) {
                    pom2.developers(arg_0 -> pomFromGradleProperties.1.invoke$lambda$4((Function1)new Function1<MavenPomDeveloperSpec, Unit>(developerId, developerName, developerUrl, developerEmail){
                        final /* synthetic */ String $developerId;
                        final /* synthetic */ String $developerName;
                        final /* synthetic */ String $developerUrl;
                        final /* synthetic */ String $developerEmail;
                        {
                            this.$developerId = $developerId;
                            this.$developerName = $developerName;
                            this.$developerUrl = $developerUrl;
                            this.$developerEmail = $developerEmail;
                            super(1);
                        }

                        public final void invoke(MavenPomDeveloperSpec developers) {
                            developers.developer(arg_0 -> pomFromGradleProperties.5.invoke$lambda$0((Function1)new Function1<MavenPomDeveloper, Unit>(this.$developerId, this.$developerName, this.$developerUrl, this.$developerEmail){
                                final /* synthetic */ String $developerId;
                                final /* synthetic */ String $developerName;
                                final /* synthetic */ String $developerUrl;
                                final /* synthetic */ String $developerEmail;
                                {
                                    this.$developerId = $developerId;
                                    this.$developerName = $developerName;
                                    this.$developerUrl = $developerUrl;
                                    this.$developerEmail = $developerEmail;
                                    super(1);
                                }

                                public final void invoke(MavenPomDeveloper it) {
                                    it.getId().set((Object)this.$developerId);
                                    it.getName().set((Object)this.$developerName);
                                    it.getUrl().set((Object)this.$developerUrl);
                                    it.getEmail().set((Object)this.$developerEmail);
                                }
                            }, arg_0));
                        }

                        private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            $tmp0.invoke(p0);
                        }
                    }, arg_0));
                }
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$2(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$3(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            private static final void invoke$lambda$4(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }
        }, arg_0)));
    }

    @Incubating
    public final void configure(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform.set((Object)platform);
        this.platform.finalizeValue();
        platform.configure$plugin(this.project);
    }

    @Incubating
    public final void configureBasedOnAppliedPlugins() {
        if (this.platform.isPresent()) {
            return;
        }
        if (this.project.getPlugins().hasPlugin("org.jetbrains.kotlin.multiplatform")) {
            this.configure(new KotlinMultiplatform(this.defaultJavaDocOption(false), false, 2, null));
        } else if (this.project.getPlugins().hasPlugin("com.android.library")) {
            String string = ProjectExtensionsKt.findOptionalProperty(this.project, "ANDROID_VARIANT_TO_PUBLISH");
            if (string == null) {
                string = "release";
            }
            String variant = string;
            this.configure(new AndroidSingleVariantLibrary(variant, false, false, 6, null));
        } else if (this.project.getPlugins().hasPlugin("com.gradle.plugin-publish")) {
            this.configure(new GradlePublishPlugin());
        } else if (this.project.getPlugins().hasPlugin("java-gradle-plugin")) {
            this.configure(new GradlePlugin(this.defaultJavaDocOption(true), false, 2, null));
        } else if (this.project.getPlugins().hasPlugin("org.jetbrains.kotlin.jvm")) {
            this.configure(new KotlinJvm(this.defaultJavaDocOption(true), false, 2, null));
        } else if (this.project.getPlugins().hasPlugin("org.jetbrains.kotlin.js")) {
            this.configure(new KotlinJs(this.defaultJavaDocOption(false)));
        } else if (this.project.getPlugins().hasPlugin("java-library")) {
            this.configure(new JavaLibrary(this.defaultJavaDocOption(true), false, 2, null));
        } else if (this.project.getPlugins().hasPlugin("java")) {
            this.configure(new JavaLibrary(this.defaultJavaDocOption(true), false, 2, null));
        } else if (this.project.getPlugins().hasPlugin("java-platform")) {
            this.configure(new JavaPlatform());
        } else if (this.project.getPlugins().hasPlugin("version-catalog")) {
            this.configure(new VersionCatalog());
        } else {
            this.project.getLogger().warn("No compatible plugin found in project " + this.project.getPath() + " for publishing");
        }
    }

    private final JavadocJar defaultJavaDocOption(boolean plainJavadocSupported) {
        JavadocJar javadocJar;
        if (this.project.getPlugins().hasPlugin("org.jetbrains.dokka") || this.project.getPlugins().hasPlugin("org.jetbrains.dokka-android")) {
            Provider dokkaTask = this.project.provider(() -> MavenPublishBaseExtension.defaultJavaDocOption$lambda$21(this));
            Intrinsics.checkNotNull((Object)dokkaTask);
            javadocJar = new JavadocJar.Dokka((Provider<String>)dokkaTask);
        } else {
            if (plainJavadocSupported) {
                this.project.getTasks().withType(Javadoc.class).configureEach(arg_0 -> MavenPublishBaseExtension.defaultJavaDocOption$lambda$22((Function1)new Function1<Javadoc, Unit>(this){
                    final /* synthetic */ MavenPublishBaseExtension this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(Javadoc it) {
                        MinimalJavadocOptions minimalJavadocOptions = it.getOptions();
                        Intrinsics.checkNotNull((Object)minimalJavadocOptions, (String)"null cannot be cast to non-null type org.gradle.external.javadoc.StandardJavadocDocletOptions");
                        StandardJavadocDocletOptions options = (StandardJavadocDocletOptions)minimalJavadocOptions;
                        JavaVersion javaVersion = ProjectExtensionsKt.javaVersion(MavenPublishBaseExtension.access$getProject$p(this.this$0));
                        if (javaVersion.isJava9Compatible()) {
                            options.addBooleanOption("html5", true);
                        }
                        if (javaVersion.isJava8Compatible()) {
                            options.addStringOption("Xdoclint:none", "-quiet");
                        }
                    }
                }, arg_0));
                return new JavadocJar.Javadoc();
            }
            javadocJar = new JavadocJar.Empty();
        }
        return javadocJar;
    }

    @JvmOverloads
    public final void publishToMavenCentral(@NotNull SonatypeHost host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        MavenPublishBaseExtension.publishToMavenCentral$default(this, host, false, 2, null);
    }

    @JvmOverloads
    public final void publishToMavenCentral() {
        MavenPublishBaseExtension.publishToMavenCentral$default(this, null, false, 3, null);
    }

    @JvmOverloads
    public final /* synthetic */ void publishToMavenCentral(String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        MavenPublishBaseExtension.publishToMavenCentral$default(this, host, false, 2, null);
    }

    private static final String groupId$lambda$0(MavenPublishBaseExtension this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.project.getGroup().toString();
    }

    private static final String version$lambda$1(MavenPublishBaseExtension this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.project.getVersion().toString();
    }

    private static final Boolean publishToMavenCentral$lambda$2(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(in);
    }

    private static final void publishToMavenCentral$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void publishToMavenCentral$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void publishToMavenCentral$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void publishToMavenCentral$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Boolean signAllPublications$lambda$7(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(in);
    }

    private static final void signAllPublications$lambda$8(MavenPublishBaseExtension this$0, MavenPublication publication) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"8.0-rc-1")) < 0) {
            TaskContainer taskContainer = this$0.project.getTasks();
            String string = publication.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Task task2 = (Task)taskContainer.findByName("sign" + StringsKt.capitalize((String)string) + "Publication");
            if (task2 == null) {
                Publication[] $this$gradleSigning$iv = this$0.project;
                boolean $i$f$getGradleSigning = false;
                Object object = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(...)");
                $this$gradleSigning$iv = new Publication[]{publication};
                ((SigningExtension)object).sign($this$gradleSigning$iv);
            }
        } else {
            Project $this$gradleSigning$iv = this$0.project;
            boolean $i$f$getGradleSigning = false;
            Object object = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(...)");
            Publication[] publicationArray = new Publication[]{publication};
            ((SigningExtension)object).sign(publicationArray);
        }
    }

    private static final void signAllPublications$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void signAllPublications$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void groupId$lambda$14(MavenPublishBaseExtension this$0, MavenPublication it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.setGroupId((String)this$0.groupId.get());
    }

    private static final void artifactId$lambda$16$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void artifactId$lambda$16(MavenPublishBaseExtension this$0, String $artifactId, MavenPublication it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$artifactId, (String)"$artifactId");
        if (this$0.project.getPlugins().hasPlugin("org.jetbrains.kotlin.multiplatform")) {
            this$0.project.afterEvaluate(arg_0 -> MavenPublishBaseExtension.artifactId$lambda$16$lambda$15((Function1)new Function1<Project, Unit>(it, this$0, $artifactId){
                final /* synthetic */ MavenPublication $it;
                final /* synthetic */ MavenPublishBaseExtension this$0;
                final /* synthetic */ String $artifactId;
                {
                    this.$it = $it;
                    this.this$0 = $receiver;
                    this.$artifactId = $artifactId;
                    super(1);
                }

                public final void invoke(Project project) {
                    MavenPublication mavenPublication = this.$it;
                    Intrinsics.checkNotNullExpressionValue((Object)mavenPublication, (String)"$it");
                    Intrinsics.checkNotNull((Object)project);
                    this.$it.setArtifactId(MavenPublishBaseExtension.access$forMultiplatform(this.this$0, this.$artifactId, mavenPublication, project));
                }
            }, arg_0));
        } else {
            it.setArtifactId($artifactId);
        }
    }

    private static final void version$lambda$17(MavenPublishBaseExtension this$0, MavenPublication it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.setVersion((String)this$0.version.get());
    }

    private static final void pom$lambda$19$lambda$18(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void pom$lambda$19(MavenPublishBaseExtension this$0, Action $configure, MavenPublication publication) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$configure, (String)"$configure");
        this$0.project.afterEvaluate(arg_0 -> MavenPublishBaseExtension.pom$lambda$19$lambda$18((Function1)new Function1<Project, Unit>(publication, (Action<? super MavenPom>)$configure){
            final /* synthetic */ MavenPublication $publication;
            final /* synthetic */ Action<? super MavenPom> $configure;
            {
                this.$publication = $publication;
                this.$configure = $configure;
                super(1);
            }

            public final void invoke(Project it) {
                this.$publication.pom(this.$configure);
            }
        }, arg_0));
    }

    private static final void pomFromGradleProperties$lambda$20(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final String defaultJavaDocOption$lambda$21(MavenPublishBaseExtension this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TaskCollection tasks = this$0.project.getTasks().withType(DokkaTask.class);
        Intrinsics.checkNotNull((Object)tasks);
        DokkaTask dokkaTask = (DokkaTask)CollectionsKt.singleOrNull((Iterable)((Iterable)tasks));
        String string = dokkaTask != null ? dokkaTask.getName() : null;
        if (string == null) {
            string = "dokkaHtml";
        }
        return string;
    }

    private static final void defaultJavaDocOption$lambda$22(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(MavenPublishBaseExtension $this) {
        return $this.project;
    }

    public static final /* synthetic */ String access$forMultiplatform(MavenPublishBaseExtension $this, String $receiver, MavenPublication publication, Project project) {
        return $this.forMultiplatform($receiver, publication, project);
    }
}

