/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish.sonatype;

import com.vanniktech.maven.publish.SonatypeHost;
import com.vanniktech.maven.publish.nexus.Nexus;
import com.vanniktech.maven.publish.sonatype.SonatypeRepositoryBuildService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\b \u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0003'()B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0019J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0015\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b J\u0016\u0010!\u001a\u00020\u00192\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0#H\u0002J\u0010\u0010$\u001a\u00020\u00192\b\u0010%\u001a\u0004\u0018\u00010\u0014J\u0010\u0010&\u001a\u00020\u00192\b\u0010%\u001a\u0004\u0018\u00010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0016\u0010\u0017\u00a8\u0006*"}, d2={"Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService;", "Lorg/gradle/api/services/BuildService;", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$Params;", "Ljava/lang/AutoCloseable;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "()V", "buildIsSuccess", "", "endOfBuildActions", "", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction;", "logger", "Lorg/gradle/api/logging/Logger;", "nexus", "Lcom/vanniktech/maven/publish/nexus/Nexus;", "getNexus", "()Lcom/vanniktech/maven/publish/nexus/Nexus;", "nexus$delegate", "Lkotlin/Lazy;", "value", "", "stagingRepositoryId", "setStagingRepositoryId", "(Ljava/lang/String;)V", "close", "", "createStagingRepository", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "publishingUrl", "configCacheEnabled", "publishingUrl$plugin", "runEndOfBuildActions", "actions", "", "shouldCloseAndReleaseRepository", "manualStagingRepositoryId", "shouldDropRepository", "Companion", "EndOfBuildAction", "Params", "plugin"})
@SourceDebugExtension(value={"SMAP\nSonatypeRepositoryBuildService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SonatypeRepositoryBuildService.kt\ncom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n766#2:233\n857#2,2:234\n766#2:236\n857#2,2:237\n800#2,11:239\n1726#2,3:250\n800#2,11:253\n*S KotlinDebug\n*F\n+ 1 SonatypeRepositoryBuildService.kt\ncom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService\n*L\n157#1:233\n157#1:234,2\n161#1:236\n161#1:237,2\n175#1:239,11\n179#1:250,3\n189#1:253,11\n*E\n"})
public abstract class SonatypeRepositoryBuildService
implements BuildService<Params>,
AutoCloseable,
OperationCompletionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy nexus$delegate;
    @Nullable
    private String stagingRepositoryId;
    @NotNull
    private final Set<EndOfBuildAction> endOfBuildActions;
    private boolean buildIsSuccess;
    @NotNull
    private static final String NAME = "sonatype-repository-build-service";

    public SonatypeRepositoryBuildService() {
        Logger logger = Logging.getLogger(SonatypeRepositoryBuildService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.nexus$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Nexus>(this){
            final /* synthetic */ SonatypeRepositoryBuildService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Nexus invoke() {
                String string = ((SonatypeHost)((Params)this.this$0.getParameters()).getSonatypeHost().get()).apiBaseUrl$plugin();
                Object object = ((Params)this.this$0.getParameters()).getRepositoryUsername().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                String string2 = (String)object;
                Object object2 = ((Params)this.this$0.getParameters()).getRepositoryPassword().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
                String string3 = (String)object2;
                Object object3 = ((Params)this.this$0.getParameters()).getOkhttpTimeoutSeconds().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
                long l = ((Number)object3).longValue();
                Object object4 = ((Params)this.this$0.getParameters()).getCloseTimeoutSeconds().get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
                return new Nexus(string, string2, string3, "com.vanniktech.maven.publish", "0.27.0", l, ((Number)object4).longValue());
            }
        }));
        this.endOfBuildActions = new LinkedHashSet();
        this.buildIsSuccess = true;
    }

    private final Nexus getNexus() {
        Lazy lazy = this.nexus$delegate;
        return (Nexus)lazy.getValue();
    }

    private final void setStagingRepositoryId(String value) {
        if (!(this.stagingRepositoryId == null || Intrinsics.areEqual((Object)this.stagingRepositoryId, (Object)value))) {
            boolean bl = false;
            String string = "stagingRepositoryId was already set to '" + this.stagingRepositoryId + "', new value '" + value + "'";
            throw new IllegalStateException(string.toString());
        }
        this.stagingRepositoryId = value;
    }

    public final void createStagingRepository() {
        Object object = ((Params)this.getParameters()).getVersionIsSnapshot().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (((Boolean)object).booleanValue()) {
            return;
        }
        if (this.stagingRepositoryId != null) {
            return;
        }
        Nexus nexus2 = this.getNexus();
        Object object2 = ((Params)this.getParameters()).getGroupId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
        this.setStagingRepositoryId(nexus2.createRepositoryForGroup((String)object2));
        ((Collection)this.endOfBuildActions).add(new EndOfBuildAction.Close(false));
        Object object3 = ((Params)this.getParameters()).getAutomaticRelease().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
        if (((Boolean)object3).booleanValue()) {
            ((Collection)this.endOfBuildActions).add(EndOfBuildAction.ReleaseAfterClose.INSTANCE);
        }
        ((Collection)this.endOfBuildActions).add(new EndOfBuildAction.Drop(true, false));
    }

    public final void shouldCloseAndReleaseRepository(@Nullable String manualStagingRepositoryId) {
        if (manualStagingRepositoryId != null) {
            this.setStagingRepositoryId(manualStagingRepositoryId);
        }
        ((Collection)this.endOfBuildActions).add(new EndOfBuildAction.Close(true));
        ((Collection)this.endOfBuildActions).add(EndOfBuildAction.ReleaseAfterClose.INSTANCE);
    }

    public final void shouldDropRepository(@Nullable String manualStagingRepositoryId) {
        if (manualStagingRepositoryId != null) {
            this.setStagingRepositoryId(manualStagingRepositoryId);
        }
        ((Collection)this.endOfBuildActions).add(new EndOfBuildAction.Drop(false, true));
    }

    @NotNull
    public final String publishingUrl$plugin(boolean configCacheEnabled) {
        String string;
        Object object = ((Params)this.getParameters()).getVersionIsSnapshot().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (((Boolean)object).booleanValue()) {
            if (!(this.stagingRepositoryId == null)) {
                boolean bl = false;
                String string2 = "Staging repositories are not supported for SNAPSHOT versions.";
                throw new IllegalArgumentException(string2.toString());
            }
            string = ((SonatypeHost)((Params)this.getParameters()).getSonatypeHost().get()).getRootUrl$plugin() + "/content/repositories/snapshots/";
        } else {
            String string3 = this.stagingRepositoryId;
            if (string3 == null) {
                boolean bl = false;
                String string4 = configCacheEnabled ? "Publishing releases to Maven Central is not supported yet with configuration caching enabled, because of this missing Gradle feature: https://github.com/gradle/gradle/issues/22779" : "The staging repository was not created yet. Please open a bug with a build scan or build logs and stacktrace";
                throw new IllegalArgumentException(string4.toString());
            }
            String stagingRepositoryId = string3;
            string = ((SonatypeHost)((Params)this.getParameters()).getSonatypeHost().get()).getRootUrl$plugin() + "/service/local/staging/deployByRepositoryId/" + stagingRepositoryId + "/";
        }
        return string;
    }

    public void onFinish(@NotNull FinishEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getResult() instanceof FailureResult) {
            this.buildIsSuccess = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        if (this.buildIsSuccess) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = this.endOfBuildActions;
            SonatypeRepositoryBuildService sonatypeRepositoryBuildService = this;
            boolean $i$f$filter = false;
            void var3_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                EndOfBuildAction it = (EndOfBuildAction)element$iv$iv;
                boolean bl = false;
                if (!(!it.getRunAfterFailure())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            sonatypeRepositoryBuildService.runEndOfBuildActions((List)destination$iv$iv);
        } else {
            try {
                Iterable $this$filter$iv = this.endOfBuildActions;
                SonatypeRepositoryBuildService sonatypeRepositoryBuildService = this;
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    EndOfBuildAction it = (EndOfBuildAction)element$iv$iv;
                    boolean bl = false;
                    if (!it.getRunAfterFailure()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                sonatypeRepositoryBuildService.runEndOfBuildActions((List)destination$iv$iv);
            }
            catch (IOException e) {
                if (this.buildIsSuccess) {
                    throw e;
                }
                this.logger.info("Failed processing " + this.stagingRepositoryId + " staging repository after previous build failure", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void runEndOfBuildActions(List<? extends EndOfBuildAction> actions) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable element$iv2;
        Iterator $this$filterIsInstanceTo$iv$iv2;
        String stagingRepositoryId = this.stagingRepositoryId;
        Iterable $this$filterIsInstance$iv = actions;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator = $this$filterIsInstanceTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof EndOfBuildAction.Close)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List closeActions = (List)destination$iv$iv;
        if (!((Collection)closeActions).isEmpty()) {
            if (stagingRepositoryId != null) {
                this.getNexus().closeStagingRepository(stagingRepositoryId);
            } else {
                boolean bl;
                block14: {
                    Iterable $this$all$iv = closeActions;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Iterable element$iv2 : $this$all$iv) {
                            EndOfBuildAction.Close it = (EndOfBuildAction.Close)((Object)element$iv2);
                            boolean bl2 = false;
                            if (it.getSearchForRepositoryIfNoIdPresent()) continue;
                            bl = false;
                            break block14;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    stagingRepositoryId = this.getNexus().closeCurrentStagingRepository();
                }
            }
            if (stagingRepositoryId != null && actions.contains(EndOfBuildAction.ReleaseAfterClose.INSTANCE)) {
                this.getNexus().releaseStagingRepository(stagingRepositoryId);
            }
        }
        Iterable $this$filterIsInstance$iv2 = actions;
        boolean $i$f$filterIsInstance2 = false;
        element$iv2 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof EndOfBuildAction.Drop)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        EndOfBuildAction.Drop dropAction = (EndOfBuildAction.Drop)CollectionsKt.singleOrNull((List)((List)destination$iv$iv2));
        if (dropAction != null) {
            if (stagingRepositoryId != null) {
                this.getNexus().dropStagingRepository(stagingRepositoryId);
            } else if (dropAction.getSearchForRepositoryIfNoIdPresent()) {
                this.getNexus().dropCurrentStagingRepository();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J^\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0010\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$Companion;", "", "()V", "NAME", "", "registerSonatypeRepositoryBuildService", "Lorg/gradle/api/provider/Provider;", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService;", "Lorg/gradle/api/Project;", "sonatypeHost", "Lcom/vanniktech/maven/publish/SonatypeHost;", "groupId", "versionIsSnapshot", "", "repositoryUsername", "repositoryPassword", "automaticRelease", "plugin"})
    @SourceDebugExtension(value={"SMAP\nSonatypeRepositoryBuildService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SonatypeRepositoryBuildService.kt\ncom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$Companion\n+ 2 TaskInternalExtensions.kt\norg/gradle/configurationcache/extensions/TaskInternalExtensionsKt\n*L\n1#1,232:1\n32#2,9:233\n*S KotlinDebug\n*F\n+ 1 SonatypeRepositoryBuildService.kt\ncom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$Companion\n*L\n227#1:233,9\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Provider<SonatypeRepositoryBuildService> registerSonatypeRepositoryBuildService(@NotNull Project $this$registerSonatypeRepositoryBuildService, @NotNull Provider<SonatypeHost> sonatypeHost, @NotNull Provider<String> groupId, @NotNull Provider<Boolean> versionIsSnapshot, @NotNull Provider<String> repositoryUsername, @NotNull Provider<String> repositoryPassword, boolean automaticRelease) {
            Intrinsics.checkNotNullParameter((Object)$this$registerSonatypeRepositoryBuildService, (String)"<this>");
            Intrinsics.checkNotNullParameter(sonatypeHost, (String)"sonatypeHost");
            Intrinsics.checkNotNullParameter(groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter(versionIsSnapshot, (String)"versionIsSnapshot");
            Intrinsics.checkNotNullParameter(repositoryUsername, (String)"repositoryUsername");
            Intrinsics.checkNotNullParameter(repositoryPassword, (String)"repositoryPassword");
            Provider okhttpTimeout2 = $this$registerSonatypeRepositoryBuildService.getProject().getProviders().gradleProperty("SONATYPE_CONNECT_TIMEOUT_SECONDS").map(arg_0 -> Companion.registerSonatypeRepositoryBuildService$lambda$0(registerSonatypeRepositoryBuildService.okhttpTimeout.1.INSTANCE, arg_0)).orElse((Object)60L);
            Provider closeTimeout2 = $this$registerSonatypeRepositoryBuildService.getProject().getProviders().gradleProperty("SONATYPE_CLOSE_TIMEOUT_SECONDS").map(arg_0 -> Companion.registerSonatypeRepositoryBuildService$lambda$1(registerSonatypeRepositoryBuildService.closeTimeout.1.INSTANCE, arg_0)).orElse((Object)900L);
            Provider service2 = $this$registerSonatypeRepositoryBuildService.getGradle().getSharedServices().registerIfAbsent(SonatypeRepositoryBuildService.NAME, SonatypeRepositoryBuildService.class, arg_0 -> Companion.registerSonatypeRepositoryBuildService$lambda$2((Function1)new Function1<BuildServiceSpec<Params>, Unit>(sonatypeHost, groupId, versionIsSnapshot, repositoryUsername, repositoryPassword, automaticRelease, (Provider<Long>)okhttpTimeout2, (Provider<Long>)closeTimeout2){
                final /* synthetic */ Provider<SonatypeHost> $sonatypeHost;
                final /* synthetic */ Provider<String> $groupId;
                final /* synthetic */ Provider<Boolean> $versionIsSnapshot;
                final /* synthetic */ Provider<String> $repositoryUsername;
                final /* synthetic */ Provider<String> $repositoryPassword;
                final /* synthetic */ boolean $automaticRelease;
                final /* synthetic */ Provider<Long> $okhttpTimeout;
                final /* synthetic */ Provider<Long> $closeTimeout;
                {
                    this.$sonatypeHost = $sonatypeHost;
                    this.$groupId = $groupId;
                    this.$versionIsSnapshot = $versionIsSnapshot;
                    this.$repositoryUsername = $repositoryUsername;
                    this.$repositoryPassword = $repositoryPassword;
                    this.$automaticRelease = $automaticRelease;
                    this.$okhttpTimeout = $okhttpTimeout;
                    this.$closeTimeout = $closeTimeout;
                    super(1);
                }

                public final void invoke(BuildServiceSpec<Params> it) {
                    it.getMaxParallelUsages().set((Object)1);
                    ((Params)it.getParameters()).getSonatypeHost().set(this.$sonatypeHost);
                    ((Params)it.getParameters()).getGroupId().set(this.$groupId);
                    ((Params)it.getParameters()).getVersionIsSnapshot().set(this.$versionIsSnapshot);
                    ((Params)it.getParameters()).getRepositoryUsername().set(this.$repositoryUsername);
                    ((Params)it.getParameters()).getRepositoryPassword().set(this.$repositoryPassword);
                    ((Params)it.getParameters()).getAutomaticRelease().set((Object)this.$automaticRelease);
                    ((Params)it.getParameters()).getOkhttpTimeoutSeconds().set(this.$okhttpTimeout);
                    ((Params)it.getParameters()).getCloseTimeoutSeconds().set(this.$closeTimeout);
                }
            }, arg_0));
            Project project = $this$registerSonatypeRepositoryBuildService.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project $this$serviceOf$iv = project;
            boolean $i$f$serviceOf = false;
            ServiceRegistry serviceRegistry = ((ProjectInternal)$this$serviceOf$iv).getServices();
            Intrinsics.checkNotNullExpressionValue((Object)serviceRegistry, (String)"this as ProjectInternal).services");
            ServiceRegistry $this$get$iv$iv = serviceRegistry;
            boolean $i$f$get = false;
            Object object = $this$get$iv$iv.get(BuildEventsListenerRegistry.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this[T::class.java]");
            ((BuildEventsListenerRegistry)object).onTaskCompletion(service2);
            Intrinsics.checkNotNull((Object)service2);
            return service2;
        }

        private static final Long registerSonatypeRepositoryBuildService$lambda$0(Function1 $tmp0, Object in) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Long)$tmp0.invoke(in);
        }

        private static final Long registerSonatypeRepositoryBuildService$lambda$1(Function1 $tmp0, Object in) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Long)$tmp0.invoke(in);
        }

        private static final void registerSonatypeRepositoryBuildService$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0003\u0006\u0007\bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0003\t\n\u000b\u00a8\u0006\f"}, d2={"Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction;", "", "runAfterFailure", "", "getRunAfterFailure", "()Z", "Close", "Drop", "ReleaseAfterClose", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction$Close;", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction$Drop;", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction$ReleaseAfterClose;", "plugin"})
    private static interface EndOfBuildAction {
        public boolean getRunAfterFailure();

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction$Close;", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction;", "searchForRepositoryIfNoIdPresent", "", "(Z)V", "runAfterFailure", "getRunAfterFailure", "()Z", "getSearchForRepositoryIfNoIdPresent", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "plugin"})
        public static final class Close
        implements EndOfBuildAction {
            private final boolean searchForRepositoryIfNoIdPresent;
            private final boolean runAfterFailure;

            public Close(boolean searchForRepositoryIfNoIdPresent) {
                this.searchForRepositoryIfNoIdPresent = searchForRepositoryIfNoIdPresent;
            }

            public final boolean getSearchForRepositoryIfNoIdPresent() {
                return this.searchForRepositoryIfNoIdPresent;
            }

            @Override
            public boolean getRunAfterFailure() {
                return this.runAfterFailure;
            }

            public final boolean component1() {
                return this.searchForRepositoryIfNoIdPresent;
            }

            @NotNull
            public final Close copy(boolean searchForRepositoryIfNoIdPresent) {
                return new Close(searchForRepositoryIfNoIdPresent);
            }

            public static /* synthetic */ Close copy$default(Close close, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = close.searchForRepositoryIfNoIdPresent;
                }
                return close.copy(bl);
            }

            @NotNull
            public String toString() {
                return "Close(searchForRepositoryIfNoIdPresent=" + this.searchForRepositoryIfNoIdPresent + ")";
            }

            public int hashCode() {
                return Boolean.hashCode(this.searchForRepositoryIfNoIdPresent);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Close)) {
                    return false;
                }
                Close close = (Close)other;
                return this.searchForRepositoryIfNoIdPresent == close.searchForRepositoryIfNoIdPresent;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction$Drop;", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction;", "runAfterFailure", "", "searchForRepositoryIfNoIdPresent", "(ZZ)V", "getRunAfterFailure", "()Z", "getSearchForRepositoryIfNoIdPresent", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "plugin"})
        public static final class Drop
        implements EndOfBuildAction {
            private final boolean runAfterFailure;
            private final boolean searchForRepositoryIfNoIdPresent;

            public Drop(boolean runAfterFailure, boolean searchForRepositoryIfNoIdPresent) {
                this.runAfterFailure = runAfterFailure;
                this.searchForRepositoryIfNoIdPresent = searchForRepositoryIfNoIdPresent;
            }

            @Override
            public boolean getRunAfterFailure() {
                return this.runAfterFailure;
            }

            public final boolean getSearchForRepositoryIfNoIdPresent() {
                return this.searchForRepositoryIfNoIdPresent;
            }

            public final boolean component1() {
                return this.runAfterFailure;
            }

            public final boolean component2() {
                return this.searchForRepositoryIfNoIdPresent;
            }

            @NotNull
            public final Drop copy(boolean runAfterFailure, boolean searchForRepositoryIfNoIdPresent) {
                return new Drop(runAfterFailure, searchForRepositoryIfNoIdPresent);
            }

            public static /* synthetic */ Drop copy$default(Drop drop, boolean bl, boolean bl2, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = drop.runAfterFailure;
                }
                if ((n & 2) != 0) {
                    bl2 = drop.searchForRepositoryIfNoIdPresent;
                }
                return drop.copy(bl, bl2);
            }

            @NotNull
            public String toString() {
                return "Drop(runAfterFailure=" + this.runAfterFailure + ", searchForRepositoryIfNoIdPresent=" + this.searchForRepositoryIfNoIdPresent + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.runAfterFailure);
                result = result * 31 + Boolean.hashCode(this.searchForRepositoryIfNoIdPresent);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Drop)) {
                    return false;
                }
                Drop drop = (Drop)other;
                if (this.runAfterFailure != drop.runAfterFailure) {
                    return false;
                }
                return this.searchForRepositoryIfNoIdPresent == drop.searchForRepositoryIfNoIdPresent;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\tH\u00d6\u0003J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\f\u001a\u00020\rH\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction$ReleaseAfterClose;", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction;", "()V", "runAfterFailure", "", "getRunAfterFailure", "()Z", "equals", "other", "", "hashCode", "", "toString", "", "plugin"})
        public static final class ReleaseAfterClose
        implements EndOfBuildAction {
            @NotNull
            public static final ReleaseAfterClose INSTANCE = new ReleaseAfterClose();
            private static final boolean runAfterFailure;

            private ReleaseAfterClose() {
            }

            @Override
            public boolean getRunAfterFailure() {
                return runAfterFailure;
            }

            @NotNull
            public String toString() {
                return "ReleaseAfterClose";
            }

            public int hashCode() {
                return -429699274;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ReleaseAfterClose)) {
                    return false;
                }
                ReleaseAfterClose cfr_ignored_0 = (ReleaseAfterClose)other;
                return true;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b`\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0018\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0006R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$Params;", "Lorg/gradle/api/services/BuildServiceParameters;", "automaticRelease", "Lorg/gradle/api/provider/Property;", "", "getAutomaticRelease", "()Lorg/gradle/api/provider/Property;", "closeTimeoutSeconds", "", "getCloseTimeoutSeconds", "groupId", "", "getGroupId", "okhttpTimeoutSeconds", "getOkhttpTimeoutSeconds", "repositoryPassword", "getRepositoryPassword", "repositoryUsername", "getRepositoryUsername", "sonatypeHost", "Lcom/vanniktech/maven/publish/SonatypeHost;", "getSonatypeHost", "versionIsSnapshot", "getVersionIsSnapshot", "plugin"})
    public static interface Params
    extends BuildServiceParameters {
        @NotNull
        public Property<SonatypeHost> getSonatypeHost();

        @NotNull
        public Property<String> getGroupId();

        @NotNull
        public Property<Boolean> getVersionIsSnapshot();

        @NotNull
        public Property<String> getRepositoryUsername();

        @NotNull
        public Property<String> getRepositoryPassword();

        @NotNull
        public Property<Boolean> getAutomaticRelease();

        @NotNull
        public Property<Long> getOkhttpTimeoutSeconds();

        @NotNull
        public Property<Long> getCloseTimeoutSeconds();
    }
}

