/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish;

import com.vanniktech.maven.publish.AndroidSingleVariantLibrary;
import com.vanniktech.maven.publish.GradlePlugin;
import com.vanniktech.maven.publish.GradlePublishPlugin;
import com.vanniktech.maven.publish.JavaLibrary;
import com.vanniktech.maven.publish.JavaPlatform;
import com.vanniktech.maven.publish.JavadocJar;
import com.vanniktech.maven.publish.KotlinJvm;
import com.vanniktech.maven.publish.KotlinMultiplatform;
import com.vanniktech.maven.publish.Platform;
import com.vanniktech.maven.publish.ProjectExtensionsKt;
import com.vanniktech.maven.publish.SonatypeHost;
import com.vanniktech.maven.publish.VersionCatalog;
import com.vanniktech.maven.publish.sonatype.CreateSonatypeRepositoryTask;
import com.vanniktech.maven.publish.sonatype.DropSonatypeRepositoryTask;
import com.vanniktech.maven.publish.sonatype.ReleaseSonatypeRepositoryTask;
import com.vanniktech.maven.publish.sonatype.SonatypeRepositoryBuildService;
import com.vanniktech.maven.publish.tasks.WorkaroundSignatureType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.MavenPomDeveloper;
import org.gradle.api.publish.maven.MavenPomDeveloperSpec;
import org.gradle.api.publish.maven.MavenPomIssueManagement;
import org.gradle.api.publish.maven.MavenPomLicense;
import org.gradle.api.publish.maven.MavenPomLicenseSpec;
import org.gradle.api.publish.maven.MavenPomScm;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.external.javadoc.MinimalJavadocOptions;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.plugins.signing.Sign;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.SigningPlugin;
import org.gradle.plugins.signing.type.SignatureType;
import org.gradle.plugins.signing.type.pgp.ArmoredSignatureType;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.gradle.DokkaTask;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\b2\b\b\u0002\u0010\u0018\u001a\u00020\nH\u0007J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\f2\b\b\u0002\u0010\u0018\u001a\u00020\nH\u0007J\u0006\u0010\u0019\u001a\u00020\u0016J*\u0010\u001a\u001a\u00020\u00162\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\fJ\u0010\u0010\u000b\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\fH\u0002J\u001c\u0010\u001c\u001a\u00020\f*\u00020\f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0016\u0010\u001f\u001a\u00020\u00162\u000e\u0010 \u001a\n\u0012\u0006\b\u0000\u0012\u00020\"0!J\b\u0010#\u001a\u00020\u0016H\u0007J\u000e\u0010 \u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010$\u001a\u00020\u00162\b\b\u0002\u0010%\u001a\u00020\n2\b\b\u0002\u0010&\u001a\u00020\nH\u0007J\u0018\u0010'\u001a\u00020(2\u0006\u0010&\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006*"}, d2={"Lcom/vanniktech/maven/publish/MavenPublishBaseExtension;", "", "project", "Lorg/gradle/api/Project;", "<init>", "(Lorg/gradle/api/Project;)V", "sonatypeHost", "Lorg/gradle/api/provider/Property;", "Lcom/vanniktech/maven/publish/SonatypeHost;", "signing", "", "groupId", "", "getGroupId$plugin", "()Lorg/gradle/api/provider/Property;", "version", "getVersion$plugin", "pomFromProperties", "platform", "Lcom/vanniktech/maven/publish/Platform;", "getPlatform$plugin", "publishToMavenCentral", "", "host", "automaticRelease", "signAllPublications", "coordinates", "artifactId", "forMultiplatform", "publication", "Lorg/gradle/api/publish/maven/MavenPublication;", "pom", "configure", "Lorg/gradle/api/Action;", "Lorg/gradle/api/publish/maven/MavenPom;", "pomFromGradleProperties", "configureBasedOnAppliedPlugins", "sourcesJar", "javadocJar", "defaultJavaDocOption", "Lcom/vanniktech/maven/publish/JavadocJar;", "plainJavadocSupported", "plugin"})
@SourceDebugExtension(value={"SMAP\nMavenPublishBaseExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenPublishBaseExtension.kt\ncom/vanniktech/maven/publish/MavenPublishBaseExtension\n+ 2 ProjectExtensions.kt\ncom/vanniktech/maven/publish/ProjectExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,429:1\n23#2:430\n20#2:431\n20#2:432\n20#2:434\n1#3:433\n*S KotlinDebug\n*F\n+ 1 MavenPublishBaseExtension.kt\ncom/vanniktech/maven/publish/MavenPublishBaseExtension\n*L\n71#1:430\n141#1:431\n148#1:432\n152#1:434\n*E\n"})
public abstract class MavenPublishBaseExtension {
    @NotNull
    private final Project project;
    @NotNull
    private final Property<SonatypeHost> sonatypeHost;
    @NotNull
    private final Property<Boolean> signing;
    @NotNull
    private final Property<String> groupId;
    @NotNull
    private final Property<String> version;
    @NotNull
    private final Property<Boolean> pomFromProperties;
    @NotNull
    private final Property<Platform> platform;

    public MavenPublishBaseExtension(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Property property = this.project.getObjects().property(SonatypeHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(...)");
        this.sonatypeHost = property;
        Property property2 = this.project.getObjects().property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(...)");
        this.signing = property2;
        Property property3 = this.project.getObjects().property(String.class).convention(this.project.provider(() -> MavenPublishBaseExtension.groupId$lambda$0(this)));
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"convention(...)");
        this.groupId = property3;
        Property property4 = this.project.getObjects().property(String.class).convention(this.project.provider(() -> MavenPublishBaseExtension.version$lambda$1(this)));
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"convention(...)");
        this.version = property4;
        Property property5 = this.project.getObjects().property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"property(...)");
        this.pomFromProperties = property5;
        Property property6 = this.project.getObjects().property(Platform.class);
        Intrinsics.checkNotNullExpressionValue((Object)property6, (String)"property(...)");
        this.platform = property6;
    }

    @NotNull
    public final Property<String> getGroupId$plugin() {
        return this.groupId;
    }

    @NotNull
    public final Property<String> getVersion$plugin() {
        return this.version;
    }

    @NotNull
    public final Property<Platform> getPlatform$plugin() {
        return this.platform;
    }

    @JvmOverloads
    public final void publishToMavenCentral(@NotNull SonatypeHost host, boolean automaticRelease) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.sonatypeHost.set((Object)host);
        this.sonatypeHost.finalizeValue();
        Provider provider = (Provider)this.sonatypeHost;
        Provider provider2 = (Provider)this.groupId;
        Provider provider3 = this.version.map(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$3(MavenPublishBaseExtension::publishToMavenCentral$lambda$2, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"map(...)");
        Provider provider4 = this.project.getProviders().gradleProperty("mavenCentralUsername");
        Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"gradleProperty(...)");
        Provider provider5 = this.project.getProviders().gradleProperty("mavenCentralPassword");
        Intrinsics.checkNotNullExpressionValue((Object)provider5, (String)"gradleProperty(...)");
        DirectoryProperty directoryProperty = this.project.getRootProject().getLayout().getBuildDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"getBuildDirectory(...)");
        Provider<SonatypeRepositoryBuildService> buildService = SonatypeRepositoryBuildService.Companion.registerSonatypeRepositoryBuildService(this.project, (Provider<SonatypeHost>)provider, (Provider<String>)provider2, (Provider<Boolean>)provider3, (Provider<String>)provider4, (Provider<String>)provider5, automaticRelease, (Provider<Directory>)((Provider)directoryProperty));
        boolean configCacheEnabled = ProjectExtensionsKt.configurationCache(this.project);
        Project $this$gradlePublishing$iv = this.project;
        boolean $i$f$getGradlePublishing = false;
        Object object = $this$gradlePublishing$iv.getExtensions().getByType(PublishingExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(...)");
        ((PublishingExtension)object).getRepositories().maven(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$7(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$6(buildService, host, configCacheEnabled, arg_0), arg_0));
        TaskContainer taskContainer = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskProvider<CreateSonatypeRepositoryTask> createRepository = CreateSonatypeRepositoryTask.Companion.registerCreateRepository(taskContainer, buildService);
        this.project.getTasks().withType(PublishToMavenRepository.class).configureEach(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$9(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$8(createRepository, arg_0), arg_0));
        TaskContainer taskContainer2 = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer2, (String)"getTasks(...)");
        TaskProvider<ReleaseSonatypeRepositoryTask> releaseRepository = ReleaseSonatypeRepositoryTask.Companion.registerReleaseRepository(taskContainer2, buildService, createRepository);
        TaskContainer taskContainer3 = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer3, (String)"getTasks(...)");
        DropSonatypeRepositoryTask.Companion.registerDropRepository(taskContainer3, buildService, createRepository);
        this.project.getTasks().register("publishToMavenCentral", arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$11(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$10(this, arg_0), arg_0));
        this.project.getTasks().register("publishAndReleaseToMavenCentral", arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$13(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$12(this, releaseRepository, arg_0), arg_0));
    }

    public static /* synthetic */ void publishToMavenCentral$default(MavenPublishBaseExtension mavenPublishBaseExtension, SonatypeHost sonatypeHost, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishToMavenCentral");
        }
        if ((n & 1) != 0) {
            sonatypeHost = SonatypeHost.DEFAULT;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        mavenPublishBaseExtension.publishToMavenCentral(sonatypeHost, bl);
    }

    @JvmOverloads
    public final /* synthetic */ void publishToMavenCentral(String host, boolean automaticRelease) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.publishToMavenCentral(SonatypeHost.Companion.valueOf(host), automaticRelease);
    }

    public static /* synthetic */ void publishToMavenCentral$default(MavenPublishBaseExtension mavenPublishBaseExtension, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishToMavenCentral");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        mavenPublishBaseExtension.publishToMavenCentral(string, bl);
    }

    public final void signAllPublications() {
        this.signing.set((Object)true);
        this.signing.finalizeValue();
        this.project.getPlugins().apply(SigningPlugin.class);
        Project $this$gradleSigning$iv = this.project;
        boolean $i$f$getGradleSigning = false;
        Object object = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(...)");
        ((SigningExtension)object).setRequired((Object)this.version.map(arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$15(MavenPublishBaseExtension::signAllPublications$lambda$14, arg_0)));
        String inMemoryKey = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKey");
        if (inMemoryKey != null) {
            String inMemoryKeyId = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKeyId");
            String string = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKeyPassword");
            if (string == null) {
                string = "";
            }
            String inMemoryKeyPassword = string;
            Project $this$gradleSigning$iv2 = this.project;
            boolean $i$f$getGradleSigning2 = false;
            Object object2 = $this$gradleSigning$iv2.getExtensions().getByType(SigningExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getByType(...)");
            ((SigningExtension)object2).useInMemoryPgpKeys(inMemoryKeyId, inMemoryKey, inMemoryKeyPassword);
        }
        ProjectExtensionsKt.mavenPublications(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$16(this, arg_0)));
        this.project.getPlugins().withId("org.jetbrains.kotlin.multiplatform", arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$20(arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$19(this, arg_0), arg_0));
    }

    public final void coordinates(@Nullable String groupId, @Nullable String artifactId, @Nullable String version) {
        block2: {
            String it;
            String string;
            String string2 = groupId;
            if (string2 != null) {
                it = string = string2;
                boolean bl = false;
                this.groupId(it);
            }
            String string3 = artifactId;
            if (string3 != null) {
                it = string = string3;
                boolean bl = false;
                this.artifactId(it);
            }
            String string4 = version;
            if (string4 == null) break block2;
            it = string = string4;
            boolean bl = false;
            this.version(it);
        }
    }

    public static /* synthetic */ void coordinates$default(MavenPublishBaseExtension mavenPublishBaseExtension, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: coordinates");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        mavenPublishBaseExtension.coordinates(string, string2, string3);
    }

    private final void groupId(String groupId) {
        this.groupId.set((Object)groupId);
        this.groupId.finalizeValueOnRead();
        ProjectExtensionsKt.mavenPublicationsWithoutPluginMarker(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.groupId$lambda$24(this, arg_0)));
    }

    private final void artifactId(String artifactId) {
        ProjectExtensionsKt.mavenPublicationsWithoutPluginMarker(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.artifactId$lambda$27(this, artifactId, arg_0)));
    }

    private final String forMultiplatform(String $this$forMultiplatform, MavenPublication publication, Project project) {
        String string;
        String projectName = project.getName();
        if (Intrinsics.areEqual((Object)publication.getArtifactId(), (Object)projectName)) {
            string = $this$forMultiplatform;
        } else {
            String string2 = publication.getArtifactId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getArtifactId(...)");
            if (StringsKt.startsWith$default((String)string2, (String)(projectName + "-"), (boolean)false, (int)2, null)) {
                String string3 = publication.getArtifactId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getArtifactId(...)");
                string = StringsKt.replace$default((String)string3, (String)(projectName + "-"), (String)($this$forMultiplatform + "-"), (boolean)false, (int)4, null);
            } else {
                throw new IllegalStateException("The plugin can't handle the publication " + publication.getName() + " artifactId " + publication.getArtifactId() + " in project " + projectName);
            }
        }
        return string;
    }

    private final void version(String version) {
        this.version.set((Object)version);
        this.version.finalizeValueOnRead();
        ProjectExtensionsKt.mavenPublications(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.version$lambda$28(this, arg_0)));
    }

    public final void pom(@NotNull Action<? super MavenPom> configure) {
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        ProjectExtensionsKt.mavenPublications(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.pom$lambda$31(configure, this, arg_0)));
    }

    @Incubating
    public final void pomFromGradleProperties() {
        String version;
        String artifactId;
        this.pomFromProperties.set((Object)true);
        this.pomFromProperties.finalizeValue();
        String groupId = ProjectExtensionsKt.findOptionalProperty(this.project, "GROUP");
        if (groupId != null) {
            this.groupId(groupId);
        }
        if ((artifactId = ProjectExtensionsKt.findOptionalProperty(this.project, "POM_ARTIFACT_ID")) != null) {
            this.artifactId(artifactId);
        }
        if ((version = ProjectExtensionsKt.findOptionalProperty(this.project, "VERSION_NAME")) != null) {
            this.version(version);
        }
        this.pom((Action<? super MavenPom>)((Action)arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$49(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$48(this, arg_0), arg_0)));
    }

    public final void configure(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform.set((Object)platform);
        this.platform.finalizeValue();
        platform.configure$plugin(this.project);
    }

    @Incubating
    @JvmOverloads
    public final void configureBasedOnAppliedPlugins(boolean sourcesJar, boolean javadocJar) {
        if (this.platform.isPresent()) {
            return;
        }
        if (this.project.getPlugins().hasPlugin("org.jetbrains.kotlin.multiplatform")) {
            String string = ProjectExtensionsKt.findOptionalProperty(this.project, "ANDROID_VARIANT_TO_PUBLISH");
            if (string == null) {
                string = "release";
            }
            String variant = string;
            this.configure(new KotlinMultiplatform(this.defaultJavaDocOption(javadocJar, false), sourcesJar, CollectionsKt.listOf((Object)variant), false));
        } else if (this.project.getPlugins().hasPlugin("com.android.library")) {
            String string = ProjectExtensionsKt.findOptionalProperty(this.project, "ANDROID_VARIANT_TO_PUBLISH");
            if (string == null) {
                string = "release";
            }
            String variant = string;
            this.configure(new AndroidSingleVariantLibrary(variant, sourcesJar, javadocJar));
        } else if (this.project.getPlugins().hasPlugin("com.gradle.plugin-publish")) {
            this.configure(new GradlePublishPlugin());
        } else if (this.project.getPlugins().hasPlugin("java-gradle-plugin")) {
            this.configure(new GradlePlugin(this.defaultJavaDocOption(javadocJar, true), sourcesJar));
        } else if (this.project.getPlugins().hasPlugin("org.jetbrains.kotlin.jvm")) {
            this.configure(new KotlinJvm(this.defaultJavaDocOption(javadocJar, true), sourcesJar));
        } else if (this.project.getPlugins().hasPlugin("java-library")) {
            this.configure(new JavaLibrary(this.defaultJavaDocOption(javadocJar, true), sourcesJar));
        } else if (this.project.getPlugins().hasPlugin("java")) {
            this.configure(new JavaLibrary(this.defaultJavaDocOption(javadocJar, true), sourcesJar));
        } else if (this.project.getPlugins().hasPlugin("java-platform")) {
            this.configure(new JavaPlatform());
        } else if (this.project.getPlugins().hasPlugin("version-catalog")) {
            this.configure(new VersionCatalog());
        } else {
            this.project.getLogger().warn("No compatible plugin found in project " + this.project.getPath() + " for publishing");
        }
    }

    public static /* synthetic */ void configureBasedOnAppliedPlugins$default(MavenPublishBaseExtension mavenPublishBaseExtension, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureBasedOnAppliedPlugins");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        mavenPublishBaseExtension.configureBasedOnAppliedPlugins(bl, bl2);
    }

    private final JavadocJar defaultJavaDocOption(boolean javadocJar, boolean plainJavadocSupported) {
        JavadocJar javadocJar2;
        if (!javadocJar) {
            javadocJar2 = new JavadocJar.None();
        } else if (this.project.getPlugins().hasPlugin("org.jetbrains.dokka") || this.project.getPlugins().hasPlugin("org.jetbrains.dokka-android")) {
            Provider dokkaTask = this.project.provider(() -> MavenPublishBaseExtension.defaultJavaDocOption$lambda$50(this));
            Intrinsics.checkNotNull((Object)dokkaTask);
            javadocJar2 = new JavadocJar.Dokka((Provider<String>)dokkaTask);
        } else {
            if (plainJavadocSupported) {
                this.project.getTasks().withType(Javadoc.class).configureEach(arg_0 -> MavenPublishBaseExtension.defaultJavaDocOption$lambda$52(arg_0 -> MavenPublishBaseExtension.defaultJavaDocOption$lambda$51(this, arg_0), arg_0));
                return new JavadocJar.Javadoc();
            }
            javadocJar2 = new JavadocJar.Empty();
        }
        return javadocJar2;
    }

    @JvmOverloads
    public final void publishToMavenCentral(@NotNull SonatypeHost host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        MavenPublishBaseExtension.publishToMavenCentral$default(this, host, false, 2, null);
    }

    @JvmOverloads
    public final void publishToMavenCentral() {
        MavenPublishBaseExtension.publishToMavenCentral$default(this, null, false, 3, null);
    }

    @JvmOverloads
    public final /* synthetic */ void publishToMavenCentral(String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        MavenPublishBaseExtension.publishToMavenCentral$default(this, host, false, 2, null);
    }

    @Incubating
    @JvmOverloads
    public final void configureBasedOnAppliedPlugins(boolean sourcesJar) {
        MavenPublishBaseExtension.configureBasedOnAppliedPlugins$default(this, sourcesJar, false, 2, null);
    }

    @Incubating
    @JvmOverloads
    public final void configureBasedOnAppliedPlugins() {
        MavenPublishBaseExtension.configureBasedOnAppliedPlugins$default(this, false, false, 3, null);
    }

    private static final String groupId$lambda$0(MavenPublishBaseExtension this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.project.getGroup().toString();
    }

    private static final String version$lambda$1(MavenPublishBaseExtension this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.project.getVersion().toString();
    }

    private static final Boolean publishToMavenCentral$lambda$2(String it) {
        Intrinsics.checkNotNull((Object)it);
        return StringsKt.endsWith$default((String)it, (String)"-SNAPSHOT", (boolean)false, (int)2, null);
    }

    private static final Boolean publishToMavenCentral$lambda$3(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(in);
    }

    private static final String publishToMavenCentral$lambda$6$lambda$4(boolean $configCacheEnabled, SonatypeRepositoryBuildService it) {
        return it.publishingUrl$plugin($configCacheEnabled);
    }

    private static final String publishToMavenCentral$lambda$6$lambda$5(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(in);
    }

    private static final Unit publishToMavenCentral$lambda$6(Provider $buildService, SonatypeHost $host, boolean $configCacheEnabled, MavenArtifactRepository repo) {
        Intrinsics.checkNotNullParameter((Object)$buildService, (String)"$buildService");
        Intrinsics.checkNotNullParameter((Object)$host, (String)"$host");
        repo.setName("mavenCentral");
        repo.setUrl((Object)$buildService.map(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$6$lambda$5(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$6$lambda$4($configCacheEnabled, arg_0), arg_0)));
        if (!$host.isCentralPortal$plugin()) {
            repo.credentials(PasswordCredentials.class);
        }
        return Unit.INSTANCE;
    }

    private static final void publishToMavenCentral$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit publishToMavenCentral$lambda$8(TaskProvider $createRepository, PublishToMavenRepository publishTask) {
        Intrinsics.checkNotNullParameter((Object)$createRepository, (String)"$createRepository");
        String string = publishTask.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string, (String)"ToMavenCentralRepository", (boolean)false, (int)2, null)) {
            Object[] objectArray = new Object[]{$createRepository};
            publishTask.dependsOn(objectArray);
        }
        return Unit.INSTANCE;
    }

    private static final void publishToMavenCentral$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit publishToMavenCentral$lambda$10(MavenPublishBaseExtension this$0, Task it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.setDescription("Publishes to a staging repository on Sonatype OSS");
        it.setGroup("release");
        Object[] objectArray = new Object[]{this$0.project.getTasks().named("publishAllPublicationsToMavenCentralRepository")};
        it.dependsOn(objectArray);
        return Unit.INSTANCE;
    }

    private static final void publishToMavenCentral$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit publishToMavenCentral$lambda$12(MavenPublishBaseExtension this$0, TaskProvider $releaseRepository, Task it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$releaseRepository, (String)"$releaseRepository");
        it.setDescription("Publishes to a staging repository on Sonatype OSS and releases it to MavenCentral");
        it.setGroup("release");
        Object[] objectArray = new Object[]{this$0.project.getTasks().named("publishAllPublicationsToMavenCentralRepository")};
        it.dependsOn(objectArray);
        objectArray = new Object[]{$releaseRepository};
        it.dependsOn(objectArray);
        return Unit.INSTANCE;
    }

    private static final void publishToMavenCentral$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Boolean signAllPublications$lambda$14(String it) {
        Intrinsics.checkNotNull((Object)it);
        return !StringsKt.endsWith$default((String)it, (String)"-SNAPSHOT", (boolean)false, (int)2, null);
    }

    private static final Boolean signAllPublications$lambda$15(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(in);
    }

    private static final void signAllPublications$lambda$16(MavenPublishBaseExtension this$0, MavenPublication publication) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Project $this$gradleSigning$iv = this$0.project;
        boolean $i$f$getGradleSigning = false;
        Object object = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(...)");
        Publication[] publicationArray = new Publication[]{publication};
        ((SigningExtension)object).sign(publicationArray);
    }

    private static final Unit signAllPublications$lambda$19$lambda$17(MavenPublishBaseExtension this$0, Sign it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SignatureType signatureType = it.getSignatureType();
        if (signatureType == null) {
            signatureType = (SignatureType)new ArmoredSignatureType();
        }
        Provider provider = this$0.project.getLayout().getBuildDirectory().dir("signatures/" + it.getName());
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"dir(...)");
        it.setSignatureType((SignatureType)new WorkaroundSignatureType(signatureType, (Provider<Directory>)provider));
        return Unit.INSTANCE;
    }

    private static final void signAllPublications$lambda$19$lambda$18(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit signAllPublications$lambda$19(MavenPublishBaseExtension this$0, Plugin it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.project.getTasks().withType(Sign.class).configureEach(arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$19$lambda$18(arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$19$lambda$17(this$0, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void signAllPublications$lambda$20(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void groupId$lambda$24(MavenPublishBaseExtension this$0, MavenPublication it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.setGroupId((String)this$0.groupId.get());
    }

    private static final Unit artifactId$lambda$27$lambda$25(MavenPublication $it, MavenPublishBaseExtension this$0, String $artifactId, Project project) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$artifactId, (String)"$artifactId");
        Intrinsics.checkNotNull((Object)$it);
        Intrinsics.checkNotNull((Object)project);
        $it.setArtifactId(this$0.forMultiplatform($artifactId, $it, project));
        return Unit.INSTANCE;
    }

    private static final void artifactId$lambda$27$lambda$26(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void artifactId$lambda$27(MavenPublishBaseExtension this$0, String $artifactId, MavenPublication it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$artifactId, (String)"$artifactId");
        if (this$0.project.getPlugins().hasPlugin("org.jetbrains.kotlin.multiplatform")) {
            this$0.project.afterEvaluate(arg_0 -> MavenPublishBaseExtension.artifactId$lambda$27$lambda$26(arg_0 -> MavenPublishBaseExtension.artifactId$lambda$27$lambda$25(it, this$0, $artifactId, arg_0), arg_0));
        } else {
            it.setArtifactId($artifactId);
        }
    }

    private static final void version$lambda$28(MavenPublishBaseExtension this$0, MavenPublication it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.setVersion((String)this$0.version.get());
    }

    private static final Unit pom$lambda$31$lambda$29(MavenPublication $publication, Action $configure, Project it) {
        Intrinsics.checkNotNullParameter((Object)$configure, (String)"$configure");
        $publication.pom($configure);
        return Unit.INSTANCE;
    }

    private static final void pom$lambda$31$lambda$30(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void pom$lambda$31(Action $configure, MavenPublishBaseExtension this$0, MavenPublication publication) {
        Intrinsics.checkNotNullParameter((Object)$configure, (String)"$configure");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"8.8-rc-1")) >= 0) {
            publication.pom($configure);
        } else {
            this$0.project.afterEvaluate(arg_0 -> MavenPublishBaseExtension.pom$lambda$31$lambda$30(arg_0 -> MavenPublishBaseExtension.pom$lambda$31$lambda$29(publication, $configure, arg_0), arg_0));
        }
    }

    private static final Unit pomFromGradleProperties$lambda$48$lambda$32(String $issueManagementSystem, String $issueManagementUrl, MavenPomIssueManagement it) {
        it.getSystem().set((Object)$issueManagementSystem);
        it.getUrl().set((Object)$issueManagementUrl);
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$48$lambda$33(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit pomFromGradleProperties$lambda$48$lambda$34(String $scmUrl, String $scmConnection, String $scmDeveloperConnection, MavenPomScm it) {
        it.getUrl().set((Object)$scmUrl);
        it.getConnection().set((Object)$scmConnection);
        it.getDeveloperConnection().set((Object)$scmDeveloperConnection);
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$48$lambda$35(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit pomFromGradleProperties$lambda$48$lambda$38$lambda$36(String $licenceName, String $licenceUrl, String $licenceDistribution, MavenPomLicense it) {
        it.getName().set((Object)$licenceName);
        it.getUrl().set((Object)$licenceUrl);
        it.getDistribution().set((Object)$licenceDistribution);
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$48$lambda$38$lambda$37(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit pomFromGradleProperties$lambda$48$lambda$38(String $licenceName, String $licenceUrl, String $licenceDistribution, MavenPomLicenseSpec licences) {
        licences.license(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$48$lambda$38$lambda$37(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$48$lambda$38$lambda$36($licenceName, $licenceUrl, $licenceDistribution, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$48$lambda$39(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit pomFromGradleProperties$lambda$48$lambda$42$lambda$40(String $licenseName, String $licenseUrl, String $licenseDistribution, MavenPomLicense it) {
        it.getName().set((Object)$licenseName);
        it.getUrl().set((Object)$licenseUrl);
        it.getDistribution().set((Object)$licenseDistribution);
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$48$lambda$42$lambda$41(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit pomFromGradleProperties$lambda$48$lambda$42(String $licenseName, String $licenseUrl, String $licenseDistribution, MavenPomLicenseSpec licenses) {
        licenses.license(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$48$lambda$42$lambda$41(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$48$lambda$42$lambda$40($licenseName, $licenseUrl, $licenseDistribution, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$48$lambda$43(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit pomFromGradleProperties$lambda$48$lambda$46$lambda$44(String $developerId, String $developerName, String $developerUrl, String $developerEmail, MavenPomDeveloper it) {
        it.getId().set((Object)$developerId);
        it.getName().set((Object)$developerName);
        it.getUrl().set((Object)$developerUrl);
        it.getEmail().set((Object)$developerEmail);
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$48$lambda$46$lambda$45(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit pomFromGradleProperties$lambda$48$lambda$46(String $developerId, String $developerName, String $developerUrl, String $developerEmail, MavenPomDeveloperSpec developers) {
        developers.developer(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$48$lambda$46$lambda$45(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$48$lambda$46$lambda$44($developerId, $developerName, $developerUrl, $developerEmail, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$48$lambda$47(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final Unit pomFromGradleProperties$lambda$48(MavenPublishBaseExtension this$0, MavenPom pom) {
        String inceptionYear;
        String url;
        String description;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String name = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_NAME");
        if (name != null) {
            pom.getName().set((Object)name);
        }
        if ((description = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_DESCRIPTION")) != null) {
            pom.getDescription().set((Object)description);
        }
        if ((url = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_URL")) != null) {
            pom.getUrl().set((Object)url);
        }
        if ((inceptionYear = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_INCEPTION_YEAR")) != null) {
            pom.getInceptionYear().set((Object)inceptionYear);
        }
        String issueManagementSystem = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_ISSUE_SYSTEM");
        String issueManagementUrl = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_ISSUE_URL");
        if (issueManagementSystem != null || issueManagementUrl != null) {
            pom.issueManagement(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$48$lambda$33(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$48$lambda$32(issueManagementSystem, issueManagementUrl, arg_0), arg_0));
        }
        String scmUrl = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_SCM_URL");
        String scmConnection = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_SCM_CONNECTION");
        String scmDeveloperConnection = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_SCM_DEV_CONNECTION");
        if (scmUrl != null || scmConnection != null || scmDeveloperConnection != null) {
            pom.scm(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$48$lambda$35(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$48$lambda$34(scmUrl, scmConnection, scmDeveloperConnection, arg_0), arg_0));
        }
        String licenceName = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENCE_NAME");
        String licenceUrl = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENCE_URL");
        String licenceDistribution = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENCE_DIST");
        if (licenceName != null || licenceUrl != null || licenceDistribution != null) {
            pom.licenses(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$48$lambda$39(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$48$lambda$38(licenceName, licenceUrl, licenceDistribution, arg_0), arg_0));
        }
        String licenseName = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENSE_NAME");
        String licenseUrl = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENSE_URL");
        String licenseDistribution = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENSE_DIST");
        if (licenseName != null || licenseUrl != null || licenseDistribution != null) {
            pom.licenses(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$48$lambda$43(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$48$lambda$42(licenseName, licenseUrl, licenseDistribution, arg_0), arg_0));
        }
        String developerId = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_DEVELOPER_ID");
        String developerName = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_DEVELOPER_NAME");
        String developerUrl = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_DEVELOPER_URL");
        String developerEmail = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_DEVELOPER_EMAIL");
        if (developerId != null || developerName != null || developerUrl != null) {
            pom.developers(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$48$lambda$47(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$48$lambda$46(developerId, developerName, developerUrl, developerEmail, arg_0), arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$49(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final String defaultJavaDocOption$lambda$50(MavenPublishBaseExtension this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        TaskCollection tasks = this$0.project.getTasks().withType(DokkaTask.class);
        Intrinsics.checkNotNull((Object)tasks);
        Object object = (DokkaTask)CollectionsKt.singleOrNull((Iterable)((Iterable)tasks));
        if (object == null || (object = object.getName()) == null) {
            object = "dokkaHtml";
        }
        return object;
    }

    private static final Unit defaultJavaDocOption$lambda$51(MavenPublishBaseExtension this$0, Javadoc it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        MinimalJavadocOptions minimalJavadocOptions = it.getOptions();
        Intrinsics.checkNotNull((Object)minimalJavadocOptions, (String)"null cannot be cast to non-null type org.gradle.external.javadoc.StandardJavadocDocletOptions");
        StandardJavadocDocletOptions options = (StandardJavadocDocletOptions)minimalJavadocOptions;
        JavaVersion javaVersion = ProjectExtensionsKt.javaVersion(this$0.project);
        if (javaVersion.isJava9Compatible()) {
            options.addBooleanOption("html5", true);
        }
        if (javaVersion.isJava8Compatible()) {
            options.addStringOption("Xdoclint:none", "-quiet");
        }
        return Unit.INSTANCE;
    }

    private static final void defaultJavaDocOption$lambda$52(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

