/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish;

import com.vanniktech.maven.publish.AndroidSingleVariantLibrary;
import com.vanniktech.maven.publish.GradlePlugin;
import com.vanniktech.maven.publish.GradlePublishPlugin;
import com.vanniktech.maven.publish.JavaLibrary;
import com.vanniktech.maven.publish.JavaPlatform;
import com.vanniktech.maven.publish.JavadocJar;
import com.vanniktech.maven.publish.KotlinJvm;
import com.vanniktech.maven.publish.KotlinMultiplatform;
import com.vanniktech.maven.publish.Platform;
import com.vanniktech.maven.publish.ProjectExtensionsKt;
import com.vanniktech.maven.publish.SonatypeHost;
import com.vanniktech.maven.publish.VersionCatalog;
import com.vanniktech.maven.publish.sonatype.CreateSonatypeRepositoryTask;
import com.vanniktech.maven.publish.sonatype.DropSonatypeRepositoryTask;
import com.vanniktech.maven.publish.sonatype.ReleaseSonatypeRepositoryTask;
import com.vanniktech.maven.publish.sonatype.SonatypeRepositoryBuildService;
import com.vanniktech.maven.publish.tasks.WorkaroundSignatureType;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.MavenPomDeveloper;
import org.gradle.api.publish.maven.MavenPomDeveloperSpec;
import org.gradle.api.publish.maven.MavenPomIssueManagement;
import org.gradle.api.publish.maven.MavenPomLicense;
import org.gradle.api.publish.maven.MavenPomLicenseSpec;
import org.gradle.api.publish.maven.MavenPomScm;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.gradle.external.javadoc.MinimalJavadocOptions;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.plugins.signing.Sign;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.SigningPlugin;
import org.gradle.plugins.signing.type.SignatureType;
import org.gradle.plugins.signing.type.pgp.ArmoredSignatureType;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.gradle.DokkaTask;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\n2\b\b\u0002\u0010\u0019\u001a\u00020\fH\u0007J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000e2\b\b\u0002\u0010\u0019\u001a\u00020\fH\u0007J\u0006\u0010\u001a\u001a\u00020\u0017J*\u0010\u001b\u001a\u00020\u00172\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\r\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u000eH\u0002J\u001c\u0010\u001d\u001a\u00020\u000e*\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u000eH\u0002J\u0016\u0010 \u001a\u00020\u00172\u000e\u0010!\u001a\n\u0012\u0006\b\u0000\u0012\u00020#0\"J\b\u0010$\u001a\u00020\u0017H\u0007J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\u001c\u0010%\u001a\u00020\u00172\b\b\u0002\u0010&\u001a\u00020\f2\b\b\u0002\u0010'\u001a\u00020\fH\u0007J\u0019\u0010(\u001a\u00020\u00172\u000e\b\u0004\u0010)\u001a\b\u0012\u0004\u0012\u00020\f0*H\u0082\bJ\u0018\u0010+\u001a\u00020,2\u0006\u0010'\u001a\u00020\f2\u0006\u0010-\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/vanniktech/maven/publish/MavenPublishBaseExtension;", "", "project", "Lorg/gradle/api/Project;", "buildEventsListenerRegistry", "Lorg/gradle/build/event/BuildEventsListenerRegistry;", "<init>", "(Lorg/gradle/api/Project;Lorg/gradle/build/event/BuildEventsListenerRegistry;)V", "sonatypeHost", "Lorg/gradle/api/provider/Property;", "Lcom/vanniktech/maven/publish/SonatypeHost;", "signing", "", "groupId", "", "getGroupId$plugin", "()Lorg/gradle/api/provider/Property;", "version", "getVersion$plugin", "pomFromProperties", "platform", "Lcom/vanniktech/maven/publish/Platform;", "publishToMavenCentral", "", "host", "automaticRelease", "signAllPublications", "coordinates", "artifactId", "forMultiplatform", "publication", "Lorg/gradle/api/publish/maven/MavenPublication;", "pom", "configure", "Lorg/gradle/api/Action;", "Lorg/gradle/api/publish/maven/MavenPom;", "pomFromGradleProperties", "configureBasedOnAppliedPlugins", "sourcesJar", "javadocJar", "configureCredentials", "versionIsSnapshot", "Lkotlin/Function0;", "defaultJavaDocOption", "Lcom/vanniktech/maven/publish/JavadocJar;", "plainJavadocSupported", "plugin"})
@SourceDebugExtension(value={"SMAP\nMavenPublishBaseExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenPublishBaseExtension.kt\ncom/vanniktech/maven/publish/MavenPublishBaseExtension\n+ 2 ProjectExtensions.kt\ncom/vanniktech/maven/publish/ProjectExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,451:1\n411#1:453\n416#1:455\n411#1:459\n416#1:461\n23#2:452\n23#2:454\n20#2:456\n20#2:457\n23#2:460\n23#2:462\n20#2:463\n1#3:458\n*S KotlinDebug\n*F\n+ 1 MavenPublishBaseExtension.kt\ncom/vanniktech/maven/publish/MavenPublishBaseExtension\n*L\n82#1:453\n82#1:455\n231#1:459\n231#1:461\n77#1:452\n82#1:454\n146#1:456\n153#1:457\n231#1:460\n411#1:462\n157#1:463\n*E\n"})
public abstract class MavenPublishBaseExtension {
    @NotNull
    private final Project project;
    @NotNull
    private final BuildEventsListenerRegistry buildEventsListenerRegistry;
    @NotNull
    private final Property<SonatypeHost> sonatypeHost;
    @NotNull
    private final Property<Boolean> signing;
    @NotNull
    private final Property<String> groupId;
    @NotNull
    private final Property<String> version;
    @NotNull
    private final Property<Boolean> pomFromProperties;
    @NotNull
    private final Property<Platform> platform;

    @Inject
    public MavenPublishBaseExtension(@NotNull Project project, @NotNull BuildEventsListenerRegistry buildEventsListenerRegistry) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildEventsListenerRegistry, (String)"buildEventsListenerRegistry");
        this.project = project;
        this.buildEventsListenerRegistry = buildEventsListenerRegistry;
        Property property = this.project.getObjects().property(SonatypeHost.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(...)");
        this.sonatypeHost = property;
        Property property2 = this.project.getObjects().property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(...)");
        this.signing = property2;
        Property property3 = this.project.getObjects().property(String.class).convention(this.project.provider(() -> MavenPublishBaseExtension.groupId$lambda$0(this)));
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"convention(...)");
        this.groupId = property3;
        Property property4 = this.project.getObjects().property(String.class).convention(this.project.provider(() -> MavenPublishBaseExtension.version$lambda$1(this)));
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"convention(...)");
        this.version = property4;
        Property property5 = this.project.getObjects().property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"property(...)");
        this.pomFromProperties = property5;
        Property property6 = this.project.getObjects().property(Platform.class);
        Intrinsics.checkNotNullExpressionValue((Object)property6, (String)"property(...)");
        this.platform = property6;
    }

    @NotNull
    public final Property<String> getGroupId$plugin() {
        return this.groupId;
    }

    @NotNull
    public final Property<String> getVersion$plugin() {
        return this.version;
    }

    @JvmOverloads
    public final void publishToMavenCentral(@NotNull SonatypeHost host, boolean automaticRelease) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.sonatypeHost.set((Object)host);
        this.sonatypeHost.finalizeValue();
        Provider versionIsSnapshot = this.version.map(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$3(MavenPublishBaseExtension::publishToMavenCentral$lambda$2, arg_0));
        Provider provider = (Provider)this.sonatypeHost;
        Provider provider2 = (Provider)this.groupId;
        Intrinsics.checkNotNull((Object)versionIsSnapshot);
        Provider provider3 = this.project.getProviders().gradleProperty("mavenCentralUsername");
        Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"gradleProperty(...)");
        Provider provider4 = this.project.getProviders().gradleProperty("mavenCentralPassword");
        Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"gradleProperty(...)");
        DirectoryProperty directoryProperty = this.project.getRootProject().getLayout().getBuildDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"getBuildDirectory(...)");
        Provider<SonatypeRepositoryBuildService> buildService = SonatypeRepositoryBuildService.Companion.registerSonatypeRepositoryBuildService(this.project, (Provider<SonatypeHost>)provider, (Provider<String>)provider2, (Provider<Boolean>)versionIsSnapshot, (Provider<String>)provider3, (Provider<String>)provider4, automaticRelease, (Provider<Directory>)((Provider)directoryProperty), this.buildEventsListenerRegistry);
        Project $this$gradlePublishing$iv = this.project;
        boolean $i$f$getGradlePublishing = false;
        Object object = $this$gradlePublishing$iv.getExtensions().getByType(PublishingExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(...)");
        ((PublishingExtension)object).getRepositories().maven(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$7(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$6(buildService, arg_0), arg_0));
        MavenPublishBaseExtension this_$iv = this;
        boolean $i$f$configureCredentials = false;
        Project $this$gradlePublishing$iv$iv = this_$iv.project;
        boolean $i$f$getGradlePublishing2 = false;
        Object object2 = $this$gradlePublishing$iv$iv.getExtensions().getByType(PublishingExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getByType(...)");
        Function1 function1 = (Function1)new Function1<MavenArtifactRepository, Unit>(this_$iv, versionIsSnapshot){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            final /* synthetic */ Provider $versionIsSnapshot$inlined;
            {
                this.this$0 = $receiver;
                this.$versionIsSnapshot$inlined = provider;
            }

            public final void invoke(MavenArtifactRepository repo) {
                block2: {
                    block3: {
                        if (!Intrinsics.areEqual((Object)repo.getName(), (Object)"mavenCentral")) break block2;
                        if (!((SonatypeHost)MavenPublishBaseExtension.access$getSonatypeHost$p(this.this$0).get()).isCentralPortal$plugin()) break block3;
                        boolean bl = false;
                        Object object = this.$versionIsSnapshot$inlined.get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        if (!((Boolean)object).booleanValue()) break block2;
                    }
                    repo.credentials(PasswordCredentials.class);
                }
            }
        };
        ((PublishingExtension)object2).getRepositories().withType(MavenArtifactRepository.class, new Action(function1){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        });
        TaskContainer taskContainer = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"getTasks(...)");
        TaskProvider<CreateSonatypeRepositoryTask> createRepository = CreateSonatypeRepositoryTask.Companion.registerCreateRepository(taskContainer, buildService);
        this.project.getTasks().withType(PublishToMavenRepository.class).configureEach(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$10(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$9(createRepository, arg_0), arg_0));
        TaskContainer taskContainer2 = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer2, (String)"getTasks(...)");
        TaskProvider<ReleaseSonatypeRepositoryTask> releaseRepository = ReleaseSonatypeRepositoryTask.Companion.registerReleaseRepository(taskContainer2, buildService, createRepository);
        TaskContainer taskContainer3 = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer3, (String)"getTasks(...)");
        DropSonatypeRepositoryTask.Companion.registerDropRepository(taskContainer3, buildService, createRepository);
        this.project.getTasks().register("publishToMavenCentral", arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$12(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$11(this, arg_0), arg_0));
        this.project.getTasks().register("publishAndReleaseToMavenCentral", arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$14(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$13(this, releaseRepository, arg_0), arg_0));
    }

    public static /* synthetic */ void publishToMavenCentral$default(MavenPublishBaseExtension mavenPublishBaseExtension, SonatypeHost sonatypeHost, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishToMavenCentral");
        }
        if ((n & 1) != 0) {
            sonatypeHost = SonatypeHost.DEFAULT;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        mavenPublishBaseExtension.publishToMavenCentral(sonatypeHost, bl);
    }

    @JvmOverloads
    public final /* synthetic */ void publishToMavenCentral(String host, boolean automaticRelease) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.publishToMavenCentral(SonatypeHost.Companion.valueOf(host), automaticRelease);
    }

    public static /* synthetic */ void publishToMavenCentral$default(MavenPublishBaseExtension mavenPublishBaseExtension, String string, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishToMavenCentral");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        mavenPublishBaseExtension.publishToMavenCentral(string, bl);
    }

    public final void signAllPublications() {
        this.signing.set((Object)true);
        this.signing.finalizeValue();
        this.project.getPlugins().apply(SigningPlugin.class);
        Project $this$gradleSigning$iv = this.project;
        boolean $i$f$getGradleSigning = false;
        Object object = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(...)");
        ((SigningExtension)object).setRequired((Object)this.version.map(arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$16(MavenPublishBaseExtension::signAllPublications$lambda$15, arg_0)));
        String inMemoryKey = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKey");
        if (inMemoryKey != null) {
            String inMemoryKeyId = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKeyId");
            String string = ProjectExtensionsKt.findOptionalProperty(this.project, "signingInMemoryKeyPassword");
            if (string == null) {
                string = "";
            }
            String inMemoryKeyPassword = string;
            Project $this$gradleSigning$iv2 = this.project;
            boolean $i$f$getGradleSigning2 = false;
            Object object2 = $this$gradleSigning$iv2.getExtensions().getByType(SigningExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getByType(...)");
            ((SigningExtension)object2).useInMemoryPgpKeys(inMemoryKeyId, inMemoryKey, inMemoryKeyPassword);
        }
        ProjectExtensionsKt.mavenPublications(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$17(this, arg_0)));
        this.project.getPlugins().withId("org.jetbrains.kotlin.multiplatform", arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$21(arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$20(this, arg_0), arg_0));
    }

    public final void coordinates(@Nullable String groupId, @Nullable String artifactId, @Nullable String version) {
        block2: {
            String it;
            String string;
            String string2 = groupId;
            if (string2 != null) {
                it = string = string2;
                boolean bl = false;
                this.groupId(it);
            }
            String string3 = artifactId;
            if (string3 != null) {
                it = string = string3;
                boolean bl = false;
                this.artifactId(it);
            }
            String string4 = version;
            if (string4 == null) break block2;
            it = string = string4;
            boolean bl = false;
            this.version(it);
        }
    }

    public static /* synthetic */ void coordinates$default(MavenPublishBaseExtension mavenPublishBaseExtension, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: coordinates");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        mavenPublishBaseExtension.coordinates(string, string2, string3);
    }

    private final void groupId(String groupId) {
        this.groupId.set((Object)groupId);
        this.groupId.finalizeValueOnRead();
        ProjectExtensionsKt.mavenPublicationsWithoutPluginMarker(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.groupId$lambda$25(this, arg_0)));
    }

    private final void artifactId(String artifactId) {
        ProjectExtensionsKt.mavenPublicationsWithoutPluginMarker(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.artifactId$lambda$28(this, artifactId, arg_0)));
    }

    private final String forMultiplatform(String $this$forMultiplatform, MavenPublication publication, Project project) {
        String string;
        String projectName = project.getName();
        if (Intrinsics.areEqual((Object)publication.getArtifactId(), (Object)projectName)) {
            string = $this$forMultiplatform;
        } else {
            String string2 = publication.getArtifactId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getArtifactId(...)");
            if (StringsKt.startsWith$default((String)string2, (String)(projectName + "-"), (boolean)false, (int)2, null)) {
                String string3 = publication.getArtifactId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getArtifactId(...)");
                string = StringsKt.replace$default((String)string3, (String)(projectName + "-"), (String)($this$forMultiplatform + "-"), (boolean)false, (int)4, null);
            } else {
                throw new IllegalStateException("The plugin can't handle the publication " + publication.getName() + " artifactId " + publication.getArtifactId() + " in project " + projectName);
            }
        }
        return string;
    }

    private final void version(String version) {
        this.version.set((Object)version);
        this.version.finalizeValueOnRead();
        ProjectExtensionsKt.mavenPublications(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.version$lambda$29(this, arg_0)));
        MavenPublishBaseExtension this_$iv = this;
        boolean $i$f$configureCredentials = false;
        Project $this$gradlePublishing$iv$iv = this_$iv.project;
        boolean $i$f$getGradlePublishing = false;
        Object object = $this$gradlePublishing$iv$iv.getExtensions().getByType(PublishingExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(...)");
        Function1 function1 = (Function1)new Function1<MavenArtifactRepository, Unit>(this_$iv, version){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            final /* synthetic */ String $version$inlined;
            {
                this.this$0 = $receiver;
                this.$version$inlined = string;
            }

            public final void invoke(MavenArtifactRepository repo) {
                block2: {
                    block3: {
                        if (!Intrinsics.areEqual((Object)repo.getName(), (Object)"mavenCentral")) break block2;
                        if (!((SonatypeHost)MavenPublishBaseExtension.access$getSonatypeHost$p(this.this$0).get()).isCentralPortal$plugin()) break block3;
                        boolean bl = false;
                        if (!StringsKt.endsWith$default((String)this.$version$inlined, (String)"-SNAPSHOT", (boolean)false, (int)2, null)) break block2;
                    }
                    repo.credentials(PasswordCredentials.class);
                }
            }
        };
        ((PublishingExtension)object).getRepositories().withType(MavenArtifactRepository.class, new /* invalid duplicate definition of identical inner class */);
    }

    public final void pom(@NotNull Action<? super MavenPom> configure) {
        Intrinsics.checkNotNullParameter(configure, (String)"configure");
        ProjectExtensionsKt.mavenPublications(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.pom$lambda$33(configure, this, arg_0)));
    }

    @Incubating
    public final void pomFromGradleProperties() {
        String version;
        String artifactId;
        this.pomFromProperties.set((Object)true);
        this.pomFromProperties.finalizeValue();
        String groupId = ProjectExtensionsKt.findOptionalProperty(this.project, "GROUP");
        if (groupId != null) {
            this.groupId(groupId);
        }
        if ((artifactId = ProjectExtensionsKt.findOptionalProperty(this.project, "POM_ARTIFACT_ID")) != null) {
            this.artifactId(artifactId);
        }
        if ((version = ProjectExtensionsKt.findOptionalProperty(this.project, "VERSION_NAME")) != null) {
            this.version(version);
        }
        this.pom((Action<? super MavenPom>)((Action)arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$51(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$50(this, arg_0), arg_0)));
    }

    public final void configure(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform.set((Object)platform);
        this.platform.finalizeValue();
        platform.configure$plugin(this.project);
    }

    @Incubating
    @JvmOverloads
    public final void configureBasedOnAppliedPlugins(boolean sourcesJar, boolean javadocJar) {
        if (this.platform.isPresent()) {
            return;
        }
        if (this.project.getPlugins().hasPlugin("org.jetbrains.kotlin.multiplatform")) {
            String string = ProjectExtensionsKt.findOptionalProperty(this.project, "ANDROID_VARIANT_TO_PUBLISH");
            if (string == null) {
                string = "release";
            }
            String variant = string;
            this.configure(new KotlinMultiplatform(this.defaultJavaDocOption(javadocJar, false), sourcesJar, CollectionsKt.listOf((Object)variant), false));
        } else if (this.project.getPlugins().hasPlugin("com.android.library")) {
            String string = ProjectExtensionsKt.findOptionalProperty(this.project, "ANDROID_VARIANT_TO_PUBLISH");
            if (string == null) {
                string = "release";
            }
            String variant = string;
            this.configure(new AndroidSingleVariantLibrary(variant, sourcesJar, javadocJar));
        } else if (this.project.getPlugins().hasPlugin("com.gradle.plugin-publish")) {
            this.configure(new GradlePublishPlugin());
        } else if (this.project.getPlugins().hasPlugin("java-gradle-plugin")) {
            this.configure(new GradlePlugin(this.defaultJavaDocOption(javadocJar, true), sourcesJar));
        } else if (this.project.getPlugins().hasPlugin("org.jetbrains.kotlin.jvm")) {
            this.configure(new KotlinJvm(this.defaultJavaDocOption(javadocJar, true), sourcesJar));
        } else if (this.project.getPlugins().hasPlugin("java-library")) {
            this.configure(new JavaLibrary(this.defaultJavaDocOption(javadocJar, true), sourcesJar));
        } else if (this.project.getPlugins().hasPlugin("java")) {
            this.configure(new JavaLibrary(this.defaultJavaDocOption(javadocJar, true), sourcesJar));
        } else if (this.project.getPlugins().hasPlugin("java-platform")) {
            this.configure(new JavaPlatform());
        } else if (this.project.getPlugins().hasPlugin("version-catalog")) {
            this.configure(new VersionCatalog());
        } else {
            this.project.getLogger().warn("No compatible plugin found in project " + this.project.getPath() + " for publishing");
        }
    }

    public static /* synthetic */ void configureBasedOnAppliedPlugins$default(MavenPublishBaseExtension mavenPublishBaseExtension, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureBasedOnAppliedPlugins");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        mavenPublishBaseExtension.configureBasedOnAppliedPlugins(bl, bl2);
    }

    private final void configureCredentials(Function0<Boolean> versionIsSnapshot) {
        boolean $i$f$configureCredentials = false;
        Project $this$gradlePublishing$iv = this.project;
        boolean $i$f$getGradlePublishing = false;
        Object object = $this$gradlePublishing$iv.getExtensions().getByType(PublishingExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(...)");
        Function1 function1 = (Function1)new Function1<MavenArtifactRepository, Unit>(this, versionIsSnapshot){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            final /* synthetic */ Function0<Boolean> $versionIsSnapshot;
            {
                this.this$0 = $receiver;
                this.$versionIsSnapshot = $versionIsSnapshot;
            }

            public final void invoke(MavenArtifactRepository repo) {
                if (Intrinsics.areEqual((Object)repo.getName(), (Object)"mavenCentral") && (!((SonatypeHost)MavenPublishBaseExtension.access$getSonatypeHost$p(this.this$0).get()).isCentralPortal$plugin() || ((Boolean)this.$versionIsSnapshot.invoke()).booleanValue())) {
                    repo.credentials(PasswordCredentials.class);
                }
            }
        };
        ((PublishingExtension)object).getRepositories().withType(MavenArtifactRepository.class, new /* invalid duplicate definition of identical inner class */);
    }

    private final JavadocJar defaultJavaDocOption(boolean javadocJar, boolean plainJavadocSupported) {
        JavadocJar javadocJar2;
        if (!javadocJar) {
            javadocJar2 = new JavadocJar.None();
        } else if (this.project.getPlugins().hasPlugin("org.jetbrains.dokka-javadoc")) {
            javadocJar2 = new JavadocJar.Dokka("dokkaGeneratePublicationJavadoc");
        } else if (this.project.getPlugins().hasPlugin("org.jetbrains.dokka")) {
            JavadocJar.Dokka dokka;
            if (this.project.getExtensions().findByName("dokka") != null) {
                dokka = new JavadocJar.Dokka("dokkaGeneratePublicationHtml");
            } else {
                Provider dokkaTask = this.project.provider(() -> MavenPublishBaseExtension.defaultJavaDocOption$lambda$52(this));
                Intrinsics.checkNotNull((Object)dokkaTask);
                dokka = new JavadocJar.Dokka((Provider<String>)dokkaTask);
            }
            javadocJar2 = dokka;
        } else {
            if (plainJavadocSupported) {
                this.project.getTasks().withType(Javadoc.class).configureEach(arg_0 -> MavenPublishBaseExtension.defaultJavaDocOption$lambda$54(arg_0 -> MavenPublishBaseExtension.defaultJavaDocOption$lambda$53(this, arg_0), arg_0));
                return new JavadocJar.Javadoc();
            }
            javadocJar2 = new JavadocJar.Empty();
        }
        return javadocJar2;
    }

    @JvmOverloads
    public final void publishToMavenCentral(@NotNull SonatypeHost host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        MavenPublishBaseExtension.publishToMavenCentral$default(this, host, false, 2, null);
    }

    @JvmOverloads
    public final void publishToMavenCentral() {
        MavenPublishBaseExtension.publishToMavenCentral$default(this, null, false, 3, null);
    }

    @JvmOverloads
    public final /* synthetic */ void publishToMavenCentral(String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        MavenPublishBaseExtension.publishToMavenCentral$default(this, host, false, 2, null);
    }

    @Incubating
    @JvmOverloads
    public final void configureBasedOnAppliedPlugins(boolean sourcesJar) {
        MavenPublishBaseExtension.configureBasedOnAppliedPlugins$default(this, sourcesJar, false, 2, null);
    }

    @Incubating
    @JvmOverloads
    public final void configureBasedOnAppliedPlugins() {
        MavenPublishBaseExtension.configureBasedOnAppliedPlugins$default(this, false, false, 3, null);
    }

    private static final String groupId$lambda$0(MavenPublishBaseExtension this$0) {
        return this$0.project.getGroup().toString();
    }

    private static final String version$lambda$1(MavenPublishBaseExtension this$0) {
        return this$0.project.getVersion().toString();
    }

    private static final Boolean publishToMavenCentral$lambda$2(String it) {
        Intrinsics.checkNotNull((Object)it);
        return StringsKt.endsWith$default((String)it, (String)"-SNAPSHOT", (boolean)false, (int)2, null);
    }

    private static final Boolean publishToMavenCentral$lambda$3(Function1 $tmp0, Object in) {
        return (Boolean)$tmp0.invoke(in);
    }

    private static final String publishToMavenCentral$lambda$6$lambda$4(SonatypeRepositoryBuildService it) {
        return it.publishingUrl$plugin();
    }

    private static final String publishToMavenCentral$lambda$6$lambda$5(Function1 $tmp0, Object in) {
        return (String)$tmp0.invoke(in);
    }

    private static final Unit publishToMavenCentral$lambda$6(Provider $buildService, MavenArtifactRepository repo) {
        repo.setName("mavenCentral");
        repo.setUrl((Object)$buildService.map(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$6$lambda$5(MavenPublishBaseExtension::publishToMavenCentral$lambda$6$lambda$4, arg_0)));
        return Unit.INSTANCE;
    }

    private static final void publishToMavenCentral$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit publishToMavenCentral$lambda$9(TaskProvider $createRepository, PublishToMavenRepository publishTask) {
        String string = publishTask.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        if (StringsKt.endsWith$default((String)string, (String)"ToMavenCentralRepository", (boolean)false, (int)2, null)) {
            Object[] objectArray = new Object[]{$createRepository};
            publishTask.dependsOn(objectArray);
        }
        return Unit.INSTANCE;
    }

    private static final void publishToMavenCentral$lambda$10(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit publishToMavenCentral$lambda$11(MavenPublishBaseExtension this$0, Task it) {
        it.setDescription("Publishes to a staging repository on Sonatype OSS");
        it.setGroup("release");
        Object[] objectArray = new Object[]{this$0.project.getTasks().named("publishAllPublicationsToMavenCentralRepository")};
        it.dependsOn(objectArray);
        return Unit.INSTANCE;
    }

    private static final void publishToMavenCentral$lambda$12(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit publishToMavenCentral$lambda$13(MavenPublishBaseExtension this$0, TaskProvider $releaseRepository, Task it) {
        it.setDescription("Publishes to a staging repository on Sonatype OSS and releases it to MavenCentral");
        it.setGroup("release");
        Object[] objectArray = new Object[]{this$0.project.getTasks().named("publishAllPublicationsToMavenCentralRepository")};
        it.dependsOn(objectArray);
        objectArray = new Object[]{$releaseRepository};
        it.dependsOn(objectArray);
        return Unit.INSTANCE;
    }

    private static final void publishToMavenCentral$lambda$14(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Boolean signAllPublications$lambda$15(String it) {
        Intrinsics.checkNotNull((Object)it);
        return !StringsKt.endsWith$default((String)it, (String)"-SNAPSHOT", (boolean)false, (int)2, null);
    }

    private static final Boolean signAllPublications$lambda$16(Function1 $tmp0, Object in) {
        return (Boolean)$tmp0.invoke(in);
    }

    private static final void signAllPublications$lambda$17(MavenPublishBaseExtension this$0, MavenPublication publication) {
        Project $this$gradleSigning$iv = this$0.project;
        boolean $i$f$getGradleSigning = false;
        Object object = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getByType(...)");
        Publication[] publicationArray = new Publication[]{publication};
        ((SigningExtension)object).sign(publicationArray);
    }

    private static final Unit signAllPublications$lambda$20$lambda$18(MavenPublishBaseExtension this$0, Sign it) {
        SignatureType signatureType = it.getSignatureType();
        if (signatureType == null) {
            signatureType = (SignatureType)new ArmoredSignatureType();
        }
        Provider provider = this$0.project.getLayout().getBuildDirectory().dir("signatures/" + it.getName());
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"dir(...)");
        it.setSignatureType((SignatureType)new WorkaroundSignatureType(signatureType, (Provider<Directory>)provider));
        return Unit.INSTANCE;
    }

    private static final void signAllPublications$lambda$20$lambda$19(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit signAllPublications$lambda$20(MavenPublishBaseExtension this$0, Plugin it) {
        this$0.project.getTasks().withType(Sign.class).configureEach(arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$20$lambda$19(arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$20$lambda$18(this$0, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void signAllPublications$lambda$21(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void groupId$lambda$25(MavenPublishBaseExtension this$0, MavenPublication it) {
        it.setGroupId((String)this$0.groupId.get());
    }

    private static final Unit artifactId$lambda$28$lambda$26(MavenPublication $it, MavenPublishBaseExtension this$0, String $artifactId, Project project) {
        Intrinsics.checkNotNull((Object)$it);
        Intrinsics.checkNotNull((Object)project);
        $it.setArtifactId(this$0.forMultiplatform($artifactId, $it, project));
        return Unit.INSTANCE;
    }

    private static final void artifactId$lambda$28$lambda$27(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void artifactId$lambda$28(MavenPublishBaseExtension this$0, String $artifactId, MavenPublication it) {
        if (this$0.project.getPlugins().hasPlugin("org.jetbrains.kotlin.multiplatform")) {
            this$0.project.afterEvaluate(arg_0 -> MavenPublishBaseExtension.artifactId$lambda$28$lambda$27(arg_0 -> MavenPublishBaseExtension.artifactId$lambda$28$lambda$26(it, this$0, $artifactId, arg_0), arg_0));
        } else {
            it.setArtifactId($artifactId);
        }
    }

    private static final void version$lambda$29(MavenPublishBaseExtension this$0, MavenPublication it) {
        it.setVersion((String)this$0.version.get());
    }

    private static final Unit pom$lambda$33$lambda$31(MavenPublication $publication, Action $configure, Project it) {
        $publication.pom($configure);
        return Unit.INSTANCE;
    }

    private static final void pom$lambda$33$lambda$32(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void pom$lambda$33(Action $configure, MavenPublishBaseExtension this$0, MavenPublication publication) {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"8.8-rc-1")) >= 0) {
            publication.pom($configure);
        } else {
            this$0.project.afterEvaluate(arg_0 -> MavenPublishBaseExtension.pom$lambda$33$lambda$32(arg_0 -> MavenPublishBaseExtension.pom$lambda$33$lambda$31(publication, $configure, arg_0), arg_0));
        }
    }

    private static final Unit pomFromGradleProperties$lambda$50$lambda$34(String $issueManagementSystem, String $issueManagementUrl, MavenPomIssueManagement it) {
        it.getSystem().set((Object)$issueManagementSystem);
        it.getUrl().set((Object)$issueManagementUrl);
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$50$lambda$35(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit pomFromGradleProperties$lambda$50$lambda$36(String $scmUrl, String $scmConnection, String $scmDeveloperConnection, MavenPomScm it) {
        it.getUrl().set((Object)$scmUrl);
        it.getConnection().set((Object)$scmConnection);
        it.getDeveloperConnection().set((Object)$scmDeveloperConnection);
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$50$lambda$37(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit pomFromGradleProperties$lambda$50$lambda$40$lambda$38(String $licenceName, String $licenceUrl, String $licenceDistribution, MavenPomLicense it) {
        it.getName().set((Object)$licenceName);
        it.getUrl().set((Object)$licenceUrl);
        it.getDistribution().set((Object)$licenceDistribution);
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$50$lambda$40$lambda$39(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit pomFromGradleProperties$lambda$50$lambda$40(String $licenceName, String $licenceUrl, String $licenceDistribution, MavenPomLicenseSpec licences) {
        licences.license(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$50$lambda$40$lambda$39(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$50$lambda$40$lambda$38($licenceName, $licenceUrl, $licenceDistribution, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$50$lambda$41(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit pomFromGradleProperties$lambda$50$lambda$44$lambda$42(String $licenseName, String $licenseUrl, String $licenseDistribution, MavenPomLicense it) {
        it.getName().set((Object)$licenseName);
        it.getUrl().set((Object)$licenseUrl);
        it.getDistribution().set((Object)$licenseDistribution);
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$50$lambda$44$lambda$43(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit pomFromGradleProperties$lambda$50$lambda$44(String $licenseName, String $licenseUrl, String $licenseDistribution, MavenPomLicenseSpec licenses) {
        licenses.license(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$50$lambda$44$lambda$43(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$50$lambda$44$lambda$42($licenseName, $licenseUrl, $licenseDistribution, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$50$lambda$45(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit pomFromGradleProperties$lambda$50$lambda$48$lambda$46(String $developerId, String $developerName, String $developerUrl, String $developerEmail, MavenPomDeveloper it) {
        it.getId().set((Object)$developerId);
        it.getName().set((Object)$developerName);
        it.getUrl().set((Object)$developerUrl);
        it.getEmail().set((Object)$developerEmail);
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$50$lambda$48$lambda$47(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit pomFromGradleProperties$lambda$50$lambda$48(String $developerId, String $developerName, String $developerUrl, String $developerEmail, MavenPomDeveloperSpec developers) {
        developers.developer(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$50$lambda$48$lambda$47(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$50$lambda$48$lambda$46($developerId, $developerName, $developerUrl, $developerEmail, arg_0), arg_0));
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$50$lambda$49(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit pomFromGradleProperties$lambda$50(MavenPublishBaseExtension this$0, MavenPom pom) {
        String inceptionYear;
        String url;
        String description;
        String name = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_NAME");
        if (name != null) {
            pom.getName().set((Object)name);
        }
        if ((description = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_DESCRIPTION")) != null) {
            pom.getDescription().set((Object)description);
        }
        if ((url = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_URL")) != null) {
            pom.getUrl().set((Object)url);
        }
        if ((inceptionYear = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_INCEPTION_YEAR")) != null) {
            pom.getInceptionYear().set((Object)inceptionYear);
        }
        String issueManagementSystem = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_ISSUE_SYSTEM");
        String issueManagementUrl = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_ISSUE_URL");
        if (issueManagementSystem != null || issueManagementUrl != null) {
            pom.issueManagement(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$50$lambda$35(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$50$lambda$34(issueManagementSystem, issueManagementUrl, arg_0), arg_0));
        }
        String scmUrl = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_SCM_URL");
        String scmConnection = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_SCM_CONNECTION");
        String scmDeveloperConnection = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_SCM_DEV_CONNECTION");
        if (scmUrl != null || scmConnection != null || scmDeveloperConnection != null) {
            pom.scm(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$50$lambda$37(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$50$lambda$36(scmUrl, scmConnection, scmDeveloperConnection, arg_0), arg_0));
        }
        String licenceName = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENCE_NAME");
        String licenceUrl = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENCE_URL");
        String licenceDistribution = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENCE_DIST");
        if (licenceName != null || licenceUrl != null || licenceDistribution != null) {
            pom.licenses(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$50$lambda$41(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$50$lambda$40(licenceName, licenceUrl, licenceDistribution, arg_0), arg_0));
        }
        String licenseName = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENSE_NAME");
        String licenseUrl = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENSE_URL");
        String licenseDistribution = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_LICENSE_DIST");
        if (licenseName != null || licenseUrl != null || licenseDistribution != null) {
            pom.licenses(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$50$lambda$45(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$50$lambda$44(licenseName, licenseUrl, licenseDistribution, arg_0), arg_0));
        }
        String developerId = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_DEVELOPER_ID");
        String developerName = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_DEVELOPER_NAME");
        String developerUrl = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_DEVELOPER_URL");
        String developerEmail = ProjectExtensionsKt.findOptionalProperty(this$0.project, "POM_DEVELOPER_EMAIL");
        if (developerId != null || developerName != null || developerUrl != null) {
            pom.developers(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$50$lambda$49(arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$50$lambda$48(developerId, developerName, developerUrl, developerEmail, arg_0), arg_0));
        }
        return Unit.INSTANCE;
    }

    private static final void pomFromGradleProperties$lambda$51(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final String defaultJavaDocOption$lambda$52(MavenPublishBaseExtension this$0) {
        TaskCollection tasks = this$0.project.getTasks().withType(DokkaTask.class);
        Intrinsics.checkNotNull((Object)tasks);
        Object object = (DokkaTask)CollectionsKt.singleOrNull((Iterable)((Iterable)tasks));
        if (object == null || (object = object.getName()) == null) {
            object = "dokkaHtml";
        }
        return object;
    }

    private static final Unit defaultJavaDocOption$lambda$53(MavenPublishBaseExtension this$0, Javadoc it) {
        MinimalJavadocOptions minimalJavadocOptions = it.getOptions();
        Intrinsics.checkNotNull((Object)minimalJavadocOptions, (String)"null cannot be cast to non-null type org.gradle.external.javadoc.StandardJavadocDocletOptions");
        StandardJavadocDocletOptions options = (StandardJavadocDocletOptions)minimalJavadocOptions;
        JavaVersion javaVersion = ProjectExtensionsKt.javaVersion(this$0.project);
        if (javaVersion.isJava9Compatible()) {
            options.addBooleanOption("html5", true);
        }
        if (javaVersion.isJava8Compatible()) {
            options.addStringOption("Xdoclint:none", "-quiet");
        }
        return Unit.INSTANCE;
    }

    private static final void defaultJavaDocOption$lambda$54(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Property access$getSonatypeHost$p(MavenPublishBaseExtension $this) {
        return $this.sonatypeHost;
    }
}

