/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish.sonatype;

import com.vanniktech.maven.publish.SonatypeHost;
import com.vanniktech.maven.publish.nexus.Nexus;
import com.vanniktech.maven.publish.portal.SonatypeCentralPortal;
import com.vanniktech.maven.publish.sonatype.SonatypeRepositoryBuildService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\t\b \u0018\u0000 42\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0003456B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010!\u001a\u00020\"H\u0016J\u001e\u0010#\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u0011J\u0010\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)H\u0016J\r\u0010*\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b+J\u0016\u0010,\u001a\u00020\"2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130.H\u0002J\u0016\u0010/\u001a\u00020\"2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130.H\u0002J\u0016\u00100\u001a\u00020\"2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130.H\u0002J\u0010\u00101\u001a\u00020\"2\b\u00102\u001a\u0004\u0018\u00010\u0011J\u0010\u00103\u001a\u00020\"2\b\u00102\u001a\u0004\u0018\u00010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR&\u0010\u000e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\r\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u001c\u001a\u0004\u0018\u00010\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001d\u0010\u001eR\"\u0010\u001f\u001a\u0004\u0018\u00010\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u0011@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b \u0010\u001e\u00a8\u00067"}, d2={"Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService;", "Lorg/gradle/api/services/BuildService;", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$Params;", "Ljava/lang/AutoCloseable;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "()V", "buildIsSuccess", "", "centralPortal", "Lcom/vanniktech/maven/publish/portal/SonatypeCentralPortal;", "getCentralPortal", "()Lcom/vanniktech/maven/publish/portal/SonatypeCentralPortal;", "centralPortal$delegate", "Lkotlin/Lazy;", "coordinates", "", "Lkotlin/Triple;", "", "endOfBuildActions", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction;", "logger", "Lorg/gradle/api/logging/Logger;", "nexus", "Lcom/vanniktech/maven/publish/nexus/Nexus;", "getNexus", "()Lcom/vanniktech/maven/publish/nexus/Nexus;", "nexus$delegate", "value", "publishId", "setPublishId", "(Ljava/lang/String;)V", "uploadId", "setUploadId", "close", "", "createStagingRepository", "group", "artifactId", "version", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "publishingUrl", "publishingUrl$plugin", "runCentralPortalEndOfBuildActions", "actions", "", "runEndOfBuildActions", "runNexusEndOfBuildActions", "shouldCloseAndReleaseRepository", "manualStagingRepositoryId", "shouldDropRepository", "Companion", "EndOfBuildAction", "Params", "plugin"})
@SourceDebugExtension(value={"SMAP\nSonatypeRepositoryBuildService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SonatypeRepositoryBuildService.kt\ncom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,370:1\n774#2:371\n865#2,2:372\n774#2:374\n865#2,2:375\n808#2,11:377\n1663#2,8:388\n1734#2,3:398\n808#2,11:401\n808#2,11:412\n1734#2,3:423\n808#2,11:426\n1317#3,2:396\n*S KotlinDebug\n*F\n+ 1 SonatypeRepositoryBuildService.kt\ncom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService\n*L\n219#1:371\n219#1:372,2\n223#1:374\n223#1:375,2\n245#1:377,11\n251#1:388,8\n286#1:398,3\n292#1:401,11\n306#1:412,11\n310#1:423,3\n320#1:426,11\n266#1:396,2\n*E\n"})
public abstract class SonatypeRepositoryBuildService
implements BuildService<Params>,
AutoCloseable,
OperationCompletionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy centralPortal$delegate;
    @NotNull
    private final Lazy nexus$delegate;
    @Nullable
    private String uploadId;
    @Nullable
    private String publishId;
    @NotNull
    private final Set<EndOfBuildAction> endOfBuildActions;
    @NotNull
    private final Set<Triple<String, String, String>> coordinates;
    private boolean buildIsSuccess;
    @NotNull
    private static final String NAME = "sonatype-repository-build-service";

    public SonatypeRepositoryBuildService() {
        Logger logger = Logging.getLogger(SonatypeRepositoryBuildService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(SonatypeReposi\u2026BuildService::class.java)");
        this.logger = logger;
        this.centralPortal$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SonatypeCentralPortal>(this){
            final /* synthetic */ SonatypeRepositoryBuildService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final SonatypeCentralPortal invoke() {
                String string = ((SonatypeHost)((Params)this.this$0.getParameters()).getSonatypeHost().get()).apiBaseUrl$plugin();
                Base64.Encoder encoder = Base64.getEncoder();
                Object object = ((Params)this.this$0.getParameters()).getRepositoryUsername().get() + ":" + ((Params)this.this$0.getParameters()).getRepositoryPassword().get();
                byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] byArray2 = encoder.encode(byArray);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoder()\n        .en\u2026.toByteArray(),\n        )");
                byte[] byArray3 = byArray2;
                object = Charsets.UTF_8;
                String string2 = new String(byArray3, (Charset)object);
                Object object2 = ((Params)this.this$0.getParameters()).getOkhttpTimeoutSeconds().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.okhttpTimeoutSeconds.get()");
                long l = ((Number)object2).longValue();
                Object object3 = ((Params)this.this$0.getParameters()).getCloseTimeoutSeconds().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.closeTimeoutSeconds.get()");
                return new SonatypeCentralPortal(string, string2, "com.vanniktech.maven.publish", "0.33.0", l, ((Number)object3).longValue());
            }
        }));
        this.nexus$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Nexus>(this){
            final /* synthetic */ SonatypeRepositoryBuildService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Nexus invoke() {
                String string = ((SonatypeHost)((Params)this.this$0.getParameters()).getSonatypeHost().get()).apiBaseUrl$plugin();
                Object object = ((Params)this.this$0.getParameters()).getRepositoryUsername().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.repositoryUsername.get()");
                String string2 = (String)object;
                Object object2 = ((Params)this.this$0.getParameters()).getRepositoryPassword().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.repositoryPassword.get()");
                String string3 = (String)object2;
                Object object3 = ((Params)this.this$0.getParameters()).getOkhttpTimeoutSeconds().get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.okhttpTimeoutSeconds.get()");
                long l = ((Number)object3).longValue();
                Object object4 = ((Params)this.this$0.getParameters()).getCloseTimeoutSeconds().get();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parameters.closeTimeoutSeconds.get()");
                return new Nexus(string, string2, string3, "com.vanniktech.maven.publish", "0.33.0", l, ((Number)object4).longValue());
            }
        }));
        this.endOfBuildActions = new LinkedHashSet();
        this.coordinates = new LinkedHashSet();
        this.buildIsSuccess = true;
    }

    private final SonatypeCentralPortal getCentralPortal() {
        Lazy lazy = this.centralPortal$delegate;
        return (SonatypeCentralPortal)lazy.getValue();
    }

    private final Nexus getNexus() {
        Lazy lazy = this.nexus$delegate;
        return (Nexus)lazy.getValue();
    }

    private final void setUploadId(String value) {
        if (!(this.uploadId == null || Intrinsics.areEqual((Object)this.uploadId, (Object)value))) {
            boolean bl = false;
            String string = "uploadId was already set to '" + this.uploadId + "', new value '" + value + "'";
            throw new IllegalStateException(string.toString());
        }
        this.uploadId = value;
    }

    private final void setPublishId(String value) {
        if (!(this.publishId == null || Intrinsics.areEqual((Object)this.publishId, (Object)value))) {
            boolean bl = false;
            String string = "publishId was already set to '" + this.publishId + "', new value '" + value + "'";
            throw new IllegalStateException(string.toString());
        }
        this.publishId = value;
    }

    public final void createStagingRepository(@NotNull String group, @NotNull String artifactId2, @NotNull String version) {
        String string;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)artifactId2, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.coordinates.add((Triple<String, String, String>)new Triple((Object)group, (Object)artifactId2, (Object)version));
        Object object = ((Params)this.getParameters()).getVersionIsSnapshot().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.versionIsSnapshot.get()");
        if (((Boolean)object).booleanValue()) {
            return;
        }
        if (this.uploadId != null) {
            return;
        }
        if (((SonatypeHost)((Params)this.getParameters()).getSonatypeHost().get()).isCentralPortal$plugin()) {
            string = UUID.randomUUID().toString();
        } else {
            Nexus nexus2 = this.getNexus();
            Object object2 = ((Params)this.getParameters()).getGroupId().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.groupId.get()");
            string = nexus2.createRepositoryForGroup((String)object2);
        }
        this.setUploadId(string);
        ((Collection)this.endOfBuildActions).add(new EndOfBuildAction.Close(false));
        Object object3 = ((Params)this.getParameters()).getAutomaticRelease().get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.automaticRelease.get()");
        if (((Boolean)object3).booleanValue()) {
            ((Collection)this.endOfBuildActions).add(EndOfBuildAction.ReleaseAfterClose.INSTANCE);
        }
        ((Collection)this.endOfBuildActions).add(new EndOfBuildAction.Drop(true, false));
    }

    public final void shouldCloseAndReleaseRepository(@Nullable String manualStagingRepositoryId) {
        if (manualStagingRepositoryId != null) {
            this.setPublishId(manualStagingRepositoryId);
        } else if (this.uploadId == null && ((SonatypeHost)((Params)this.getParameters()).getSonatypeHost().get()).isCentralPortal$plugin()) {
            throw new IllegalStateException("A deployment id needs to be provided with `--repository` when publishing through Central Portal".toString());
        }
        ((Collection)this.endOfBuildActions).add(new EndOfBuildAction.Close(true));
        ((Collection)this.endOfBuildActions).add(EndOfBuildAction.ReleaseAfterClose.INSTANCE);
    }

    public final void shouldDropRepository(@Nullable String manualStagingRepositoryId) {
        if (manualStagingRepositoryId != null) {
            this.setPublishId(manualStagingRepositoryId);
        } else if (((SonatypeHost)((Params)this.getParameters()).getSonatypeHost().get()).isCentralPortal$plugin()) {
            throw new IllegalStateException("A deployment id needs to be provided with `--repository` when publishing through Central Portal".toString());
        }
        ((Collection)this.endOfBuildActions).add(new EndOfBuildAction.Drop(false, true));
    }

    @NotNull
    public final String publishingUrl$plugin() {
        String string;
        Object object = ((Params)this.getParameters()).getVersionIsSnapshot().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.versionIsSnapshot.get()");
        if (((Boolean)object).booleanValue()) {
            if (!(this.uploadId == null)) {
                boolean $i$a$-require-SonatypeRepositoryBuildService$publishingUrl$22 = false;
                String $i$a$-require-SonatypeRepositoryBuildService$publishingUrl$22 = "Staging repositories are not supported for SNAPSHOT versions.";
                throw new IllegalArgumentException($i$a$-require-SonatypeRepositoryBuildService$publishingUrl$22.toString());
            }
            SonatypeHost host = (SonatypeHost)((Params)this.getParameters()).getSonatypeHost().get();
            string = host.isCentralPortal$plugin() ? host.getRootUrl$plugin() + "/repository/maven-snapshots/" : host.getRootUrl$plugin() + "/content/repositories/snapshots/";
        } else {
            String string2 = this.uploadId;
            if (string2 == null) {
                boolean bl = false;
                Object object2 = ((Params)this.getParameters()).getConfigurationCacheActive().get();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.configurationCacheActive.get()");
                String string3 = ((Boolean)object2).booleanValue() ? "Publishing releases to Maven Central is not supported yet with configuration caching enabled, because of this missing Gradle feature: https://github.com/gradle/gradle/issues/22779" : "The staging repository was not created yet. Please open a bug with a build scan or build logs and stacktrace";
                throw new IllegalArgumentException(string3.toString());
            }
            String stagingRepositoryId = string2;
            SonatypeHost host = (SonatypeHost)((Params)this.getParameters()).getSonatypeHost().get();
            string = host.isCentralPortal$plugin() ? "file://" + ((Params)this.getParameters()).getRootBuildDirectory().get() + "/publish/staging/" + stagingRepositoryId : host.getRootUrl$plugin() + "/service/local/staging/deployByRepositoryId/" + stagingRepositoryId + "/";
        }
        return string;
    }

    public void onFinish(@NotNull FinishEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getResult() instanceof FailureResult) {
            this.buildIsSuccess = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        if (this.buildIsSuccess) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = this.endOfBuildActions;
            SonatypeRepositoryBuildService sonatypeRepositoryBuildService = this;
            boolean $i$f$filter = false;
            void var3_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                EndOfBuildAction it = (EndOfBuildAction)element$iv$iv;
                boolean bl = false;
                if (!(!it.getRunAfterFailure())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            sonatypeRepositoryBuildService.runEndOfBuildActions((List)destination$iv$iv);
        } else {
            try {
                Iterable $this$filter$iv = this.endOfBuildActions;
                SonatypeRepositoryBuildService sonatypeRepositoryBuildService = this;
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    EndOfBuildAction it = (EndOfBuildAction)element$iv$iv;
                    boolean bl = false;
                    if (!it.getRunAfterFailure()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                sonatypeRepositoryBuildService.runEndOfBuildActions((List)destination$iv$iv);
            }
            catch (IOException e) {
                if (this.buildIsSuccess) {
                    throw e;
                }
                this.logger.info("Failed processing " + this.uploadId + " staging repository after previous build failure", (Throwable)e);
            }
        }
    }

    private final void runEndOfBuildActions(List<? extends EndOfBuildAction> actions) {
        if (((SonatypeHost)((Params)this.getParameters()).getSonatypeHost().get()).isCentralPortal$plugin()) {
            this.runCentralPortalEndOfBuildActions(actions);
        } else {
            this.runNexusEndOfBuildActions(actions);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void runCentralPortalEndOfBuildActions(List<? extends EndOfBuildAction> actions) {
        void $this$filterIsInstanceTo$iv$iv;
        Object zipFile;
        void $this$filterIsInstanceTo$iv$iv2;
        String uploadId = this.uploadId;
        Iterable $this$filterIsInstance$iv = actions;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv2) {
            if (!(element$iv$iv instanceof EndOfBuildAction.Close)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List closeActions = (List)destination$iv$iv;
        if (!((Collection)closeActions).isEmpty()) {
            if (uploadId != null) {
                String string;
                Triple coordinate;
                if (this.coordinates.size() == 1) {
                    coordinate = (Triple)CollectionsKt.single((Iterable)this.coordinates);
                    string = coordinate.getFirst() + "-" + coordinate.getSecond() + "-" + coordinate.getThird();
                } else {
                    Iterable $this$distinctBy$iv = this.coordinates;
                    boolean $i$f$distinctBy = false;
                    HashSet<CallSite> set$iv = new HashSet<CallSite>();
                    ArrayList list$iv = new ArrayList();
                    for (Object e$iv : $this$distinctBy$iv) {
                        Triple it = (Triple)e$iv;
                        boolean bl = false;
                        String key$iv = "" + it.getFirst() + it.getThird();
                        if (!set$iv.add((CallSite)((Object)key$iv))) continue;
                        list$iv.add(e$iv);
                    }
                    if (((List)list$iv).size() == 1) {
                        coordinate = (Triple)CollectionsKt.first((Iterable)this.coordinates);
                        string = coordinate.getFirst() + "-" + coordinate.getThird();
                    } else {
                        string = ((Params)this.getParameters()).getGroupId().get() + "-" + uploadId;
                    }
                }
                String deploymentName = string;
                String publishingType = actions.contains(EndOfBuildAction.ReleaseAfterClose.INSTANCE) ? "AUTOMATIC" : "USER_MANAGED";
                File directory = new File(StringsKt.substringAfter$default((String)this.publishingUrl$plugin(), (String)"://", null, (int)2, null));
                zipFile = new File(directory.getAbsolutePath() + ".zip");
                ZipOutputStream out = new ZipOutputStream(new FileOutputStream((File)zipFile));
                Sequence $this$forEach$iv = (Sequence)FilesKt.walkTopDown((File)directory);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    File it = (File)element$iv;
                    boolean bl = false;
                    if (it.isDirectory()) continue;
                    String string2 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name");
                    if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"maven-metadata", (boolean)false, (int)2, null)) continue;
                    ZipEntry entry = new ZipEntry(FilesKt.toRelativeString((File)it, (File)directory));
                    out.putNextEntry(entry);
                    out.write(FilesKt.readBytes((File)it));
                    out.closeEntry();
                }
                out.close();
                this.setPublishId(this.getCentralPortal().upload(deploymentName, publishingType, (File)zipFile));
            } else {
                String publishId = this.publishId;
                if (publishId != null) {
                    this.getCentralPortal().publishDeployment(publishId);
                } else {
                    boolean bl;
                    block21: {
                        Iterable $this$all$iv = closeActions;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                EndOfBuildAction.Close it = (EndOfBuildAction.Close)element$iv;
                                boolean bl2 = false;
                                if (it.getSearchForRepositoryIfNoIdPresent()) continue;
                                bl = false;
                                break block21;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        throw new IllegalStateException("A deployment id needs to be provided when publishing through Central Portal".toString());
                    }
                }
            }
        }
        Iterable $this$filterIsInstance$iv2 = actions;
        boolean $i$f$filterIsInstance2 = false;
        zipFile = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof EndOfBuildAction.Drop)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        EndOfBuildAction.Drop dropAction = (EndOfBuildAction.Drop)CollectionsKt.singleOrNull((List)((List)destination$iv$iv2));
        if (dropAction != null) {
            String publishId = this.publishId;
            if (publishId != null) {
                this.getCentralPortal().deleteDeployment(publishId);
            } else if (dropAction.getSearchForRepositoryIfNoIdPresent()) {
                throw new IllegalStateException("A deployment id needs to be provided when publishing through Central Portal".toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void runNexusEndOfBuildActions(List<? extends EndOfBuildAction> actions) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable element$iv2;
        Iterator $this$filterIsInstanceTo$iv$iv2;
        String string = this.uploadId;
        if (string == null) {
            string = this.publishId;
        }
        String stagingRepositoryId = string;
        Iterable $this$filterIsInstance$iv = actions;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator = $this$filterIsInstanceTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof EndOfBuildAction.Close)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List closeActions = (List)destination$iv$iv;
        if (!((Collection)closeActions).isEmpty()) {
            if (stagingRepositoryId != null) {
                this.getNexus().closeStagingRepository(stagingRepositoryId);
            } else {
                boolean bl;
                block15: {
                    Iterable $this$all$iv = closeActions;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Iterable element$iv2 : $this$all$iv) {
                            EndOfBuildAction.Close it = (EndOfBuildAction.Close)((Object)element$iv2);
                            boolean bl2 = false;
                            if (it.getSearchForRepositoryIfNoIdPresent()) continue;
                            bl = false;
                            break block15;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    stagingRepositoryId = this.getNexus().closeCurrentStagingRepository();
                }
            }
            if (stagingRepositoryId != null && actions.contains(EndOfBuildAction.ReleaseAfterClose.INSTANCE)) {
                this.getNexus().releaseStagingRepository(stagingRepositoryId);
            }
        }
        Iterable $this$filterIsInstance$iv2 = actions;
        boolean $i$f$filterIsInstance2 = false;
        element$iv2 = $this$filterIsInstance$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof EndOfBuildAction.Drop)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        EndOfBuildAction.Drop dropAction = (EndOfBuildAction.Drop)CollectionsKt.singleOrNull((List)((List)destination$iv$iv2));
        if (dropAction != null) {
            if (stagingRepositoryId != null) {
                this.getNexus().dropStagingRepository(stagingRepositoryId);
            } else if (dropAction.getSearchForRepositoryIfNoIdPresent()) {
                this.getNexus().dropCurrentStagingRepository();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0082\u0001\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00062\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\r0\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$Companion;", "", "()V", "NAME", "", "registerSonatypeRepositoryBuildService", "Lorg/gradle/api/provider/Provider;", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService;", "Lorg/gradle/api/Project;", "sonatypeHost", "Lcom/vanniktech/maven/publish/SonatypeHost;", "groupId", "versionIsSnapshot", "", "repositoryUsername", "repositoryPassword", "automaticRelease", "rootBuildDirectory", "Lorg/gradle/api/file/Directory;", "buildEventsListenerRegistry", "Lorg/gradle/build/event/BuildEventsListenerRegistry;", "isConfigurationCacheActive", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Provider<SonatypeRepositoryBuildService> registerSonatypeRepositoryBuildService(@NotNull Project $this$registerSonatypeRepositoryBuildService, @NotNull Provider<SonatypeHost> sonatypeHost, @NotNull Provider<String> groupId, @NotNull Provider<Boolean> versionIsSnapshot2, @NotNull Provider<String> repositoryUsername, @NotNull Provider<String> repositoryPassword, boolean automaticRelease, @NotNull Provider<Directory> rootBuildDirectory, @NotNull BuildEventsListenerRegistry buildEventsListenerRegistry, @NotNull Provider<Boolean> isConfigurationCacheActive) {
            Intrinsics.checkNotNullParameter((Object)$this$registerSonatypeRepositoryBuildService, (String)"<this>");
            Intrinsics.checkNotNullParameter(sonatypeHost, (String)"sonatypeHost");
            Intrinsics.checkNotNullParameter(groupId, (String)"groupId");
            Intrinsics.checkNotNullParameter(versionIsSnapshot2, (String)"versionIsSnapshot");
            Intrinsics.checkNotNullParameter(repositoryUsername, (String)"repositoryUsername");
            Intrinsics.checkNotNullParameter(repositoryPassword, (String)"repositoryPassword");
            Intrinsics.checkNotNullParameter(rootBuildDirectory, (String)"rootBuildDirectory");
            Intrinsics.checkNotNullParameter((Object)buildEventsListenerRegistry, (String)"buildEventsListenerRegistry");
            Intrinsics.checkNotNullParameter(isConfigurationCacheActive, (String)"isConfigurationCacheActive");
            Provider okhttpTimeout2 = $this$registerSonatypeRepositoryBuildService.getProject().getProviders().gradleProperty("SONATYPE_CONNECT_TIMEOUT_SECONDS").map(arg_0 -> Companion.registerSonatypeRepositoryBuildService$lambda$0(registerSonatypeRepositoryBuildService.okhttpTimeout.1.INSTANCE, arg_0)).orElse((Object)60L);
            Provider closeTimeout2 = $this$registerSonatypeRepositoryBuildService.getProject().getProviders().gradleProperty("SONATYPE_CLOSE_TIMEOUT_SECONDS").map(arg_0 -> Companion.registerSonatypeRepositoryBuildService$lambda$1(registerSonatypeRepositoryBuildService.closeTimeout.1.INSTANCE, arg_0)).orElse((Object)900L);
            Provider service2 = $this$registerSonatypeRepositoryBuildService.getGradle().getSharedServices().registerIfAbsent(SonatypeRepositoryBuildService.NAME, SonatypeRepositoryBuildService.class, arg_0 -> Companion.registerSonatypeRepositoryBuildService$lambda$2((Function1)new Function1<BuildServiceSpec<Params>, Unit>(sonatypeHost, groupId, versionIsSnapshot2, repositoryUsername, repositoryPassword, automaticRelease, (Provider<Long>)okhttpTimeout2, (Provider<Long>)closeTimeout2, rootBuildDirectory, isConfigurationCacheActive){
                final /* synthetic */ Provider<SonatypeHost> $sonatypeHost;
                final /* synthetic */ Provider<String> $groupId;
                final /* synthetic */ Provider<Boolean> $versionIsSnapshot;
                final /* synthetic */ Provider<String> $repositoryUsername;
                final /* synthetic */ Provider<String> $repositoryPassword;
                final /* synthetic */ boolean $automaticRelease;
                final /* synthetic */ Provider<Long> $okhttpTimeout;
                final /* synthetic */ Provider<Long> $closeTimeout;
                final /* synthetic */ Provider<Directory> $rootBuildDirectory;
                final /* synthetic */ Provider<Boolean> $isConfigurationCacheActive;
                {
                    this.$sonatypeHost = $sonatypeHost;
                    this.$groupId = $groupId;
                    this.$versionIsSnapshot = $versionIsSnapshot;
                    this.$repositoryUsername = $repositoryUsername;
                    this.$repositoryPassword = $repositoryPassword;
                    this.$automaticRelease = $automaticRelease;
                    this.$okhttpTimeout = $okhttpTimeout;
                    this.$closeTimeout = $closeTimeout;
                    this.$rootBuildDirectory = $rootBuildDirectory;
                    this.$isConfigurationCacheActive = $isConfigurationCacheActive;
                    super(1);
                }

                public final void invoke(BuildServiceSpec<Params> it) {
                    it.getMaxParallelUsages().set((Object)1);
                    ((Params)it.getParameters()).getSonatypeHost().set(this.$sonatypeHost);
                    ((Params)it.getParameters()).getGroupId().set(this.$groupId);
                    ((Params)it.getParameters()).getVersionIsSnapshot().set(this.$versionIsSnapshot);
                    ((Params)it.getParameters()).getRepositoryUsername().set(this.$repositoryUsername);
                    ((Params)it.getParameters()).getRepositoryPassword().set(this.$repositoryPassword);
                    ((Params)it.getParameters()).getAutomaticRelease().set((Object)this.$automaticRelease);
                    ((Params)it.getParameters()).getOkhttpTimeoutSeconds().set(this.$okhttpTimeout);
                    ((Params)it.getParameters()).getCloseTimeoutSeconds().set(this.$closeTimeout);
                    ((Params)it.getParameters()).getRootBuildDirectory().set(this.$rootBuildDirectory);
                    ((Params)it.getParameters()).getConfigurationCacheActive().set(this.$isConfigurationCacheActive);
                }
            }, arg_0));
            buildEventsListenerRegistry.onTaskCompletion(service2);
            Intrinsics.checkNotNullExpressionValue((Object)service2, (String)"service");
            return service2;
        }

        private static final Long registerSonatypeRepositoryBuildService$lambda$0(Function1 $tmp0, Object in) {
            return (Long)$tmp0.invoke(in);
        }

        private static final Long registerSonatypeRepositoryBuildService$lambda$1(Function1 $tmp0, Object in) {
            return (Long)$tmp0.invoke(in);
        }

        private static final void registerSonatypeRepositoryBuildService$lambda$2(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0003\u0006\u0007\bR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0003\t\n\u000b\u00a8\u0006\f"}, d2={"Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction;", "", "runAfterFailure", "", "getRunAfterFailure", "()Z", "Close", "Drop", "ReleaseAfterClose", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction$Close;", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction$Drop;", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction$ReleaseAfterClose;", "plugin"})
    private static interface EndOfBuildAction {
        public boolean getRunAfterFailure();

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction$Close;", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction;", "searchForRepositoryIfNoIdPresent", "", "(Z)V", "runAfterFailure", "getRunAfterFailure", "()Z", "getSearchForRepositoryIfNoIdPresent", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "", "plugin"})
        public static final class Close
        implements EndOfBuildAction {
            private final boolean searchForRepositoryIfNoIdPresent;
            private final boolean runAfterFailure;

            public Close(boolean searchForRepositoryIfNoIdPresent) {
                this.searchForRepositoryIfNoIdPresent = searchForRepositoryIfNoIdPresent;
            }

            public final boolean getSearchForRepositoryIfNoIdPresent() {
                return this.searchForRepositoryIfNoIdPresent;
            }

            @Override
            public boolean getRunAfterFailure() {
                return this.runAfterFailure;
            }

            public final boolean component1() {
                return this.searchForRepositoryIfNoIdPresent;
            }

            @NotNull
            public final Close copy(boolean searchForRepositoryIfNoIdPresent) {
                return new Close(searchForRepositoryIfNoIdPresent);
            }

            public static /* synthetic */ Close copy$default(Close close, boolean bl, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = close.searchForRepositoryIfNoIdPresent;
                }
                return close.copy(bl);
            }

            @NotNull
            public String toString() {
                return "Close(searchForRepositoryIfNoIdPresent=" + this.searchForRepositoryIfNoIdPresent + ")";
            }

            public int hashCode() {
                return Boolean.hashCode(this.searchForRepositoryIfNoIdPresent);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Close)) {
                    return false;
                }
                Close close = (Close)other;
                return this.searchForRepositoryIfNoIdPresent == close.searchForRepositoryIfNoIdPresent;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction$Drop;", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction;", "runAfterFailure", "", "searchForRepositoryIfNoIdPresent", "(ZZ)V", "getRunAfterFailure", "()Z", "getSearchForRepositoryIfNoIdPresent", "component1", "component2", "copy", "equals", "other", "", "hashCode", "", "toString", "", "plugin"})
        public static final class Drop
        implements EndOfBuildAction {
            private final boolean runAfterFailure;
            private final boolean searchForRepositoryIfNoIdPresent;

            public Drop(boolean runAfterFailure, boolean searchForRepositoryIfNoIdPresent) {
                this.runAfterFailure = runAfterFailure;
                this.searchForRepositoryIfNoIdPresent = searchForRepositoryIfNoIdPresent;
            }

            @Override
            public boolean getRunAfterFailure() {
                return this.runAfterFailure;
            }

            public final boolean getSearchForRepositoryIfNoIdPresent() {
                return this.searchForRepositoryIfNoIdPresent;
            }

            public final boolean component1() {
                return this.runAfterFailure;
            }

            public final boolean component2() {
                return this.searchForRepositoryIfNoIdPresent;
            }

            @NotNull
            public final Drop copy(boolean runAfterFailure, boolean searchForRepositoryIfNoIdPresent) {
                return new Drop(runAfterFailure, searchForRepositoryIfNoIdPresent);
            }

            public static /* synthetic */ Drop copy$default(Drop drop, boolean bl, boolean bl2, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = drop.runAfterFailure;
                }
                if ((n & 2) != 0) {
                    bl2 = drop.searchForRepositoryIfNoIdPresent;
                }
                return drop.copy(bl, bl2);
            }

            @NotNull
            public String toString() {
                return "Drop(runAfterFailure=" + this.runAfterFailure + ", searchForRepositoryIfNoIdPresent=" + this.searchForRepositoryIfNoIdPresent + ")";
            }

            public int hashCode() {
                int result = Boolean.hashCode(this.runAfterFailure);
                result = result * 31 + Boolean.hashCode(this.searchForRepositoryIfNoIdPresent);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Drop)) {
                    return false;
                }
                Drop drop = (Drop)other;
                if (this.runAfterFailure != drop.runAfterFailure) {
                    return false;
                }
                return this.searchForRepositoryIfNoIdPresent == drop.searchForRepositoryIfNoIdPresent;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction$ReleaseAfterClose;", "Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$EndOfBuildAction;", "()V", "runAfterFailure", "", "getRunAfterFailure", "()Z", "plugin"})
        public static final class ReleaseAfterClose
        implements EndOfBuildAction {
            @NotNull
            public static final ReleaseAfterClose INSTANCE = new ReleaseAfterClose();
            private static final boolean runAfterFailure;

            private ReleaseAfterClose() {
            }

            @Override
            public boolean getRunAfterFailure() {
                return runAfterFailure;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b`\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0006R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0006R\u0018\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R\u0018\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0006R\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lcom/vanniktech/maven/publish/sonatype/SonatypeRepositoryBuildService$Params;", "Lorg/gradle/api/services/BuildServiceParameters;", "automaticRelease", "Lorg/gradle/api/provider/Property;", "", "getAutomaticRelease", "()Lorg/gradle/api/provider/Property;", "closeTimeoutSeconds", "", "getCloseTimeoutSeconds", "configurationCacheActive", "getConfigurationCacheActive", "groupId", "", "getGroupId", "okhttpTimeoutSeconds", "getOkhttpTimeoutSeconds", "repositoryPassword", "getRepositoryPassword", "repositoryUsername", "getRepositoryUsername", "rootBuildDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getRootBuildDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "sonatypeHost", "Lcom/vanniktech/maven/publish/SonatypeHost;", "getSonatypeHost", "versionIsSnapshot", "getVersionIsSnapshot", "plugin"})
    public static interface Params
    extends BuildServiceParameters {
        @NotNull
        public Property<SonatypeHost> getSonatypeHost();

        @NotNull
        public Property<String> getGroupId();

        @NotNull
        public Property<Boolean> getVersionIsSnapshot();

        @NotNull
        public Property<String> getRepositoryUsername();

        @NotNull
        public Property<String> getRepositoryPassword();

        @NotNull
        public Property<Boolean> getAutomaticRelease();

        @NotNull
        public Property<Long> getOkhttpTimeoutSeconds();

        @NotNull
        public Property<Long> getCloseTimeoutSeconds();

        @NotNull
        public DirectoryProperty getRootBuildDirectory();

        @NotNull
        public Property<Boolean> getConfigurationCacheActive();
    }
}

