/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish;

import com.vanniktech.maven.publish.AndroidFusedLibrary;
import com.vanniktech.maven.publish.AndroidSingleVariantLibrary;
import com.vanniktech.maven.publish.GradlePlugin;
import com.vanniktech.maven.publish.GradlePublishPlugin;
import com.vanniktech.maven.publish.JavaLibrary;
import com.vanniktech.maven.publish.JavaPlatform;
import com.vanniktech.maven.publish.JavadocJar;
import com.vanniktech.maven.publish.KotlinJvm;
import com.vanniktech.maven.publish.KotlinMultiplatform;
import com.vanniktech.maven.publish.MavenPublishBaseExtension;
import com.vanniktech.maven.publish.Platform;
import com.vanniktech.maven.publish.ProjectExtensionsKt;
import com.vanniktech.maven.publish.VersionCatalog;
import com.vanniktech.maven.publish.central.DropMavenCentralDeploymentTask;
import com.vanniktech.maven.publish.central.EnableAutomaticMavenCentralPublishingTask;
import com.vanniktech.maven.publish.central.MavenCentralBuildService;
import com.vanniktech.maven.publish.central.PrepareMavenCentralPublishingTask;
import com.vanniktech.maven.publish.workaround.DirectorySignatureType;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.configuration.BuildFeatures;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.MavenPomDeveloper;
import org.gradle.api.publish.maven.MavenPomDeveloperSpec;
import org.gradle.api.publish.maven.MavenPomIssueManagement;
import org.gradle.api.publish.maven.MavenPomLicense;
import org.gradle.api.publish.maven.MavenPomLicenseSpec;
import org.gradle.api.publish.maven.MavenPomScm;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.gradle.external.javadoc.MinimalJavadocOptions;
import org.gradle.external.javadoc.StandardJavadocDocletOptions;
import org.gradle.plugins.signing.Sign;
import org.gradle.plugins.signing.SigningExtension;
import org.gradle.plugins.signing.SigningPlugin;
import org.gradle.plugins.signing.type.SignatureType;
import org.gradle.plugins.signing.type.pgp.ArmoredSignatureType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dokka.gradle.DokkaTask;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\u000bH\u0002J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u001a\u001a\u00020\u00182\b\b\u0002\u0010\u001b\u001a\u00020\u00112\b\b\u0002\u0010\u001c\u001a\u00020\u0011H\u0007J*\u0010\u001d\u001a\u00020\u00182\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u000bJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0011H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0002J\u0010\u0010\u000e\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0016\u0010#\u001a\u00020\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0000\u0012\u00020%0$J\b\u0010&\u001a\u00020\u0018H\u0007J\u001c\u0010'\u001a\u00020\u00182\b\b\u0002\u0010(\u001a\u00020\u00112\b\b\u0002\u0010)\u001a\u00020\u0011H\u0007J\u0006\u0010*\u001a\u00020\u0018J\u0010\u0010\u0016\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u001c\u0010+\u001a\u00020\u000b*\u00020\u000b2\u0006\u0010,\u001a\u00020-2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\r\u00a8\u0006."}, d2={"Lcom/vanniktech/maven/publish/MavenPublishBaseExtension;", "", "project", "Lorg/gradle/api/Project;", "buildEventsListenerRegistry", "Lorg/gradle/build/event/BuildEventsListenerRegistry;", "buildFeatures", "Lorg/gradle/api/configuration/BuildFeatures;", "(Lorg/gradle/api/Project;Lorg/gradle/build/event/BuildEventsListenerRegistry;Lorg/gradle/api/configuration/BuildFeatures;)V", "artifactId", "Lorg/gradle/api/provider/Property;", "", "getArtifactId$plugin", "()Lorg/gradle/api/provider/Property;", "groupId", "getGroupId$plugin", "mavenCentral", "", "platform", "Lcom/vanniktech/maven/publish/Platform;", "pomFromProperties", "signing", "version", "getVersion$plugin", "", "configure", "configureBasedOnAppliedPlugins", "sourcesJar", "javadocJar", "coordinates", "defaultJavaDocOption", "Lcom/vanniktech/maven/publish/JavadocJar;", "plainJavadocSupported", "findOptionalProperty", "propertyName", "pom", "Lorg/gradle/api/Action;", "Lorg/gradle/api/publish/maven/MavenPom;", "pomFromGradleProperties", "publishToMavenCentral", "automaticRelease", "validateDeployment", "signAllPublications", "forMultiplatform", "publication", "Lorg/gradle/api/publish/maven/MavenPublication;", "plugin"})
@SourceDebugExtension(value={"SMAP\nMavenPublishBaseExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenPublishBaseExtension.kt\ncom/vanniktech/maven/publish/MavenPublishBaseExtension\n+ 2 ProjectExtensions.kt\ncom/vanniktech/maven/publish/ProjectExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,466:1\n23#2:467\n20#2:468\n20#2:469\n20#2:471\n1#3:470\n*S KotlinDebug\n*F\n+ 1 MavenPublishBaseExtension.kt\ncom/vanniktech/maven/publish/MavenPublishBaseExtension\n*L\n76#1:467\n155#1:468\n162#1:469\n166#1:471\n*E\n"})
public abstract class MavenPublishBaseExtension {
    @NotNull
    private final Project project;
    @NotNull
    private final BuildEventsListenerRegistry buildEventsListenerRegistry;
    @NotNull
    private final BuildFeatures buildFeatures;
    @NotNull
    private final Property<Boolean> mavenCentral;
    @NotNull
    private final Property<Boolean> signing;
    @NotNull
    private final Property<String> groupId;
    @NotNull
    private final Property<String> artifactId;
    @NotNull
    private final Property<String> version;
    @NotNull
    private final Property<Boolean> pomFromProperties;
    @NotNull
    private final Property<Platform> platform;

    @Inject
    public MavenPublishBaseExtension(@NotNull Project project, @NotNull BuildEventsListenerRegistry buildEventsListenerRegistry, @NotNull BuildFeatures buildFeatures) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildEventsListenerRegistry, (String)"buildEventsListenerRegistry");
        Intrinsics.checkNotNullParameter((Object)buildFeatures, (String)"buildFeatures");
        this.project = project;
        this.buildEventsListenerRegistry = buildEventsListenerRegistry;
        this.buildFeatures = buildFeatures;
        Property property = this.project.getObjects().property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"project.objects.property(Boolean::class.java)");
        this.mavenCentral = property;
        Property property2 = this.project.getObjects().property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"project.objects.property(Boolean::class.java)");
        this.signing = property2;
        Property property3 = this.project.getObjects().property(String.class).convention(this.project.provider(() -> MavenPublishBaseExtension.groupId$lambda$0(this)));
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"project.objects\n    .pro\u2026oject.group.toString() })");
        this.groupId = property3;
        Property property4 = this.project.getObjects().property(String.class).convention(this.project.provider(() -> MavenPublishBaseExtension.artifactId$lambda$0(this)));
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"project.objects\n    .pro\u2026roject.name.toString() })");
        this.artifactId = property4;
        Property property5 = this.project.getObjects().property(String.class).convention(this.project.provider(() -> MavenPublishBaseExtension.version$lambda$0(this)));
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"project.objects\n    .pro\u2026ect.version.toString() })");
        this.version = property5;
        Property property6 = this.project.getObjects().property(Boolean.TYPE);
        Intrinsics.checkNotNullExpressionValue((Object)property6, (String)"project.objects.property(Boolean::class.java)");
        this.pomFromProperties = property6;
        Property property7 = this.project.getObjects().property(Platform.class);
        Intrinsics.checkNotNullExpressionValue((Object)property7, (String)"project.objects.property(Platform::class.java)");
        this.platform = property7;
    }

    @NotNull
    public final Property<String> getGroupId$plugin() {
        return this.groupId;
    }

    @NotNull
    public final Property<String> getArtifactId$plugin() {
        return this.artifactId;
    }

    @NotNull
    public final Property<String> getVersion$plugin() {
        return this.version;
    }

    @JvmOverloads
    public final void publishToMavenCentral(boolean automaticRelease, boolean validateDeployment) {
        this.mavenCentral.set((Object)true);
        this.mavenCentral.finalizeValue();
        Provider localRepository = this.project.getLayout().getBuildDirectory().dir("publishing/mavenCentral");
        Provider versionIsSnapshot2 = this.version.map(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$0(publishToMavenCentral.versionIsSnapshot.1.INSTANCE, arg_0));
        Project $this$gradlePublishing$iv = this.project;
        boolean $i$f$getGradlePublishing = false;
        Object object = $this$gradlePublishing$iv.getExtensions().getByType(PublishingExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(Pub\u2026ingExtension::class.java)");
        MavenArtifactRepository repository2 = ((PublishingExtension)object).getRepositories().maven(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$1(publishToMavenCentral.repository.1.INSTANCE, arg_0));
        this.project.afterEvaluate(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$2((Function1)new Function1<Project, Unit>((Provider<Boolean>)versionIsSnapshot2, repository2, (Provider<Directory>)localRepository){
            final /* synthetic */ Provider<Boolean> $versionIsSnapshot;
            final /* synthetic */ MavenArtifactRepository $repository;
            final /* synthetic */ Provider<Directory> $localRepository;
            {
                this.$versionIsSnapshot = $versionIsSnapshot;
                this.$repository = $repository;
                this.$localRepository = $localRepository;
                super(1);
            }

            public final void invoke(Project it) {
                Object object = this.$versionIsSnapshot.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"versionIsSnapshot.get()");
                if (((Boolean)object).booleanValue()) {
                    this.$repository.setUrl((Object)"https://central.sonatype.com/repository/maven-snapshots/");
                    this.$repository.credentials(PasswordCredentials.class);
                } else {
                    this.$repository.setUrl((Object)((Directory)this.$localRepository.get()).getAsFile());
                }
            }
        }, arg_0));
        Provider provider = this.project.getProviders().gradleProperty("mavenCentralUsername");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.providers.gradle\u2026y(\"mavenCentralUsername\")");
        Provider provider2 = this.project.getProviders().gradleProperty("mavenCentralPassword");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"project.providers.gradle\u2026y(\"mavenCentralPassword\")");
        Directory directory = this.project.getLayout().getSettingsDirectory().dir("build");
        Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"project.layout.settingsDirectory.dir(\"build\")");
        Provider<MavenCentralBuildService> buildService = MavenCentralBuildService.Companion.registerMavenCentralBuildService(this.project, (Provider<String>)provider, (Provider<String>)provider2, directory, this.buildEventsListenerRegistry);
        TaskContainer taskContainer = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        Provider provider3 = (Provider)this.groupId;
        Provider provider4 = (Provider)this.artifactId;
        Provider provider5 = (Provider)this.version;
        Intrinsics.checkNotNullExpressionValue((Object)localRepository, (String)"localRepository");
        TaskProvider<PrepareMavenCentralPublishingTask> prepareTask = PrepareMavenCentralPublishingTask.Companion.registerPrepareMavenCentralPublishingTask(taskContainer, buildService, (Provider<String>)provider3, (Provider<String>)provider4, (Provider<String>)provider5, (Provider<Directory>)localRepository);
        TaskContainer taskContainer2 = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer2, (String)"project.tasks");
        TaskProvider<EnableAutomaticMavenCentralPublishingTask> enableAutomaticTask = EnableAutomaticMavenCentralPublishingTask.Companion.registerEnableAutomaticMavenCentralPublishingTask(taskContainer2, buildService, validateDeployment);
        this.project.getTasks().withType(PublishToMavenRepository.class).configureEach(arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$3((Function1)new Function1<PublishToMavenRepository, Unit>(prepareTask, automaticRelease, enableAutomaticTask){
            final /* synthetic */ TaskProvider<PrepareMavenCentralPublishingTask> $prepareTask;
            final /* synthetic */ boolean $automaticRelease;
            final /* synthetic */ TaskProvider<EnableAutomaticMavenCentralPublishingTask> $enableAutomaticTask;
            {
                this.$prepareTask = $prepareTask;
                this.$automaticRelease = $automaticRelease;
                this.$enableAutomaticTask = $enableAutomaticTask;
                super(1);
            }

            public final void invoke(PublishToMavenRepository publishTask) {
                String string = publishTask.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"publishTask.name");
                if (StringsKt.endsWith$default((String)string, (String)"ToMavenCentralRepository", (boolean)false, (int)2, null)) {
                    Object[] objectArray = new Object[]{this.$prepareTask};
                    publishTask.dependsOn(objectArray);
                    if (this.$automaticRelease) {
                        objectArray = new Object[]{this.$enableAutomaticTask};
                        publishTask.dependsOn(objectArray);
                    }
                }
            }
        }, arg_0));
        this.project.getTasks().register("publishToMavenCentral", arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$4((Function1)new Function1<Task, Unit>(this){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Task it) {
                it.setDescription("Publishes to Maven Central");
                it.setGroup("publishing");
                Object[] objectArray = new Object[]{MavenPublishBaseExtension.access$getProject$p(this.this$0).getTasks().named("publishAllPublicationsToMavenCentralRepository")};
                it.dependsOn(objectArray);
            }
        }, arg_0));
        this.project.getTasks().register("publishAndReleaseToMavenCentral", arg_0 -> MavenPublishBaseExtension.publishToMavenCentral$lambda$5((Function1)new Function1<Task, Unit>(this, enableAutomaticTask){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            final /* synthetic */ TaskProvider<EnableAutomaticMavenCentralPublishingTask> $enableAutomaticTask;
            {
                this.this$0 = $receiver;
                this.$enableAutomaticTask = $enableAutomaticTask;
                super(1);
            }

            public final void invoke(Task it) {
                it.setDescription("Publishes to Maven Central and automatically triggers release");
                it.setGroup("publishing");
                Object[] objectArray = new Object[]{MavenPublishBaseExtension.access$getProject$p(this.this$0).getTasks().named("publishAllPublicationsToMavenCentralRepository")};
                it.dependsOn(objectArray);
                objectArray = new Object[]{this.$enableAutomaticTask};
                it.dependsOn(objectArray);
            }
        }, arg_0));
        TaskContainer taskContainer3 = this.project.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer3, (String)"project.tasks");
        DropMavenCentralDeploymentTask.Companion.registerDropMavenCentralDeploymentTask(taskContainer3, buildService);
    }

    public static /* synthetic */ void publishToMavenCentral$default(MavenPublishBaseExtension mavenPublishBaseExtension, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: publishToMavenCentral");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        mavenPublishBaseExtension.publishToMavenCentral(bl, bl2);
    }

    public final void signAllPublications() {
        this.signing.set((Object)true);
        this.signing.finalizeValue();
        this.project.getPlugins().apply(SigningPlugin.class);
        Project $this$gradleSigning$iv = this.project;
        boolean $i$f$getGradleSigning = false;
        Object object = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(SigningExtension::class.java)");
        ((SigningExtension)object).setRequired((Object)this.version.map(arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$0(signAllPublications.1.INSTANCE, arg_0)));
        Provider inMemoryKey = this.project.getProviders().gradleProperty("signingInMemoryKey");
        if (inMemoryKey.isPresent()) {
            Provider inMemoryKeyId = this.project.getProviders().gradleProperty("signingInMemoryKeyId");
            Provider inMemoryKeyPassword = this.project.getProviders().gradleProperty("signingInMemoryKeyPassword").orElse((Object)"");
            Project $this$gradleSigning$iv2 = this.project;
            boolean $i$f$getGradleSigning2 = false;
            Object object2 = $this$gradleSigning$iv2.getExtensions().getByType(SigningExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"extensions.getByType(SigningExtension::class.java)");
            ((SigningExtension)object2).useInMemoryPgpKeys((String)inMemoryKeyId.getOrNull(), (String)inMemoryKey.get(), (String)inMemoryKeyPassword.get());
        }
        ProjectExtensionsKt.mavenPublications(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$1(this, arg_0)));
        this.project.getPlugins().withId("org.jetbrains.kotlin.multiplatform", arg_0 -> MavenPublishBaseExtension.signAllPublications$lambda$2((Function1)new Function1<Plugin<?>, Unit>(this){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                MavenPublishBaseExtension.access$getProject$p(this.this$0).getTasks().withType(Sign.class).configureEach(arg_0 -> signAllPublications.3.invoke$lambda$0((Function1)new Function1<Sign, Unit>(this.this$0){
                    final /* synthetic */ MavenPublishBaseExtension this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(Sign it) {
                        SignatureType signatureType = it.getSignatureType();
                        if (signatureType == null) {
                            signatureType = (SignatureType)new ArmoredSignatureType();
                        }
                        Provider provider = MavenPublishBaseExtension.access$getProject$p(this.this$0).getLayout().getBuildDirectory().dir("signatures/" + it.getName());
                        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.layout.buildDire\u2026(\"signatures/${it.name}\")");
                        it.setSignatureType((SignatureType)new DirectorySignatureType(signatureType, (Provider<Directory>)provider));
                    }
                }, arg_0));
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object t) {
                $tmp0.invoke(t);
            }
        }, arg_0));
    }

    public final void coordinates(@Nullable String groupId, @Nullable String artifactId2, @Nullable String version) {
        block2: {
            String it;
            String string;
            String string2 = groupId;
            if (string2 != null) {
                it = string = string2;
                boolean bl = false;
                this.groupId(it);
            }
            String string3 = artifactId2;
            if (string3 != null) {
                it = string = string3;
                boolean bl = false;
                this.artifactId(it);
            }
            String string4 = version;
            if (string4 == null) break block2;
            it = string = string4;
            boolean bl = false;
            this.version(it);
        }
    }

    public static /* synthetic */ void coordinates$default(MavenPublishBaseExtension mavenPublishBaseExtension, String string, String string2, String string3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: coordinates");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            string3 = null;
        }
        mavenPublishBaseExtension.coordinates(string, string2, string3);
    }

    private final void groupId(String groupId) {
        this.groupId.set((Object)groupId);
        this.groupId.finalizeValueOnRead();
        ProjectExtensionsKt.mavenPublicationsWithoutPluginMarker(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.groupId$lambda$1(this, arg_0)));
    }

    private final void artifactId(String artifactId2) {
        this.artifactId.set((Object)artifactId2);
        this.artifactId.finalizeValueOnRead();
        ProjectExtensionsKt.mavenPublicationsWithoutPluginMarker(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.artifactId$lambda$1(this, artifactId2, arg_0)));
    }

    private final String forMultiplatform(String $this$forMultiplatform, MavenPublication publication, Project project) {
        String string;
        String projectName = project.getName();
        if (Intrinsics.areEqual((Object)publication.getArtifactId(), (Object)projectName)) {
            string = $this$forMultiplatform;
        } else {
            String string2 = publication.getArtifactId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"publication.artifactId");
            if (StringsKt.startsWith$default((String)string2, (String)(projectName + "-"), (boolean)false, (int)2, null)) {
                String string3 = publication.getArtifactId();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"publication.artifactId");
                string = StringsKt.replace$default((String)string3, (String)(projectName + "-"), (String)($this$forMultiplatform + "-"), (boolean)false, (int)4, null);
            } else {
                throw new IllegalStateException("The plugin can't handle the publication " + publication.getName() + " artifactId " + publication.getArtifactId() + " in project " + projectName);
            }
        }
        return string;
    }

    private final void version(String version) {
        this.version.set((Object)version);
        this.version.finalizeValueOnRead();
        ProjectExtensionsKt.mavenPublications(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.version$lambda$1(this, arg_0)));
    }

    public final void pom(@NotNull Action<? super MavenPom> configure2) {
        Intrinsics.checkNotNullParameter(configure2, (String)"configure");
        ProjectExtensionsKt.mavenPublications(this.project, (Action<MavenPublication>)((Action)arg_0 -> MavenPublishBaseExtension.pom$lambda$0(configure2, arg_0)));
    }

    @Incubating
    public final void pomFromGradleProperties() {
        String version;
        String artifactId2;
        this.pomFromProperties.set((Object)true);
        this.pomFromProperties.finalizeValue();
        String groupId = this.findOptionalProperty("GROUP");
        if (groupId != null) {
            this.groupId(groupId);
        }
        if ((artifactId2 = this.findOptionalProperty("POM_ARTIFACT_ID")) != null) {
            this.artifactId(artifactId2);
        }
        if ((version = this.findOptionalProperty("VERSION_NAME")) != null) {
            this.version(version);
        }
        this.pom((Action<? super MavenPom>)((Action)arg_0 -> MavenPublishBaseExtension.pomFromGradleProperties$lambda$0((Function1)new Function1<MavenPom, Unit>(this){
            final /* synthetic */ MavenPublishBaseExtension this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(MavenPom pom) {
                String inceptionYear;
                String url;
                String description;
                String name = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_NAME");
                if (name != null) {
                    pom.getName().set((Object)name);
                }
                if ((description = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_DESCRIPTION")) != null) {
                    pom.getDescription().set((Object)description);
                }
                if ((url = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_URL")) != null) {
                    pom.getUrl().set((Object)url);
                }
                if ((inceptionYear = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_INCEPTION_YEAR")) != null) {
                    pom.getInceptionYear().set((Object)inceptionYear);
                }
                String issueManagementSystem = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_ISSUE_SYSTEM");
                String issueManagementUrl = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_ISSUE_URL");
                if (issueManagementSystem != null || issueManagementUrl != null) {
                    pom.issueManagement(arg_0 -> pomFromGradleProperties.1.invoke$lambda$0((Function1)new Function1<MavenPomIssueManagement, Unit>(issueManagementSystem, issueManagementUrl){
                        final /* synthetic */ String $issueManagementSystem;
                        final /* synthetic */ String $issueManagementUrl;
                        {
                            this.$issueManagementSystem = $issueManagementSystem;
                            this.$issueManagementUrl = $issueManagementUrl;
                            super(1);
                        }

                        public final void invoke(MavenPomIssueManagement it) {
                            it.getSystem().set((Object)this.$issueManagementSystem);
                            it.getUrl().set((Object)this.$issueManagementUrl);
                        }
                    }, arg_0));
                }
                String scmUrl = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_SCM_URL");
                String scmConnection = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_SCM_CONNECTION");
                String scmDeveloperConnection = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_SCM_DEV_CONNECTION");
                if (scmUrl != null || scmConnection != null || scmDeveloperConnection != null) {
                    pom.scm(arg_0 -> pomFromGradleProperties.1.invoke$lambda$1((Function1)new Function1<MavenPomScm, Unit>(scmUrl, scmConnection, scmDeveloperConnection){
                        final /* synthetic */ String $scmUrl;
                        final /* synthetic */ String $scmConnection;
                        final /* synthetic */ String $scmDeveloperConnection;
                        {
                            this.$scmUrl = $scmUrl;
                            this.$scmConnection = $scmConnection;
                            this.$scmDeveloperConnection = $scmDeveloperConnection;
                            super(1);
                        }

                        public final void invoke(MavenPomScm it) {
                            it.getUrl().set((Object)this.$scmUrl);
                            it.getConnection().set((Object)this.$scmConnection);
                            it.getDeveloperConnection().set((Object)this.$scmDeveloperConnection);
                        }
                    }, arg_0));
                }
                String licenceName = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_LICENCE_NAME");
                String licenceUrl = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_LICENCE_URL");
                String licenceDistribution = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_LICENCE_DIST");
                if (licenceName != null || licenceUrl != null || licenceDistribution != null) {
                    pom.licenses(arg_0 -> pomFromGradleProperties.1.invoke$lambda$2((Function1)new Function1<MavenPomLicenseSpec, Unit>(licenceName, licenceUrl, licenceDistribution){
                        final /* synthetic */ String $licenceName;
                        final /* synthetic */ String $licenceUrl;
                        final /* synthetic */ String $licenceDistribution;
                        {
                            this.$licenceName = $licenceName;
                            this.$licenceUrl = $licenceUrl;
                            this.$licenceDistribution = $licenceDistribution;
                            super(1);
                        }

                        public final void invoke(MavenPomLicenseSpec licences) {
                            licences.license(arg_0 -> pomFromGradleProperties.3.invoke$lambda$0((Function1)new Function1<MavenPomLicense, Unit>(this.$licenceName, this.$licenceUrl, this.$licenceDistribution){
                                final /* synthetic */ String $licenceName;
                                final /* synthetic */ String $licenceUrl;
                                final /* synthetic */ String $licenceDistribution;
                                {
                                    this.$licenceName = $licenceName;
                                    this.$licenceUrl = $licenceUrl;
                                    this.$licenceDistribution = $licenceDistribution;
                                    super(1);
                                }

                                public final void invoke(MavenPomLicense it) {
                                    it.getName().set((Object)this.$licenceName);
                                    it.getUrl().set((Object)this.$licenceUrl);
                                    it.getDistribution().set((Object)this.$licenceDistribution);
                                }
                            }, arg_0));
                        }

                        private static final void invoke$lambda$0(Function1 $tmp0, Object t) {
                            $tmp0.invoke(t);
                        }
                    }, arg_0));
                }
                String licenseName = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_LICENSE_NAME");
                String licenseUrl = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_LICENSE_URL");
                String licenseDistribution = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_LICENSE_DIST");
                if (licenseName != null || licenseUrl != null || licenseDistribution != null) {
                    pom.licenses(arg_0 -> pomFromGradleProperties.1.invoke$lambda$3((Function1)new Function1<MavenPomLicenseSpec, Unit>(licenseName, licenseUrl, licenseDistribution){
                        final /* synthetic */ String $licenseName;
                        final /* synthetic */ String $licenseUrl;
                        final /* synthetic */ String $licenseDistribution;
                        {
                            this.$licenseName = $licenseName;
                            this.$licenseUrl = $licenseUrl;
                            this.$licenseDistribution = $licenseDistribution;
                            super(1);
                        }

                        public final void invoke(MavenPomLicenseSpec licenses) {
                            licenses.license(arg_0 -> pomFromGradleProperties.4.invoke$lambda$0((Function1)new Function1<MavenPomLicense, Unit>(this.$licenseName, this.$licenseUrl, this.$licenseDistribution){
                                final /* synthetic */ String $licenseName;
                                final /* synthetic */ String $licenseUrl;
                                final /* synthetic */ String $licenseDistribution;
                                {
                                    this.$licenseName = $licenseName;
                                    this.$licenseUrl = $licenseUrl;
                                    this.$licenseDistribution = $licenseDistribution;
                                    super(1);
                                }

                                public final void invoke(MavenPomLicense it) {
                                    it.getName().set((Object)this.$licenseName);
                                    it.getUrl().set((Object)this.$licenseUrl);
                                    it.getDistribution().set((Object)this.$licenseDistribution);
                                }
                            }, arg_0));
                        }

                        private static final void invoke$lambda$0(Function1 $tmp0, Object t) {
                            $tmp0.invoke(t);
                        }
                    }, arg_0));
                }
                String developerId = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_DEVELOPER_ID");
                String developerName = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_DEVELOPER_NAME");
                String developerUrl = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_DEVELOPER_URL");
                String developerEmail = MavenPublishBaseExtension.access$findOptionalProperty(this.this$0, "POM_DEVELOPER_EMAIL");
                if (developerId != null || developerName != null || developerUrl != null) {
                    pom.developers(arg_0 -> pomFromGradleProperties.1.invoke$lambda$4((Function1)new Function1<MavenPomDeveloperSpec, Unit>(developerId, developerName, developerUrl, developerEmail){
                        final /* synthetic */ String $developerId;
                        final /* synthetic */ String $developerName;
                        final /* synthetic */ String $developerUrl;
                        final /* synthetic */ String $developerEmail;
                        {
                            this.$developerId = $developerId;
                            this.$developerName = $developerName;
                            this.$developerUrl = $developerUrl;
                            this.$developerEmail = $developerEmail;
                            super(1);
                        }

                        public final void invoke(MavenPomDeveloperSpec developers) {
                            developers.developer(arg_0 -> pomFromGradleProperties.5.invoke$lambda$0((Function1)new Function1<MavenPomDeveloper, Unit>(this.$developerId, this.$developerName, this.$developerUrl, this.$developerEmail){
                                final /* synthetic */ String $developerId;
                                final /* synthetic */ String $developerName;
                                final /* synthetic */ String $developerUrl;
                                final /* synthetic */ String $developerEmail;
                                {
                                    this.$developerId = $developerId;
                                    this.$developerName = $developerName;
                                    this.$developerUrl = $developerUrl;
                                    this.$developerEmail = $developerEmail;
                                    super(1);
                                }

                                public final void invoke(MavenPomDeveloper it) {
                                    it.getId().set((Object)this.$developerId);
                                    it.getName().set((Object)this.$developerName);
                                    it.getUrl().set((Object)this.$developerUrl);
                                    it.getEmail().set((Object)this.$developerEmail);
                                }
                            }, arg_0));
                        }

                        private static final void invoke$lambda$0(Function1 $tmp0, Object t) {
                            $tmp0.invoke(t);
                        }
                    }, arg_0));
                }
            }

            private static final void invoke$lambda$0(Function1 $tmp0, Object t) {
                $tmp0.invoke(t);
            }

            private static final void invoke$lambda$1(Function1 $tmp0, Object t) {
                $tmp0.invoke(t);
            }

            private static final void invoke$lambda$2(Function1 $tmp0, Object t) {
                $tmp0.invoke(t);
            }

            private static final void invoke$lambda$3(Function1 $tmp0, Object t) {
                $tmp0.invoke(t);
            }

            private static final void invoke$lambda$4(Function1 $tmp0, Object t) {
                $tmp0.invoke(t);
            }
        }, arg_0)));
    }

    public final void configure(@NotNull Platform platform) {
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        this.platform.set((Object)platform);
        this.platform.finalizeValue();
        platform.configure$plugin(this.project);
    }

    @Incubating
    @JvmOverloads
    public final void configureBasedOnAppliedPlugins(boolean sourcesJar, boolean javadocJar) {
        if (this.platform.isPresent()) {
            return;
        }
        if (this.project.getPlugins().hasPlugin("org.jetbrains.kotlin.multiplatform")) {
            List list;
            if (this.project.getPlugins().hasPlugin("com.android.kotlin.multiplatform.library")) {
                list = CollectionsKt.emptyList();
            } else {
                String string = (String)this.project.getProviders().gradleProperty("ANDROID_VARIANT_TO_PUBLISH").getOrNull();
                if (string == null) {
                    string = "release";
                }
                list = CollectionsKt.listOf((Object)string);
            }
            List variants = list;
            this.configure(new KotlinMultiplatform(this.defaultJavaDocOption(javadocJar, false), sourcesJar, variants, false));
        } else if (this.project.getPlugins().hasPlugin("com.android.library")) {
            String string = (String)this.project.getProviders().gradleProperty("ANDROID_VARIANT_TO_PUBLISH").getOrNull();
            if (string == null) {
                string = "release";
            }
            String variant = string;
            this.configure(new AndroidSingleVariantLibrary(variant, sourcesJar, javadocJar));
        } else if (this.project.getPlugins().hasPlugin("com.android.fused-library")) {
            this.configure(new AndroidFusedLibrary());
        } else if (this.project.getPlugins().hasPlugin("com.gradle.plugin-publish")) {
            this.configure(new GradlePublishPlugin());
        } else if (this.project.getPlugins().hasPlugin("java-gradle-plugin")) {
            this.configure(new GradlePlugin(this.defaultJavaDocOption(javadocJar, true), sourcesJar));
        } else if (this.project.getPlugins().hasPlugin("org.jetbrains.kotlin.jvm")) {
            this.configure(new KotlinJvm(this.defaultJavaDocOption(javadocJar, true), sourcesJar));
        } else if (this.project.getPlugins().hasPlugin("java-library")) {
            this.configure(new JavaLibrary(this.defaultJavaDocOption(javadocJar, true), sourcesJar));
        } else if (this.project.getPlugins().hasPlugin("java")) {
            this.configure(new JavaLibrary(this.defaultJavaDocOption(javadocJar, true), sourcesJar));
        } else if (this.project.getPlugins().hasPlugin("java-platform")) {
            this.configure(new JavaPlatform());
        } else if (this.project.getPlugins().hasPlugin("version-catalog")) {
            this.configure(new VersionCatalog());
        } else {
            this.project.getLogger().warn("No compatible plugin found in project " + this.project.getPath() + " for publishing");
        }
    }

    public static /* synthetic */ void configureBasedOnAppliedPlugins$default(MavenPublishBaseExtension mavenPublishBaseExtension, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: configureBasedOnAppliedPlugins");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        mavenPublishBaseExtension.configureBasedOnAppliedPlugins(bl, bl2);
    }

    private final JavadocJar defaultJavaDocOption(boolean javadocJar, boolean plainJavadocSupported) {
        JavadocJar javadocJar2;
        if (!javadocJar) {
            javadocJar2 = new JavadocJar.None();
        } else if (this.project.getPlugins().hasPlugin("org.jetbrains.dokka-javadoc")) {
            javadocJar2 = new JavadocJar.Dokka("dokkaGeneratePublicationJavadoc");
        } else if (this.project.getPlugins().hasPlugin("org.jetbrains.dokka")) {
            JavadocJar.Dokka dokka;
            if (this.project.getExtensions().findByName("dokka") != null) {
                dokka = new JavadocJar.Dokka("dokkaGeneratePublicationHtml");
            } else {
                Provider dokkaTask = this.project.provider(() -> MavenPublishBaseExtension.defaultJavaDocOption$lambda$0(this));
                Intrinsics.checkNotNullExpressionValue((Object)dokkaTask, (String)"dokkaTask");
                dokka = new JavadocJar.Dokka((Provider<String>)dokkaTask);
            }
            javadocJar2 = dokka;
        } else {
            if (plainJavadocSupported) {
                this.project.getTasks().withType(Javadoc.class).configureEach(arg_0 -> MavenPublishBaseExtension.defaultJavaDocOption$lambda$1((Function1)new Function1<Javadoc, Unit>(this){
                    final /* synthetic */ MavenPublishBaseExtension this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(Javadoc it) {
                        MinimalJavadocOptions minimalJavadocOptions = it.getOptions();
                        Intrinsics.checkNotNull((Object)minimalJavadocOptions, (String)"null cannot be cast to non-null type org.gradle.external.javadoc.StandardJavadocDocletOptions");
                        StandardJavadocDocletOptions options = (StandardJavadocDocletOptions)minimalJavadocOptions;
                        JavaVersion javaVersion = ProjectExtensionsKt.javaVersion(MavenPublishBaseExtension.access$getProject$p(this.this$0));
                        if (javaVersion.isJava9Compatible()) {
                            options.addBooleanOption("html5", true);
                        }
                    }
                }, arg_0));
                return new JavadocJar.Javadoc();
            }
            javadocJar2 = new JavadocJar.Empty();
        }
        return javadocJar2;
    }

    private final String findOptionalProperty(String propertyName) {
        String string;
        Object object = this.buildFeatures.getIsolatedProjects().getActive().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"buildFeatures.isolatedProjects.active.get()");
        if (((Boolean)object).booleanValue()) {
            string = (String)this.project.getProviders().gradleProperty(propertyName).getOrNull();
        } else {
            Object object2 = this.project.findProperty(propertyName);
            string = object2 != null ? object2.toString() : null;
        }
        return string;
    }

    @JvmOverloads
    public final void publishToMavenCentral(boolean automaticRelease) {
        MavenPublishBaseExtension.publishToMavenCentral$default(this, automaticRelease, false, 2, null);
    }

    @JvmOverloads
    public final void publishToMavenCentral() {
        MavenPublishBaseExtension.publishToMavenCentral$default(this, false, false, 3, null);
    }

    @Incubating
    @JvmOverloads
    public final void configureBasedOnAppliedPlugins(boolean sourcesJar) {
        MavenPublishBaseExtension.configureBasedOnAppliedPlugins$default(this, sourcesJar, false, 2, null);
    }

    @Incubating
    @JvmOverloads
    public final void configureBasedOnAppliedPlugins() {
        MavenPublishBaseExtension.configureBasedOnAppliedPlugins$default(this, false, false, 3, null);
    }

    private static final String groupId$lambda$0(MavenPublishBaseExtension this$0) {
        return this$0.project.getGroup().toString();
    }

    private static final String artifactId$lambda$0(MavenPublishBaseExtension this$0) {
        return this$0.project.getName().toString();
    }

    private static final String version$lambda$0(MavenPublishBaseExtension this$0) {
        return this$0.project.getVersion().toString();
    }

    private static final Boolean publishToMavenCentral$lambda$0(Function1 $tmp0, Object in) {
        return (Boolean)$tmp0.invoke(in);
    }

    private static final void publishToMavenCentral$lambda$1(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final void publishToMavenCentral$lambda$2(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final void publishToMavenCentral$lambda$3(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final void publishToMavenCentral$lambda$4(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final void publishToMavenCentral$lambda$5(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final Boolean signAllPublications$lambda$0(Function1 $tmp0, Object in) {
        return (Boolean)$tmp0.invoke(in);
    }

    private static final void signAllPublications$lambda$1(MavenPublishBaseExtension this$0, MavenPublication publication) {
        Project $this$gradleSigning$iv = this$0.project;
        boolean $i$f$getGradleSigning = false;
        Object object = $this$gradleSigning$iv.getExtensions().getByType(SigningExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.getByType(SigningExtension::class.java)");
        Publication[] publicationArray = new Publication[]{publication};
        ((SigningExtension)object).sign(publicationArray);
    }

    private static final void signAllPublications$lambda$2(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final void groupId$lambda$1(MavenPublishBaseExtension this$0, MavenPublication it) {
        it.setGroupId((String)this$0.groupId.get());
    }

    private static final void artifactId$lambda$1(MavenPublishBaseExtension this$0, String $artifactId, MavenPublication it) {
        if (this$0.project.getPlugins().hasPlugin("org.jetbrains.kotlin.multiplatform")) {
            this$0.project.afterEvaluate(arg_0 -> MavenPublishBaseExtension.artifactId$lambda$1$0((Function1)new Function1<Project, Unit>(it, this$0, $artifactId){
                final /* synthetic */ MavenPublication $it;
                final /* synthetic */ MavenPublishBaseExtension this$0;
                final /* synthetic */ String $artifactId;
                {
                    this.$it = $it;
                    this.this$0 = $receiver;
                    this.$artifactId = $artifactId;
                    super(1);
                }

                public final void invoke(Project project) {
                    MavenPublication mavenPublication = this.$it;
                    Intrinsics.checkNotNullExpressionValue((Object)mavenPublication, (String)"it");
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                    this.$it.setArtifactId(MavenPublishBaseExtension.access$forMultiplatform(this.this$0, this.$artifactId, mavenPublication, project));
                }
            }, arg_0));
        } else {
            it.setArtifactId($artifactId);
        }
    }

    private static final void artifactId$lambda$1$0(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final void version$lambda$1(MavenPublishBaseExtension this$0, MavenPublication it) {
        it.setVersion((String)this$0.version.get());
    }

    private static final void pom$lambda$0(Action $configure, MavenPublication publication) {
        publication.pom($configure);
    }

    private static final void pomFromGradleProperties$lambda$0(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    private static final String defaultJavaDocOption$lambda$0(MavenPublishBaseExtension this$0) {
        TaskCollection tasks = this$0.project.getTasks().withType(DokkaTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)tasks, (String)"tasks");
        DokkaTask dokkaTask = (DokkaTask)CollectionsKt.singleOrNull((Iterable)((Iterable)tasks));
        String string = dokkaTask != null ? dokkaTask.getName() : null;
        if (string == null) {
            string = "dokkaHtml";
        }
        return string;
    }

    private static final void defaultJavaDocOption$lambda$1(Function1 $tmp0, Object t) {
        $tmp0.invoke(t);
    }

    public static final /* synthetic */ Project access$getProject$p(MavenPublishBaseExtension $this) {
        return $this.project;
    }

    public static final /* synthetic */ String access$findOptionalProperty(MavenPublishBaseExtension $this, String propertyName) {
        return $this.findOptionalProperty(propertyName);
    }

    public static final /* synthetic */ String access$forMultiplatform(MavenPublishBaseExtension $this, String $receiver, MavenPublication publication, Project project) {
        return $this.forMultiplatform($receiver, publication, project);
    }
}

