/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.maven.publish.central;

import com.vanniktech.maven.publish.central.EndOfBuildAction;
import com.vanniktech.maven.publish.central.MavenCentralBuildService;
import com.vanniktech.maven.publish.central.MavenCentralCoordinates;
import com.vanniktech.maven.publish.central.MavenCentralProject;
import com.vanniktech.maven.publish.portal.SonatypeCentralPortal;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.build.event.BuildEventsListenerRegistry;
import org.gradle.tooling.events.FailureResult;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b \u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004:\u0002)*B\u0005\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u0007J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J&\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020%J\u0016\u0010&\u001a\u00020\u00192\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120(H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/vanniktech/maven/publish/central/MavenCentralBuildService;", "Lorg/gradle/api/services/BuildService;", "Lcom/vanniktech/maven/publish/central/MavenCentralBuildService$Params;", "Ljava/lang/AutoCloseable;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "()V", "buildIsSuccess", "", "centralPortal", "Lcom/vanniktech/maven/publish/portal/SonatypeCentralPortal;", "getCentralPortal", "()Lcom/vanniktech/maven/publish/portal/SonatypeCentralPortal;", "centralPortal$delegate", "Lkotlin/Lazy;", "deploymentId", "", "endOfBuildActions", "", "Lcom/vanniktech/maven/publish/central/EndOfBuildAction;", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "projectsToPublish", "Lcom/vanniktech/maven/publish/central/MavenCentralProject;", "close", "", "dropDeployment", "enableAutomaticPublishing", "validateDeployment", "onFinish", "event", "Lorg/gradle/tooling/events/FinishEvent;", "registerProject", "group", "artifactId", "version", "localRepository", "Ljava/io/File;", "runEndOfBuildActions", "actions", "", "Companion", "Params", "plugin"})
@SourceDebugExtension(value={"SMAP\nMavenCentralBuildService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenCentralBuildService.kt\ncom/vanniktech/maven/publish/central/MavenCentralBuildService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,213:1\n774#2:214\n865#2,2:215\n774#2:217\n865#2,2:218\n1563#2:220\n1634#2,3:221\n1669#2,8:224\n1869#2:233\n1870#2:236\n808#2,11:237\n1#3:232\n1321#4,2:234\n*S KotlinDebug\n*F\n+ 1 MavenCentralBuildService.kt\ncom/vanniktech/maven/publish/central/MavenCentralBuildService\n*L\n109#1:214\n109#1:215,2\n113#1:217\n113#1:218,2\n121#1:220\n121#1:221,3\n125#1:224,8\n146#1:233\n146#1:236\n169#1:237,11\n150#1:234,2\n*E\n"})
public abstract class MavenCentralBuildService
implements BuildService<Params>,
AutoCloseable,
OperationCompletionListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final org.gradle.api.logging.Logger logger = Logging.getLogger(MavenCentralBuildService.class);
    @NotNull
    private final Lazy centralPortal$delegate = LazyKt.lazy((Function0)((Function0)new Function0<SonatypeCentralPortal>(this){
        final /* synthetic */ MavenCentralBuildService this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        public final SonatypeCentralPortal invoke() {
            Base64.Encoder encoder = Base64.getEncoder();
            Object object = ((Params)this.this$0.getParameters()).getRepositoryUsername().get() + ":" + ((Params)this.this$0.getParameters()).getRepositoryPassword().get();
            byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] byArray2 = encoder.encode(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoder()\n        .en\u2026.toByteArray(),\n        )");
            byte[] byArray3 = byArray2;
            object = Charsets.UTF_8;
            String string = new String(byArray3, (Charset)object);
            Object object2 = ((Params)this.this$0.getParameters()).getOkhttpTimeoutSeconds().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.okhttpTimeoutSeconds.get()");
            long l = ((Number)object2).longValue();
            Object object3 = ((Params)this.this$0.getParameters()).getCloseTimeoutSeconds().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.closeTimeoutSeconds.get()");
            long l2 = ((Number)object3).longValue();
            long l3 = ((Number)((Params)this.this$0.getParameters()).getPollIntervalSeconds().get()).longValue() * 1000L;
            org.gradle.api.logging.Logger logger = MavenCentralBuildService.access$getLogger$p(this.this$0);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            return new SonatypeCentralPortal("https://central.sonatype.com", string, "com.vanniktech.maven.publish", "0.35.0", l, l2, l3, (Logger)logger);
        }
    }));
    @Nullable
    private String deploymentId;
    @NotNull
    private final Set<EndOfBuildAction> endOfBuildActions = new LinkedHashSet();
    @NotNull
    private final Set<MavenCentralProject> projectsToPublish = new LinkedHashSet();
    private boolean buildIsSuccess = true;
    @NotNull
    private static final String NAME = "maven-central-build-service";

    private final SonatypeCentralPortal getCentralPortal() {
        Lazy lazy = this.centralPortal$delegate;
        return (SonatypeCentralPortal)lazy.getValue();
    }

    public final void registerProject(@NotNull String group, @NotNull String artifactId2, @NotNull String version, @NotNull File localRepository) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)artifactId2, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)localRepository, (String)"localRepository");
        if (StringsKt.endsWith$default((String)version, (String)"-SNAPSHOT", (boolean)false, (int)2, null)) {
            return;
        }
        MavenCentralCoordinates coordinates = new MavenCentralCoordinates(group, artifactId2, version);
        MavenCentralProject project = new MavenCentralProject(coordinates, localRepository);
        this.projectsToPublish.add(project);
        ((Collection)this.endOfBuildActions).add(EndOfBuildAction.Upload.INSTANCE);
        ((Collection)this.endOfBuildActions).add(new EndOfBuildAction.Drop(true));
    }

    public final void enableAutomaticPublishing(boolean validateDeployment) {
        ((Collection)this.endOfBuildActions).add(EndOfBuildAction.Publish.INSTANCE);
        if (validateDeployment) {
            ((Collection)this.endOfBuildActions).add(EndOfBuildAction.Validate.INSTANCE);
        }
    }

    public final void dropDeployment(@NotNull String deploymentId) {
        Intrinsics.checkNotNullParameter((Object)deploymentId, (String)"deploymentId");
        this.deploymentId = deploymentId;
        ((Collection)this.endOfBuildActions).add(new EndOfBuildAction.Drop(false));
    }

    public void onFinish(@NotNull FinishEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getResult() instanceof FailureResult) {
            this.buildIsSuccess = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        if (this.buildIsSuccess) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Iterable iterable = this.endOfBuildActions;
            MavenCentralBuildService mavenCentralBuildService = this;
            boolean $i$f$filter = false;
            void var3_8 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                EndOfBuildAction it = (EndOfBuildAction)element$iv$iv;
                boolean bl = false;
                if (!(!it.getRunAfterFailure())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            mavenCentralBuildService.runEndOfBuildActions((List)destination$iv$iv);
        } else {
            try {
                Iterable $this$filter$iv = this.endOfBuildActions;
                MavenCentralBuildService mavenCentralBuildService = this;
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    EndOfBuildAction it = (EndOfBuildAction)element$iv$iv;
                    boolean bl = false;
                    if (!it.getRunAfterFailure()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                mavenCentralBuildService.runEndOfBuildActions((List)destination$iv$iv);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void runEndOfBuildActions(List<? extends EndOfBuildAction> actions) {
        String id;
        void $this$filterIsInstanceTo$iv$iv;
        Object zipFile;
        Collection destination$iv$iv;
        if (actions.contains(EndOfBuildAction.Upload.INSTANCE)) {
            String deploymentId;
            String string;
            MavenCentralCoordinates coordinate;
            MavenCentralCoordinates it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.projectsToPublish;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                MavenCentralProject mavenCentralProject = (MavenCentralProject)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(((MavenCentralProject)((Object)it)).getCoordinates());
            }
            Set coordinates = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            if (coordinates.size() == 1) {
                coordinate = (MavenCentralCoordinates)CollectionsKt.single((Iterable)coordinates);
                string = coordinate.getGroup() + "-" + coordinate.getArtifactId() + "-" + coordinate.getVersion();
            } else {
                Iterable $this$distinctBy$iv = coordinates;
                boolean $i$f$distinctBy = false;
                HashSet<CallSite> set$iv = new HashSet<CallSite>();
                ArrayList list$iv = new ArrayList();
                for (Object e$iv : $this$distinctBy$iv) {
                    it = (MavenCentralCoordinates)e$iv;
                    boolean bl = false;
                    String key$iv = it.getGroup() + it.getVersion();
                    if (!set$iv.add((CallSite)((Object)key$iv))) continue;
                    list$iv.add(e$iv);
                }
                if (((List)list$iv).size() == 1) {
                    coordinate = (MavenCentralCoordinates)CollectionsKt.first((Iterable)coordinates);
                    string = coordinate.getGroup() + "-" + coordinate.getVersion();
                } else {
                    coordinate = (MavenCentralCoordinates)CollectionsKt.first((Iterable)coordinates);
                    string = coordinate.getGroup() + "-" + System.currentTimeMillis();
                }
            }
            String deploymentName = string;
            SonatypeCentralPortal.PublishingType publishingType = actions.contains(EndOfBuildAction.Publish.INSTANCE) ? SonatypeCentralPortal.PublishingType.AUTOMATIC : SonatypeCentralPortal.PublishingType.USER_MANAGED;
            zipFile = ((RegularFile)((Params)this.getParameters()).getRootBuildDirectory().file("publish/" + deploymentName + "-" + System.currentTimeMillis() + ".zip").get()).getAsFile();
            ((File)zipFile).getParentFile().mkdirs();
            if (!((File)zipFile).createNewFile()) {
                boolean $i$a$-check-MavenCentralBuildService$runEndOfBuildActions$22 = false;
                String $i$a$-check-MavenCentralBuildService$runEndOfBuildActions$22 = (File)zipFile + " already exists";
                throw new IllegalStateException($i$a$-check-MavenCentralBuildService$runEndOfBuildActions$22.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)zipFile, (String)"zipFile");
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream((File)zipFile));
            Iterable $this$forEach$iv = this.projectsToPublish;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                MavenCentralProject project = (MavenCentralProject)element$iv;
                boolean bl = false;
                Sequence sequence = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)project.getLocalRepository())), (Function1)runEndOfBuildActions.2.1.INSTANCE);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File it2 = (File)element$iv2;
                    boolean bl2 = false;
                    ZipEntry entry = new ZipEntry(FilesKt.toRelativeString((File)it2, (File)project.getLocalRepository()));
                    out.putNextEntry(entry);
                    out.write(FilesKt.readBytes((File)it2));
                    out.closeEntry();
                }
            }
            out.close();
            this.deploymentId = deploymentId = this.getCentralPortal().upload(deploymentName, publishingType, (File)zipFile);
            if (actions.contains(EndOfBuildAction.Validate.INSTANCE)) {
                this.getCentralPortal().validateDeployment(deploymentId);
            } else {
                this.logger.lifecycle("Skipping deployment validation!");
            }
        }
        Iterable $this$filterIsInstance$iv = actions;
        boolean $i$f$filterIsInstance = false;
        zipFile = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof EndOfBuildAction.Drop)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        EndOfBuildAction.Drop dropAction = (EndOfBuildAction.Drop)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
        if (dropAction != null && (id = this.deploymentId) != null) {
            this.getCentralPortal().deleteDeployment(id);
        }
    }

    public static final /* synthetic */ org.gradle.api.logging.Logger access$getLogger$p(MavenCentralBuildService $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/vanniktech/maven/publish/central/MavenCentralBuildService$Companion;", "", "()V", "NAME", "", "registerMavenCentralBuildService", "Lorg/gradle/api/provider/Provider;", "Lcom/vanniktech/maven/publish/central/MavenCentralBuildService;", "Lorg/gradle/api/Project;", "repositoryUsername", "repositoryPassword", "rootBuildDirectory", "Lorg/gradle/api/file/Directory;", "buildEventsListenerRegistry", "Lorg/gradle/build/event/BuildEventsListenerRegistry;", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Provider<MavenCentralBuildService> registerMavenCentralBuildService(@NotNull Project $this$registerMavenCentralBuildService, @NotNull Provider<String> repositoryUsername, @NotNull Provider<String> repositoryPassword, @NotNull Directory rootBuildDirectory, @NotNull BuildEventsListenerRegistry buildEventsListenerRegistry) {
            Intrinsics.checkNotNullParameter((Object)$this$registerMavenCentralBuildService, (String)"<this>");
            Intrinsics.checkNotNullParameter(repositoryUsername, (String)"repositoryUsername");
            Intrinsics.checkNotNullParameter(repositoryPassword, (String)"repositoryPassword");
            Intrinsics.checkNotNullParameter((Object)rootBuildDirectory, (String)"rootBuildDirectory");
            Intrinsics.checkNotNullParameter((Object)buildEventsListenerRegistry, (String)"buildEventsListenerRegistry");
            Provider okhttpTimeout2 = $this$registerMavenCentralBuildService.getProject().getProviders().gradleProperty("SONATYPE_CONNECT_TIMEOUT_SECONDS").map(arg_0 -> Companion.registerMavenCentralBuildService$lambda$0(registerMavenCentralBuildService.okhttpTimeout.1.INSTANCE, arg_0)).orElse((Object)60L);
            Provider closeTimeout2 = $this$registerMavenCentralBuildService.getProject().getProviders().gradleProperty("SONATYPE_CLOSE_TIMEOUT_SECONDS").map(arg_0 -> Companion.registerMavenCentralBuildService$lambda$1(registerMavenCentralBuildService.closeTimeout.1.INSTANCE, arg_0)).orElse((Object)900L);
            Provider pollIntervalSeconds2 = $this$registerMavenCentralBuildService.getProject().getProviders().gradleProperty("SONATYPE_POLL_INTERVAL_SECONDS").map(arg_0 -> Companion.registerMavenCentralBuildService$lambda$2(registerMavenCentralBuildService.pollIntervalSeconds.1.INSTANCE, arg_0)).orElse((Object)5L);
            Provider service2 = $this$registerMavenCentralBuildService.getGradle().getSharedServices().registerIfAbsent(MavenCentralBuildService.NAME, MavenCentralBuildService.class, arg_0 -> Companion.registerMavenCentralBuildService$lambda$3((Function1)new Function1<BuildServiceSpec<Params>, Unit>(repositoryUsername, repositoryPassword, (Provider<Long>)okhttpTimeout2, (Provider<Long>)closeTimeout2, (Provider<Long>)pollIntervalSeconds2, rootBuildDirectory){
                final /* synthetic */ Provider<String> $repositoryUsername;
                final /* synthetic */ Provider<String> $repositoryPassword;
                final /* synthetic */ Provider<Long> $okhttpTimeout;
                final /* synthetic */ Provider<Long> $closeTimeout;
                final /* synthetic */ Provider<Long> $pollIntervalSeconds;
                final /* synthetic */ Directory $rootBuildDirectory;
                {
                    this.$repositoryUsername = $repositoryUsername;
                    this.$repositoryPassword = $repositoryPassword;
                    this.$okhttpTimeout = $okhttpTimeout;
                    this.$closeTimeout = $closeTimeout;
                    this.$pollIntervalSeconds = $pollIntervalSeconds;
                    this.$rootBuildDirectory = $rootBuildDirectory;
                    super(1);
                }

                public final void invoke(BuildServiceSpec<Params> it) {
                    it.getMaxParallelUsages().set((Object)1);
                    ((Params)it.getParameters()).getRepositoryUsername().set(this.$repositoryUsername);
                    ((Params)it.getParameters()).getRepositoryPassword().set(this.$repositoryPassword);
                    ((Params)it.getParameters()).getOkhttpTimeoutSeconds().set(this.$okhttpTimeout);
                    ((Params)it.getParameters()).getCloseTimeoutSeconds().set(this.$closeTimeout);
                    ((Params)it.getParameters()).getPollIntervalSeconds().set(this.$pollIntervalSeconds);
                    ((Params)it.getParameters()).getRootBuildDirectory().set((Object)this.$rootBuildDirectory);
                }
            }, arg_0));
            buildEventsListenerRegistry.onTaskCompletion(service2);
            Intrinsics.checkNotNullExpressionValue((Object)service2, (String)"service");
            return service2;
        }

        private static final Long registerMavenCentralBuildService$lambda$0(Function1 $tmp0, Object in) {
            return (Long)$tmp0.invoke(in);
        }

        private static final Long registerMavenCentralBuildService$lambda$1(Function1 $tmp0, Object in) {
            return (Long)$tmp0.invoke(in);
        }

        private static final Long registerMavenCentralBuildService$lambda$2(Function1 $tmp0, Object in) {
            return (Long)$tmp0.invoke(in);
        }

        private static final void registerMavenCentralBuildService$lambda$3(Function1 $tmp0, Object t) {
            $tmp0.invoke(t);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001R\u0018\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0018\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0006R\u0018\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0006R\u0012\u0010\u0010\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/vanniktech/maven/publish/central/MavenCentralBuildService$Params;", "Lorg/gradle/api/services/BuildServiceParameters;", "closeTimeoutSeconds", "Lorg/gradle/api/provider/Property;", "", "getCloseTimeoutSeconds", "()Lorg/gradle/api/provider/Property;", "okhttpTimeoutSeconds", "getOkhttpTimeoutSeconds", "pollIntervalSeconds", "getPollIntervalSeconds", "repositoryPassword", "", "getRepositoryPassword", "repositoryUsername", "getRepositoryUsername", "rootBuildDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getRootBuildDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "plugin"})
    public static interface Params
    extends BuildServiceParameters {
        @NotNull
        public Property<String> getRepositoryUsername();

        @NotNull
        public Property<String> getRepositoryPassword();

        @NotNull
        public Property<Long> getOkhttpTimeoutSeconds();

        @NotNull
        public Property<Long> getCloseTimeoutSeconds();

        @NotNull
        public Property<Long> getPollIntervalSeconds();

        @NotNull
        public DirectoryProperty getRootBuildDirectory();
    }
}

