/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.rxbilling.aidl;

import com.vanniktech.rxbilling.InventoryInApp;
import com.vanniktech.rxbilling.InventorySubscription;
import com.vanniktech.rxbilling.PurchaseResponse;
import com.vanniktech.rxbilling.PurchasedInApp;
import com.vanniktech.rxbilling.PurchasedSubscription;
import com.vanniktech.rxbilling.aidl.AidlInventoryInApp;
import com.vanniktech.rxbilling.aidl.AidlInventorySubscription;
import com.vanniktech.rxbilling.aidl.JsonConverter;
import org.json.JSONException;
import org.json.JSONObject;

final class JsonConverters {
    static final String PRODUCT_ID = "productId";
    static final String TYPE = "type";
    static final String PRICE = "price";
    static final String TITLE = "title";
    static final String DESCRIPTION = "description";
    static final String PRICE_AMOUNT_MICROS = "price_amount_micros";
    static final String PRICE_CURRENCY_CODE = "price_currency_code";
    static final String PACKAGE_NAME = "packageName";
    static final String PURCHASE_TOKEN = "purchaseToken";
    static final String PURCHASE_STATE = "purchaseState";
    static final String PURCHASE_TIME = "purchaseTime";
    static final String ORDER_ID = "orderId";
    static final JsonConverter<InventoryInApp> CONVERTER_INVENTORY_IN_APP = new JsonConverter<InventoryInApp>(){

        @Override
        public InventoryInApp convert(String json) throws JSONException {
            JSONObject jsonObject = new JSONObject(json);
            String sku = jsonObject.getString(JsonConverters.PRODUCT_ID);
            String type = jsonObject.getString(JsonConverters.TYPE);
            String price = jsonObject.getString(JsonConverters.PRICE);
            String title = jsonObject.getString(JsonConverters.TITLE);
            String description = jsonObject.getString(JsonConverters.DESCRIPTION);
            int priceAmountMicros = jsonObject.getInt(JsonConverters.PRICE_AMOUNT_MICROS);
            String priceCurrencyCode = jsonObject.getString(JsonConverters.PRICE_CURRENCY_CODE);
            return AidlInventoryInApp.create(sku, type, price, priceAmountMicros, priceCurrencyCode, title, description);
        }
    };
    static final JsonConverter<InventorySubscription> CONVERTER_INVENTORY_SUBSCRIPTION = new JsonConverter<InventorySubscription>(){

        @Override
        public InventorySubscription convert(String json) throws JSONException {
            JSONObject jsonObject = new JSONObject(json);
            String sku = jsonObject.getString(JsonConverters.PRODUCT_ID);
            String type = jsonObject.getString(JsonConverters.TYPE);
            String price = jsonObject.getString(JsonConverters.PRICE);
            String title = jsonObject.getString(JsonConverters.TITLE);
            String description = jsonObject.getString(JsonConverters.DESCRIPTION);
            int priceAmountMicros = jsonObject.getInt(JsonConverters.PRICE_AMOUNT_MICROS);
            String priceCurrencyCode = jsonObject.getString(JsonConverters.PRICE_CURRENCY_CODE);
            return AidlInventorySubscription.create(sku, type, price, priceAmountMicros, priceCurrencyCode, title, description);
        }
    };
    static final JsonConverter<PurchasedInApp> CONVERTER_PURCHASED_IN_APP = new JsonConverter<PurchasedInApp>(){

        @Override
        public PurchasedInApp convert(String json) throws JSONException {
            JSONObject jsonObject = new JSONObject(json);
            String packageName = jsonObject.getString(JsonConverters.PACKAGE_NAME);
            String productId = jsonObject.getString(JsonConverters.PRODUCT_ID);
            String purchaseToken = jsonObject.getString(JsonConverters.PURCHASE_TOKEN);
            int purchaseState = jsonObject.getInt(JsonConverters.PURCHASE_STATE);
            long purchaseTime = jsonObject.getLong(JsonConverters.PURCHASE_TIME);
            String orderId = jsonObject.optString(JsonConverters.ORDER_ID, null);
            return PurchasedInApp.create((String)packageName, (String)productId, (String)purchaseToken, (int)purchaseState, (long)purchaseTime, (String)orderId);
        }
    };
    static final JsonConverter<PurchasedSubscription> CONVERTER_PURCHASED_SUBSCRIPTION = new JsonConverter<PurchasedSubscription>(){

        @Override
        public PurchasedSubscription convert(String json) throws JSONException {
            JSONObject jsonObject = new JSONObject(json);
            String packageName = jsonObject.getString(JsonConverters.PACKAGE_NAME);
            String productId = jsonObject.getString(JsonConverters.PRODUCT_ID);
            String purchaseToken = jsonObject.getString(JsonConverters.PURCHASE_TOKEN);
            int purchaseState = jsonObject.getInt(JsonConverters.PURCHASE_STATE);
            long purchaseTime = jsonObject.getLong(JsonConverters.PURCHASE_TIME);
            String orderId = jsonObject.optString(JsonConverters.ORDER_ID, null);
            return PurchasedSubscription.create((String)packageName, (String)productId, (String)purchaseToken, (int)purchaseState, (long)purchaseTime, (String)orderId);
        }
    };
    static final JsonConverter<PurchaseResponse> CONVERTER_PURCHASE_RESPONSE = new JsonConverter<PurchaseResponse>(){

        @Override
        public PurchaseResponse convert(String json) throws JSONException {
            JSONObject jsonObject = new JSONObject(json);
            String packageName = jsonObject.getString(JsonConverters.PACKAGE_NAME);
            String productId = jsonObject.getString(JsonConverters.PRODUCT_ID);
            String purchaseToken = jsonObject.getString(JsonConverters.PURCHASE_TOKEN);
            int purchaseState = jsonObject.getInt(JsonConverters.PURCHASE_STATE);
            long purchaseTime = jsonObject.getLong(JsonConverters.PURCHASE_TIME);
            String orderId = jsonObject.optString(JsonConverters.ORDER_ID, null);
            return PurchaseResponse.create((String)packageName, (String)productId, (String)purchaseToken, (int)purchaseState, (long)purchaseTime, (String)orderId);
        }
    };

    private JsonConverters() {
        throw new AssertionError((Object)"No instances.");
    }
}

