/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.rxbilling.aidl;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import androidx.annotation.NonNull;
import com.android.vending.billing.IInAppBillingService;
import com.trello.navi2.Event;
import com.trello.navi2.NaviComponent;
import com.trello.navi2.model.ActivityResult;
import com.trello.navi2.rx.RxNavi;
import com.vanniktech.rxbilling.BillingResponseUtil;
import com.vanniktech.rxbilling.InAppBillingException;
import com.vanniktech.rxbilling.InventoryInApp;
import com.vanniktech.rxbilling.InventorySubscription;
import com.vanniktech.rxbilling.Logger;
import com.vanniktech.rxbilling.NoBillingSupportedException;
import com.vanniktech.rxbilling.PurchaseAble;
import com.vanniktech.rxbilling.PurchaseException;
import com.vanniktech.rxbilling.PurchaseResponse;
import com.vanniktech.rxbilling.Purchased;
import com.vanniktech.rxbilling.PurchasedInApp;
import com.vanniktech.rxbilling.PurchasedSubscription;
import com.vanniktech.rxbilling.RxBilling;
import com.vanniktech.rxbilling.aidl.JsonConverter;
import com.vanniktech.rxbilling.aidl.JsonConverters;
import com.vanniktech.rxbilling.aidl.LogcatLogger;
import io.reactivex.Completable;
import io.reactivex.CompletableEmitter;
import io.reactivex.CompletableOnSubscribe;
import io.reactivex.CompletableSource;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleEmitter;
import io.reactivex.SingleOnSubscribe;
import io.reactivex.SingleSource;
import io.reactivex.annotations.CheckReturnValue;
import io.reactivex.annotations.SchedulerSupport;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Arrays;
import org.json.JSONException;

public final class RxBillingAidlV3
implements RxBilling {
    static final int DEFAULT_REQUEST_CODE = 1001;
    static final int API_VERSION = 3;
    static final String TYPE_INAPP = "inapp";
    static final String TYPE_SUBSCRIPTIONS = "subs";
    static final String RESPONSE_CODE = "RESPONSE_CODE";
    static final String INAPP_PURCHASE_DATA = "INAPP_PURCHASE_DATA";
    static final String INAPP_PURCHASE_DATA_LIST = "INAPP_PURCHASE_DATA_LIST";
    static final String BUY_INTENT = "BUY_INTENT";
    static final String DETAILS_LIST = "DETAILS_LIST";
    IInAppBillingService service;
    ServiceConnection serviceConnection;
    Activity activity;
    private final Scheduler scheduler;
    final Logger logger;
    final int requestCode;

    @SchedulerSupport(value="io.reactivex:io")
    public RxBillingAidlV3(@NonNull Activity activity) {
        this(activity, Schedulers.io());
    }

    @SchedulerSupport(value="custom")
    public RxBillingAidlV3(@NonNull Activity activity, @NonNull Scheduler scheduler) {
        this(activity, scheduler, new LogcatLogger());
    }

    @SchedulerSupport(value="io.reactivex:io")
    public RxBillingAidlV3(@NonNull Activity activity, @NonNull Logger logger) {
        this(activity, Schedulers.io(), logger);
    }

    @SchedulerSupport(value="io.reactivex:io")
    public RxBillingAidlV3(@NonNull Activity activity, int requestCode) {
        this(activity, Schedulers.io(), new LogcatLogger(), requestCode);
    }

    @SchedulerSupport(value="custom")
    public RxBillingAidlV3(@NonNull Activity activity, @NonNull Scheduler scheduler, @NonNull Logger logger) {
        this(activity, scheduler, logger, 1001);
    }

    @SchedulerSupport(value="custom")
    public RxBillingAidlV3(@NonNull Activity activity, @NonNull Scheduler scheduler, @NonNull Logger logger, int requestCode) {
        if (!(activity instanceof NaviComponent)) {
            throw new IllegalArgumentException("Your Activity needs to implement NaviComponent.\nUsually there's already a Navi component that you can use straight away.\nAppCompatActivity can be replaced by NaviAppCompatActivity for instance.");
        }
        this.activity = activity;
        this.scheduler = scheduler;
        this.logger = logger;
        this.requestCode = requestCode;
    }

    public void destroy() {
        if (this.activity != null) {
            if (this.service != null) {
                this.activity.unbindService(this.serviceConnection);
            }
            this.activity = null;
        }
    }

    @CheckReturnValue
    @NonNull
    public Observable<InventoryInApp> queryInAppPurchases(String ... skuIds) {
        return this.query(TYPE_INAPP, JsonConverters.CONVERTER_INVENTORY_IN_APP, skuIds);
    }

    @CheckReturnValue
    @NonNull
    public Observable<InventorySubscription> querySubscriptions(String ... skuIds) {
        return this.query(TYPE_SUBSCRIPTIONS, JsonConverters.CONVERTER_INVENTORY_SUBSCRIPTION, skuIds);
    }

    @CheckReturnValue
    private <T> Observable<T> query(final String queryType, final JsonConverter<T> converter, final String ... skuIds) {
        if (skuIds.length == 0) {
            throw new IllegalArgumentException("No ids were passed");
        }
        return this.connect().andThen((ObservableSource)Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<T>(){

            public void subscribe(@NonNull ObservableEmitter<T> emitter) throws Exception {
                Bundle bundle = new Bundle(1);
                bundle.putStringArrayList("ITEM_ID_LIST", new ArrayList<String>(Arrays.asList(skuIds)));
                Bundle skuDetails = RxBillingAidlV3.this.service.getSkuDetails(3, RxBillingAidlV3.this.activity.getPackageName(), queryType, bundle);
                int responseCode = skuDetails.getInt(RxBillingAidlV3.RESPONSE_CODE);
                if (responseCode == 0) {
                    ArrayList responseList = skuDetails.getStringArrayList(RxBillingAidlV3.DETAILS_LIST);
                    if (responseList != null) {
                        for (String json : responseList) {
                            emitter.onNext(converter.convert(json));
                        }
                    }
                    emitter.onComplete();
                } else {
                    emitter.onError((Throwable)new RuntimeException("Querying failed. ResponseCode: " + responseCode + " (" + BillingResponseUtil.asDebugString((int)responseCode) + ")"));
                }
            }
        }).subscribeOn(this.scheduler));
    }

    @CheckReturnValue
    @NonNull
    public Completable isBillingForInAppSupported() {
        return this.isBillingSupported(TYPE_INAPP);
    }

    @CheckReturnValue
    @NonNull
    public Completable isBillingForSubscriptionsSupported() {
        return this.isBillingSupported(TYPE_SUBSCRIPTIONS);
    }

    @CheckReturnValue
    private Completable isBillingSupported(final String type) {
        return this.connect().andThen((CompletableSource)Completable.create((CompletableOnSubscribe)new CompletableOnSubscribe(){

            public void subscribe(@NonNull CompletableEmitter emitter) throws Exception {
                int responseCode = RxBillingAidlV3.this.service.isBillingSupported(3, RxBillingAidlV3.this.activity.getPackageName(), type);
                if (responseCode == 0) {
                    RxBillingAidlV3.this.logger.d("Billing is supported");
                    emitter.onComplete();
                } else {
                    RxBillingAidlV3.this.logger.w("Billing is not supported. Code " + responseCode);
                    emitter.onError((Throwable)new NoBillingSupportedException(responseCode));
                }
            }
        }).subscribeOn(this.scheduler));
    }

    @CheckReturnValue
    @NonNull
    public Single<PurchaseResponse> purchase(final @NonNull PurchaseAble purchaseAble, final @NonNull String developerPayload) {
        this.logger.d("Trying to purchase " + purchaseAble);
        return this.connect().andThen((SingleSource)Single.create((SingleOnSubscribe)new SingleOnSubscribe<PurchaseResponse>(){

            public void subscribe(final @NonNull SingleEmitter<PurchaseResponse> emitter) throws Exception {
                Bundle buyIntentBundle = RxBillingAidlV3.this.service.getBuyIntent(3, RxBillingAidlV3.this.activity.getPackageName(), purchaseAble.sku(), purchaseAble.type(), developerPayload);
                PendingIntent pendingIntent = (PendingIntent)buyIntentBundle.getParcelable(RxBillingAidlV3.BUY_INTENT);
                if (pendingIntent == null) {
                    emitter.onError((Throwable)new RuntimeException("Pending buying intent is null for " + purchaseAble + ". Please file a bug with reproducible instructions."));
                    return;
                }
                emitter.setDisposable(RxNavi.observe((NaviComponent)((NaviComponent)RxBillingAidlV3.this.activity), (Event)Event.ACTIVITY_RESULT).subscribe((Consumer)new Consumer<ActivityResult>(){

                    public void accept(ActivityResult activityResult) throws Exception {
                        if (activityResult.requestCode() != RxBillingAidlV3.this.requestCode) {
                            return;
                        }
                        Intent data = activityResult.data();
                        if (data != null) {
                            int responseCode = data.getIntExtra(RxBillingAidlV3.RESPONSE_CODE, 0);
                            String json = data.getStringExtra(RxBillingAidlV3.INAPP_PURCHASE_DATA);
                            RxBillingAidlV3.this.logger.d("ResultCode: " + activityResult.resultCode() + ", ResponseCode: " + responseCode + " (" + BillingResponseUtil.asDebugString((int)responseCode) + ") for purchase " + purchaseAble);
                            if (activityResult.resultCode() == -1) {
                                PurchaseResponse purchaseResponse = JsonConverters.CONVERTER_PURCHASE_RESPONSE.convert(json);
                                boolean isWhatWeWant = purchaseResponse.productId().equals(purchaseAble.sku());
                                if (isWhatWeWant) {
                                    emitter.onSuccess((Object)purchaseResponse);
                                } else {
                                    RxBillingAidlV3.this.logger.e("Got an activity result for a purchase that we did not order. Please file a bug with reproducible instructions.");
                                }
                            } else if (activityResult.resultCode() == 0) {
                                emitter.onError((Throwable)new PurchaseException(1));
                            } else {
                                RxBillingAidlV3.this.logger.e("Illegal state with activityResult " + activityResult + ". Please file a bug with reproducible instructions.");
                            }
                        } else {
                            RxBillingAidlV3.this.logger.w("Intent data is null");
                        }
                    }
                }, (Consumer)new ThrowableConsumer(emitter)));
                RxBillingAidlV3.this.activity.startIntentSenderForResult(pendingIntent.getIntentSender(), RxBillingAidlV3.this.requestCode, new Intent(), 0, 0, 0);
            }
        }).subscribeOn(this.scheduler));
    }

    @CheckReturnValue
    @NonNull
    public Single<Integer> acknowledgePurchase(@NonNull Purchased purchased) {
        this.logger.d("Trying to acknowledge purchase " + purchased);
        return Single.just((Object)0);
    }

    @CheckReturnValue
    @NonNull
    public Single<Integer> consumePurchase(final @NonNull Purchased purchased) {
        this.logger.d("Trying to consume purchase " + purchased);
        return this.connect().andThen((SingleSource)Single.create((SingleOnSubscribe)new SingleOnSubscribe<Integer>(){

            public void subscribe(@NonNull SingleEmitter<Integer> emitter) throws Exception {
                Integer result = RxBillingAidlV3.this.service.consumePurchase(3, RxBillingAidlV3.this.activity.getPackageName(), purchased.purchaseToken());
                emitter.onSuccess((Object)result);
            }
        }));
    }

    @CheckReturnValue
    @NonNull
    public Observable<PurchasedInApp> getPurchasedInApps() {
        return this.getPurchased(TYPE_INAPP, JsonConverters.CONVERTER_PURCHASED_IN_APP);
    }

    @CheckReturnValue
    @NonNull
    public Observable<PurchasedSubscription> getPurchasedSubscriptions() {
        return this.getPurchased(TYPE_SUBSCRIPTIONS, JsonConverters.CONVERTER_PURCHASED_SUBSCRIPTION);
    }

    @CheckReturnValue
    private <T> Observable<T> getPurchased(final String type, final JsonConverter<T> converter) {
        return this.connect().andThen((ObservableSource)Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<T>(){

            public void subscribe(@NonNull ObservableEmitter<T> emitter) throws Exception {
                Bundle purchases = RxBillingAidlV3.this.service.getPurchases(3, RxBillingAidlV3.this.activity.getPackageName(), type, null);
                int responseCode = purchases.getInt(RxBillingAidlV3.RESPONSE_CODE);
                if (responseCode == 0) {
                    ArrayList dataList = purchases.getStringArrayList(RxBillingAidlV3.INAPP_PURCHASE_DATA_LIST);
                    if (dataList != null && dataList.size() > 0) {
                        for (String json : dataList) {
                            try {
                                emitter.onNext(converter.convert(json));
                            }
                            catch (JSONException e) {
                                RxBillingAidlV3.this.logger.w((Throwable)e);
                            }
                        }
                    }
                    emitter.onComplete();
                } else {
                    emitter.onError((Throwable)new InAppBillingException(responseCode));
                }
            }
        })).subscribeOn(this.scheduler);
    }

    @CheckReturnValue
    private Completable connect() {
        return Completable.create((CompletableOnSubscribe)new CompletableOnSubscribe(){

            public void subscribe(final @NonNull CompletableEmitter emitter) {
                if (RxBillingAidlV3.this.service == null) {
                    Intent serviceIntent = new Intent("com.android.vending.billing.InAppBillingService.BIND");
                    serviceIntent.setPackage("com.android.vending");
                    RxBillingAidlV3.this.serviceConnection = new ServiceConnection(){

                        public void onServiceConnected(ComponentName name, IBinder binder) {
                            RxBillingAidlV3.this.logger.d("Connected to InApp Service");
                            RxBillingAidlV3.this.service = IInAppBillingService.Stub.asInterface(binder);
                            emitter.onComplete();
                        }

                        public void onServiceDisconnected(ComponentName name) {
                            RxBillingAidlV3.this.service = null;
                        }
                    };
                    RxBillingAidlV3.this.activity.bindService(serviceIntent, RxBillingAidlV3.this.serviceConnection, 1);
                } else {
                    emitter.onComplete();
                }
            }
        });
    }

    static class ThrowableConsumer
    implements Consumer<Throwable> {
        final SingleEmitter<PurchaseResponse> emitter;

        ThrowableConsumer(SingleEmitter<PurchaseResponse> emitter) {
            this.emitter = emitter;
        }

        public void accept(Throwable throwable) {
            this.emitter.onError(throwable);
        }
    }
}

