/*
 * Decompiled with CFR 0.152.
 */
package com.varunrajput.vscraper;

import com.varunrajput.vscraper.sm.ScraperManager;
import com.varunrajput.vscraper.util.ClassUtil;
import com.varunrajput.vscraper.util.MailUtil;
import com.varunrajput.vscraper.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VScraper {
    private static final Logger log = LoggerFactory.getLogger(VScraper.class);

    public static void run() {
        VScraper.run(null);
    }

    public static void run(String propertiesFile) {
        try {
            VScraper.checkAndLoadExternalPropertiesFile(propertiesFile);
            ScraperManager scraperManager = ClassUtil.getNewInstance(ScraperManager.class, "SCRAPER_MANAGER_CLASS");
            scraperManager.runScrapers();
            MailUtil.sendSuccessIfRequested();
        }
        catch (Exception e) {
            MailUtil.sendFailedIfRequested(e);
        }
        finally {
            PropertiesUtil.restoreDefaults();
        }
    }

    public static void setProperty(String propertyName, String propertyValue) {
        PropertiesUtil.set(propertyName, propertyValue);
    }

    public static void setPropertyForComparison(String comparisonPrefix, String propertyName, String propertyValue) {
        PropertiesUtil.set(comparisonPrefix + propertyName, propertyValue);
    }

    private static void checkAndLoadExternalPropertiesFile(String propertiesFile) {
        if (propertiesFile != null && !propertiesFile.isEmpty()) {
            try {
                PropertiesUtil.restoreDefaults();
                PropertiesUtil.overrideDefaults(propertiesFile);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            VScraper.run(args[0]);
        } else {
            VScraper.run(null);
        }
    }
}

