/*
 * Decompiled with CFR 0.152.
 */
package com.varunrajput.vscraper.im;

import com.varunrajput.vscraper.im.InputManager;
import com.varunrajput.vscraper.input.Input;
import com.varunrajput.vscraper.util.ClassUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInputManager
implements InputManager {
    private static final Logger log = LoggerFactory.getLogger(AbstractInputManager.class);
    protected String lastLoadedInputFile = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Input> loadInput(String queriesFile) {
        this.lastLoadedInputFile = queriesFile;
        ArrayList<Input> inputs = new ArrayList<Input>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(queriesFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.isEmpty()) continue;
                try {
                    Input input = ClassUtil.getNewInstance(Input.class, "INPUT_CLASS");
                    input.populateQuery(line.trim());
                    inputs.add(input);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return inputs;
    }

    public void reloadInput() {
        if (this.lastLoadedInputFile == null) {
            log.error("Cannot reload queries. No queries loaded previously");
        }
        this.loadInput(this.lastLoadedInputFile);
    }
}

