/*
 * Decompiled with CFR 0.152.
 */
package com.varunrajput.vscraper.im;

import com.varunrajput.vscraper.im.AbstractInputManager;
import com.varunrajput.vscraper.input.Input;
import com.varunrajput.vscraper.util.PropertiesUtil;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultithreadedInputManager
extends AbstractInputManager {
    private static final Logger log = LoggerFactory.getLogger(MultithreadedInputManager.class);
    private ConcurrentLinkedQueue<Input> queries = new ConcurrentLinkedQueue<Input>(this.loadInput(PropertiesUtil.get("INPUT_QUERIES_FILE")));
    private Integer totalQueries = this.queries.size();
    private Boolean QPSisToBeRegulated = false;
    private Integer sleepInterval;

    public MultithreadedInputManager() {
        Integer QPS = Integer.parseInt(PropertiesUtil.get("QPS"));
        this.QPSisToBeRegulated = QPS > 0;
        this.sleepInterval = this.QPSisToBeRegulated != false ? (int)(1.0 / (double)QPS.intValue() * 1000.0) : 0;
    }

    @Override
    public Integer totalInputs() {
        return this.totalQueries;
    }

    @Override
    public Integer inputsRemaining() {
        return this.queries.size();
    }

    @Override
    public boolean hasMoreInputs() {
        return !this.queries.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Input getInput() {
        Input query = null;
        try {
            query = (Input)this.queries.remove();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (this.QPSisToBeRegulated.booleanValue()) {
            MultithreadedInputManager multithreadedInputManager = this;
            synchronized (multithreadedInputManager) {
                try {
                    Thread.sleep(this.sleepInterval.intValue());
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return query;
    }
}

