/*
 * Decompiled with CFR 0.152.
 */
package com.varunrajput.vscraper.im;

import com.varunrajput.vscraper.im.InputManager;
import com.varunrajput.vscraper.input.Input;
import com.varunrajput.vscraper.util.ClassUtil;
import com.varunrajput.vscraper.util.PropertiesUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingInputManager
implements InputManager {
    public static final Logger log = LoggerFactory.getLogger(StreamingInputManager.class);
    private volatile int totalInputs;
    private volatile boolean QPSisToBeRegulated = false;
    private volatile int sleepInterval;
    private volatile int inputsRead;
    private BufferedReader reader;

    public StreamingInputManager() {
        String inputQueriesFile = PropertiesUtil.get("INPUT_QUERIES_FILE");
        Integer QPS = Integer.parseInt(PropertiesUtil.get("QPS"));
        this.QPSisToBeRegulated = QPS > 0;
        this.sleepInterval = this.QPSisToBeRegulated ? (int)(1.0 / (double)QPS.intValue() * 1000.0) : 0;
        try {
            this.totalInputs = StreamingInputManager.getTotalInputs(inputQueriesFile);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        try {
            this.reader = new BufferedReader(new FileReader(inputQueriesFile));
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Integer totalInputs() {
        return this.totalInputs;
    }

    @Override
    public Integer inputsRemaining() {
        return this.totalInputs - this.inputsRead;
    }

    @Override
    public boolean hasMoreInputs() {
        return this.inputsRead >= this.totalInputs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Input getInput() {
        Input input = null;
        try {
            String line = this.reader.readLine();
            if (line == null || line.trim().isEmpty()) {
                return input;
            }
            input = ClassUtil.getNewInstance(Input.class, "INPUT_CLASS");
            input.populateQuery(line);
            ++this.inputsRead;
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
        if (this.QPSisToBeRegulated) {
            StreamingInputManager streamingInputManager = this;
            synchronized (streamingInputManager) {
                try {
                    Thread.sleep(this.sleepInterval);
                }
                catch (InterruptedException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Integer getTotalInputs(String filename) throws Exception {
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(filename));
            byte[] c = new byte[1024];
            int count = 0;
            int readChars = 0;
            boolean empty = true;
            while ((readChars = is.read(c)) != -1) {
                empty = false;
                for (int i = 0; i < readChars; ++i) {
                    if (c[i] != 10) continue;
                    ++count;
                }
            }
            Integer n = count == 0 && !empty ? 1 : count;
            return n;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

