/*
 * Decompiled with CFR 0.152.
 */
package com.varunrajput.vscraper.input;

import com.varunrajput.vscraper.input.Input;
import com.varunrajput.vscraper.util.PropertiesUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DelimitedInput
implements Input {
    protected List<String> inputMetadata;
    protected String query;
    private static final Pattern delimiter = Pattern.compile(PropertiesUtil.get("DELIMITED_INPUT_DELIMITER"));
    private static final Integer queryFieldIdx = Integer.parseInt(PropertiesUtil.get("DELIMITED_INPUT_QUERY_FIELD_INDEX"));

    @Override
    public void populateQuery(String input) {
        String[] fields = delimiter.split(input);
        this.inputMetadata = new ArrayList<String>(fields.length - 1);
        for (int i = 0; i < fields.length; ++i) {
            if (i == queryFieldIdx) {
                this.query = fields[i];
                continue;
            }
            this.inputMetadata.add(fields[i]);
        }
    }

    @Override
    public String getQueryString() {
        return this.query;
    }

    @Override
    public Map<String, String> getDynamicParams() {
        return null;
    }

    public List<String> getMetadata() {
        return Collections.unmodifiableList(this.inputMetadata);
    }
}

