/*
 * Decompiled with CFR 0.152.
 */
package com.varunrajput.vscraper.input;

import com.varunrajput.vscraper.input.Input;
import com.varunrajput.vscraper.util.PropertiesUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderedDelimitedInput
implements Input {
    private static final Logger log = LoggerFactory.getLogger(HeaderedDelimitedInput.class);
    private static final Pattern delimiter = Pattern.compile(PropertiesUtil.get("HEADERED_DELIMITED_INPUT_DELIMITER"));
    private static String[] paramsHeader;
    private Map<String, String> paramValueMap;

    @Override
    public void populateQuery(String input) {
        this.paramValueMap = new HashMap<String, String>();
        String[] paramValues = delimiter.split(input);
        for (int i = 0; i < paramValues.length; ++i) {
            if (i >= paramsHeader.length || paramValues[i].isEmpty()) continue;
            this.paramValueMap.put(paramsHeader[i], paramValues[i]);
        }
    }

    @Override
    public String getQueryString() {
        return this.paramValueMap.toString();
    }

    @Override
    public Map<String, String> getDynamicParams() {
        return Collections.unmodifiableMap(this.paramValueMap);
    }

    static {
        try {
            BufferedReader reader = new BufferedReader(new FileReader(PropertiesUtil.get("INPUT_QUERIES_FILE")));
            String line = reader.readLine();
            if (line != null && !line.trim().isEmpty()) {
                paramsHeader = delimiter.split(line);
            }
            reader.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

