/*
 * Decompiled with CFR 0.152.
 */
package com.varunrajput.vscraper.om;

import com.varunrajput.vscraper.om.OutputManager;
import com.varunrajput.vscraper.output.Output;
import com.varunrajput.vscraper.util.FileUtil;
import com.varunrajput.vscraper.util.PropertiesUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchPersistOutputManager
implements OutputManager {
    private static final Logger log = LoggerFactory.getLogger(BatchPersistOutputManager.class);
    private List<Output> outputs = Collections.synchronizedList(new ArrayList());
    private String outputFile = PropertiesUtil.get("OUTPUT_FILE");
    private BatchWriter batchWriter;
    private Thread batchWriterThread;
    private List<Output> batchOutput;
    private Integer batchSize = Integer.parseInt(PropertiesUtil.get("BATCH_SIZE"));
    private String batchFile = this.outputFile + "_batch_" + System.currentTimeMillis();

    public BatchPersistOutputManager() {
        this.batchWriter = new BatchWriter();
        this.batchWriterThread = new Thread(this.batchWriter);
        this.batchWriterThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logOutput(Output output) {
        this.outputs.add(output);
        if (this.outputs.size() >= this.batchSize) {
            BatchPersistOutputManager batchPersistOutputManager = this;
            synchronized (batchPersistOutputManager) {
                if (this.outputs.size() >= this.batchSize) {
                    while (this.batchWriter.isWriting && this.batchWriter.isWriting) {
                    }
                    this.batchOutput = this.outputs;
                    this.outputs = Collections.synchronizedList(new ArrayList());
                }
            }
        }
    }

    @Override
    public void generateOuputFile() {
        this.batchWriter.run = false;
        try {
            this.batchWriterThread.join();
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.writeOutput(this.outputs, this.batchFile, true);
        File of = new File(this.batchFile);
        if (of.exists()) {
            of.renameTo(new File(this.outputFile));
        }
    }

    private void writeOutput(List<Output> outputList, String filename, Boolean append) {
        if (outputList == null || outputList.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (Output output : outputList) {
            sb.append(output.writeFormatted()).append("\n");
        }
        FileUtil.writeToFile(sb.toString(), filename, append);
    }

    private class BatchWriter
    implements Runnable {
        volatile boolean run = true;
        volatile boolean isWriting = false;

        private BatchWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.run) {
                if (BatchPersistOutputManager.this.batchOutput == null || BatchPersistOutputManager.this.batchOutput.isEmpty()) continue;
                List list = BatchPersistOutputManager.this.batchOutput;
                synchronized (list) {
                    if (BatchPersistOutputManager.this.batchOutput != null && !BatchPersistOutputManager.this.batchOutput.isEmpty()) {
                        this.isWriting = true;
                        BatchPersistOutputManager.this.writeOutput(BatchPersistOutputManager.this.batchOutput, BatchPersistOutputManager.this.batchFile, true);
                        BatchPersistOutputManager.this.batchOutput = null;
                        this.isWriting = false;
                    }
                }
            }
        }
    }
}

