/*
 * Decompiled with CFR 0.152.
 */
package com.varunrajput.vscraper.output;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.varunrajput.vscraper.input.DelimitedInput;
import com.varunrajput.vscraper.input.Input;
import com.varunrajput.vscraper.output.ComparisonOutput;
import com.varunrajput.vscraper.output.SolrOutput;
import com.varunrajput.vscraper.util.PropertiesUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class SolrComparisonDecisionOutput
extends ComparisonOutput {
    protected static final Gson gson = new GsonBuilder().create();
    protected static final List<String> comparisonPrefixes = new ArrayList<String>(new LinkedHashSet<String>(Arrays.asList(PropertiesUtil.get("COMPARISON_SCRAPING_PREFIXES").split(","))));
    protected Map<String, SolrOutput> solrOutputMap;
    protected DelimitedInput input;
    protected List<String> fieldsToCompare = new ArrayList<String>(Arrays.asList(PropertiesUtil.get("SOLR_COMPARISON_OUTPUT_FIELDS_TO_COMPARE").split(",")));
    protected static final String fieldSeparator = "\t";
    protected static final String lineSeparator = "\n";

    public SolrComparisonDecisionOutput() {
        this.solrOutputMap = new HashMap<String, SolrOutput>();
    }

    @Override
    public void populateFromString(String comparisonPrefix, String outputString, Input input) {
        if (this.input == null) {
            this.input = (DelimitedInput)input;
        }
        if (outputString != null && !outputString.isEmpty()) {
            SolrOutput parsedOutput = (SolrOutput)gson.fromJson(outputString, SolrOutput.class);
            this.solrOutputMap.put(comparisonPrefix, parsedOutput);
        }
    }

    @Override
    public String writeFormatted() {
        StringBuilder sb = new StringBuilder();
        for (String fieldToCompare : this.fieldsToCompare) {
            sb.append(this.input.getQueryString()).append(fieldSeparator);
            sb.append(fieldToCompare).append(fieldSeparator);
            for (int prefIdx = 0; prefIdx < comparisonPrefixes.size(); ++prefIdx) {
                if (prefIdx != 0) continue;
                sb.append(this.solrOutputMap.get((Object)SolrComparisonDecisionOutput.comparisonPrefixes.get((int)prefIdx)).response.getDocs());
            }
        }
        return sb.toString();
    }
}

