/*
 * Decompiled with CFR 0.152.
 */
package com.varunrajput.vscraper.output;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.varunrajput.vscraper.input.DelimitedInput;
import com.varunrajput.vscraper.input.Input;
import com.varunrajput.vscraper.output.ComparisonOutput;
import com.varunrajput.vscraper.output.SolrOutput;
import com.varunrajput.vscraper.util.PropertiesUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SolrComparisonOutput
extends ComparisonOutput {
    protected static final Gson gson = new GsonBuilder().create();
    protected static final FormatMode formatMode = FormatMode.valueOf(PropertiesUtil.get("SOLR_COMPARISON_OUTPUT_FORMAT_MODE"));
    protected static final String lineSeparator = "\n";
    protected static final String fieldSeparator = PropertiesUtil.get("SOLR_COMPARISON_OUTPUT_FIELD_SEPARATOR", "\t");
    protected static final Set<String> fieldsToCompare = new LinkedHashSet<String>(Arrays.asList(PropertiesUtil.get("SOLR_COMPARISON_OUTPUT_FIELDS_TO_COMPARE", "*").split(",")));
    protected static final Integer numResultsToCompare = Integer.parseInt(PropertiesUtil.get("SOLR_COMPARISON_OUTPUT_NUM_RESULTS_TO_COMPARE"));
    protected static final List<String> comparisonPrefixes = new ArrayList<String>(new LinkedHashSet<String>(Arrays.asList(PropertiesUtil.get("COMPARISON_SCRAPING_PREFIXES").split(","))));
    protected Map<String, SolrOutput> solrOutputMap = new HashMap<String, SolrOutput>();
    protected DelimitedInput input;

    @Override
    public void populateFromString(String comparisonPrefix, String outputString, Input input) {
        this.input = (DelimitedInput)input;
        if (outputString != null && !outputString.isEmpty()) {
            SolrOutput parsedOutput = (SolrOutput)gson.fromJson(outputString, SolrOutput.class);
            this.solrOutputMap.put(comparisonPrefix, parsedOutput);
        }
    }

    @Override
    public String writeFormatted() {
        switch (formatMode) {
            case rpc: {
                return this.writeRankPerColumn();
            }
            case rpl: {
                return this.writeRankPerLine();
            }
        }
        return this.writeRankPerLine();
    }

    public String writeRankPerColumn() {
        StringBuilder sb = new StringBuilder();
        for (String fieldToCompare : fieldsToCompare) {
            for (int i = 0; i < comparisonPrefixes.size(); ++i) {
                sb.append(this.input.getQueryString()).append(fieldSeparator);
                sb.append(fieldToCompare).append(fieldSeparator);
                sb.append(comparisonPrefixes.get(i)).append(fieldSeparator);
                SolrOutput solrOutput = this.solrOutputMap.get(comparisonPrefixes.get(i));
                if (solrOutput == null) {
                    sb.append("NO_SOLR_OUTPUT").append(lineSeparator);
                    continue;
                }
                List<Map<String, Object>> solrDocuments = solrOutput.response.getDocs();
                Integer ranksToCheck = numResultsToCompare < solrDocuments.size() ? numResultsToCompare.intValue() : solrDocuments.size();
                for (int rank = 0; rank < ranksToCheck; ++rank) {
                    Map<String, Object> solrDocument = solrDocuments.get(rank);
                    if (solrDocument.containsKey(fieldToCompare)) {
                        if (i == 0) {
                            sb.append(solrDocument.get(fieldToCompare)).append(fieldSeparator);
                            continue;
                        }
                        sb.append(this.getComparisonResult(solrDocument.get(fieldToCompare), fieldToCompare)).append(fieldSeparator);
                        continue;
                    }
                    sb.append(fieldToCompare + "_NOT_PRESENT").append(fieldSeparator);
                }
                sb.append(lineSeparator);
            }
        }
        return sb.toString().trim();
    }

    public String writeRankPerLine() {
        StringBuilder sb = new StringBuilder();
        for (int rank = 0; rank < numResultsToCompare; ++rank) {
            for (String fieldToCompare : fieldsToCompare) {
                sb.append(this.input.getQueryString()).append(fieldSeparator);
                sb.append(fieldToCompare).append(fieldSeparator);
                sb.append(rank + 1).append(fieldSeparator);
                for (int i = 0; i < comparisonPrefixes.size(); ++i) {
                    SolrOutput solrOutput = this.solrOutputMap.get(comparisonPrefixes.get(i));
                    if (solrOutput == null) {
                        sb.append("NO_SOLR_OUTPUT").append(lineSeparator);
                        continue;
                    }
                    List<Map<String, Object>> solrDocuments = solrOutput.response.getDocs();
                    if (solrDocuments.size() < rank) continue;
                    Map<String, Object> solrDocument = solrDocuments.get(rank);
                    if (solrDocument.containsKey(fieldToCompare)) {
                        if (i == 0) {
                            sb.append(solrDocument.get(fieldToCompare)).append(fieldSeparator);
                            continue;
                        }
                        sb.append(this.getComparisonResult(solrDocument.get(fieldToCompare), fieldToCompare)).append(fieldSeparator);
                        continue;
                    }
                    sb.append(fieldToCompare + "_NOT_PRESENT").append(fieldSeparator);
                }
                sb.append(lineSeparator);
            }
        }
        return sb.toString().trim();
    }

    public String getComparisonResult(Object objectToBeCompared, String fieldName) {
        return objectToBeCompared.toString();
    }

    public static enum FormatMode {
        rpc,
        rpl;

    }
}

