/*
 * Decompiled with CFR 0.152.
 */
package com.varunrajput.vscraper.output;

import com.google.common.base.Joiner;
import com.varunrajput.vscraper.input.DelimitedInput;
import com.varunrajput.vscraper.input.Input;
import com.varunrajput.vscraper.output.AbstractSolrOutput;
import com.varunrajput.vscraper.util.PropertiesUtil;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SolrOutput
extends AbstractSolrOutput {
    protected static final String lineSeparator = "\n";
    protected static final String fieldSeparator = PropertiesUtil.get("SOLR_OUTPUT_FIELD_SEPARATOR");
    protected static final Set<String> fieldsToExtract = new LinkedHashSet<String>(Arrays.asList(PropertiesUtil.get("SOLR_OUTPUT_FIELDS_TO_EXTRACT").split(",")));
    protected static final String EMPTY_VALUE = "";

    @Override
    public void populateFromString(String outputString, Input input) {
        this.input = (DelimitedInput)input;
        if (outputString != null && !outputString.isEmpty()) {
            SolrOutput parsedOutput = (SolrOutput)gson.fromJson(outputString, SolrOutput.class);
            this.responseHeader = parsedOutput.responseHeader;
            this.response = parsedOutput.response;
            this.clusters = parsedOutput.clusters;
        }
    }

    @Override
    public String writeFormatted() {
        if (this.response == null) {
            return this.input.getQueryString() + fieldSeparator + "ERROR";
        }
        List<Map<String, Object>> docList = this.response.getDocs();
        if (this.response.getNumFound() < 1L || docList.size() < 1) {
            return this.input.getQueryString() + fieldSeparator + "NO RESULTS";
        }
        StringBuilder outputBuilder = new StringBuilder();
        for (int docIdx = 0; docIdx < docList.size(); ++docIdx) {
            Map<String, Object> document = docList.get(docIdx);
            Set<String> keysToIterate = fieldsToExtract.contains("*") ? document.keySet() : fieldsToExtract;
            StringBuilder lineBuilder = new StringBuilder();
            lineBuilder.append(this.input.getQueryString()).append(fieldSeparator);
            lineBuilder.append(docIdx + 1).append(fieldSeparator);
            for (String key : keysToIterate) {
                if (document.containsKey(key)) {
                    lineBuilder.append(document.get(key)).append(fieldSeparator);
                    continue;
                }
                lineBuilder.append(EMPTY_VALUE).append(fieldSeparator);
            }
            lineBuilder.append(Joiner.on((String)fieldSeparator).join(this.input.getMetadata()));
            outputBuilder.append(lineBuilder.toString().trim()).append(lineSeparator);
        }
        return outputBuilder.toString().trim();
    }
}

