/*
 * Decompiled with CFR 0.152.
 */
package com.varunrajput.vscraper.scraper;

import com.varunrajput.vscraper.im.InputManager;
import com.varunrajput.vscraper.input.Input;
import com.varunrajput.vscraper.om.OutputManager;
import com.varunrajput.vscraper.scraper.Scraper;
import com.varunrajput.vscraper.util.PropertiesUtil;
import com.varunrajput.vscraper.util.URLUtil;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScraper
implements Scraper {
    protected static final Logger log = LoggerFactory.getLogger(AbstractScraper.class);
    protected InputManager inputManager;
    protected OutputManager outputManager;
    protected Map<String, String> params;
    protected static String queryParamKey;
    protected static String baseUrl;
    protected static URLUtil.QueryMethod queryMethod;

    protected AbstractScraper() {
        this.loadParams();
        queryParamKey = PropertiesUtil.get("QUERY_PARAM_KEY");
        baseUrl = PropertiesUtil.get("BASE_URL");
        queryMethod = URLUtil.QueryMethod.valueOf(PropertiesUtil.get("QUERY_METHOD"));
    }

    @Override
    public void setInputManager(InputManager iManager) {
        this.inputManager = iManager;
    }

    @Override
    public void setOutputManager(OutputManager oManager) {
        this.outputManager = oManager;
    }

    @Override
    public void run() {
        Input input = null;
        while ((input = this.inputManager.getInput()) != null) {
            this.outputManager.logOutput(this.scrape(input));
        }
    }

    private void loadParams() {
        if (this.params == null) {
            this.params = new HashMap<String, String>();
            String paramKeys = PropertiesUtil.get("PARAMS_TO_APPEND_TO_QUERY", "");
            if (!paramKeys.isEmpty()) {
                for (String paramKey : paramKeys.split(",")) {
                    String paramValue = PropertiesUtil.get(paramKey);
                    if (paramValue == null || paramValue.isEmpty()) continue;
                    this.params.put(paramKey, paramValue);
                }
            }
        }
    }
}

