/*
 * Decompiled with CFR 0.152.
 */
package com.varunrajput.vscraper.scraper;

import com.varunrajput.vscraper.im.InputManager;
import com.varunrajput.vscraper.input.Input;
import com.varunrajput.vscraper.om.OutputManager;
import com.varunrajput.vscraper.output.ComparisonOutput;
import com.varunrajput.vscraper.output.Output;
import com.varunrajput.vscraper.scraper.Scraper;
import com.varunrajput.vscraper.util.ClassUtil;
import com.varunrajput.vscraper.util.PropertiesUtil;
import com.varunrajput.vscraper.util.URLUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComparisonScraper
implements Scraper {
    protected InputManager inputManager;
    protected OutputManager outputManager;
    protected List<String> comparisonPrefixes = new ArrayList<String>(Arrays.asList(PropertiesUtil.get("COMPARISON_SCRAPING_PREFIXES").split(",")));
    protected Map<String, String> queryParamKeyMap = new HashMap<String, String>();
    protected Map<String, String> baseUrlMap = new HashMap<String, String>();
    protected Map<String, URLUtil.QueryMethod> queryMethodMap = new HashMap<String, URLUtil.QueryMethod>();
    protected Map<String, Map<String, String>> paramsMap = new HashMap<String, Map<String, String>>();

    public ComparisonScraper() {
        this.loadPrefixedParams();
    }

    @Override
    public Output scrape(Input input) {
        ComparisonOutput comparisonOutput = ClassUtil.getNewInstance(ComparisonOutput.class, "OUTPUT_CLASS");
        for (String comparisonPrefix : this.comparisonPrefixes) {
            this.paramsMap.get(comparisonPrefix).put(this.queryParamKeyMap.get(comparisonPrefix), input.getQueryString());
            String outputString = URLUtil.getOutputString(this.baseUrlMap.get(comparisonPrefix), this.paramsMap.get(comparisonPrefix), this.queryMethodMap.get(comparisonPrefix));
            if (outputString == null || outputString.isEmpty()) continue;
            comparisonOutput.populateFromString(comparisonPrefix, outputString, input);
        }
        return comparisonOutput;
    }

    @Override
    public void run() {
        Input input = null;
        while ((input = this.inputManager.getInput()) != null) {
            this.outputManager.logOutput(this.scrape(input));
        }
    }

    protected void loadPrefixedParams() {
        for (String comparisonPrefix : this.comparisonPrefixes) {
            this.queryParamKeyMap.put(comparisonPrefix, PropertiesUtil.get(comparisonPrefix + "QUERY_PARAM_KEY", PropertiesUtil.get("QUERY_PARAM_KEY")));
            this.baseUrlMap.put(comparisonPrefix, PropertiesUtil.get(comparisonPrefix + "BASE_URL"));
            this.queryMethodMap.put(comparisonPrefix, URLUtil.QueryMethod.valueOf(PropertiesUtil.get(comparisonPrefix + "QUERY_METHOD", PropertiesUtil.get("QUERY_METHOD"))));
            HashMap<String, String> params = new HashMap<String, String>();
            for (String paramKey : PropertiesUtil.get(comparisonPrefix + "PARAMS_TO_APPEND_TO_QUERY").split(",")) {
                params.put(paramKey, PropertiesUtil.get(comparisonPrefix + paramKey));
            }
            this.paramsMap.put(comparisonPrefix, params);
        }
    }

    @Override
    public void setInputManager(InputManager iManager) {
        this.inputManager = iManager;
    }

    @Override
    public void setOutputManager(OutputManager oManager) {
        this.outputManager = oManager;
    }
}

