/*
 * Decompiled with CFR 0.152.
 */
package com.varunrajput.vscraper.sm;

import com.varunrajput.vscraper.im.InputManager;
import com.varunrajput.vscraper.om.OutputManager;
import com.varunrajput.vscraper.scraper.Scraper;
import com.varunrajput.vscraper.sm.ScraperManager;
import com.varunrajput.vscraper.stats.ProgressTrackingStatsManager;
import com.varunrajput.vscraper.util.ClassUtil;
import com.varunrajput.vscraper.util.MailUtil;
import com.varunrajput.vscraper.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleScraperManager
implements ScraperManager {
    private static final Logger log = LoggerFactory.getLogger(SimpleScraperManager.class);
    private InputManager queryManager;
    private OutputManager outputManager;
    private ProgressTrackingStatsManager progressTrackingStatsManager;
    private Integer nScrapers = Integer.parseInt(PropertiesUtil.get("NUM_SCRAPERS"));
    private Thread[] scrapers;
    private final Thread.UncaughtExceptionHandler threadExceptionHandler = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error(e.getMessage(), e);
            MailUtil.sendFailedIfRequested(e);
        }
    };

    public SimpleScraperManager() {
        this.queryManager = ClassUtil.getNewInstance(InputManager.class, "INPUT_MANAGER_CLASS");
        this.outputManager = ClassUtil.getNewInstance(OutputManager.class, "OUTPUT_MANAGER_CLASS");
        this.progressTrackingStatsManager = new ProgressTrackingStatsManager(this.queryManager);
        this.progressTrackingStatsManager.start();
        this.scrapers = new Thread[this.nScrapers.intValue()];
        for (int i = 0; i < this.nScrapers; ++i) {
            Scraper scraper = ClassUtil.getNewInstance(Scraper.class, "SCRAPER_CLASS");
            scraper.setInputManager(this.queryManager);
            scraper.setOutputManager(this.outputManager);
            this.scrapers[i] = new Thread(scraper);
            this.scrapers[i].setUncaughtExceptionHandler(this.threadExceptionHandler);
        }
    }

    @Override
    public void runScrapers() {
        int i;
        if (this.nScrapers < 0) {
            log.error("Unable to run. Scrapers have not been initialized");
        }
        for (i = 0; i < this.nScrapers; ++i) {
            this.scrapers[i].start();
        }
        for (i = 0; i < this.nScrapers; ++i) {
            try {
                this.scrapers[i].join();
                continue;
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        this.progressTrackingStatsManager.stop();
        this.outputManager.generateOuputFile();
    }
}

