/*
 * Decompiled with CFR 0.152.
 */
package com.varunrajput.vscraper.stats;

import com.varunrajput.vscraper.im.InputManager;
import com.varunrajput.vscraper.stats.StatsManager;
import com.varunrajput.vscraper.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressTrackingStatsManager
implements StatsManager {
    private static final Logger log = LoggerFactory.getLogger(ProgressTrackingStatsManager.class);
    private static final Boolean enabled = Boolean.parseBoolean(PropertiesUtil.get("PROGRESS_TRACKING_STATS_MANAGER_ENABLE"));
    private Thread statsTrackerThread;
    private StatsTracker statsTracker;

    public ProgressTrackingStatsManager(InputManager inputManager) {
        if (enabled.booleanValue()) {
            this.statsTracker = new StatsTracker(Long.parseLong(PropertiesUtil.get("PROGRESS_TRACKING_STATS_MANAGER_INTERVAL")), Boolean.parseBoolean(PropertiesUtil.get("PROGRESS_TRACKING_STATS_MANAGER_WRITE_TO_CONSOLE")), inputManager);
            this.statsTrackerThread = new Thread(this.statsTracker);
        }
    }

    @Override
    public void start() {
        if (enabled.booleanValue()) {
            this.statsTrackerThread.start();
        }
    }

    @Override
    public void stop() {
        if (enabled.booleanValue()) {
            this.statsTrackerThread.interrupt();
            this.statsTracker.run = false;
            try {
                this.statsTrackerThread.join();
            }
            catch (InterruptedException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private class StatsTracker
    implements Runnable {
        volatile boolean run = true;
        private Long interval;
        private Boolean writeToConsole;
        private InputManager inputManager;

        public StatsTracker(Long interval, Boolean writeToConsole, InputManager inputManager) {
            this.interval = interval;
            this.writeToConsole = writeToConsole;
            this.inputManager = inputManager;
        }

        @Override
        public void run() {
            while (this.run) {
                String statsMessage = "Progress: " + String.format("%.2f", ((double)this.inputManager.totalInputs().intValue() - (double)this.inputManager.inputsRemaining().intValue()) / (double)this.inputManager.totalInputs().intValue() * 100.0) + "% Checking again in " + this.interval + "s";
                log.info(statsMessage);
                if (this.writeToConsole.booleanValue()) {
                    System.out.println(statsMessage);
                }
                try {
                    Thread.sleep(this.interval * 1000L);
                }
                catch (InterruptedException e) {
                    log.warn(e.getMessage(), (Throwable)e);
                }
            }
            log.info("Scraping Complete");
            if (this.writeToConsole.booleanValue()) {
                System.out.println("Scraping Complete");
            }
        }
    }
}

