/*
 * Decompiled with CFR 0.152.
 */
package com.varunrajput.vscraper.util;

import com.varunrajput.vscraper.util.PropertiesUtil;
import java.io.BufferedWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailUtil {
    private static final Logger log = LoggerFactory.getLogger(MailUtil.class);
    private static volatile Boolean failed = false;

    public static void send(String to, String subject, String message) {
        if (to == null || to.trim().isEmpty()) {
            return;
        }
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"mail", "-s", subject, to});
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
            writer.write(message);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static void sendSuccessIfRequested() {
        if (Boolean.parseBoolean(PropertiesUtil.get("EMAIL_NOTIFICATIONS_ENABLE"))) {
            if (failed.booleanValue()) {
                return;
            }
            MailUtil.send(PropertiesUtil.get("EMAIL_NOTIFICATIONS_ADDRESS"), "VScraper Job '" + PropertiesUtil.get("EMAIL_NOTIFICATIONS_JOB_NAME") + "' completed successfully!", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendFailedIfRequested(Throwable e) {
        if (Boolean.parseBoolean(PropertiesUtil.get("EMAIL_NOTIFICATIONS_ENABLE"))) {
            if (failed.booleanValue()) {
                return;
            }
            Boolean bl = failed;
            synchronized (bl) {
                if (failed.booleanValue()) {
                    return;
                }
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                MailUtil.send(PropertiesUtil.get("EMAIL_NOTIFICATIONS_ADDRESS"), "VScraper Job '" + PropertiesUtil.get("EMAIL_NOTIFICATIONS_JOB_NAME") + "' FAILED!", sw.toString());
                failed = true;
            }
        }
    }
}

