/*
 * Decompiled with CFR 0.152.
 */
package com.vdurmont.emoji;

import com.vdurmont.emoji.Emoji;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmojiLoader {
    public static List<Emoji> loadEmojis(InputStream stream) throws IOException {
        JSONArray emojisJSON = new JSONArray(EmojiLoader.inputStreamToString(stream));
        ArrayList<Emoji> emojis = new ArrayList<Emoji>(emojisJSON.length());
        for (int i = 0; i < emojisJSON.length(); ++i) {
            Emoji emoji = EmojiLoader.buildEmojiFromJSON(emojisJSON.getJSONObject(i));
            if (emoji == null) continue;
            emojis.add(emoji);
        }
        return emojis;
    }

    private static String inputStreamToString(InputStream stream) {
        Scanner s = new Scanner(stream, "UTF-8").useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }

    protected static Emoji buildEmojiFromJSON(JSONObject json) throws UnsupportedEncodingException {
        if (!json.has("emoji")) {
            return null;
        }
        byte[] bytes = json.getString("emoji").getBytes("UTF-8");
        String description = null;
        if (json.has("description")) {
            description = json.getString("description");
        }
        List<String> aliases = EmojiLoader.jsonArrayToStringList(json.getJSONArray("aliases"));
        List<String> tags = EmojiLoader.jsonArrayToStringList(json.getJSONArray("tags"));
        int html = EmojiLoader.getHtmlCodeFromBytes(bytes);
        return new Emoji(description, aliases, tags, html, bytes);
    }

    private static int getHtmlCodeFromBytes(byte[] bytes) throws UnsupportedEncodingException {
        String unicode = new String(bytes, "UTF-8");
        return Character.codePointAt(unicode, 0);
    }

    private static List<String> jsonArrayToStringList(JSONArray array) {
        ArrayList<String> strings = new ArrayList<String>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            strings.add(array.getString(i));
        }
        return strings;
    }
}

