/*
 * Decompiled with CFR 0.152.
 */
package com.vdurmont.semver4j;

import com.vdurmont.semver4j.Range;
import com.vdurmont.semver4j.Semver;
import com.vdurmont.semver4j.SemverException;
import com.vdurmont.semver4j.Tokenizer;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Requirement {
    private static final Pattern IVY_DYNAMIC_PATCH_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.\\+");
    private static final Pattern IVY_DYNAMIC_MINOR_PATTERN = Pattern.compile("(\\d+)\\.\\+");
    private static final Pattern IVY_LATEST_PATTERN = Pattern.compile("latest\\.\\w+");
    private static final Pattern IVY_MATH_BOUNDED_PATTERN = Pattern.compile("(\\[|\\])([\\d\\.]+),([\\d\\.]+)(\\[|\\])");
    private static final Pattern IVY_MATH_LOWER_UNBOUNDED_PATTERN = Pattern.compile("\\(,([\\d\\.]+)(\\[|\\])");
    private static final Pattern IVY_MATH_UPPER_UNBOUNDED_PATTERN = Pattern.compile("(\\[|\\])([\\d\\.]+),\\)");
    protected final Range range;
    protected final Requirement req1;
    protected final RequirementOperator op;
    protected final Requirement req2;

    protected Requirement(Range range, Requirement req1, RequirementOperator op, Requirement req2) {
        this.range = range;
        this.req1 = req1;
        this.op = op;
        this.req2 = req2;
    }

    public static Requirement buildStrict(String requirement) {
        return Requirement.buildStrict(new Semver(requirement));
    }

    public static Requirement buildStrict(Semver requirement) {
        return new Requirement(new Range(requirement, Range.RangeOperator.EQ), null, null, null);
    }

    public static Requirement buildLoose(String requirement) {
        return Requirement.buildLoose(new Semver(requirement, Semver.SemverType.LOOSE));
    }

    public static Requirement buildLoose(Semver requirement) {
        return new Requirement(new Range(requirement, Range.RangeOperator.EQ), null, null, null);
    }

    public static Requirement buildNPM(String requirement) {
        return Requirement.buildWithTokenizer(requirement, Semver.SemverType.NPM);
    }

    public static Requirement buildCocoapods(String requirement) {
        return Requirement.buildWithTokenizer(requirement, Semver.SemverType.COCOAPODS);
    }

    private static Requirement buildWithTokenizer(String requirement, Semver.SemverType type) {
        List<Tokenizer.Token> tokens = Tokenizer.tokenize(requirement, type);
        List<Tokenizer.Token> rpn = Requirement.toReversePolishNotation(tokens);
        return Requirement.evaluateReversePolishNotation(rpn.iterator(), type);
    }

    public static Requirement buildIvy(String requirement) {
        try {
            return Requirement.buildLoose(requirement);
        }
        catch (SemverException ignored) {
            Matcher matcher = IVY_DYNAMIC_PATCH_PATTERN.matcher(requirement);
            if (matcher.find()) {
                int major = Integer.valueOf(matcher.group(1));
                int minor = Integer.valueOf(matcher.group(2));
                Requirement lower = new Requirement(new Range(major + "." + minor + ".0", Range.RangeOperator.GTE), null, null, null);
                Requirement upper = new Requirement(new Range(major + "." + (minor + 1) + ".0", Range.RangeOperator.LT), null, null, null);
                return new Requirement(null, lower, RequirementOperator.AND, upper);
            }
            matcher = IVY_DYNAMIC_MINOR_PATTERN.matcher(requirement);
            if (matcher.find()) {
                int major = Integer.valueOf(matcher.group(1));
                Requirement lower = new Requirement(new Range(major + ".0.0", Range.RangeOperator.GTE), null, null, null);
                Requirement upper = new Requirement(new Range(major + 1 + ".0.0", Range.RangeOperator.LT), null, null, null);
                return new Requirement(null, lower, RequirementOperator.AND, upper);
            }
            matcher = IVY_LATEST_PATTERN.matcher(requirement);
            if (matcher.find()) {
                return new Requirement(new Range("0.0.0", Range.RangeOperator.GTE), null, null, null);
            }
            matcher = IVY_MATH_BOUNDED_PATTERN.matcher(requirement);
            if (matcher.find()) {
                Range.RangeOperator lowerOp = "[".equals(matcher.group(1)) ? Range.RangeOperator.GTE : Range.RangeOperator.GT;
                Semver lowerVersion = new Semver(matcher.group(2), Semver.SemverType.LOOSE);
                Semver upperVersion = new Semver(matcher.group(3), Semver.SemverType.LOOSE);
                Range.RangeOperator upperOp = "]".equals(matcher.group(4)) ? Range.RangeOperator.LTE : Range.RangeOperator.LT;
                Requirement lower = new Requirement(new Range(Requirement.extrapolateVersion(lowerVersion), lowerOp), null, null, null);
                Requirement upper = new Requirement(new Range(Requirement.extrapolateVersion(upperVersion), upperOp), null, null, null);
                return new Requirement(null, lower, RequirementOperator.AND, upper);
            }
            matcher = IVY_MATH_LOWER_UNBOUNDED_PATTERN.matcher(requirement);
            if (matcher.find()) {
                Semver version = new Semver(matcher.group(1), Semver.SemverType.LOOSE);
                Range.RangeOperator op = "]".equals(matcher.group(2)) ? Range.RangeOperator.LTE : Range.RangeOperator.LT;
                return new Requirement(new Range(Requirement.extrapolateVersion(version), op), null, null, null);
            }
            matcher = IVY_MATH_UPPER_UNBOUNDED_PATTERN.matcher(requirement);
            if (matcher.find()) {
                Range.RangeOperator op = "[".equals(matcher.group(1)) ? Range.RangeOperator.GTE : Range.RangeOperator.GT;
                Semver version = new Semver(matcher.group(2), Semver.SemverType.LOOSE);
                return new Requirement(new Range(Requirement.extrapolateVersion(version), op), null, null, null);
            }
            throw new SemverException("Invalid requirement");
        }
    }

    private static List<Tokenizer.Token> toReversePolishNotation(List<Tokenizer.Token> tokens) {
        LinkedList<Tokenizer.Token> queue = new LinkedList<Tokenizer.Token>();
        Stack<Tokenizer.Token> stack = new Stack<Tokenizer.Token>();
        block4: for (int i = 0; i < tokens.size(); ++i) {
            Tokenizer.Token token = tokens.get(i);
            switch (token.type) {
                case VERSION: {
                    queue.add(token);
                    continue block4;
                }
                case CLOSING: {
                    while (((Tokenizer.Token)stack.peek()).type != Tokenizer.TokenType.OPENING) {
                        queue.add((Tokenizer.Token)stack.pop());
                    }
                    stack.pop();
                    if (stack.size() <= 0 || !((Tokenizer.Token)stack.peek()).type.isUnary()) continue block4;
                    queue.add((Tokenizer.Token)stack.pop());
                    continue block4;
                }
                default: {
                    if (token.type.isUnary()) {
                        queue.push(token);
                        queue.push(tokens.get(++i));
                        continue block4;
                    }
                    stack.push(token);
                }
            }
        }
        while (!stack.isEmpty()) {
            queue.add((Tokenizer.Token)stack.pop());
        }
        Collections.reverse(queue);
        return queue;
    }

    private static Requirement evaluateReversePolishNotation(Iterator<Tokenizer.Token> iterator, Semver.SemverType type) {
        try {
            RequirementOperator requirementOp;
            Tokenizer.Token token = iterator.next();
            if (token.type == Tokenizer.TokenType.VERSION) {
                if ("*".equals(token.value) || type == Semver.SemverType.NPM && "latest".equals(token.value)) {
                    return new Requirement(new Range("0.0.0", Range.RangeOperator.GTE), null, null, null);
                }
                Semver version = new Semver(token.value, type);
                if (version.getMinor() != null && version.getPatch() != null) {
                    Range range = new Range(version, Range.RangeOperator.EQ);
                    return new Requirement(range, null, null, null);
                }
                return Requirement.tildeRequirement(version.getValue(), type);
            }
            if (token.type == Tokenizer.TokenType.HYPHEN) {
                Tokenizer.Token token3 = iterator.next();
                Tokenizer.Token token2 = iterator.next();
                return Requirement.hyphenRequirement(token2.value, token3.value, type);
            }
            if (token.type.isUnary()) {
                Range.RangeOperator rangeOp;
                Tokenizer.Token token2 = iterator.next();
                switch (token.type) {
                    case EQ: {
                        rangeOp = Range.RangeOperator.EQ;
                        break;
                    }
                    case LT: {
                        rangeOp = Range.RangeOperator.LT;
                        break;
                    }
                    case LTE: {
                        rangeOp = Range.RangeOperator.LTE;
                        break;
                    }
                    case GT: {
                        rangeOp = Range.RangeOperator.GT;
                        break;
                    }
                    case GTE: {
                        rangeOp = Range.RangeOperator.GTE;
                        break;
                    }
                    case TILDE: {
                        return Requirement.tildeRequirement(token2.value, type);
                    }
                    case CARET: {
                        return Requirement.caretRequirement(token2.value, type);
                    }
                    default: {
                        throw new SemverException("Invalid requirement");
                    }
                }
                Range range = new Range(token2.value, rangeOp);
                return new Requirement(range, null, null, null);
            }
            Requirement req1 = Requirement.evaluateReversePolishNotation(iterator, type);
            Requirement req2 = Requirement.evaluateReversePolishNotation(iterator, type);
            switch (token.type) {
                case OR: {
                    requirementOp = RequirementOperator.OR;
                    break;
                }
                case AND: {
                    requirementOp = RequirementOperator.AND;
                    break;
                }
                default: {
                    throw new SemverException("Invalid requirement");
                }
            }
            return new Requirement(null, req1, requirementOp, req2);
        }
        catch (NoSuchElementException e) {
            throw new SemverException("Invalid requirement");
        }
    }

    protected static Requirement tildeRequirement(String version, Semver.SemverType type) {
        String next;
        if (type != Semver.SemverType.NPM && type != Semver.SemverType.COCOAPODS) {
            throw new SemverException("The tilde requirements are only compatible with NPM and Cocoapods.");
        }
        Semver semver = new Semver(version, type);
        Requirement req1 = new Requirement(new Range(Requirement.extrapolateVersion(semver), Range.RangeOperator.GTE), null, null, null);
        switch (type) {
            case COCOAPODS: {
                if (semver.getPatch() != null) {
                    next = semver.getMajor() + "." + (semver.getMinor() + 1) + ".0";
                    break;
                }
                if (semver.getMinor() != null) {
                    next = semver.getMajor() + 1 + ".0.0";
                    break;
                }
                return req1;
            }
            case NPM: {
                if (semver.getMinor() != null) {
                    next = semver.getMajor() + "." + (semver.getMinor() + 1) + ".0";
                    break;
                }
                next = semver.getMajor() + 1 + ".0.0";
                break;
            }
            default: {
                throw new SemverException("The tilde requirements are only compatible with NPM and Cocoapods.");
            }
        }
        Requirement req2 = new Requirement(new Range(next, Range.RangeOperator.LT), null, null, null);
        return new Requirement(null, req1, RequirementOperator.AND, req2);
    }

    protected static Requirement caretRequirement(String version, Semver.SemverType type) {
        if (type != Semver.SemverType.NPM) {
            throw new SemverException("The caret requirements are only compatible with NPM.");
        }
        Semver semver = new Semver(version, type);
        Requirement req1 = new Requirement(new Range(Requirement.extrapolateVersion(semver), Range.RangeOperator.GTE), null, null, null);
        String next = semver.getMajor() == 0 ? (semver.getMinor() == null ? "1.0.0" : (semver.getMinor() == 0 ? (semver.getPatch() == null ? "0.1.0" : "0.0." + (semver.getPatch() + 1)) : "0." + (semver.getMinor() + 1) + ".0")) : semver.getMajor() + 1 + ".0.0";
        Requirement req2 = new Requirement(new Range(next, Range.RangeOperator.LT), null, null, null);
        return new Requirement(null, req1, RequirementOperator.AND, req2);
    }

    protected static Requirement hyphenRequirement(String lowerVersion, String upperVersion, Semver.SemverType type) {
        if (type != Semver.SemverType.NPM) {
            throw new SemverException("The hyphen requirements are only compatible with NPM.");
        }
        Semver lower = Requirement.extrapolateVersion(new Semver(lowerVersion, type));
        Semver upper = new Semver(upperVersion, type);
        Range.RangeOperator upperOperator = Range.RangeOperator.LTE;
        if (upper.getMinor() == null || upper.getPatch() == null) {
            upperOperator = Range.RangeOperator.LT;
            upper = upper.getMinor() == null ? Requirement.extrapolateVersion(upper).withIncMajor() : Requirement.extrapolateVersion(upper).withIncMinor();
        }
        Requirement req1 = new Requirement(new Range(lower, Range.RangeOperator.GTE), null, null, null);
        Requirement req2 = new Requirement(new Range(upper, upperOperator), null, null, null);
        return new Requirement(null, req1, RequirementOperator.AND, req2);
    }

    private static Semver extrapolateVersion(Semver semver) {
        StringBuilder sb = new StringBuilder().append(semver.getMajor()).append(".").append(semver.getMinor() == null ? 0 : semver.getMinor()).append(".").append(semver.getPatch() == null ? 0 : semver.getPatch());
        boolean first = true;
        for (int i = 0; i < semver.getSuffixTokens().length; ++i) {
            if (first) {
                sb.append("-");
                first = false;
            } else {
                sb.append(".");
            }
            sb.append(semver.getSuffixTokens()[i]);
        }
        if (semver.getBuild() != null) {
            sb.append("+").append(semver.getBuild());
        }
        return new Semver(sb.toString(), semver.getType());
    }

    public boolean isSatisfiedBy(String version) {
        return this.isSatisfiedBy(new Semver(version));
    }

    public boolean isSatisfiedBy(Semver version) {
        if (this.range != null) {
            return this.range.isSatisfiedBy(version);
        }
        switch (this.op) {
            case AND: {
                return this.req1.isSatisfiedBy(version) && this.req2.isSatisfiedBy(version);
            }
            case OR: {
                return this.req1.isSatisfiedBy(version) || this.req2.isSatisfiedBy(version);
            }
        }
        throw new RuntimeException("Code error. Unknown RequirementOperator: " + (Object)((Object)this.op));
    }

    public String toString() {
        if (this.range != null) {
            return "Requirement{" + this.range + "}";
        }
        return "Requirement{" + this.req1 + " " + (Object)((Object)this.op) + " " + this.req2 + "}";
    }

    protected static enum RequirementOperator {
        AND,
        OR;

    }
}

