/*
 * Decompiled with CFR 0.152.
 */
package com.vecna.maven.commons;

import com.vecna.maven.commons.AbstractClassLoaderSwappingMojo;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public abstract class BuildClassPathMojo
extends AbstractClassLoaderSwappingMojo {
    protected abstract MavenProject getProject();

    @Override
    protected ClassLoader getClassLoader() throws MojoExecutionException, MojoFailureException {
        try {
            List classpathElements = this.getProject().getCompileClasspathElements();
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("compile classpath: " + classpathElements));
            }
            classpathElements.add(this.getProject().getBuild().getOutputDirectory());
            ArrayList<URL> urls = new ArrayList<URL>(classpathElements.size());
            for (String classpathElement : classpathElements) {
                urls.add(new File(classpathElement).toURL());
            }
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("setting classpath to " + urls));
            }
            return new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("couldn't create the build classpath loader", e);
        }
    }
}

