package com.vendasta.common.v1;

public interface CredentialsManager {

	/**
	 * Any implementation must be able to return an authorization string that
	 * can be used in an HTTP Authorization header. Most commonly this will be a
	 * Bearer Token.
	 * 
	 * @return an id token
	 */
	public String getAuthorization() throws CredentialsException;

	/**
	 * The CredentialManager negotiates a credential, but it is not informed if
	 * that credential is invalidated for any reason other than expiry. This
	 * method allows clients to inform the CredentialManager that the token
	 * should be refreshed.
	 */
	public void invalidateAuthorization() throws CredentialsException;
}