/*
 * Decompiled with CFR 0.152.
 */
package com.vendasta.common.v1;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.JsonParser;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.json.webtoken.JsonWebSignature;
import com.google.api.client.json.webtoken.JsonWebToken;
import com.google.api.client.util.Charsets;
import com.google.api.client.util.GenericData;
import com.google.api.client.util.ObjectParser;
import com.google.auth.oauth2.ServiceAccountJwtAccessCredentials;
import com.google.common.io.CharStreams;
import com.vendasta.common.v1.CredentialsException;
import com.vendasta.common.v1.CredentialsManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;

public class GoogleCredentialsManager
implements CredentialsManager {
    private String serviceAccount;
    private String audience;
    private String scope;
    private String currentToken;
    private Date currentTokenExpiry;

    public GoogleCredentialsManager(InputStream serviceAccount, String audience, String scope) throws IOException {
        this.serviceAccount = CharStreams.toString((Readable)new InputStreamReader(serviceAccount, Charsets.UTF_8));
        this.audience = audience;
        this.scope = scope;
        this.currentTokenExpiry = null;
        this.currentToken = null;
    }

    @Override
    public String getAuthorization() throws CredentialsException {
        Date currentTime = new Date();
        if (this.currentTokenExpiry != null && currentTime.after(this.currentTokenExpiry)) {
            this.refreshToken();
        }
        if (this.currentToken == null) {
            this.refreshToken();
        }
        return this.currentToken;
    }

    private void refreshToken() throws CredentialsException {
        HttpResponse response;
        HttpRequest request;
        URI audienceUri;
        String jwtAccess;
        try {
            jwtAccess = this.getJWTAccessFromServiceAccount();
            audienceUri = new URI(this.audience);
        }
        catch (URISyntaxException e) {
            throw new CredentialsException("Malformed URI prevented acquisition of a JWT", e);
        }
        catch (IOException e) {
            throw new CredentialsException("Something went wrong with reading credentials back", e);
        }
        GenericData tokenRequest = new GenericData();
        tokenRequest.set("grant_type", (Object)"urn:ietf:params:oauth:grant-type:jwt-bearer");
        tokenRequest.set("assertion", (Object)jwtAccess);
        UrlEncodedContent content = new UrlEncodedContent((Object)tokenRequest);
        HttpRequestFactory requestFactory = new NetHttpTransport().createRequestFactory();
        try {
            request = requestFactory.buildPostRequest(new GenericUrl(audienceUri), (HttpContent)content);
        }
        catch (IOException e) {
            throw new CredentialsException("Error building credentials request", e);
        }
        JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
        request.setParser((ObjectParser)new JsonObjectParser((JsonFactory)jsonFactory));
        try {
            response = request.execute();
        }
        catch (IOException e) {
            throw new CredentialsException("Error getting access token for service account", e);
        }
        try {
            GenericData responseData = (GenericData)response.parseAs(GenericData.class);
            String jwtToken = (String)responseData.get((Object)"id_token");
            String[] tokens = jwtToken.split("\\.");
            String claims = new String(this.Base64Decode(tokens[1]));
            JsonWebToken.Payload payload = new JsonWebToken.Payload();
            JsonParser parser = JacksonFactory.getDefaultInstance().createJsonParser(claims);
            parser.parse((Object)payload);
            System.out.println(payload);
            this.currentToken = "Bearer " + jwtToken;
            this.currentTokenExpiry = new Date(payload.getExpirationTimeSeconds() * 1000L);
        }
        catch (IOException e) {
            throw new CredentialsException("Error parsing JSON response from google Credentials Server", e);
        }
    }

    private String getJWTAccessFromServiceAccount() throws URISyntaxException, IOException {
        String jwtAccess;
        ByteArrayInputStream is = new ByteArrayInputStream(this.serviceAccount.getBytes(Charsets.UTF_8));
        ServiceAccountJwtAccessCredentials creds = ServiceAccountJwtAccessCredentials.fromStream((InputStream)is);
        URI audienceUri = new URI(this.audience);
        JsonWebSignature.Header header = new JsonWebSignature.Header();
        header.setAlgorithm("RS256");
        header.setType("JWT");
        header.setKeyId(creds.getPrivateKeyId());
        JsonWebToken.Payload payload = new JsonWebToken.Payload();
        long currentTime = System.currentTimeMillis();
        payload.setIssuer(creds.getClientEmail());
        payload.setSubject(creds.getClientEmail());
        payload.setAudience((Object)audienceUri.toString());
        payload.setIssuedAtTimeSeconds(Long.valueOf(currentTime / 1000L));
        payload.setExpirationTimeSeconds(Long.valueOf(currentTime / 1000L + 3600L));
        payload.put("scope", (Object)this.scope);
        JacksonFactory jsonFactory = JacksonFactory.getDefaultInstance();
        try {
            jwtAccess = JsonWebSignature.signUsingRsaSha256((PrivateKey)creds.getPrivateKey(), (JsonFactory)jsonFactory, (JsonWebSignature.Header)header, (JsonWebToken.Payload)payload);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Error signing service account JWT access header with private key:", e);
        }
        return jwtAccess;
    }

    @Override
    public void invalidateAuthorization() {
        this.currentToken = null;
    }

    private String Base64Decode(String encoded) throws UnsupportedEncodingException {
        byte[] decoded = Base64.decodeBase64((byte[])encoded.getBytes("UTF-8"));
        return new String(decoded, "UTF-8");
    }
}

