/*
 * Decompiled with CFR 0.152.
 */
package com.vendasta.common.v1;

import com.vendasta.common.v1.CredentialsManager;
import com.vendasta.common.v1.SDKException;
import io.grpc.Attributes;
import io.grpc.CallCredentials;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.stub.AbstractStub;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public abstract class SDKClient<T extends AbstractStub<T>> {
    static final Metadata.Key<String> AUTHORIZATION = Metadata.Key.of((String)"Authorization", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final int port = 443;
    private final String host;
    private final ManagedChannel channel;
    protected T blockingStub;

    public SDKClient(String host, InputStream serviceAccount) throws SDKException {
        this.host = host;
        try {
            this.channel = ManagedChannelBuilder.forAddress((String)this.host, (int)this.port).build();
            CredentialsManager credentialsManager = this.getCredentialsManager(serviceAccount, host);
            AbstractStub stub = this.newBlockingStub(this.channel).withCallCredentials((CallCredentials)new OAuthCallCredentials(credentialsManager));
            this.blockingStub = stub.withWaitForReady();
        }
        catch (Exception e) {
            throw new SDKException(e);
        }
    }

    public void shutdown() throws SDKException {
        try {
            this.channel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new SDKException("Error shutting down channel", e);
        }
    }

    protected abstract CredentialsManager getCredentialsManager(InputStream var1, String var2) throws IOException;

    protected abstract T newBlockingStub(ManagedChannel var1);

    private class OAuthCallCredentials
    implements CallCredentials {
        private CredentialsManager credentialsManager;

        OAuthCallCredentials(CredentialsManager credentialsManager) {
            this.credentialsManager = credentialsManager;
        }

        public void applyRequestMetadata(MethodDescriptor<?, ?> methodDescriptor, Attributes attributes, Executor executor, final CallCredentials.MetadataApplier metadataApplier) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Metadata headers = new Metadata();
                        headers.put(AUTHORIZATION, (Object)OAuthCallCredentials.this.credentialsManager.getAuthorization());
                        metadataApplier.apply(headers);
                    }
                    catch (Throwable e) {
                        metadataApplier.fail(Status.UNAUTHENTICATED.withCause(e));
                    }
                }
            });
        }
    }
}

