/*
 * Decompiled with CFR 0.152.
 */
package com.vendasta.common.v1;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.vendasta.common.v1.CredentialsException;
import com.vendasta.common.v1.CredentialsManager;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class VendastaCredentialsManager
implements CredentialsManager {
    private Gson gson = new Gson();
    private String audience;
    private Credentials creds;
    private ECPrivateKey privateKey;
    private String currentToken;
    private Date currentTokenExpiry;

    public VendastaCredentialsManager(InputStream serviceAccount, String audience) throws IOException {
        this.audience = audience;
        this.creds = (Credentials)this.gson.fromJson((Reader)new InputStreamReader(serviceAccount), Credentials.class);
        this.currentToken = null;
        this.currentTokenExpiry = null;
        Security.addProvider((Provider)new BouncyCastleProvider());
        StringReader reader = new StringReader(this.creds.privateKey);
        Object parsed = new PEMParser((Reader)reader).readObject();
        KeyPair pair = new JcaPEMKeyConverter().getKeyPair((PEMKeyPair)parsed);
        this.privateKey = (ECPrivateKey)pair.getPrivate();
    }

    @Override
    public String getAuthorization() throws CredentialsException {
        Date currentTime = new Date();
        if (this.currentTokenExpiry != null && currentTime.after(this.currentTokenExpiry)) {
            this.refreshToken();
        }
        if (this.currentToken == null) {
            this.refreshToken();
        }
        if (this.currentToken == null) {
            throw new CredentialsException("Could not refresh token");
        }
        return this.currentToken;
    }

    @Override
    public void invalidateAuthorization() {
        this.currentToken = null;
    }

    private void refreshToken() throws CredentialsException {
        String jwtAccess;
        try {
            jwtAccess = this.buildJWT();
        }
        catch (Exception e) {
            throw new CredentialsException("Something went wrong with building the credentials", e);
        }
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpPost request = new HttpPost(this.creds.tokenURI);
            StringEntity params = new StringEntity("{\"token\":\"" + jwtAccess + "\"}");
            request.addHeader("content-type", "application/json");
            request.setEntity((HttpEntity)params);
            HttpResponse response = httpClient.execute((HttpUriRequest)request);
            String responseAsString = EntityUtils.toString((HttpEntity)response.getEntity());
            GetTokenResponse tokenResponse = (GetTokenResponse)this.gson.fromJson(responseAsString, GetTokenResponse.class);
            this.currentToken = "Bearer " + tokenResponse.token;
            SignedJWT signedJWT = SignedJWT.parse((String)tokenResponse.token);
            this.currentTokenExpiry = signedJWT.getJWTClaimsSet().getExpirationTime();
        }
        catch (Exception e) {
            throw new CredentialsException("An error occured while fetching the token", e);
        }
    }

    private String buildJWT() throws CredentialsException {
        ECDSASigner signer = null;
        try {
            signer = new ECDSASigner(this.privateKey);
        }
        catch (JOSEException e) {
            throw new CredentialsException("Could not create ECDSASigner from private key", e);
        }
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().audience(this.audience).subject(this.creds.email).expirationTime(new Date(new Date().getTime() + 300000L)).claim("kid", (Object)this.creds.privateKeyID).build();
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.ES256), claimsSet);
        try {
            signedJWT.sign((JWSSigner)signer);
        }
        catch (JOSEException e) {
            throw new CredentialsException("Could not sign JWT", e);
        }
        return signedJWT.serialize();
    }

    private class GetTokenResponse {
        private String token;

        private GetTokenResponse() {
        }
    }

    private class Credentials {
        @SerializedName(value="private_key_id")
        private String privateKeyID;
        @SerializedName(value="private_key")
        private String privateKey;
        @SerializedName(value="client_email")
        private String email;
        @SerializedName(value="token_uri")
        private String tokenURI;

        private Credentials() {
        }
    }
}

