package com.vendasta.sso.v1.internal;

import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import com.vendasta.sso.v1.generated.ApiProto;

/**
 * 
 **/
public final class CreateServiceProviderRequest {




	private final ServiceProviderConfig serviceProvider;
	

	private CreateServiceProviderRequest (
		final ServiceProviderConfig serviceProvider)
		
	{
		this.serviceProvider = serviceProvider;
		
	}
	
	/**
	 * 
      * @return The final value of serviceProvider on the object
	 **/
	public ServiceProviderConfig getServiceProvider() {
		return this.serviceProvider;
	}
	

	public static class Builder {
		private ServiceProviderConfig serviceProvider;
		
		public Builder() {
			this.serviceProvider = null;
			
		}
		
		/**
		  * Adds a value to the builder for serviceProvider
		  * @param serviceProvider Value to assign to the mutable Builder
		  * @return The Builder instance so that call chaining works
		 **/
		public Builder setServiceProvider(ServiceProviderConfig serviceProvider) {
			this.serviceProvider = serviceProvider;
			return this;
		}
		
		/**
		  * Takes the configuration in the mutable Builder and uses it to instantiate a final instance
		  * of the CreateServiceProviderRequest class
		  * @return The instantiated final CreateServiceProviderRequest
		 **/
		public CreateServiceProviderRequest build() {
			return new CreateServiceProviderRequest(
				this.serviceProvider);
		}
	}

	/**
	 * Returns a Builder for CreateServiceProviderRequest, which is a mutable representation of the object.  Once the
	 * client has built up an object they can then create an immutable CreateServiceProviderRequest object using the
	 * build function.
	 * @return A fresh Builder instance with no values set
	 **/
	public static Builder newBuilder() {
		return new Builder();
	}

	/**
	 * Provides a human-readable representation of this object.  Useful for debugging.
	 * @return A string representation of the CreateServiceProviderRequest instance
	 **/
	 public String toString() {
		 String result = "CreateServiceProviderRequest\n";
		 result += "-> serviceProvider: (ServiceProviderConfig)"
		     + StringUtils.join("\n  ", Arrays.asList(String.valueOf(this.serviceProvider).split("\n"))) + "\n"; 
		 
		 return result;
	 }
	/**
	* Allows for simple conversion between the low-level generated protobuf object to
	* CreateServiceProviderRequest, which is much more usable.
	* @return An instance of CreateServiceProviderRequest representing the input proto object
	**/
	public static CreateServiceProviderRequest fromProto(ApiProto.CreateServiceProviderRequest proto) {
		CreateServiceProviderRequest out = null;
		if (proto != null) {
			CreateServiceProviderRequest.Builder outBuilder = CreateServiceProviderRequest.newBuilder()
			.setServiceProvider(ServiceProviderConfig.fromProto(proto.getServiceProvider()));
			out = outBuilder.build();
		}
		return out;
	}

	/**
	* Convenience method for handling lists of proto objects.  It calls .fromProto on each one
	* and returns a list of the converted results.
	* @return A list of CreateServiceProviderRequest instances representing the input proto objects
	**/
	public static List<CreateServiceProviderRequest> fromProtos(List<ApiProto.CreateServiceProviderRequest> protos) {
		List<CreateServiceProviderRequest> out = new ArrayList<CreateServiceProviderRequest>();
		for(ApiProto.CreateServiceProviderRequest proto : protos) {
			out.add(CreateServiceProviderRequest.fromProto(proto));
		}
		return out;
	}

	/**
	 * Allows for simple conversion of an object to the low-level generated protobuf object.
	 * @return An instance of ApiProto.CreateServiceProviderRequest which is a proto object ready for wire transmission
	 **/
	 public ApiProto.CreateServiceProviderRequest toProto() {
		 CreateServiceProviderRequest obj = this;
		 ApiProto.CreateServiceProviderRequest.Builder outBuilder = ApiProto.CreateServiceProviderRequest.newBuilder();
		 if(obj.getServiceProvider() != null){outBuilder.setServiceProvider(obj.getServiceProvider().toProto());}
		 return outBuilder.build();
	 }

	 /**
	  * Convenience method for handling lists of objects.  It calls .toProto on each one and
	  * returns a list of the converted results.
	  * @return A list of ApiProto.CreateServiceProviderRequest instances representing the input objects.
	  */
	public static List<ApiProto.CreateServiceProviderRequest> toProtos(List<CreateServiceProviderRequest> objects) {
		List<ApiProto.CreateServiceProviderRequest> out = new ArrayList<ApiProto.CreateServiceProviderRequest>();
		if(objects != null) {
			for (CreateServiceProviderRequest obj : objects) {
				out.add(obj!=null?obj.toProto():null);
			}
		}
		return out;
	}
}